/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoBlob;
import virtuoso.jdbc4.VirtuosoCallableStatement;
import virtuoso.jdbc4.VirtuosoColumn;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoExplicitString;
import virtuoso.jdbc4.VirtuosoFNSException;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoParameterMetaData;
import virtuoso.jdbc4.VirtuosoPreparedStatement;
import virtuoso.jdbc4.VirtuosoResultSetMetaData;
import virtuoso.jdbc4.VirtuosoRow;
import virtuoso.jdbc4.VirtuosoStatement;

public class VirtuosoResultSet
implements ResultSet {
    private static final String er1 = "I/O error on output stream.";
    protected Vector rows = new Vector(20);
    private Object[] row;
    private int concurrency;
    private int fetchDirection;
    private int prefetch;
    private int type;
    private VirtuosoStatement statement;
    protected VirtuosoResultSetMetaData metaData;
    private int maxRows;
    protected int totalRows;
    private boolean is_complete;
    private int updateCount;
    private String cursorName;
    protected int currentRow;
    protected int stmt_current_of;
    protected int stmt_n_rows_to_get;
    protected boolean stmt_co_last_in_batch;
    private int oldRow;
    private boolean wasNull = false;
    private boolean rowIsDeleted = false;
    private boolean rowIsUpdated = false;
    private boolean rowIsInserted = false;
    private boolean more_result;
    protected boolean isLastResult = false;
    protected boolean isLastRow = false;
    private int kindop;
    private VirtuosoPreparedStatement pstmt;
    private int rowNum = 0;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;

    VirtuosoResultSet(VirtuosoStatement virtuosoStatement, VirtuosoResultSetMetaData virtuosoResultSetMetaData, boolean bl) throws VirtuosoException {
        this.statement = virtuosoStatement;
        this.metaData = virtuosoResultSetMetaData;
        this.fetchDirection = virtuosoStatement.getFetchDirection();
        this.concurrency = virtuosoStatement.getResultSetConcurrency();
        this.type = virtuosoStatement.getResultSetType();
        this.prefetch = virtuosoStatement.getFetchSize();
        this.maxRows = virtuosoStatement.getMaxRows();
        this.cursorName = virtuosoStatement.cursorName == null ? virtuosoStatement.statid : virtuosoStatement.cursorName;
        this.stmt_current_of = -1;
        this.stmt_n_rows_to_get = this.prefetch;
        this.stmt_co_last_in_batch = false;
        this.process_result(bl);
    }

    VirtuosoResultSet(VirtuosoConnection virtuosoConnection) throws VirtuosoException {
        this.statement = new VirtuosoStatement(virtuosoConnection);
        this.metaData = new VirtuosoResultSetMetaData(null, virtuosoConnection);
        this.type = 1003;
        this.is_complete = true;
    }

    protected VirtuosoResultSet(VirtuosoConnection virtuosoConnection, String[] stringArray, int[] nArray) throws VirtuosoException {
        this.statement = new VirtuosoStatement(virtuosoConnection);
        this.metaData = new VirtuosoResultSetMetaData(virtuosoConnection, stringArray, nArray);
        this.type = 1003;
        this.is_complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMoreResults(boolean bl) throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.statement.connection;
        synchronized (virtuosoConnection) {
            this.is_complete = false;
            this.rowIsInserted = false;
            this.rowIsUpdated = false;
            this.rowIsDeleted = false;
            this.currentRow = 0;
            if (this.rows == null) {
                this.rows = new Vector(20);
            } else {
                this.rows.removeAllElements();
            }
            this.process_result(bl);
            this.more_result = true;
        }
    }

    protected int getUpdateCount() {
        return this.updateCount;
    }

    protected void setUpdateCount(int n) {
        this.updateCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch_rpc() throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.statement.connection;
            synchronized (virtuosoConnection) {
                Object[] objectArray = new Object[]{this.statement.statid, new Long(this.statement.future.hashCode())};
                this.statement.connection.removeFuture(this.statement.connection.getFuture("FTCH", objectArray, this.statement.rpc_timeout));
            }
        }
        catch (IOException iOException) {
            throw new VirtuosoException("Problem during serialization : " + iOException.getMessage(), -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extended_fetch(int n, long l, long l2) throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.statement.connection;
            synchronized (virtuosoConnection) {
                Object[] objectArray = new Object[]{this.statement.statid, new Long(n), new Long(l), new Long(l2), new Long(this.statement.connection.getAutoCommit() ? 1L : 0L), null};
                this.statement.future = this.statement.connection.getFuture("EXTF", objectArray, this.statement.rpc_timeout);
                this.getMoreResults(false);
                if (this.statement.connection.getAutoCommit()) {
                    this.process_result(false);
                }
            }
        }
        catch (IOException iOException) {
            throw new VirtuosoException("Problem during serialization : " + iOException.getMessage(), -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set_pos(int n, Vector vector, long l) throws VirtuosoException {
        if (this.pstmt == null) {
            this.pstmt = (VirtuosoPreparedStatement)this.statement.connection.prepareStatement("__set_pos(?,?,?,?)");
        }
        this.pstmt.setString(1, this.statement.statid);
        this.pstmt.setLong(2, n);
        this.pstmt.setLong(3, l);
        this.pstmt.setVector(4, vector);
        this.pstmt.execute();
        VirtuosoConnection virtuosoConnection = this.statement.connection;
        synchronized (virtuosoConnection) {
            switch (n) {
                case 3: {
                    do {
                        this.pstmt.vresultSet.getMoreResults(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsDeleted = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 2: {
                    this.pstmt.vresultSet.metaData = this.metaData;
                    this.pstmt.vresultSet.rows = this.rows;
                    this.pstmt.vresultSet.totalRows = this.totalRows;
                    this.pstmt.vresultSet.currentRow = this.currentRow;
                    do {
                        this.pstmt.vresultSet.more_result = false;
                        this.pstmt.vresultSet.is_complete = false;
                        this.pstmt.vresultSet.process_result(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsUpdated = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 4: {
                    do {
                        this.pstmt.vresultSet.getMoreResults(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsInserted = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 1: {
                    this.pstmt.vresultSet.metaData = this.metaData;
                    this.pstmt.vresultSet.rows = this.rows;
                    this.pstmt.vresultSet.totalRows = this.totalRows;
                    this.pstmt.vresultSet.currentRow = this.currentRow;
                    do {
                        this.pstmt.vresultSet.more_result = false;
                        this.pstmt.vresultSet.is_complete = false;
                        this.pstmt.vresultSet.process_result(false);
                    } while (this.pstmt.vresultSet.more_result());
                    this.totalRows = this.pstmt.vresultSet.totalRows;
                }
            }
            this.pstmt.vresultSet.rows = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process_result(boolean bl) throws VirtuosoException {
        this.more_result = false;
        int n = 0;
        block16: while (!this.is_complete) {
            if (this.rows.size() == this.statement.getMaxRows() && this.rows.size() > 0) {
                this.is_complete = true;
                continue;
            }
            if (this.statement == null || this.statement.future == null) {
                throw new VirtuosoException("Statement closed. Operation not applicable", -17);
            }
            Vector vector = this.statement.future.nextResult();
            Vector vector2 = vector = vector == null ? null : vector.firstElement();
            if (vector instanceof Vector) {
                Vector vector3 = vector;
                switch (((Short)vector3.firstElement()).intValue()) {
                    case 9: {
                        this.statement.connection.qualifier = (String)vector3.elementAt(1);
                        break;
                    }
                    case 13: {
                        if (this.statement.type != 1003) {
                            this.is_complete = true;
                        } else {
                            this.stmt_co_last_in_batch = true;
                        }
                    }
                    case 1: {
                        this.isLastRow = false;
                        vector3.removeElementAt(0);
                        if (this.currentRow == 0) {
                            this.rows.insertElementAt(new VirtuosoRow(this, vector3), n++);
                        } else {
                            this.rows.setElementAt(new VirtuosoRow(this, vector3), this.currentRow - 1);
                        }
                        if (this.statement.type == 1003) {
                            return;
                        }
                        if (n < (this.prefetch == 0 ? 100 : this.prefetch)) continue block16;
                        return;
                    }
                    case 4: {
                        Vector vector4 = (Vector)vector3.elementAt(1);
                        Number number = (Number)vector4.elementAt(1);
                        if (number == null) {
                            this.kindop = 0;
                            if (this.statement != null && this.statement.getExecType() == 1) {
                                throw new VirtuosoException("executeUpdate can't execute update/insert/delete queries", -4);
                            }
                            if (!(this.statement instanceof VirtuosoPreparedStatement)) {
                                this.statement.metaData = this.metaData = new VirtuosoResultSetMetaData(null, this.statement.connection);
                                break;
                            }
                        } else {
                            this.kindop = number.intValue();
                            if (this.statement != null) {
                                if (this.statement.getExecType() == 0 && this.kindop == 1) {
                                    throw new VirtuosoException("executeUpdate can execute only update/insert/delete queries", -4);
                                }
                                if (this.statement.getExecType() == 1 && this.kindop == 0) {
                                    throw new VirtuosoException("executeUpdate can't execute update/insert/delete queries", -4);
                                }
                            }
                        }
                        if (this.metaData != null) {
                            this.metaData.close();
                        }
                        this.statement.metaData = this.metaData = new VirtuosoResultSetMetaData(vector4, this.statement.connection);
                        if (!(this.statement instanceof PreparedStatement) || !bl) continue block16;
                        Object object = vector4.elementAt(3);
                        this.statement.objparams = null;
                        this.statement.paramsMetaData = null;
                        if (object != null && object instanceof Vector) {
                            this.statement.objparams = (Vector)object;
                            this.statement.parameters = (Vector)this.statement.objparams.clone();
                            if (this.statement instanceof CallableStatement) {
                                VirtuosoCallableStatement virtuosoCallableStatement = (VirtuosoCallableStatement)this.statement;
                                virtuosoCallableStatement.param_type = new int[this.statement.parameters.capacity()];
                                virtuosoCallableStatement.param_scale = new int[this.statement.parameters.capacity()];
                                for (int i = 0; i < virtuosoCallableStatement.param_type.length; ++i) {
                                    virtuosoCallableStatement.param_type[i] = 1111;
                                    virtuosoCallableStatement.param_scale[i] = 0;
                                }
                            }
                            this.is_complete = true;
                            this.statement.paramsMetaData = new VirtuosoParameterMetaData((Vector)object, this.statement.connection);
                            break;
                        }
                        this.statement.parameters = null;
                        break;
                    }
                    case 7: {
                        if (this.type != 1003) {
                            this.totalRows = ((Number)vector3.elementAt(1)).intValue();
                            this.updateCount = 0;
                            this.is_complete = true;
                        } else {
                            this.updateCount = ((Number)vector3.elementAt(1)).intValue();
                            this.is_complete = true;
                        }
                        this.isLastRow = true;
                        if (this.kindop == 2) continue block16;
                        this.isLastResult = true;
                        break;
                    }
                    case 12: {
                        vector3.removeElementAt(0);
                        this.rows.removeElementAt(this.currentRow - 1);
                        --this.totalRows;
                        break;
                    }
                    case 11: {
                        vector3.removeElementAt(0);
                        vector3.removeElementAt(vector3.size() - 1);
                        this.rows.setElementAt(new VirtuosoRow(this, vector3), this.currentRow - 1);
                        break;
                    }
                    case 3: {
                        Object object;
                        if (VirtuosoFuture.rpc_log != null) {
                            object = VirtuosoFuture.rpc_log;
                            synchronized (object) {
                                VirtuosoFuture.rpc_log.println("---> QA_ERROR err=[" + (String)vector3.elementAt(2) + "] stat=[" + (String)vector3.elementAt(1) + "]");
                                VirtuosoFuture.rpc_log.flush();
                            }
                        }
                        this.isLastResult = true;
                        this.isLastRow = true;
                        throw new VirtuosoException((String)vector3.elementAt(2), (String)vector3.elementAt(1), -8);
                    }
                    case 14: {
                        this.statement.connection.setWarning(new SQLWarning((String)vector3.elementAt(2), (String)vector3.elementAt(1), -8));
                        break;
                    }
                    case 6: {
                        if (this.statement.objparams != null && this.statement.objparams.size() != vector3.size() - 2) {
                            this.statement.objparams = new Vector(vector3.size() - 2);
                        }
                        for (int i = 2; i < vector3.size(); ++i) {
                            if (this.statement.objparams == null) {
                                this.statement.objparams = new Vector(vector3.size() - 2);
                            }
                            this.statement.objparams.setElementAt(vector3.elementAt(i), i - 2);
                        }
                        this.is_complete = true;
                        this.isLastResult = true;
                        this.isLastRow = true;
                        break;
                    }
                    case 5: {
                        this.sendBlobData(vector3);
                        break;
                    }
                    default: {
                        throw new VirtuosoException(((Object)vector).toString(), -16);
                    }
                }
                continue;
            }
            this.isLastRow = true;
            if (this.kindop != 2) {
                this.isLastResult = true;
            }
            if (vector == null) {
                this.more_result = true;
                this.is_complete = true;
                continue;
            }
            if ((Short)((Object)vector) != 0 && (Short)((Object)vector) != 100) continue;
            this.is_complete = true;
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    @Override
    public SQLWarning getWarnings() throws VirtuosoException {
        return null;
    }

    @Override
    public void clearWarnings() throws VirtuosoException {
    }

    @Override
    public int getType() throws VirtuosoException {
        return this.type;
    }

    @Override
    public int getConcurrency() throws VirtuosoException {
        return this.concurrency;
    }

    @Override
    public void setFetchDirection(int n) throws VirtuosoException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.fetchDirection = n;
    }

    @Override
    public int getFetchDirection() throws VirtuosoException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws VirtuosoException {
        if (n < 0 || n > this.statement.getMaxRows()) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.prefetch = n == 0 ? 100 : n;
    }

    @Override
    public int getFetchSize() throws VirtuosoException {
        return this.prefetch;
    }

    @Override
    public Statement getStatement() throws VirtuosoException {
        return this.statement;
    }

    @Override
    public ResultSetMetaData getMetaData() throws VirtuosoException {
        return this.metaData;
    }

    protected int kindop() throws VirtuosoException {
        return this.kindop;
    }

    protected boolean more_result() throws VirtuosoException {
        return this.more_result;
    }

    @Override
    public int findColumn(String string) throws VirtuosoException {
        if (string == null) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        Integer n = this.metaData.hcolumns.get(new VirtuosoColumn(string, 182, this.statement.connection));
        return n == null ? 0 : n + 1;
    }

    @Override
    public boolean wasNull() throws VirtuosoException {
        return this.wasNull;
    }

    @Override
    public String getString(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getString(n);
    }

    @Override
    public boolean getBoolean(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBoolean(n);
    }

    @Override
    public byte getByte(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getByte(n);
    }

    @Override
    public short getShort(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getShort(n);
    }

    @Override
    public int getInt(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getInt(n);
    }

    @Override
    public long getLong(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getLong(n);
    }

    @Override
    public float getFloat(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getFloat(n);
    }

    @Override
    public double getDouble(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getDouble(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws VirtuosoException {
        return this.getBigDecimal(n).setScale(n2, 7);
    }

    @Override
    public byte[] getBytes(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBytes(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBigDecimal(n);
    }

    @Override
    public InputStream getAsciiStream(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getAsciiStream(n);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws VirtuosoException {
        return this.getAsciiStream(n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBinaryStream(n);
    }

    @Override
    public Reader getCharacterStream(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getCharacterStream(n);
    }

    @Override
    public String getString(String string) throws VirtuosoException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws VirtuosoException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws VirtuosoException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws VirtuosoException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws VirtuosoException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws VirtuosoException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws VirtuosoException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws VirtuosoException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws VirtuosoException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(String string) throws VirtuosoException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(String string) throws VirtuosoException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws VirtuosoException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws VirtuosoException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws VirtuosoException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws VirtuosoException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Object getObject(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getObject(n);
    }

    @Override
    public Object getObject(String string) throws VirtuosoException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Date getDate(int n) throws VirtuosoException {
        return this.getDate(n, null);
    }

    @Override
    public Time getTime(int n) throws VirtuosoException {
        return this.getTime(n, null);
    }

    @Override
    public Timestamp getTimestamp(int n) throws VirtuosoException {
        return this.getTimestamp(n, null);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        java.util.Date date = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getDate(n);
        if (calendar != null && date != null) {
            calendar.setTime(date);
            date = calendar.getTime();
            date = Date.valueOf(new Date(date.getTime()).toString());
        }
        return date;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Time time = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getTime(n);
        if (calendar != null && time != null) {
            calendar.setTime(time);
            time = Time.valueOf(new Time(calendar.getTime().getTime()).toString());
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Timestamp timestamp = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getTimestamp(n);
        if (calendar != null) {
            calendar.setTime(timestamp);
            timestamp = new Timestamp(calendar.getTime().getTime());
        }
        return timestamp;
    }

    @Override
    public Date getDate(String string) throws VirtuosoException {
        return this.getDate(this.findColumn(string), null);
    }

    @Override
    public Time getTime(String string) throws VirtuosoException {
        return this.getTime(this.findColumn(string), null);
    }

    @Override
    public Timestamp getTimestamp(String string) throws VirtuosoException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    @Override
    public void updateNull(String string) throws VirtuosoException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws VirtuosoException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws VirtuosoException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws VirtuosoException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws VirtuosoException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws VirtuosoException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws VirtuosoException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws VirtuosoException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws VirtuosoException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws VirtuosoException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws VirtuosoException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws VirtuosoException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws VirtuosoException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws VirtuosoException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws VirtuosoException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws VirtuosoException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws VirtuosoException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws VirtuosoException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws VirtuosoException {
        this.updateObject(this.findColumn(string), object);
    }

    public Object getObject(String string, Map map) throws VirtuosoException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws VirtuosoException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws VirtuosoException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws VirtuosoException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws VirtuosoException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws VirtuosoException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws VirtuosoException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws VirtuosoException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    protected void wasNull(boolean bl) {
        this.wasNull = bl;
    }

    @Override
    public void close() throws VirtuosoException {
        if (this.pstmt != null) {
            this.pstmt.close();
            this.pstmt = null;
        }
        if (this.rows != null) {
            this.rows.removeAllElements();
        }
        this.row = null;
        this.cursorName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws VirtuosoException {
        try {
            int n = this.currentRow + 1;
            if (this.statement == null) {
                throw new VirtuosoException("Activity on a closed statement 1", "IM001", -8);
            }
            if (this.statement.isClosed()) {
                throw new VirtuosoException("Activity on a closed statement 2", "IM001", -8);
            }
            if (this.type == 1003) {
                if (this.rowNum >= this.maxRows && this.maxRows > 0) {
                    return false;
                }
                while (true) {
                    VirtuosoConnection virtuosoConnection = this.statement.connection;
                    synchronized (virtuosoConnection) {
                        if (this.is_complete) {
                            return false;
                        }
                        Object object = this.rows.firstElement();
                        if (!this.stmt_co_last_in_batch && this.currentRow == 0 && object != null) {
                            ++this.stmt_current_of;
                            ++this.currentRow;
                            ++this.rowNum;
                            return true;
                        }
                        if ((this.stmt_co_last_in_batch || this.stmt_current_of == this.stmt_n_rows_to_get - 1) && this.metaData != null && this.kindop == 1) {
                            this.rows.removeElementAt(1);
                            this.fetch_rpc();
                            this.stmt_current_of = -1;
                            this.stmt_co_last_in_batch = false;
                        }
                        this.process_result(false);
                    }
                    this.currentRow = 0;
                }
            }
            if (n > 0 && n <= this.rows.size()) {
                this.currentRow = n;
                return true;
            }
            if (this.type == 1003) {
                this.currentRow = this.rows.size() + 1;
                return false;
            }
            if (this.type == 1004 && this.getRow() == this.totalRows) {
                this.currentRow = this.rows.size() + 1;
                return false;
            }
            this.extended_fetch(1, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 1;
                return false;
            }
            this.currentRow = 1;
            return true;
        }
        catch (Throwable throwable) {
            this.statement.notify_error(throwable);
            return false;
        }
    }

    @Override
    public int getRow() throws VirtuosoException {
        if (this.currentRow > 0 && this.currentRow <= this.rows.size()) {
            int n = this.type == 1004 ? ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getRow() : (this.type == 1005 ? ((Number)((Vector)((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBookmark().elementAt(1)).elementAt(0)).intValue() : (this.type == 1003 ? this.rowNum : 0));
            if (n == 0) {
                return this.currentRow;
            }
            return n;
        }
        return this.currentRow;
    }

    @Override
    public boolean previous() throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't access to the previous row, the type is forward only.", -12);
        }
        if (this.currentRow == 0) {
            return false;
        }
        int n = this.currentRow - 1;
        if (n > 0 && n <= this.rows.size()) {
            this.currentRow = n;
            return true;
        }
        if (this.type == 1004 && this.getRow() == 1) {
            this.currentRow = 0;
            return false;
        }
        if (this.type == 1004) {
            int n2 = this.getRow();
            this.extended_fetch(4, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 0;
                return false;
            }
            for (int i = this.rows.size() - 1; i >= 0; --i) {
                if (this.rows.elementAt(i) == null || ((VirtuosoRow)this.rows.elementAt(i)).getRow() != n2) continue;
                this.currentRow = i;
                return true;
            }
        }
        if (this.type == 1005) {
            VirtuosoRow virtuosoRow = (VirtuosoRow)this.rows.elementAt(this.currentRow - 1);
            Vector vector = null;
            if (virtuosoRow != null) {
                vector = virtuosoRow.getBookmark();
            }
            this.extended_fetch(4, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 0;
                return false;
            }
            if (vector != null) {
                for (int i = this.rows.size() - 1; i >= 0; --i) {
                    if (this.rows.elementAt(i) == null || !((VirtuosoRow)this.rows.elementAt(i)).getBookmark().equals(vector)) continue;
                    this.currentRow = i;
                    return true;
                }
            }
        }
        this.currentRow = this.rows.size();
        return true;
    }

    @Override
    public void beforeFirst() throws VirtuosoException {
        this.absolute(1);
        this.previous();
    }

    @Override
    public void afterLast() throws VirtuosoException {
        this.absolute(-1);
        this.next();
    }

    @Override
    public boolean first() throws VirtuosoException {
        return this.absolute(1);
    }

    @Override
    public boolean isBeforeFirst() throws VirtuosoException {
        return this.getRow() == 0;
    }

    @Override
    public boolean isAfterLast() throws VirtuosoException {
        return this.getRow() == this.rows.size() + 1;
    }

    @Override
    public boolean isFirst() throws VirtuosoException {
        return this.getRow() == 1;
    }

    @Override
    public boolean isLast() throws VirtuosoException {
        return this.getRow() == this.totalRows;
    }

    @Override
    public boolean last() throws VirtuosoException {
        return this.absolute(-1);
    }

    @Override
    public boolean absolute(int n) throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't go before the first row, the type is forward only.", -12);
        }
        this.extended_fetch(5, n, this.prefetch == 0 ? 100L : (long)this.prefetch);
        if (this.rows.size() == 0) {
            this.currentRow = n > 0 ? 0 : 1;
            return false;
        }
        this.currentRow = 1;
        return true;
    }

    @Override
    public boolean relative(int n) throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't go before the first row, the type is forward only.", -12);
        }
        this.extended_fetch(6, n, this.prefetch == 0 ? 100L : (long)this.prefetch);
        if (this.rows.size() == 0) {
            this.currentRow = n > 0 ? 0 : 1;
            return false;
        }
        this.currentRow = 1;
        return true;
    }

    @Override
    public String getCursorName() throws VirtuosoException {
        return this.cursorName;
    }

    @Override
    public Blob getBlob(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBlob(n);
    }

    @Override
    public Clob getClob(int n) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getClob(n);
    }

    @Override
    public boolean rowUpdated() throws VirtuosoException {
        return this.rowIsUpdated;
    }

    @Override
    public boolean rowInserted() throws VirtuosoException {
        return this.rowIsInserted;
    }

    @Override
    public boolean rowDeleted() throws VirtuosoException {
        return this.rowIsDeleted;
    }

    @Override
    public void updateNull(int n) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = null;
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Boolean(bl);
    }

    @Override
    public void updateByte(int n, byte by) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Byte(by);
    }

    @Override
    public void updateShort(int n, short s) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Short(s);
    }

    @Override
    public void updateInt(int n, int n2) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Integer(n2);
    }

    @Override
    public void updateLong(int n, long l) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Long(l);
    }

    @Override
    public void updateFloat(int n, float f) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Float(f);
    }

    @Override
    public void updateDouble(int n, double d) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = new Double(d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = bigDecimal;
    }

    @Override
    public void updateString(int n, String string) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = string;
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        try {
            this.row[n - 1] = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (byArray == null) {
                this.row[n - 1] = new String(byArray);
            }
            char[] cArray = new char[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                cArray[i] = (char)byArray[i];
            }
            this.row[n - 1] = new String(cArray);
        }
    }

    @Override
    public void updateDate(int n, Date date) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = date;
    }

    @Override
    public void updateTime(int n, Time time) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = time;
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws VirtuosoException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = timestamp;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (inputStream == null || n2 < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((object = this.row[n - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object).setInputStream(inputStream, n2);
            return;
        }
        this.row[n - 1] = new VirtuosoBlob(inputStream, (long)n2, (long)(n - 1));
        this.pstmt.objparams.setElementAt(this.row[n - 1], n - 1);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (inputStream == null || n2 < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((object = this.row[n - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object).setInputStream(inputStream, n2);
            return;
        }
        this.row[n - 1] = new VirtuosoBlob(inputStream, (long)n2, (long)(n - 1));
        this.pstmt.objparams.setElementAt(this.row[n - 1], n - 1);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (reader == null || n2 < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((object = this.row[n - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object).setReader(reader, n2);
            return;
        }
        this.row[n - 1] = new VirtuosoBlob(reader, (long)n2, (long)(n - 1));
        this.pstmt.objparams.setElementAt(this.row[n - 1], n - 1);
    }

    @Override
    public void updateObject(int n, Object object) throws VirtuosoException {
        Object object2;
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (object == null) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((object2 = this.row[n - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object2).setObject(object);
            return;
        }
        this.row[n - 1] = new VirtuosoBlob(object, n - 1);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws VirtuosoException {
        this.updateObject(n, object);
    }

    @Override
    public void cancelRowUpdates() throws VirtuosoException {
        if (this.row != null) {
            this.row = null;
        }
    }

    @Override
    public void insertRow() throws VirtuosoException {
        Object[] objectArray = new Object[]{new Vector(this.row)};
        this.set_pos(4, new Vector(objectArray), 0L);
        this.row = null;
    }

    @Override
    public void updateRow() throws VirtuosoException {
        if (this.currentRow < 0 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        if (this.currentRow != 0) {
            this.set_pos(2, new Vector(this.row), this.currentRow);
            this.row = null;
        } else if (this.oldRow != 0) {
            this.insertRow();
        }
    }

    @Override
    public void deleteRow() throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        this.set_pos(3, null, this.currentRow);
    }

    @Override
    public void refreshRow() throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        this.set_pos(1, null, this.currentRow);
    }

    @Override
    public void moveToInsertRow() throws VirtuosoException {
        if (this.oldRow == 0) {
            this.oldRow = this.getRow();
            this.currentRow = 0;
        }
    }

    @Override
    public void moveToCurrentRow() throws VirtuosoException {
        if (this.oldRow != 0) {
            this.absolute(this.oldRow);
            this.oldRow = 0;
        }
    }

    public Object getObject(int n, Map map) throws VirtuosoException {
        return null;
    }

    @Override
    public Ref getRef(int n) throws VirtuosoException {
        return null;
    }

    @Override
    public Array getArray(int n) throws VirtuosoException {
        return null;
    }

    protected void sendBlobData(Vector vector) throws VirtuosoException {
        try {
            int n;
            Object object;
            int n2 = ((Number)vector.elementAt(1)).intValue();
            VirtuosoBlob virtuosoBlob = (VirtuosoBlob)this.statement.objparams.elementAt(n2);
            Reader reader = virtuosoBlob.getCharacterStream();
            long l = 0L;
            int n3 = 182;
            if (this.statement.parameters != null && this.statement.parameters.elementAt(n2) instanceof Vector) {
                object = (Vector)this.statement.parameters.elementAt(n2);
                n3 = ((Number)((Vector)object).elementAt(0)).intValue();
                n3 = n3 == 131 ? 222 : (n3 == 132 ? 225 : 182);
            }
            object = new char[8192];
            do {
                int n4;
                n = 0;
                while (n < 8192 && (long)n < virtuosoBlob.length() - l && (n4 = reader.read((char[])object, n, (int)(virtuosoBlob.length() - l < (long)(8192 - n) ? virtuosoBlob.length() - l : (long)(8192 - n)))) != -1) {
                    n += n4;
                    l += (long)n4;
                }
                if (n <= 0) continue;
                Object object2 = n3 == 222 ? new String((char[])object, 0, n) : new VirtuosoExplicitString(new String((char[])object, 0, n), n3, this.statement.connection);
                this.statement.connection.write_object(object2);
            } while (n > 0);
            byte[] byArray = new byte[]{0};
            this.statement.connection.write_bytes(byArray);
        }
        catch (IOException iOException) {
            throw new VirtuosoException(er1, -3);
        }
    }

    public boolean equals(Object object) {
        return object != null && object instanceof VirtuosoResultSet;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new VirtuosoException("DATALINK not supported", -7);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new VirtuosoException("DATALINK not supported", -7);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new VirtuosoException("SQL REF not supported", -7);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new VirtuosoException("SQL REF not supported", -7);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBinaryStream(string, blob.getBinaryStream(), (int)blob.length());
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateCharacterStream(n, clob.getCharacterStream(), (int)clob.length());
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateCharacterStream(string, clob.getCharacterStream(), (int)clob.length());
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new VirtuosoException("Arrays not supported", -7);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new VirtuosoException("Arrays not supported", -7);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new VirtuosoFNSException("getRowId(columnIndex)  not supported", -7);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new VirtuosoFNSException("getRowId(columnLabel)  not supported", -7);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new VirtuosoFNSException("updateRowId(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new VirtuosoFNSException("updateRowId(columnLabel, x)  not supported", -7);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new VirtuosoFNSException("getHoldability()  not supported", -7);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement == null || this.statement.future == null;
    }

    @Override
    public synchronized void updateNString(int n, String string) throws SQLException {
        if (n < 1 || n > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[n - 1] = string;
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public synchronized void updateNClob(int n, NClob nClob) throws SQLException {
        this.updateCharacterStream(n, nClob.getCharacterStream(), (int)nClob.length());
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public synchronized NClob getNClob(int n) throws SQLException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getClob(n);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new VirtuosoFNSException("getSQLXML(columnIndex)  not supported", -7);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new VirtuosoFNSException("getSQLXML(String columnLabel)  not supported", -7);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new VirtuosoFNSException("updateSQLXML(columnIndex, xmlObject)  not supported", -7);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new VirtuosoFNSException("updateSQLXML(columnLabel, xmlObject)  not supported", -7);
    }

    @Override
    public synchronized String getNString(int n) throws SQLException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public synchronized Reader getNCharacterStream(int n) throws SQLException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public synchronized void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(n, inputStream, (int)l);
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public synchronized void updateClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateNCharacterStream(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateNCharacterStream(columnLabel, reader)  not supported", -7);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("updateAsciiStream(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("updateBinaryStream(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateCharacterStream(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("updateAsciiStream(columnLabel, x)  not supported", -7);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("updateBinaryStream(columnLabel, x)  not supported", -7);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateCharacterStream(columnLabel, reader)  not supported", -7);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("updateBlob(columnIndex, inputStream)  not supported", -7);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("updateBlob(columnLabel, inputStream)  not supported", -7);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateClob(columnIndex,  reader)  not supported", -7);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateClob(columnLabel,  reader)  not supported", -7);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateNClob(columnIndex,  reader)  not supported", -7);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateNClob(columnLabel,  reader)  not supported", -7);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new VirtuosoException("Unable to unwrap to " + clazz.toString(), "22023", -4);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }
}

