Network.BlockedURLsPane=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('network/blockedURLsPane.css');Network.BlockedURLsPane._instance=this;this._manager=SDK.multitargetNetworkManager;this._manager.addEventListener(SDK.MultitargetNetworkManager.Events.BlockedPatternsChanged,this._update,this);this._toolbar=new UI.Toolbar('',this.contentElement);this._enabledCheckbox=new UI.ToolbarCheckbox(Common.UIString('Enable request blocking'),undefined,this._toggleEnabled.bind(this));this._toolbar.appendToolbarItem(this._enabledCheckbox);this._toolbar.appendSeparator();const addButton=new UI.ToolbarButton(Common.UIString('Add pattern'),'largeicon-add');addButton.addEventListener(UI.ToolbarButton.Events.Click,this._addButtonClicked,this);this._toolbar.appendToolbarItem(addButton);const clearButton=new UI.ToolbarButton(Common.UIString('Remove all patterns'),'largeicon-clear');clearButton.addEventListener(UI.ToolbarButton.Events.Click,this._removeAll,this);this._toolbar.appendToolbarItem(clearButton);this._list=new UI.ListWidget(this);this._list.element.classList.add('blocked-urls');this._list.registerRequiredCSS('network/blockedURLsPane.css');this._list.setEmptyPlaceholder(this._createEmptyPlaceholder());this._list.show(this.contentElement);this._editor=null;this._blockedCountForUrl=new Map();SDK.targetManager.addModelListener(SDK.NetworkManager,SDK.NetworkManager.Events.RequestFinished,this._onRequestFinished,this);this._updateThrottler=new Common.Throttler(200);this._update();}
_createEmptyPlaceholder(){const element=this.contentElement.createChild('div','no-blocked-urls');element.createChild('span').textContent=Common.UIString('Requests are not blocked. ');const addLink=element.createChild('span','link');addLink.textContent=Common.UIString('Add pattern.');addLink.href='';addLink.addEventListener('click',this._addButtonClicked.bind(this),false);return element;}
static reset(){if(Network.BlockedURLsPane._instance)
Network.BlockedURLsPane._instance.reset();}
_addButtonClicked(){this._manager.setBlockingEnabled(true);this._list.addNewItem(0,{url:'',enabled:true});}
renderItem(pattern,editable){const count=this._blockedRequestsCount(pattern.url);const element=createElementWithClass('div','blocked-url');const checkbox=element.createChild('input','blocked-url-checkbox');checkbox.type='checkbox';checkbox.checked=pattern.enabled;checkbox.disabled=!this._manager.blockingEnabled();element.createChild('div','blocked-url-label').textContent=pattern.url;element.createChild('div','blocked-url-count').textContent=Common.UIString('%d blocked',count);element.addEventListener('click',event=>this._togglePattern(pattern,event),false);checkbox.addEventListener('click',event=>this._togglePattern(pattern,event),false);return element;}
_togglePattern(pattern,event){event.consume(true);const patterns=this._manager.blockedPatterns();patterns.splice(patterns.indexOf(pattern),1,{enabled:!pattern.enabled,url:pattern.url});this._manager.setBlockedPatterns(patterns);}
_toggleEnabled(){this._manager.setBlockingEnabled(!this._manager.blockingEnabled());this._update();}
removeItemRequested(pattern,index){const patterns=this._manager.blockedPatterns();patterns.splice(index,1);this._manager.setBlockedPatterns(patterns);}
beginEdit(pattern){this._editor=this._createEditor();this._editor.control('url').value=pattern.url;return this._editor;}
commitEdit(item,editor,isNew){const url=editor.control('url').value;const patterns=this._manager.blockedPatterns();if(isNew)
patterns.push({enabled:true,url:url});else
patterns.splice(patterns.indexOf(item),1,{enabled:true,url:url});this._manager.setBlockedPatterns(patterns);}
_createEditor(){if(this._editor)
return this._editor;const editor=new UI.ListWidget.Editor();const content=editor.contentElement();const titles=content.createChild('div','blocked-url-edit-row');titles.createChild('div').textContent=Common.UIString('Text pattern to block matching requests; use * for wildcard');const fields=content.createChild('div','blocked-url-edit-row');const urlInput=editor.createInput('url','text','',(item,index,input)=>!!input.value&&!this._manager.blockedPatterns().find(pattern=>pattern.url===input.value));fields.createChild('div','blocked-url-edit-value').appendChild(urlInput);return editor;}
_removeAll(){this._manager.setBlockedPatterns([]);}
_update(){const enabled=this._manager.blockingEnabled();this._list.element.classList.toggle('blocking-disabled',!enabled&&!!this._manager.blockedPatterns().length);this._enabledCheckbox.setChecked(enabled);this._list.clear();for(const pattern of this._manager.blockedPatterns())
this._list.appendItem(pattern,true);return Promise.resolve();}
_blockedRequestsCount(url){if(!url)
return 0;let result=0;for(const blockedUrl of this._blockedCountForUrl.keys()){if(this._matches(url,blockedUrl))
result+=this._blockedCountForUrl.get(blockedUrl);}
return result;}
_matches(pattern,url){let pos=0;const parts=pattern.split('*');for(let index=0;index<parts.length;index++){const part=parts[index];if(!part.length)
continue;pos=url.indexOf(part,pos);if(pos===-1)
return false;pos+=part.length;}
return true;}
reset(){this._blockedCountForUrl.clear();this._updateThrottler.schedule(this._update.bind(this));}
_onRequestFinished(event){const request=(event.data);if(request.wasBlocked()){const count=this._blockedCountForUrl.get(request.url())||0;this._blockedCountForUrl.set(request.url(),count+1);this._updateThrottler.schedule(this._update.bind(this));}}};Network.BlockedURLsPane._instance=null;;Network.EventSourceMessagesView=class extends UI.VBox{constructor(request){super();this.registerRequiredCSS('network/eventSourceMessagesView.css');this.element.classList.add('event-source-messages-view');this._request=request;const columns=([{id:'id',title:Common.UIString('Id'),sortable:true,weight:8},{id:'type',title:Common.UIString('Type'),sortable:true,weight:8},{id:'data',title:Common.UIString('Data'),sortable:false,weight:88},{id:'time',title:Common.UIString('Time'),sortable:true,weight:8}]);this._dataGrid=new DataGrid.SortableDataGrid(columns);this._dataGrid.setStriped(true);this._dataGrid.setStickToBottom(true);this._dataGrid.markColumnAsSortedBy('time',DataGrid.DataGrid.Order.Ascending);this._sortItems();this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._sortItems,this);this._dataGrid.setName('EventSourceMessagesView');this._dataGrid.asWidget().show(this.element);}
wasShown(){this._dataGrid.rootNode().removeChildren();const messages=this._request.eventSourceMessages();for(let i=0;i<messages.length;++i)
this._dataGrid.insertChild(new Network.EventSourceMessageNode(messages[i]));this._request.addEventListener(SDK.NetworkRequest.Events.EventSourceMessageAdded,this._messageAdded,this);}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.EventSourceMessageAdded,this._messageAdded,this);}
_messageAdded(event){const message=(event.data);this._dataGrid.insertChild(new Network.EventSourceMessageNode(message));}
_sortItems(){const sortColumnId=this._dataGrid.sortColumnId();if(!sortColumnId)
return;const comparator=Network.EventSourceMessageNode.Comparators[sortColumnId];if(!comparator)
return;this._dataGrid.sortNodes(comparator,!this._dataGrid.isSortOrderAscending());}};Network.EventSourceMessageNode=class extends DataGrid.SortableDataGridNode{constructor(message){const time=new Date(message.time*1000);const timeText=('0'+time.getHours()).substr(-2)+':'+('0'+time.getMinutes()).substr(-2)+':'+
('0'+time.getSeconds()).substr(-2)+'.'+('00'+time.getMilliseconds()).substr(-3);const timeNode=createElement('div');timeNode.createTextChild(timeText);timeNode.title=time.toLocaleString();super({id:message.eventId,type:message.eventName,data:message.data,time:timeNode});this._message=message;}};Network.EventSourceMessageNodeComparator=function(field,a,b){const aValue=a._message[field];const bValue=b._message[field];return aValue<bValue?-1:aValue>bValue?1:0;};Network.EventSourceMessageNode.Comparators={'id':Network.EventSourceMessageNodeComparator.bind(null,'eventId'),'type':Network.EventSourceMessageNodeComparator.bind(null,'eventName'),'time':Network.EventSourceMessageNodeComparator.bind(null,'time')};;Network.HARWriter=class{static async write(stream,requests,progress){const compositeProgress=new Common.CompositeProgress(progress);const content=await Network.HARWriter._harStringForRequests(requests,compositeProgress);if(progress.isCanceled())
return Promise.resolve();return Network.HARWriter._writeToStream(stream,compositeProgress,content);}
static async _harStringForRequests(requests,compositeProgress){const progress=compositeProgress.createSubProgress();progress.setTitle(Common.UIString('Collecting content\u2026'));progress.setTotalWork(requests.length);const harLog=await BrowserSDK.HARLog.build(requests);const promises=[];for(let i=0;i<requests.length;i++){const promise=requests[i].contentData();promises.push(promise.then(contentLoaded.bind(null,harLog.entries[i])));}
await Promise.all(promises);progress.done();if(progress.isCanceled())
return'';return JSON.stringify({log:harLog},null,Network.HARWriter._jsonIndent);function isValidCharacter(code_point){return code_point<0xD800||(code_point>=0xE000&&code_point<0xFDD0)||(code_point>0xFDEF&&code_point<=0x10FFFF&&(code_point&0xFFFE)!==0xFFFE);}
function needsEncoding(content){for(let i=0;i<content.length;i++){if(!isValidCharacter(content.charCodeAt(i)))
return true;}
return false;}
function contentLoaded(entry,contentData){progress.worked();let encoded=contentData.encoded;if(contentData.content!==null){let content=contentData.content;if(content&&!encoded&&needsEncoding(content)){content=content.toBase64();encoded=true;}
entry.response.content.text=content;}
if(encoded)
entry.response.content.encoding='base64';}}
static async _writeToStream(stream,compositeProgress,fileContent){const progress=compositeProgress.createSubProgress();progress.setTitle(Common.UIString('Writing file\u2026'));progress.setTotalWork(fileContent.length);for(let i=0;i<fileContent.length&&!progress.isCanceled();i+=Network.HARWriter._chunkSize){const chunk=fileContent.substr(i,Network.HARWriter._chunkSize);await stream.write(chunk);progress.worked(chunk.length);}
progress.done();}};Network.HARWriter._jsonIndent=2;Network.HARWriter._chunkSize=100000;;Network.NetworkConfigView=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('network/networkConfigView.css');this.contentElement.classList.add('network-config');this._createCacheSection();this.contentElement.createChild('div').classList.add('panel-section-separator');this._createNetworkThrottlingSection();this.contentElement.createChild('div').classList.add('panel-section-separator');this._createUserAgentSection();}
static createUserAgentSelectAndInput(){const userAgentSetting=Common.settings.createSetting('customUserAgent','');const userAgentSelectElement=createElement('select');const customOverride={title:Common.UIString('Custom...'),value:'custom'};userAgentSelectElement.appendChild(new Option(customOverride.title,customOverride.value));const groups=Network.NetworkConfigView._userAgentGroups;for(const userAgentDescriptor of groups){const groupElement=userAgentSelectElement.createChild('optgroup');groupElement.label=userAgentDescriptor.title;for(const userAgentVersion of userAgentDescriptor.values){const userAgentValue=SDK.MultitargetNetworkManager.patchUserAgentWithChromeVersion(userAgentVersion.value);groupElement.appendChild(new Option(userAgentVersion.title,userAgentValue));}}
userAgentSelectElement.selectedIndex=0;const otherUserAgentElement=UI.createInput('','text');otherUserAgentElement.value=userAgentSetting.get();otherUserAgentElement.title=userAgentSetting.get();otherUserAgentElement.placeholder=Common.UIString('Enter a custom user agent');otherUserAgentElement.required=true;settingChanged();userAgentSelectElement.addEventListener('change',userAgentSelected,false);otherUserAgentElement.addEventListener('input',applyOtherUserAgent,false);function userAgentSelected(){const value=userAgentSelectElement.options[userAgentSelectElement.selectedIndex].value;if(value!==customOverride.value){userAgentSetting.set(value);otherUserAgentElement.value=value;otherUserAgentElement.title=value;}else{otherUserAgentElement.select();}}
function settingChanged(){const value=userAgentSetting.get();const options=userAgentSelectElement.options;let selectionRestored=false;for(let i=0;i<options.length;++i){if(options[i].value===value){userAgentSelectElement.selectedIndex=i;selectionRestored=true;break;}}
if(!selectionRestored)
userAgentSelectElement.selectedIndex=0;}
function applyOtherUserAgent(){if(userAgentSetting.get()!==otherUserAgentElement.value){userAgentSetting.set(otherUserAgentElement.value);otherUserAgentElement.title=otherUserAgentElement.value;settingChanged();}}
return{select:userAgentSelectElement,input:otherUserAgentElement};}
_createSection(title,className){const section=this.contentElement.createChild('section','network-config-group');if(className)
section.classList.add(className);section.createChild('div','network-config-title').textContent=title;return section.createChild('div','network-config-fields');}
_createCacheSection(){const section=this._createSection(Common.UIString('Caching'),'network-config-disable-cache');section.appendChild(UI.SettingsUI.createSettingCheckbox(Common.UIString('Disable cache'),Common.moduleSetting('cacheDisabled'),true));}
_createNetworkThrottlingSection(){const section=this._createSection(Common.UIString('Network throttling'),'network-config-throttling');const networkThrottlingSelect=(section.createChild('select','chrome-select'));MobileThrottling.throttlingManager().decorateSelectWithNetworkThrottling(networkThrottlingSelect);}
_createUserAgentSection(){const section=this._createSection(Common.UIString('User agent'),'network-config-ua');const checkboxLabel=UI.CheckboxLabel.create(Common.UIString('Select automatically'),true);section.appendChild(checkboxLabel);const autoCheckbox=checkboxLabel.checkboxElement;const customUserAgentSetting=Common.settings.createSetting('customUserAgent','');customUserAgentSetting.addChangeListener(()=>{if(autoCheckbox.checked)
return;SDK.multitargetNetworkManager.setCustomUserAgentOverride(customUserAgentSetting.get());});const customUserAgentSelectBox=section.createChild('div','network-config-ua-custom');autoCheckbox.addEventListener('change',userAgentSelectBoxChanged);const customSelectAndInput=Network.NetworkConfigView.createUserAgentSelectAndInput();customSelectAndInput.select.classList.add('chrome-select');customUserAgentSelectBox.appendChild(customSelectAndInput.select);customUserAgentSelectBox.appendChild(customSelectAndInput.input);userAgentSelectBoxChanged();function userAgentSelectBoxChanged(){const useCustomUA=!autoCheckbox.checked;customUserAgentSelectBox.classList.toggle('checked',useCustomUA);customSelectAndInput.select.disabled=!useCustomUA;customSelectAndInput.input.disabled=!useCustomUA;const customUA=useCustomUA?customUserAgentSetting.get():'';SDK.multitargetNetworkManager.setCustomUserAgentOverride(customUA);}}};Network.NetworkConfigView._userAgentGroups=[{title:'Android',values:[{title:'Android (4.0.2) Browser \u2014 Galaxy Nexus',value:'Mozilla/5.0 (Linux; U; Android 4.0.2; en-us; Galaxy Nexus Build/ICL53F) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30'},{title:'Android (2.3) Browser \u2014 Nexus S',value:'Mozilla/5.0 (Linux; U; Android 2.3.6; en-us; Nexus S Build/GRK39F) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1'}]},{title:'BlackBerry',values:[{title:'BlackBerry \u2014 BB10',value:'Mozilla/5.0 (BB10; Touch) AppleWebKit/537.1+ (KHTML, like Gecko) Version/10.0.0.1337 Mobile Safari/537.1+'},{title:'BlackBerry \u2014 PlayBook 2.1',value:'Mozilla/5.0 (PlayBook; U; RIM Tablet OS 2.1.0; en-US) AppleWebKit/536.2+ (KHTML, like Gecko) Version/7.2.1.0 Safari/536.2+'},{title:'BlackBerry \u2014 9900',value:'Mozilla/5.0 (BlackBerry; U; BlackBerry 9900; en-US) AppleWebKit/534.11+ (KHTML, like Gecko) Version/7.0.0.187 Mobile Safari/534.11+'}]},{title:'Chrome',values:[{title:'Chrome \u2014 Android Mobile',value:'Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36'},{title:'Chrome \u2014 Android Tablet',value:'Mozilla/5.0 (Linux; Android 4.3; Nexus 7 Build/JSS15Q) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36'},{title:'Chrome \u2014 iPhone',value:'Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1 (KHTML, like Gecko) CriOS/%s Mobile/13B143 Safari/601.1.46'},{title:'Chrome \u2014 iPad',value:'Mozilla/5.0 (iPad; CPU OS 9_1 like Mac OS X) AppleWebKit/601.1 (KHTML, like Gecko) CriOS/%s Mobile/13B143 Safari/601.1.46'},{title:'Chrome \u2014 Chrome OS',value:'Mozilla/5.0 (X11; CrOS x86_64 10066.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36'},{title:'Chrome \u2014 Mac',value:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36'},{title:'Chrome \u2014 Windows',value:'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36'}]},{title:'Edge',values:[{title:'Edge \u2014 Windows',value:'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.10240'},{title:'Edge \u2014 Mobile',value:'Mozilla/5.0 (Windows Phone 10.0; Android 4.2.1; Microsoft; Lumia 640 XL LTE) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Mobile Safari/537.36 Edge/12.10166'},{title:'Edge \u2014 XBox',value:'Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/13.10586'}]},{title:'Firefox',values:[{title:'Firefox \u2014 Android Mobile',value:'Mozilla/5.0 (Android 4.4; Mobile; rv:46.0) Gecko/46.0 Firefox/46.0'},{title:'Firefox \u2014 Android Tablet',value:'Mozilla/5.0 (Android 4.4; Tablet; rv:46.0) Gecko/46.0 Firefox/46.0'},{title:'Firefox \u2014 iPhone',value:'Mozilla/5.0 (iPhone; CPU iPhone OS 8_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) FxiOS/1.0 Mobile/12F69 Safari/600.1.4'},{title:'Firefox \u2014 iPad',value:'Mozilla/5.0 (iPad; CPU iPhone OS 8_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) FxiOS/1.0 Mobile/12F69 Safari/600.1.4'},{title:'Firefox \u2014 Mac',value:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:46.0) Gecko/20100101 Firefox/46.0'},{title:'Firefox \u2014 Windows',value:'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0'}]},{title:'Googlebot',values:[{title:'Googlebot',value:'Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)'},{title:'Googlebot Smartphone',value:'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.96 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)'}]},{title:'Internet Explorer',values:[{title:'Internet Explorer 11',value:'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko'},{title:'Internet Explorer 10',value:'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)'},{title:'Internet Explorer 9',value:'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)'},{title:'Internet Explorer 8',value:'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0)'},{title:'Internet Explorer 7',value:'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)'}]},{title:'Opera',values:[{title:'Opera \u2014 Mac',value:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.87 Safari/537.36 OPR/37.0.2178.31'},{title:'Opera \u2014 Windows',value:'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.87 Safari/537.36 OPR/37.0.2178.31'},{title:'Opera (Presto) \u2014 Mac',value:'Opera/9.80 (Macintosh; Intel Mac OS X 10.9.1) Presto/2.12.388 Version/12.16'},{title:'Opera (Presto) \u2014 Windows',value:'Opera/9.80 (Windows NT 6.1) Presto/2.12.388 Version/12.16'},{title:'Opera Mobile \u2014 Android Mobile',value:'Opera/12.02 (Android 4.1; Linux; Opera Mobi/ADR-1111101157; U; en-US) Presto/2.9.201 Version/12.02'},{title:'Opera Mini \u2014 iOS',value:'Opera/9.80 (iPhone; Opera Mini/8.0.0/34.2336; U; en) Presto/2.8.119 Version/11.10'}]},{title:'Safari',values:[{title:'Safari \u2014 iPad iOS 9',value:'Mozilla/5.0 (iPad; CPU OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B137 Safari/601.1'},{title:'Safari \u2014 iPhone iOS 9',value:'Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B137 Safari/601.1'},{title:'Safari \u2014 Mac',value:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/7046A194A'}]},{title:'UC Browser',values:[{title:'UC Browser \u2014 Android Mobile',value:'Mozilla/5.0 (Linux; U; Android 4.4.4; en-US; XT1022 Build/KXC21.5-40) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.7.0.636 U3/0.8.0 Mobile Safari/534.30'},{title:'UC Browser \u2014 iOS',value:'UCWEB/2.0 (iPad; U; CPU OS 7_1 like Mac OS X; en; iPad3,6) U2/1.0.0 UCBrowser/9.3.1.344'},{title:'UC Browser \u2014 Windows Phone',value:'NokiaX2-02/2.0 (11.79) Profile/MIDP-2.1 Configuration/CLDC-1.1 Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2;.NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; InfoPath.2) UCBrowser8.4.0.159/70/352'}]}];;Network.NetworkNode=class extends DataGrid.SortableDataGridNode{constructor(parentView){super({});this._parentView=parentView;this._isHovered=false;this._isProduct=false;this._showingInitiatorChain=false;this._requestOrFirstKnownChildRequest=null;}
static _themedBackgroundColors(){if(Network.NetworkNode._themedBackgroundColorsCache)
return Network.NetworkNode._themedBackgroundColorsCache;const themedColors={};for(const name in Network.NetworkNode._backgroundColors){const color=Common.Color.fromRGBA(Network.NetworkNode._backgroundColors[name]);themedColors[name]=UI.themeSupport.patchColor(color,UI.ThemeSupport.ColorUsage.Background);}
Network.NetworkNode._themedBackgroundColorsCache=(themedColors);return Network.NetworkNode._themedBackgroundColorsCache;}
displayName(){return'';}
createCell(columnId){const cell=this.createTD(columnId);this.renderCell(cell,columnId);return cell;}
renderCell(cell,columnId){}
backgroundColor(){const bgColors=Network.NetworkNode._themedBackgroundColors();if(this.selected)
return(bgColors.Selected.asString(Common.Color.Format.HEX));let color=this.isStriped()?bgColors.Stripe:bgColors.Default;if(this.isNavigationRequest())
color=color.blendWith(bgColors.Navigation);if(this.hovered())
color=color.blendWith(bgColors.Hovered);if(this.isOnInitiatorPath())
color=color.blendWith(bgColors.InitiatorPath);if(this.isOnInitiatedPath())
color=color.blendWith(bgColors.InitiatedPath);return(color.asString(Common.Color.Format.HEX));}
_updateBackgroundColor(){const element=this.existingElement();if(!element)
return;element.style.backgroundColor=this.backgroundColor();this._parentView.stylesChanged();}
setStriped(isStriped){super.setStriped(isStriped);this._updateBackgroundColor();}
parentView(){return this._parentView;}
hovered(){return this._isHovered;}
showingInitiatorChain(){return this._showingInitiatorChain;}
nodeSelfHeight(){return this._parentView.rowHeight();}
setHovered(hovered,showInitiatorChain){if(this._isHovered===hovered&&this._showingInitiatorChain===showInitiatorChain)
return;if(this._isHovered!==hovered){this._isHovered=hovered;if(this.attached())
this.element().classList.toggle('hover',hovered);}
if(this._showingInitiatorChain!==showInitiatorChain){this._showingInitiatorChain=showInitiatorChain;this.showingInitiatorChainChanged();}
this._parentView.stylesChanged();this._updateBackgroundColor();}
showingInitiatorChainChanged(){}
isOnInitiatorPath(){return false;}
isOnInitiatedPath(){return false;}
request(){return null;}
isNavigationRequest(){return false;}
clearFlatNodes(){super.clearFlatNodes();this._requestOrFirstKnownChildRequest=null;}
requestOrFirstKnownChildRequest(){if(this._requestOrFirstKnownChildRequest)
return this._requestOrFirstKnownChildRequest;let request=this.request();if(request||!this.hasChildren()){this._requestOrFirstKnownChildRequest=request;return this._requestOrFirstKnownChildRequest;}
let firstChildRequest=null;const flatChildren=this.flatChildren();for(let i=0;i<flatChildren.length;i++){request=flatChildren[i].request();if(!firstChildRequest||(request&&request.issueTime()<firstChildRequest.issueTime()))
firstChildRequest=request;}
this._requestOrFirstKnownChildRequest=firstChildRequest;return this._requestOrFirstKnownChildRequest;}};Network.NetworkNode._backgroundColors={Default:[255,255,255,1.0],Stripe:[245,245,245,1.0],Navigation:[221,238,255,1.0],Hovered:[235,242,252,0.7],InitiatorPath:[58,217,58,0.4],InitiatedPath:[217,58,58,0.4],Selected:[63,81,181,.6],FromFrame:[224,247,250,.4],IsProduct:[255,252,225,.6],};Network.NetworkNode._SupportedBackgroundColors;Network.NetworkNode._themedBackgroundColorsCache;Network.NetworkNode._ProductEntryInfo;Network.NetworkRequestNode=class extends Network.NetworkNode{constructor(parentView,request){super(parentView);this._nameCell=null;this._nameBadgeElement=null;this._initiatorCell=null;this._request=request;this._isNavigationRequest=false;this.selectable=true;this._isOnInitiatorPath=false;this._isOnInitiatedPath=false;}
static NameComparator(a,b){const aName=a.displayName().toLowerCase();const bName=b.displayName().toLowerCase();if(aName===bName){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(aRequest&&bRequest)
return aRequest.indentityCompare(bRequest);return aRequest?-1:1;}
return aName<bName?-1:1;}
static RemoteAddressComparator(a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aRemoteAddress=aRequest.remoteAddress();const bRemoteAddress=bRequest.remoteAddress();if(aRemoteAddress>bRemoteAddress)
return 1;if(bRemoteAddress>aRemoteAddress)
return-1;return aRequest.indentityCompare(bRequest);}
static ProductComparator(productRegistry,a,b){const aRequest=a.request();const bRequest=b.request();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aName=productRegistry.nameForUrl(aRequest.parsedURL)||'';const bName=productRegistry.nameForUrl(bRequest.parsedURL)||'';return aName.localeCompare(bName)||aRequest.indentityCompare(bRequest);}
static SizeComparator(a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;if(bRequest.cached()&&!aRequest.cached())
return 1;if(aRequest.cached()&&!bRequest.cached())
return-1;return(aRequest.transferSize-bRequest.transferSize)||aRequest.indentityCompare(bRequest);}
static TypeComparator(a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aSimpleType=a.displayType();const bSimpleType=b.displayType();if(aSimpleType>bSimpleType)
return 1;if(bSimpleType>aSimpleType)
return-1;return aRequest.indentityCompare(bRequest);}
static InitiatorComparator(a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;if(!a._initiatorCell||!b._initiatorCell)
return!a._initiatorCell?-1:1;const aText=a._linkifiedInitiatorAnchor?a._linkifiedInitiatorAnchor.textContent:a._initiatorCell.title;const bText=b._linkifiedInitiatorAnchor?b._linkifiedInitiatorAnchor.textContent:b._initiatorCell.title;return aText.localeCompare(bText);}
static RequestCookiesCountComparator(a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aScore=aRequest.requestCookies?aRequest.requestCookies.length:0;const bScore=bRequest.requestCookies?bRequest.requestCookies.length:0;return(aScore-bScore)||aRequest.indentityCompare(bRequest);}
static ResponseCookiesCountComparator(a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aScore=aRequest.responseCookies?aRequest.responseCookies.length:0;const bScore=bRequest.responseCookies?bRequest.responseCookies.length:0;return(aScore-bScore)||aRequest.indentityCompare(bRequest);}
static PriorityComparator(a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aPriority=aRequest.priority();let aScore=aPriority?PerfUI.networkPriorityWeight(aPriority):0;aScore=aScore||0;const bPriority=bRequest.priority();let bScore=bPriority?PerfUI.networkPriorityWeight(bPriority):0;bScore=bScore||0;return aScore-bScore||aRequest.indentityCompare(bRequest);}
static RequestPropertyComparator(propertyName,a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aValue=aRequest[propertyName];const bValue=bRequest[propertyName];if(aValue===bValue)
return aRequest.indentityCompare(bRequest);return aValue>bValue?1:-1;}
static ResponseHeaderStringComparator(propertyName,a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aValue=String(aRequest.responseHeaderValue(propertyName)||'');const bValue=String(bRequest.responseHeaderValue(propertyName)||'');return aValue.localeCompare(bValue)||aRequest.indentityCompare(bRequest);}
static ResponseHeaderNumberComparator(propertyName,a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aValue=(aRequest.responseHeaderValue(propertyName)!==undefined)?parseFloat(aRequest.responseHeaderValue(propertyName)):-Infinity;const bValue=(bRequest.responseHeaderValue(propertyName)!==undefined)?parseFloat(bRequest.responseHeaderValue(propertyName)):-Infinity;if(aValue===bValue)
return aRequest.indentityCompare(bRequest);return aValue>bValue?1:-1;}
static ResponseHeaderDateComparator(propertyName,a,b){const aRequest=a.requestOrFirstKnownChildRequest();const bRequest=b.requestOrFirstKnownChildRequest();if(!aRequest||!bRequest)
return!aRequest?-1:1;const aHeader=aRequest.responseHeaderValue(propertyName);const bHeader=bRequest.responseHeaderValue(propertyName);const aValue=aHeader?new Date(aHeader).getTime():-Infinity;const bValue=bHeader?new Date(bHeader).getTime():-Infinity;if(aValue===bValue)
return aRequest.indentityCompare(bRequest);return aValue>bValue?1:-1;}
showingInitiatorChainChanged(){const showInitiatorChain=this.showingInitiatorChain();const initiatorGraph=BrowserSDK.networkLog.initiatorGraphForRequest(this._request);for(const request of initiatorGraph.initiators){if(request===this._request)
continue;const node=this.parentView().nodeForRequest(request);if(!node)
continue;node._setIsOnInitiatorPath(showInitiatorChain);}
for(const request of initiatorGraph.initiated){if(request===this._request)
continue;const node=this.parentView().nodeForRequest(request);if(!node)
continue;node._setIsOnInitiatedPath(showInitiatorChain);}}
_setIsOnInitiatorPath(isOnInitiatorPath){if(this._isOnInitiatorPath===isOnInitiatorPath||!this.attached())
return;this._isOnInitiatorPath=isOnInitiatorPath;this._updateBackgroundColor();}
isOnInitiatorPath(){return this._isOnInitiatorPath;}
_setIsOnInitiatedPath(isOnInitiatedPath){if(this._isOnInitiatedPath===isOnInitiatedPath||!this.attached())
return;this._isOnInitiatedPath=isOnInitiatedPath;this._updateBackgroundColor();}
isOnInitiatedPath(){return this._isOnInitiatedPath;}
displayType(){const mimeType=this._request.mimeType||this._request.requestContentType()||'';const resourceType=this._request.resourceType();let simpleType=resourceType.name();if(resourceType===Common.resourceTypes.Other||resourceType===Common.resourceTypes.Image)
simpleType=mimeType.replace(/^(application|image)\//,'');return simpleType;}
displayName(){return this._request.name();}
request(){return this._request;}
isNavigationRequest(){const pageLoad=BrowserSDK.PageLoad.forRequest(this._request);return pageLoad?pageLoad.mainRequest===this._request:false;}
nodeSelfHeight(){return this.parentView().rowHeight();}
createCells(element){this._nameCell=null;this._initiatorCell=null;element.classList.toggle('network-error-row',this._isFailed());element.classList.toggle('network-navigation-row',this._isNavigationRequest);super.createCells(element);this._updateBackgroundColor();ProductRegistry.instance().then(productRegistry=>{if(productRegistry.entryForUrl(this._request.parsedURL)){this._isProduct=true;this._updateBackgroundColor();}});}
_setTextAndTitle(element,text){element.createTextChild(text);element.title=text;}
renderCell(cell,columnId){switch(columnId){case'name':this._renderNameCell(cell);break;case'method':this._setTextAndTitle(cell,this._request.requestMethod);break;case'status':this._renderStatusCell(cell);break;case'protocol':this._setTextAndTitle(cell,this._request.protocol);break;case'scheme':this._setTextAndTitle(cell,this._request.scheme);break;case'domain':this._setTextAndTitle(cell,this._request.domain);break;case'remoteaddress':this._setTextAndTitle(cell,this._request.remoteAddress());break;case'cookies':this._setTextAndTitle(cell,this._arrayLength(this._request.requestCookies));break;case'setcookies':this._setTextAndTitle(cell,this._arrayLength(this._request.responseCookies));break;case'priority':const priority=this._request.priority();this._setTextAndTitle(cell,priority?PerfUI.uiLabelForNetworkPriority(priority):'');break;case'connectionid':this._setTextAndTitle(cell,this._request.connectionId);break;case'type':this._setTextAndTitle(cell,this.displayType());break;case'initiator':this._renderInitiatorCell(cell);break;case'size':this._renderSizeCell(cell);break;case'time':this._renderTimeCell(cell);break;case'timeline':this._setTextAndTitle(cell,'');break;default:this._setTextAndTitle(cell,this._request.responseHeaderValue(columnId)||'');break;}}
_arrayLength(array){return array?''+array.length:'';}
select(supressSelectedEvent){super.select(supressSelectedEvent);this.parentView().dispatchEventToListeners(Network.NetworkLogView.Events.RequestSelected,this._request);}
highlightMatchedSubstring(regexp){if(!regexp)
return[];this.element();const domChanges=[];const matchInfo=this._nameCell.textContent.match(regexp);if(matchInfo)
UI.highlightSearchResult(this._nameCell,matchInfo.index,matchInfo[0].length,domChanges);return domChanges;}
_openInNewTab(){InspectorFrontendHost.openInNewTab(this._request.url());}
_isFailed(){return(this._request.failed&&!this._request.statusCode)||(this._request.statusCode>=400);}
_renderNameCell(cell){const leftPadding=this.leftPadding?this.leftPadding+'px':'';cell.style.setProperty('padding-left',leftPadding);this._nameCell=cell;cell.addEventListener('dblclick',this._openInNewTab.bind(this),false);let iconElement;if(this._request.resourceType()===Common.resourceTypes.Image){const previewImage=createElementWithClass('img','image-network-icon-preview');this._request.populateImageSource(previewImage);iconElement=createElementWithClass('div','icon');iconElement.appendChild(previewImage);}else{iconElement=createElementWithClass('img','icon');}
iconElement.classList.add(this._request.resourceType().name());cell.appendChild(iconElement);if(!this._nameBadgeElement){this._nameBadgeElement=this.parentView().badgePool.badgeForURL(this._request.parsedURL);this._nameBadgeElement.classList.add('network-badge');}
cell.appendChild(this._nameBadgeElement);const name=this._request.name().trimMiddle(100);const networkManager=SDK.NetworkManager.forRequest(this._request);cell.createTextChild(networkManager?networkManager.target().decorateLabel(name):name);this._appendSubtitle(cell,this._request.path());cell.title=this._request.url();}
_renderStatusCell(cell){cell.classList.toggle('network-dim-cell',!this._isFailed()&&(this._request.cached()||!this._request.statusCode));if(this._request.failed&&!this._request.canceled&&!this._request.wasBlocked()){const failText=Common.UIString('(failed)');if(this._request.localizedFailDescription){cell.createTextChild(failText);this._appendSubtitle(cell,this._request.localizedFailDescription);cell.title=failText+' '+this._request.localizedFailDescription;}else{this._setTextAndTitle(cell,failText);}}else if(this._request.statusCode){cell.createTextChild(''+this._request.statusCode);this._appendSubtitle(cell,this._request.statusText);cell.title=this._request.statusCode+' '+this._request.statusText;}else if(this._request.parsedURL.isDataURL()){this._setTextAndTitle(cell,Common.UIString('(data)'));}else if(this._request.canceled){this._setTextAndTitle(cell,Common.UIString('(canceled)'));}else if(this._request.wasBlocked()){let reason=Common.UIString('other');switch(this._request.blockedReason()){case Protocol.Network.BlockedReason.Other:reason=Common.UIString('other');break;case Protocol.Network.BlockedReason.Csp:reason=Common.UIString('csp');break;case Protocol.Network.BlockedReason.MixedContent:reason=Common.UIString('mixed-content');break;case Protocol.Network.BlockedReason.Origin:reason=Common.UIString('origin');break;case Protocol.Network.BlockedReason.Inspector:reason=Common.UIString('devtools');break;case Protocol.Network.BlockedReason.SubresourceFilter:reason=Common.UIString('subresource-filter');break;case Protocol.Network.BlockedReason.ContentType:reason=Common.UIString('content-type');break;case Protocol.Network.BlockedReason.CollapsedByClient:reason=Common.UIString('extension');break;}
this._setTextAndTitle(cell,Common.UIString('(blocked:%s)',reason));}else if(this._request.finished){this._setTextAndTitle(cell,Common.UIString('Finished'));}else{this._setTextAndTitle(cell,Common.UIString('(pending)'));}}
_renderInitiatorCell(cell){this._initiatorCell=cell;const request=this._request;const initiator=BrowserSDK.networkLog.initiatorInfoForRequest(request);const timing=request.timing;if(timing&&timing.pushStart)
cell.appendChild(createTextNode(Common.UIString('Push / ')));switch(initiator.type){case SDK.NetworkRequest.InitiatorType.Parser:cell.title=initiator.url+':'+(initiator.lineNumber+1);const uiSourceCode=Workspace.workspace.uiSourceCodeForURL(initiator.url);cell.appendChild(Components.Linkifier.linkifyURL(initiator.url,{text:uiSourceCode?uiSourceCode.displayName():undefined,lineNumber:initiator.lineNumber,columnNumber:initiator.columnNumber}));this._appendSubtitle(cell,Common.UIString('Parser'));break;case SDK.NetworkRequest.InitiatorType.Redirect:cell.title=initiator.url;const redirectSource=(request.redirectSource());console.assert(redirectSource);if(this.parentView().nodeForRequest(redirectSource)){cell.appendChild(Components.Linkifier.linkifyRevealable(redirectSource,Bindings.displayNameForURL(redirectSource.url())));}else{cell.appendChild(Components.Linkifier.linkifyURL(redirectSource.url()));}
this._appendSubtitle(cell,Common.UIString('Redirect'));break;case SDK.NetworkRequest.InitiatorType.Script:const networkManager=SDK.NetworkManager.forRequest(request);if(initiator.stack){this._linkifiedInitiatorAnchor=this.parentView().linkifier.linkifyStackTraceTopFrame(networkManager?networkManager.target():null,initiator.stack);}else{this._linkifiedInitiatorAnchor=this.parentView().linkifier.linkifyScriptLocation(networkManager?networkManager.target():null,initiator.scriptId,initiator.url,initiator.lineNumber,initiator.columnNumber);}
this._linkifiedInitiatorAnchor.title='';cell.appendChild(this._linkifiedInitiatorAnchor);this._appendSubtitle(cell,Common.UIString('Script'));cell.classList.add('network-script-initiated');cell.request=request;break;case SDK.NetworkRequest.InitiatorType.Preload:cell.title=Common.UIString('Preload');cell.classList.add('network-dim-cell');cell.appendChild(createTextNode(Common.UIString('Preload')));break;case SDK.NetworkRequest.InitiatorType.SignedExchange:cell.appendChild(Components.Linkifier.linkifyURL(initiator.url));this._appendSubtitle(cell,Common.UIString('signed-exchange'));break;default:cell.title=Common.UIString('Other');cell.classList.add('network-dim-cell');cell.appendChild(createTextNode(Common.UIString('Other')));}}
_renderSizeCell(cell){if(this._request.fetchedViaServiceWorker){this._setTextAndTitle(cell,Common.UIString('(from ServiceWorker)'));cell.classList.add('network-dim-cell');}else if(this._request.redirectSource()&&this._request.redirectSource().signedExchangeInfo()){this._setTextAndTitle(cell,Common.UIString('(from signed-exchange)'));cell.classList.add('network-dim-cell');}else if(this._request.cached()){if(this._request.cachedInMemory())
this._setTextAndTitle(cell,Common.UIString('(from memory cache)'));else
this._setTextAndTitle(cell,Common.UIString('(from disk cache)'));cell.classList.add('network-dim-cell');}else{const resourceSize=Number.bytesToString(this._request.resourceSize);const transferSize=Number.bytesToString(this._request.transferSize);this._setTextAndTitle(cell,transferSize);this._appendSubtitle(cell,resourceSize);}}
_renderTimeCell(cell){if(this._request.duration>0){this._setTextAndTitle(cell,Number.secondsToString(this._request.duration));this._appendSubtitle(cell,Number.secondsToString(this._request.latency));}else{cell.classList.add('network-dim-cell');this._setTextAndTitle(cell,Common.UIString('Pending'));}}
_appendSubtitle(cellElement,subtitleText){const subtitleElement=createElement('div');subtitleElement.className='network-cell-subtitle';subtitleElement.textContent=subtitleText;cellElement.appendChild(subtitleElement);}};Network.NetworkGroupNode=class extends Network.NetworkNode{renderCell(cell,columnId){if(columnId==='name'){const leftPadding=this.leftPadding?this.leftPadding+'px':'';cell.style.setProperty('padding-left',leftPadding);cell.classList.add('disclosure');}}
select(supressSelectedEvent){if(this.expanded){this.collapse();return;}
this.expand();}};;Network.NetworkItemView=class extends UI.TabbedPane{constructor(request,calculator){super();this.element.classList.add('network-item-view');this._resourceViewTabSetting=Common.settings.createSetting('resourceViewTab','preview');this._headersView=new Network.RequestHeadersView(request);this.appendTab(Network.NetworkItemView.Tabs.Headers,Common.UIString('Headers'),this._headersView);this.addEventListener(UI.TabbedPane.Events.TabSelected,this._tabSelected,this);if(request.resourceType()===Common.resourceTypes.WebSocket){const frameView=new Network.ResourceWebSocketFrameView(request);this.appendTab(Network.NetworkItemView.Tabs.WsFrames,Common.UIString('Frames'),frameView);}else if(request.mimeType==='text/event-stream'){this.appendTab(Network.NetworkItemView.Tabs.EventSource,Common.UIString('EventStream'),new Network.EventSourceMessagesView(request));}else{this._responseView=new Network.RequestResponseView(request);const previewView=new Network.RequestPreviewView(request);this.appendTab(Network.NetworkItemView.Tabs.Preview,Common.UIString('Preview'),previewView);if(request.signedExchangeInfo()&&request.signedExchangeInfo().errors&&request.signedExchangeInfo().errors.length){const icon=UI.Icon.create('smallicon-error');icon.title=Common.UIString('SignedExchange error');this.setTabIcon(Network.NetworkItemView.Tabs.Preview,icon);}
this.appendTab(Network.NetworkItemView.Tabs.Response,Common.UIString('Response'),this._responseView);}
if(request.requestCookies||request.responseCookies){this._cookiesView=new Network.RequestCookiesView(request);this.appendTab(Network.NetworkItemView.Tabs.Cookies,Common.UIString('Cookies'),this._cookiesView);}
this.appendTab(Network.NetworkItemView.Tabs.Timing,Common.UIString('Timing'),new Network.RequestTimingView(request,calculator));this._request=request;}
wasShown(){super.wasShown();this._selectTab();}
_selectTab(tabId){if(!tabId)
tabId=this._resourceViewTabSetting.get();if(!this.selectTab(tabId))
this.selectTab('headers');}
_tabSelected(event){if(!event.data.isUserGesture)
return;this._resourceViewTabSetting.set(event.data.tabId);}
request(){return this._request;}
async revealResponseBody(line){this._selectTab(Network.NetworkItemView.Tabs.Response);if(this._responseView&&typeof line==='number')
await this._responseView.revealLine((line));}
revealRequestHeader(header){this._selectTab(Network.NetworkItemView.Tabs.Headers);this._headersView.revealRequestHeader(header);}
revealResponseHeader(header){this._selectTab(Network.NetworkItemView.Tabs.Headers);this._headersView.revealResponseHeader(header);}};Network.NetworkItemView.Tabs={Cookies:'cookies',EventSource:'eventSource',Headers:'headers',Preview:'preview',Response:'response',Timing:'timing',WsFrames:'webSocketFrames'};;Network.NetworkTimeBoundary=class{constructor(minimum,maximum){this.minimum=minimum;this.maximum=maximum;}
equals(other){return(this.minimum===other.minimum)&&(this.maximum===other.maximum);}};Network.NetworkTimeCalculator=class extends Common.Object{constructor(startAtZero){super();this.startAtZero=startAtZero;this._minimumBoundary=-1;this._maximumBoundary=-1;this._boundryChangedEventThrottler=new Common.Throttler(0);this._window=null;}
setWindow(window){this._window=window;this._boundaryChanged();}
setInitialUserFriendlyBoundaries(){this._minimumBoundary=0;this._maximumBoundary=1;}
computePosition(time){return(time-this.minimumBoundary())/this.boundarySpan()*this._workingArea;}
formatValue(value,precision){return Number.secondsToString(value,!!precision);}
minimumBoundary(){return this._window?this._window.minimum:this._minimumBoundary;}
zeroTime(){return this._minimumBoundary;}
maximumBoundary(){return this._window?this._window.maximum:this._maximumBoundary;}
boundary(){return new Network.NetworkTimeBoundary(this.minimumBoundary(),this.maximumBoundary());}
boundarySpan(){return this.maximumBoundary()-this.minimumBoundary();}
reset(){this._minimumBoundary=-1;this._maximumBoundary=-1;this._boundaryChanged();}
_value(item){return 0;}
setDisplayWidth(clientWidth){this._workingArea=clientWidth;}
computeBarGraphPercentages(request){let start;let middle;let end;if(request.startTime!==-1)
start=((request.startTime-this.minimumBoundary())/this.boundarySpan())*100;else
start=0;if(request.responseReceivedTime!==-1)
middle=((request.responseReceivedTime-this.minimumBoundary())/this.boundarySpan())*100;else
middle=(this.startAtZero?start:100);if(request.endTime!==-1)
end=((request.endTime-this.minimumBoundary())/this.boundarySpan())*100;else
end=(this.startAtZero?middle:100);if(this.startAtZero){end-=start;middle-=start;start=0;}
return{start:start,middle:middle,end:end};}
computePercentageFromEventTime(eventTime){if(eventTime!==-1&&!this.startAtZero)
return((eventTime-this.minimumBoundary())/this.boundarySpan())*100;return 0;}
percentageToTime(percentage){return percentage*this.boundarySpan()/100+this.minimumBoundary();}
_boundaryChanged(){this._boundryChangedEventThrottler.schedule(dispatchEvent.bind(this));function dispatchEvent(){this.dispatchEventToListeners(Network.NetworkTimeCalculator.Events.BoundariesChanged);return Promise.resolve();}}
updateBoundariesForEventTime(eventTime){if(eventTime===-1||this.startAtZero)
return;if(this._maximumBoundary===undefined||eventTime>this._maximumBoundary){this._maximumBoundary=eventTime;this._boundaryChanged();}}
computeBarGraphLabels(request){let rightLabel='';if(request.responseReceivedTime!==-1&&request.endTime!==-1)
rightLabel=Number.secondsToString(request.endTime-request.responseReceivedTime);const hasLatency=request.latency>0;const leftLabel=hasLatency?Number.secondsToString(request.latency):rightLabel;if(request.timing)
return{left:leftLabel,right:rightLabel};let tooltip;if(hasLatency&&rightLabel){const total=Number.secondsToString(request.duration);tooltip=Network.NetworkTimeCalculator._latencyDownloadTotalFormat.format(leftLabel,rightLabel,total);}else if(hasLatency){tooltip=Network.NetworkTimeCalculator._latencyFormat.format(leftLabel);}else if(rightLabel){tooltip=Network.NetworkTimeCalculator._downloadFormat.format(rightLabel);}
if(request.fetchedViaServiceWorker)
tooltip=Network.NetworkTimeCalculator._fromServiceWorkerFormat.format(tooltip);else if(request.cached())
tooltip=Network.NetworkTimeCalculator._fromCacheFormat.format(tooltip);return{left:leftLabel,right:rightLabel,tooltip:tooltip};}
updateBoundaries(request){const lowerBound=this._lowerBound(request);const upperBound=this._upperBound(request);let changed=false;if(lowerBound!==-1||this.startAtZero)
changed=this._extendBoundariesToIncludeTimestamp(this.startAtZero?0:lowerBound);if(upperBound!==-1)
changed=this._extendBoundariesToIncludeTimestamp(upperBound)||changed;if(changed)
this._boundaryChanged();}
_extendBoundariesToIncludeTimestamp(timestamp){const previousMinimumBoundary=this._minimumBoundary;const previousMaximumBoundary=this._maximumBoundary;const minOffset=Network.NetworkTimeCalculator._minimumSpread;if(this._minimumBoundary===-1||this._maximumBoundary===-1){this._minimumBoundary=timestamp;this._maximumBoundary=timestamp+minOffset;}else{this._minimumBoundary=Math.min(timestamp,this._minimumBoundary);this._maximumBoundary=Math.max(timestamp,this._minimumBoundary+minOffset,this._maximumBoundary);}
return previousMinimumBoundary!==this._minimumBoundary||previousMaximumBoundary!==this._maximumBoundary;}
_lowerBound(request){return 0;}
_upperBound(request){return 0;}};Network.NetworkTimeCalculator._minimumSpread=0.1;Network.NetworkTimeCalculator.Events={BoundariesChanged:Symbol('BoundariesChanged')};Network.NetworkTimeCalculator._latencyDownloadTotalFormat=new Common.UIStringFormat('%s latency, %s download (%s total)');Network.NetworkTimeCalculator._latencyFormat=new Common.UIStringFormat('%s latency');Network.NetworkTimeCalculator._downloadFormat=new Common.UIStringFormat('%s download');Network.NetworkTimeCalculator._fromServiceWorkerFormat=new Common.UIStringFormat('%s (from ServiceWorker)');Network.NetworkTimeCalculator._fromCacheFormat=new Common.UIStringFormat('%s (from cache)');Network.NetworkTransferTimeCalculator=class extends Network.NetworkTimeCalculator{constructor(){super(false);}
formatValue(value,precision){return Number.secondsToString(value-this.zeroTime(),!!precision);}
_lowerBound(request){return request.issueTime();}
_upperBound(request){return request.endTime;}};Network.NetworkTransferDurationCalculator=class extends Network.NetworkTimeCalculator{constructor(){super(true);}
formatValue(value,precision){return Number.secondsToString(value,!!precision);}
_upperBound(request){return request.duration;}};;Network.NetworkLogView=class extends UI.VBox{constructor(filterBar,progressBarContainer,networkLogLargeRowsSetting){super();this.setMinimumSize(50,64);this.registerRequiredCSS('network/networkLogView.css');this.element.id='network-container';this._networkHideDataURLSetting=Common.settings.createSetting('networkHideDataURL',false);this._networkResourceTypeFiltersSetting=Common.settings.createSetting('networkResourceTypeFilters',{});this._rawRowHeight=0;this._progressBarContainer=progressBarContainer;this._networkLogLargeRowsSetting=networkLogLargeRowsSetting;this._networkLogLargeRowsSetting.addChangeListener(updateRowHeight.bind(this),this);function updateRowHeight(){this._rawRowHeight=!!this._networkLogLargeRowsSetting.get()?41:21;this._rowHeight=this._computeRowHeight();}
this._rawRowHeight=0;this._rowHeight=0;updateRowHeight.call(this);this._timeCalculator=new Network.NetworkTransferTimeCalculator();this._durationCalculator=new Network.NetworkTransferDurationCalculator();this._calculator=this._timeCalculator;this._columns=new Network.NetworkLogViewColumns(this,this._timeCalculator,this._durationCalculator,networkLogLargeRowsSetting);this._columns.show(this.element);this._staleRequests=new Set();this._mainRequestLoadTime=-1;this._mainRequestDOMContentLoadedTime=-1;this._highlightedSubstringChanges=[];this._filters=[];this._timeFilter=null;this._hoveredNode=null;this._recordingHint=null;this._refreshRequestId=null;this._highlightedNode=null;this.linkifier=new Components.Linkifier();this.badgePool=new ProductRegistry.BadgePool();this._recording=false;this._needsRefresh=false;this._headerHeight=0;this._groupLookups=new Map();this._groupLookups.set('Frame',new Network.NetworkFrameGrouper(this));this._activeGroupLookup=null;this._textFilterUI=new UI.TextFilterUI();this._textFilterUI.addEventListener(UI.FilterUI.Events.FilterChanged,this._filterChanged,this);filterBar.addFilter(this._textFilterUI);this._dataURLFilterUI=new UI.CheckboxFilterUI('hide-data-url',Common.UIString('Hide data URLs'),true,this._networkHideDataURLSetting);this._dataURLFilterUI.addEventListener(UI.FilterUI.Events.FilterChanged,this._filterChanged.bind(this),this);filterBar.addFilter(this._dataURLFilterUI);const filterItems=Object.values(Common.resourceCategories).map(category=>({name:category.title,label:category.shortTitle,title:category.title}));this._resourceCategoryFilterUI=new UI.NamedBitSetFilterUI(filterItems,this._networkResourceTypeFiltersSetting);this._resourceCategoryFilterUI.addEventListener(UI.FilterUI.Events.FilterChanged,this._filterChanged.bind(this),this);filterBar.addFilter(this._resourceCategoryFilterUI);this._filterParser=new TextUtils.FilterParser(Network.NetworkLogView._searchKeys);this._suggestionBuilder=new UI.FilterSuggestionBuilder(Network.NetworkLogView._searchKeys,Network.NetworkLogView._sortSearchValues);this._resetSuggestionBuilder();this._dataGrid=this._columns.dataGrid();this._setupDataGrid();this._columns.sortByCurrentColumn();filterBar.filterButton().addEventListener(UI.ToolbarButton.Events.Click,this._dataGrid.scheduleUpdate.bind(this._dataGrid,true));this._summaryBarElement=this.element.createChild('div','network-summary-bar');new UI.DropTarget(this.element,[UI.DropTarget.Type.File],Common.UIString('Drop HAR files here'),this._handleDrop.bind(this));Common.moduleSetting('networkColorCodeResourceTypes').addChangeListener(this._invalidateAllItems.bind(this,false),this);SDK.targetManager.observeModels(SDK.NetworkManager,this);BrowserSDK.networkLog.addEventListener(BrowserSDK.NetworkLog.Events.RequestAdded,this._onRequestUpdated,this);BrowserSDK.networkLog.addEventListener(BrowserSDK.NetworkLog.Events.RequestUpdated,this._onRequestUpdated,this);BrowserSDK.networkLog.addEventListener(BrowserSDK.NetworkLog.Events.Reset,this._reset,this);this._updateGroupByFrame();Common.moduleSetting('network.group-by-frame').addChangeListener(()=>this._updateGroupByFrame());this._filterBar=filterBar;}
_updateGroupByFrame(){const value=Common.moduleSetting('network.group-by-frame').get();this._setGrouping(value?'Frame':null);}
static _sortSearchValues(key,values){if(key===Network.NetworkLogView.FilterType.Priority){values.sort((a,b)=>{const aPriority=(PerfUI.uiLabelToNetworkPriority(a));const bPriority=(PerfUI.uiLabelToNetworkPriority(b));return PerfUI.networkPriorityWeight(aPriority)-PerfUI.networkPriorityWeight(bPriority);});}else{values.sort();}}
static _negativeFilter(filter,request){return!filter(request);}
static _requestPathFilter(regex,request){if(!regex)
return false;return regex.test(request.path()+'/'+request.name());}
static _subdomains(domain){const result=[domain];let indexOfPeriod=domain.indexOf('.');while(indexOfPeriod!==-1){result.push('*'+domain.substring(indexOfPeriod));indexOfPeriod=domain.indexOf('.',indexOfPeriod+1);}
return result;}
static _createRequestDomainFilter(value){function escapeForRegExp(string){return string.escapeForRegExp();}
const escapedPattern=value.split('*').map(escapeForRegExp).join('.*');return Network.NetworkLogView._requestDomainFilter.bind(null,new RegExp('^'+escapedPattern+'$','i'));}
static _requestDomainFilter(regex,request){return regex.test(request.domain);}
static _runningRequestFilter(request){return!request.finished;}
static _fromCacheRequestFilter(request){return request.cached();}
static _requestResponseHeaderFilter(value,request){return request.responseHeaderValue(value)!==undefined;}
static _requestMethodFilter(value,request){return request.requestMethod===value;}
static _requestPriorityFilter(value,request){return request.priority()===value;}
static _requestMimeTypeFilter(value,request){return request.mimeType===value;}
static _requestMixedContentFilter(value,request){if(value===Network.NetworkLogView.MixedContentFilterValues.Displayed)
return request.mixedContentType===Protocol.Security.MixedContentType.OptionallyBlockable;else if(value===Network.NetworkLogView.MixedContentFilterValues.Blocked)
return request.mixedContentType===Protocol.Security.MixedContentType.Blockable&&request.wasBlocked();else if(value===Network.NetworkLogView.MixedContentFilterValues.BlockOverridden)
return request.mixedContentType===Protocol.Security.MixedContentType.Blockable&&!request.wasBlocked();else if(value===Network.NetworkLogView.MixedContentFilterValues.All)
return request.mixedContentType!==Protocol.Security.MixedContentType.None;return false;}
static _requestSchemeFilter(value,request){return request.scheme===value;}
static _requestSetCookieDomainFilter(value,request){const cookies=request.responseCookies;for(let i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].domain()===value)
return true;}
return false;}
static _requestSetCookieNameFilter(value,request){const cookies=request.responseCookies;for(let i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].name()===value)
return true;}
return false;}
static _requestSetCookieValueFilter(value,request){const cookies=request.responseCookies;for(let i=0,l=cookies?cookies.length:0;i<l;++i){if(cookies[i].value()===value)
return true;}
return false;}
static _requestSizeLargerThanFilter(value,request){return request.transferSize>=value;}
static _statusCodeFilter(value,request){return(''+request.statusCode)===value;}
static HTTPRequestsFilter(request){return request.parsedURL.isValid&&(request.scheme in Network.NetworkLogView.HTTPSchemas);}
static FinishedRequestsFilter(request){return request.finished;}
static _requestTimeFilter(windowStart,windowEnd,request){if(request.issueTime()>windowEnd)
return false;if(request.endTime!==-1&&request.endTime<windowStart)
return false;return true;}
static _copyRequestHeaders(request){InspectorFrontendHost.copyText(request.requestHeadersText());}
static _copyResponseHeaders(request){InspectorFrontendHost.copyText(request.responseHeadersText);}
static async _copyResponse(request){const contentData=await request.contentData();let content=contentData.content;if(contentData.encoded){content=Common.ContentProvider.contentAsDataURL(contentData.content,request.mimeType,contentData.encoded,contentData.encoded?'utf-8':null);}
InspectorFrontendHost.copyText(content||'');}
_handleDrop(dataTransfer){const items=dataTransfer.items;if(!items.length)
return;const entry=items[0].webkitGetAsEntry();if(entry.isDirectory)
return;entry.file(this._onLoadFromFile.bind(this));}
async _onLoadFromFile(file){const outputStream=new Common.StringOutputStream();const reader=new Bindings.ChunkedFileReader(file,10000000);const success=await reader.read(outputStream);if(!success){this._harLoadFailed(reader.error().message);return;}
let harRoot;try{harRoot=new HARImporter.HARRoot(JSON.parse(outputStream.data()));}catch(e){this._harLoadFailed(e);return;}
BrowserSDK.networkLog.importRequests(HARImporter.Importer.requestsFromHARLog(harRoot.log));}
_harLoadFailed(message){Common.console.error('Failed to load HAR file with following error: '+message);}
_setGrouping(groupKey){if(this._activeGroupLookup)
this._activeGroupLookup.reset();const groupLookup=groupKey?this._groupLookups.get(groupKey)||null:null;this._activeGroupLookup=groupLookup;this._invalidateAllItems();}
_computeRowHeight(){return Math.round(this._rawRowHeight*window.devicePixelRatio)/window.devicePixelRatio;}
nodeForRequest(request){return request[Network.NetworkLogView._networkNodeSymbol]||null;}
headerHeight(){return this._headerHeight;}
setRecording(recording){this._recording=recording;this._updateSummaryBar();}
modelAdded(networkManager){if(networkManager.target().parentTarget())
return;const resourceTreeModel=networkManager.target().model(SDK.ResourceTreeModel);if(resourceTreeModel){resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.Load,this._loadEventFired,this);resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.DOMContentLoaded,this._domContentLoadedEventFired,this);}}
modelRemoved(networkManager){if(!networkManager.target().parentTarget()){const resourceTreeModel=networkManager.target().model(SDK.ResourceTreeModel);if(resourceTreeModel){resourceTreeModel.removeEventListener(SDK.ResourceTreeModel.Events.Load,this._loadEventFired,this);resourceTreeModel.removeEventListener(SDK.ResourceTreeModel.Events.DOMContentLoaded,this._domContentLoadedEventFired,this);}}}
setWindow(start,end){if(!start&&!end){this._timeFilter=null;this._timeCalculator.setWindow(null);}else{this._timeFilter=Network.NetworkLogView._requestTimeFilter.bind(null,start,end);this._timeCalculator.setWindow(new Network.NetworkTimeBoundary(start,end));}
this._filterRequests();}
clearSelection(){if(this._dataGrid.selectedNode)
this._dataGrid.selectedNode.deselect();}
_resetSuggestionBuilder(){this._suggestionBuilder.clear();this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Is,Network.NetworkLogView.IsFilterType.Running);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Is,Network.NetworkLogView.IsFilterType.FromCache);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.LargerThan,'100');this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.LargerThan,'10k');this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.LargerThan,'1M');this._textFilterUI.setSuggestionProvider(this._suggestionBuilder.completions.bind(this._suggestionBuilder));}
_filterChanged(event){this.removeAllNodeHighlights();this._parseFilterQuery(this._textFilterUI.value());this._filterRequests();}
_showRecordingHint(){this._hideRecordingHint();this._recordingHint=this.element.createChild('div','network-status-pane fill');const hintText=this._recordingHint.createChild('div','recording-hint');const reloadShortcutNode=this._recordingHint.createChild('b');reloadShortcutNode.textContent=UI.shortcutRegistry.shortcutDescriptorsForAction('inspector_main.reload')[0].name;if(this._recording){const recordingText=hintText.createChild('span');recordingText.textContent=Common.UIString('Recording network activity\u2026');hintText.createChild('br');hintText.appendChild(UI.formatLocalized('Perform a request or hit %s to record the reload.',[reloadShortcutNode]));}else{const recordNode=hintText.createChild('b');recordNode.textContent=UI.shortcutRegistry.shortcutTitleForAction('network.toggle-recording');hintText.appendChild(UI.formatLocalized('Record (%s) or reload (%s) to display network activity.',[recordNode,reloadShortcutNode]));}}
_hideRecordingHint(){if(this._recordingHint)
this._recordingHint.remove();this._recordingHint=null;}
elementsToRestoreScrollPositionsFor(){if(!this._dataGrid)
return[];return[this._dataGrid.scrollContainer];}
columnExtensionResolved(){this._invalidateAllItems(true);}
_setupDataGrid(){this._dataGrid.setRowContextMenuCallback((contextMenu,node)=>{const request=node.request();if(request)
this.handleContextMenuForRequest(contextMenu,request);});this._dataGrid.setStickToBottom(true);this._dataGrid.setName('networkLog');this._dataGrid.setResizeMethod(DataGrid.DataGrid.ResizeMethod.Last);this._dataGrid.element.classList.add('network-log-grid');this._dataGrid.element.addEventListener('mousedown',this._dataGridMouseDown.bind(this),true);this._dataGrid.element.addEventListener('mousemove',this._dataGridMouseMove.bind(this),true);this._dataGrid.element.addEventListener('mouseleave',()=>this._setHoveredNode(null),true);return this._dataGrid;}
_dataGridMouseMove(event){const node=(this._dataGrid.dataGridNodeFromNode((event.target)));const highlightInitiatorChain=event.shiftKey;this._setHoveredNode(node,highlightInitiatorChain);}
hoveredNode(){return this._hoveredNode;}
_setHoveredNode(node,highlightInitiatorChain){if(this._hoveredNode)
this._hoveredNode.setHovered(false,false);this._hoveredNode=node;if(this._hoveredNode)
this._hoveredNode.setHovered(true,!!highlightInitiatorChain);}
_dataGridMouseDown(event){if(!this._dataGrid.selectedNode&&event.button)
event.consume();}
_updateSummaryBar(){this._hideRecordingHint();let transferSize=0;let selectedNodeNumber=0;let selectedTransferSize=0;let baseTime=-1;let maxTime=-1;let nodeCount=0;for(const request of BrowserSDK.networkLog.requests()){const node=request[Network.NetworkLogView._networkNodeSymbol];if(!node)
continue;nodeCount++;const requestTransferSize=request.transferSize;transferSize+=requestTransferSize;if(!node[Network.NetworkLogView._isFilteredOutSymbol]){selectedNodeNumber++;selectedTransferSize+=requestTransferSize;}
const networkManager=SDK.NetworkManager.forRequest(request);if(networkManager&&request.url()===networkManager.target().inspectedURL()&&request.resourceType()===Common.resourceTypes.Document&&!networkManager.target().parentTarget())
baseTime=request.startTime;if(request.endTime>maxTime)
maxTime=request.endTime;}
if(!nodeCount){this._showRecordingHint();return;}
const summaryBar=this._summaryBarElement;summaryBar.removeChildren();const separator='\u2002\u2758\u2002';let text='';function appendChunk(chunk){const span=summaryBar.createChild('span');span.textContent=chunk;text+=chunk;return span;}
if(selectedNodeNumber!==nodeCount){appendChunk(Common.UIString('%d / %d requests',selectedNodeNumber,nodeCount));appendChunk(separator);appendChunk(Common.UIString('%s / %s transferred',Number.bytesToString(selectedTransferSize),Number.bytesToString(transferSize)));}else{appendChunk(Common.UIString('%d requests',nodeCount));appendChunk(separator);appendChunk(Common.UIString('%s transferred',Number.bytesToString(transferSize)));}
if(baseTime!==-1&&maxTime!==-1){appendChunk(separator);appendChunk(Common.UIString('Finish: %s',Number.secondsToString(maxTime-baseTime)));if(this._mainRequestDOMContentLoadedTime!==-1&&this._mainRequestDOMContentLoadedTime>baseTime){appendChunk(separator);const domContentLoadedText=Common.UIString('DOMContentLoaded: %s',Number.secondsToString(this._mainRequestDOMContentLoadedTime-baseTime));appendChunk(domContentLoadedText).classList.add('summary-blue');}
if(this._mainRequestLoadTime!==-1){appendChunk(separator);const loadText=Common.UIString('Load: %s',Number.secondsToString(this._mainRequestLoadTime-baseTime));appendChunk(loadText).classList.add('summary-red');}}
summaryBar.title=text;}
scheduleRefresh(){if(this._needsRefresh)
return;this._needsRefresh=true;if(this.isShowing()&&!this._refreshRequestId)
this._refreshRequestId=this.element.window().requestAnimationFrame(this._refresh.bind(this));}
addFilmStripFrames(times){this._columns.addEventDividers(times,'network-frame-divider');}
selectFilmStripFrame(time){this._columns.selectFilmStripFrame(time);}
clearFilmStripFrame(){this._columns.clearFilmStripFrame();}
_refreshIfNeeded(){if(this._needsRefresh)
this._refresh();}
_invalidateAllItems(deferUpdate){this._staleRequests=new Set(BrowserSDK.networkLog.requests());if(deferUpdate)
this.scheduleRefresh();else
this._refresh();}
timeCalculator(){return this._timeCalculator;}
calculator(){return this._calculator;}
setCalculator(x){if(!x||this._calculator===x)
return;if(this._calculator!==x){this._calculator=x;this._columns.setCalculator(this._calculator);}
this._calculator.reset();if(this._calculator.startAtZero)
this._columns.hideEventDividers();else
this._columns.showEventDividers();this._invalidateAllItems();}
_loadEventFired(event){if(!this._recording)
return;const time=(event.data.loadTime);if(time){this._mainRequestLoadTime=time;this._columns.addEventDividers([time],'network-red-divider');}}
_domContentLoadedEventFired(event){if(!this._recording)
return;const data=(event.data);if(data){this._mainRequestDOMContentLoadedTime=data;this._columns.addEventDividers([data],'network-blue-divider');}}
wasShown(){this._refreshIfNeeded();this._columns.wasShown();}
willHide(){this._columns.willHide();}
onResize(){this._rowHeight=this._computeRowHeight();}
flatNodesList(){return this._dataGrid.rootNode().flatChildren();}
stylesChanged(){this._columns.scheduleRefresh();}
_refresh(){this._needsRefresh=false;if(this._refreshRequestId){this.element.window().cancelAnimationFrame(this._refreshRequestId);this._refreshRequestId=null;}
this.removeAllNodeHighlights();this._timeCalculator.updateBoundariesForEventTime(this._mainRequestLoadTime);this._durationCalculator.updateBoundariesForEventTime(this._mainRequestLoadTime);this._timeCalculator.updateBoundariesForEventTime(this._mainRequestDOMContentLoadedTime);this._durationCalculator.updateBoundariesForEventTime(this._mainRequestDOMContentLoadedTime);const nodesToInsert=new Map();const nodesToRefresh=[];const staleNodes=new Set();while(this._staleRequests.size){const request=this._staleRequests.firstValue();this._staleRequests.delete(request);let node=request[Network.NetworkLogView._networkNodeSymbol];if(!node)
node=this._createNodeForRequest(request);staleNodes.add(node);}
for(const node of staleNodes){const isFilteredOut=!this._applyFilter(node);if(isFilteredOut&&node===this._hoveredNode)
this._setHoveredNode(null);if(!isFilteredOut)
nodesToRefresh.push(node);const request=node.request();this._timeCalculator.updateBoundaries(request);this._durationCalculator.updateBoundaries(request);const newParent=this._parentNodeForInsert(node);if(node[Network.NetworkLogView._isFilteredOutSymbol]===isFilteredOut&&node.parent===newParent)
continue;node[Network.NetworkLogView._isFilteredOutSymbol]=isFilteredOut;const removeFromParent=node.parent&&(isFilteredOut||node.parent!==newParent);if(removeFromParent){let parent=node.parent;parent.removeChild(node);while(parent&&!parent.hasChildren()&&parent.dataGrid&&parent.dataGrid.rootNode()!==parent){const grandparent=parent.parent;grandparent.removeChild(parent);parent=grandparent;}}
if(!newParent||isFilteredOut)
continue;if(!newParent.dataGrid&&!nodesToInsert.has(newParent)){nodesToInsert.set(newParent,this._dataGrid.rootNode());nodesToRefresh.push(newParent);}
nodesToInsert.set(node,newParent);}
for(const node of nodesToInsert.keys())
nodesToInsert.get(node).appendChild(node);for(const node of nodesToRefresh)
node.refresh();this._updateSummaryBar();if(nodesToInsert.size)
this._columns.sortByCurrentColumn();this._dataGrid.updateInstantly();this._didRefreshForTest();}
_didRefreshForTest(){}
_parentNodeForInsert(node){if(!this._activeGroupLookup)
return this._dataGrid.rootNode();const groupNode=this._activeGroupLookup.groupNodeForRequest(node.request());if(!groupNode)
return this._dataGrid.rootNode();return groupNode;}
_reset(){this.dispatchEventToListeners(Network.NetworkLogView.Events.RequestSelected,null);this._setHoveredNode(null);this._columns.reset();this._timeFilter=null;this._calculator.reset();this._timeCalculator.setWindow(null);this.linkifier.reset();this.badgePool.reset();if(this._activeGroupLookup)
this._activeGroupLookup.reset();this._staleRequests.clear();this._resetSuggestionBuilder();this._mainRequestLoadTime=-1;this._mainRequestDOMContentLoadedTime=-1;this._dataGrid.rootNode().removeChildren();this._updateSummaryBar();this._dataGrid.setStickToBottom(true);this.scheduleRefresh();}
setTextFilterValue(filterString){this._textFilterUI.setValue(filterString);this._dataURLFilterUI.setChecked(false);this._resourceCategoryFilterUI.reset();}
_createNodeForRequest(request){const node=new Network.NetworkRequestNode(this,request);request[Network.NetworkLogView._networkNodeSymbol]=node;node[Network.NetworkLogView._isFilteredOutSymbol]=true;for(let redirect=request.redirectSource();redirect;redirect=redirect.redirectSource())
this._refreshRequest(redirect);return node;}
_onRequestUpdated(event){const request=(event.data);this._refreshRequest(request);}
_refreshRequest(request){Network.NetworkLogView._subdomains(request.domain).forEach(this._suggestionBuilder.addItem.bind(this._suggestionBuilder,Network.NetworkLogView.FilterType.Domain));this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Method,request.requestMethod);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.MimeType,request.mimeType);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Scheme,''+request.scheme);this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.StatusCode,''+request.statusCode);const priority=request.priority();if(priority){this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.Priority,PerfUI.uiLabelForNetworkPriority(priority));}
if(request.mixedContentType!==Protocol.Security.MixedContentType.None){this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.MixedContent,Network.NetworkLogView.MixedContentFilterValues.All);}
if(request.mixedContentType===Protocol.Security.MixedContentType.OptionallyBlockable){this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.MixedContent,Network.NetworkLogView.MixedContentFilterValues.Displayed);}
if(request.mixedContentType===Protocol.Security.MixedContentType.Blockable){const suggestion=request.wasBlocked()?Network.NetworkLogView.MixedContentFilterValues.Blocked:Network.NetworkLogView.MixedContentFilterValues.BlockOverridden;this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.MixedContent,suggestion);}
const responseHeaders=request.responseHeaders;for(let i=0,l=responseHeaders.length;i<l;++i)
this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.HasResponseHeader,responseHeaders[i].name);const cookies=request.responseCookies;for(let i=0,l=cookies?cookies.length:0;i<l;++i){const cookie=cookies[i];this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.SetCookieDomain,cookie.domain());this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.SetCookieName,cookie.name());this._suggestionBuilder.addItem(Network.NetworkLogView.FilterType.SetCookieValue,cookie.value());}
this._staleRequests.add(request);this.scheduleRefresh();}
rowHeight(){return this._rowHeight;}
switchViewMode(gridMode){this._columns.switchViewMode(gridMode);}
handleContextMenuForRequest(contextMenu,request){contextMenu.appendApplicableItems(request);let copyMenu=contextMenu.clipboardSection().appendSubMenuItem(Common.UIString('Copy'));const footerSection=copyMenu.footerSection();if(request){copyMenu.defaultSection().appendItem(UI.copyLinkAddressLabel(),InspectorFrontendHost.copyText.bind(InspectorFrontendHost,request.contentURL()));if(request.requestHeadersText()){copyMenu.defaultSection().appendItem(Common.UIString('Copy request headers'),Network.NetworkLogView._copyRequestHeaders.bind(null,request));}
if(request.responseHeadersText){copyMenu.defaultSection().appendItem(Common.UIString('Copy response headers'),Network.NetworkLogView._copyResponseHeaders.bind(null,request));}
if(request.finished){copyMenu.defaultSection().appendItem(Common.UIString('Copy response'),Network.NetworkLogView._copyResponse.bind(null,request));}
if(Host.isWin()){footerSection.appendItem(Common.UIString('Copy as PowerShell'),this._copyPowerShellCommand.bind(this,request));footerSection.appendItem(Common.UIString('Copy as fetch'),this._copyFetchCall.bind(this,request));footerSection.appendItem(Common.UIString('Copy as cURL (cmd)'),this._copyCurlCommand.bind(this,request,'win'));footerSection.appendItem(Common.UIString('Copy as cURL (bash)'),this._copyCurlCommand.bind(this,request,'unix'));footerSection.appendItem(Common.UIString('Copy all as PowerShell'),this._copyAllPowerShellCommand.bind(this));footerSection.appendItem(Common.UIString('Copy all as fetch'),this._copyAllFetchCall.bind(this));footerSection.appendItem(Common.UIString('Copy all as cURL (cmd)'),this._copyAllCurlCommand.bind(this,'win'));footerSection.appendItem(Common.UIString('Copy all as cURL (bash)'),this._copyAllCurlCommand.bind(this,'unix'));}else{footerSection.appendItem(Common.UIString('Copy as fetch'),this._copyFetchCall.bind(this,request));footerSection.appendItem(Common.UIString('Copy as cURL'),this._copyCurlCommand.bind(this,request,'unix'));footerSection.appendItem(Common.UIString('Copy all as fetch'),this._copyAllFetchCall.bind(this));footerSection.appendItem(Common.UIString('Copy all as cURL'),this._copyAllCurlCommand.bind(this,'unix'));}}else{copyMenu=contextMenu.clipboardSection().appendSubMenuItem(Common.UIString('Copy'));}
footerSection.appendItem(Common.UIString('Copy all as HAR'),this._copyAll.bind(this));contextMenu.saveSection().appendItem(Common.UIString('Save as HAR with content'),this._exportAll.bind(this));contextMenu.editSection().appendItem(Common.UIString('Clear browser cache'),this._clearBrowserCache.bind(this));contextMenu.editSection().appendItem(Common.UIString('Clear browser cookies'),this._clearBrowserCookies.bind(this));if(request){const maxBlockedURLLength=20;const manager=SDK.multitargetNetworkManager;let patterns=manager.blockedPatterns();const urlWithoutScheme=request.parsedURL.urlWithoutScheme();if(urlWithoutScheme&&!patterns.find(pattern=>pattern.url===urlWithoutScheme)){contextMenu.debugSection().appendItem(Common.UIString('Block request URL'),addBlockedURL.bind(null,urlWithoutScheme));}else if(urlWithoutScheme){const croppedURL=urlWithoutScheme.trimMiddle(maxBlockedURLLength);contextMenu.debugSection().appendItem(Common.UIString('Unblock %s',croppedURL),removeBlockedURL.bind(null,urlWithoutScheme));}
const domain=request.parsedURL.domain();if(domain&&!patterns.find(pattern=>pattern.url===domain)){contextMenu.debugSection().appendItem(Common.UIString('Block request domain'),addBlockedURL.bind(null,domain));}else if(domain){const croppedDomain=domain.trimMiddle(maxBlockedURLLength);contextMenu.debugSection().appendItem(Common.UIString('Unblock %s',croppedDomain),removeBlockedURL.bind(null,domain));}
if(SDK.NetworkManager.canReplayRequest(request)){contextMenu.debugSection().appendItem(Common.UIString('Replay XHR'),SDK.NetworkManager.replayRequest.bind(null,request));}
function addBlockedURL(url){patterns.push({enabled:true,url:url});manager.setBlockedPatterns(patterns);manager.setBlockingEnabled(true);UI.viewManager.showView('network.blocked-urls');}
function removeBlockedURL(url){patterns=patterns.filter(pattern=>pattern.url!==url);manager.setBlockedPatterns(patterns);UI.viewManager.showView('network.blocked-urls');}}}
_harRequests(){const httpRequests=BrowserSDK.networkLog.requests().filter(Network.NetworkLogView.HTTPRequestsFilter);return httpRequests.filter(Network.NetworkLogView.FinishedRequestsFilter);}
async _copyAll(){const harArchive={log:await BrowserSDK.HARLog.build(this._harRequests())};InspectorFrontendHost.copyText(JSON.stringify(harArchive,null,2));}
async _copyCurlCommand(request,platform){const command=await this._generateCurlCommand(request,platform);InspectorFrontendHost.copyText(command);}
async _copyAllCurlCommand(platform){const requests=BrowserSDK.networkLog.requests();const commands=await Promise.all(requests.map(request=>this._generateCurlCommand(request,platform)));if(platform==='win')
InspectorFrontendHost.copyText(commands.join(' &\r\n'));else
InspectorFrontendHost.copyText(commands.join(' ;\n'));}
async _copyFetchCall(request,platform){const command=await this._generateFetchCall(request);InspectorFrontendHost.copyText(command);}
async _copyAllFetchCall(){const requests=BrowserSDK.networkLog.requests();const commands=await Promise.all(requests.map(request=>this._generateFetchCall(request)));InspectorFrontendHost.copyText(commands.join(' ;\n'));}
async _copyPowerShellCommand(request){const command=await this._generatePowerShellCommand(request);InspectorFrontendHost.copyText(command);}
async _copyAllPowerShellCommand(){const requests=BrowserSDK.networkLog.requests();const commands=await Promise.all(requests.map(request=>this._generatePowerShellCommand(request)));InspectorFrontendHost.copyText(commands.join(';\r\n'));}
async _exportAll(){const url=SDK.targetManager.mainTarget().inspectedURL();const parsedURL=url.asParsedURL();const filename=parsedURL?parsedURL.host:'network-log';const stream=new Bindings.FileOutputStream();if(!await stream.open(filename+'.har'))
return;const progressIndicator=new UI.ProgressIndicator();this._progressBarContainer.appendChild(progressIndicator.element);await Network.HARWriter.write(stream,this._harRequests(),progressIndicator);progressIndicator.done();stream.close();}
_clearBrowserCache(){if(confirm(Common.UIString('Are you sure you want to clear browser cache?')))
SDK.multitargetNetworkManager.clearBrowserCache();}
_clearBrowserCookies(){if(confirm(Common.UIString('Are you sure you want to clear browser cookies?')))
SDK.multitargetNetworkManager.clearBrowserCookies();}
_removeAllHighlights(){this.removeAllNodeHighlights();for(let i=0;i<this._highlightedSubstringChanges.length;++i)
UI.revertDomChanges(this._highlightedSubstringChanges[i]);this._highlightedSubstringChanges=[];}
_applyFilter(node){const request=node.request();if(this._timeFilter&&!this._timeFilter(request))
return false;const categoryName=request.resourceType().category().title;if(!this._resourceCategoryFilterUI.accept(categoryName))
return false;if(this._dataURLFilterUI.checked()&&request.parsedURL.isDataURL())
return false;if(request.statusText==='Service Worker Fallback Required')
return false;for(let i=0;i<this._filters.length;++i){if(!this._filters[i](request))
return false;}
return true;}
_parseFilterQuery(query){const descriptors=this._filterParser.parse(query);this._filters=descriptors.map(descriptor=>{const key=descriptor.key;const text=descriptor.text||'';const regex=descriptor.regex;let filter;if(key){const defaultText=(key+':'+text).escapeForRegExp();filter=this._createSpecialFilter((key),text)||Network.NetworkLogView._requestPathFilter.bind(null,new RegExp(defaultText,'i'));}else if(descriptor.regex){filter=Network.NetworkLogView._requestPathFilter.bind(null,(regex));}else{filter=Network.NetworkLogView._requestPathFilter.bind(null,new RegExp(text.escapeForRegExp(),'i'));}
return descriptor.negative?Network.NetworkLogView._negativeFilter.bind(null,filter):filter;});}
_createSpecialFilter(type,value){switch(type){case Network.NetworkLogView.FilterType.Domain:return Network.NetworkLogView._createRequestDomainFilter(value);case Network.NetworkLogView.FilterType.HasResponseHeader:return Network.NetworkLogView._requestResponseHeaderFilter.bind(null,value);case Network.NetworkLogView.FilterType.Is:if(value.toLowerCase()===Network.NetworkLogView.IsFilterType.Running)
return Network.NetworkLogView._runningRequestFilter;if(value.toLowerCase()===Network.NetworkLogView.IsFilterType.FromCache)
return Network.NetworkLogView._fromCacheRequestFilter;break;case Network.NetworkLogView.FilterType.LargerThan:return this._createSizeFilter(value.toLowerCase());case Network.NetworkLogView.FilterType.Method:return Network.NetworkLogView._requestMethodFilter.bind(null,value);case Network.NetworkLogView.FilterType.MimeType:return Network.NetworkLogView._requestMimeTypeFilter.bind(null,value);case Network.NetworkLogView.FilterType.MixedContent:return Network.NetworkLogView._requestMixedContentFilter.bind(null,(value));case Network.NetworkLogView.FilterType.Scheme:return Network.NetworkLogView._requestSchemeFilter.bind(null,value);case Network.NetworkLogView.FilterType.SetCookieDomain:return Network.NetworkLogView._requestSetCookieDomainFilter.bind(null,value);case Network.NetworkLogView.FilterType.SetCookieName:return Network.NetworkLogView._requestSetCookieNameFilter.bind(null,value);case Network.NetworkLogView.FilterType.SetCookieValue:return Network.NetworkLogView._requestSetCookieValueFilter.bind(null,value);case Network.NetworkLogView.FilterType.Priority:return Network.NetworkLogView._requestPriorityFilter.bind(null,PerfUI.uiLabelToNetworkPriority(value));case Network.NetworkLogView.FilterType.StatusCode:return Network.NetworkLogView._statusCodeFilter.bind(null,value);}
return null;}
_createSizeFilter(value){let multiplier=1;if(value.endsWith('k')){multiplier=1024;value=value.substring(0,value.length-1);}else if(value.endsWith('m')){multiplier=1024*1024;value=value.substring(0,value.length-1);}
const quantity=Number(value);if(isNaN(quantity))
return null;return Network.NetworkLogView._requestSizeLargerThanFilter.bind(null,quantity*multiplier);}
_filterRequests(){this._removeAllHighlights();this._invalidateAllItems();}
_reveal(request){this.removeAllNodeHighlights();const node=request[Network.NetworkLogView._networkNodeSymbol];if(!node||!node.dataGrid)
return null;node.reveal();return node;}
revealAndHighlightRequest(request){const node=this._reveal(request);if(node)
this._highlightNode(node);}
selectRequest(request){this.setTextFilterValue('');const node=this._reveal(request);if(node)
node.select();}
removeAllNodeHighlights(){if(this._highlightedNode){this._highlightedNode.element().classList.remove('highlighted-row');this._highlightedNode=null;}}
_highlightNode(node){UI.runCSSAnimationOnce(node.element(),'highlighted-row');this._highlightedNode=node;}
async _generateFetchCall(request){const ignoredHeaders={'method':1,'path':1,'scheme':1,'version':1,'accept-charset':1,'accept-encoding':1,'access-control-request-headers':1,'access-control-request-method':1,'connection':1,'content-length':1,'cookie':1,'cookie2':1,'date':1,'dnt':1,'expect':1,'host':1,'keep-alive':1,'origin':1,'referer':1,'te':1,'trailer':1,'transfer-encoding':1,'upgrade':1,'via':1,'user-agent':1};const credentialHeaders={'cookie':1,'authorization':1};const url=JSON.stringify(request.url());const requestHeaders=request.requestHeaders();const headerData=requestHeaders.reduce((result,header)=>{const name=header.name;if(!ignoredHeaders[name.toLowerCase()]&&!name.includes(':'))
result.append(name,header.value);return result;},new Headers());const headers={};for(const headerArray of headerData)
headers[headerArray[0]]=headers[headerArray[1]];const credentials=request.requestCookies||requestHeaders.some(({name})=>credentialHeaders[name.toLowerCase()])?'include':'omit';const referrerHeader=requestHeaders.find(({name})=>name.toLowerCase()==='referer');const referrer=referrerHeader?referrerHeader.value:void 0;const referrerPolicy=request.referrerPolicy()||void 0;const requestBody=await request.requestFormData();const fetchOptions={credentials,headers,referrer,referrerPolicy,body:requestBody,method:request.requestMethod,mode:'cors'};const options=JSON.stringify(fetchOptions);return`fetch(${url}, ${options});`;}
async _generateCurlCommand(request,platform){let command=['curl'];const ignoredHeaders={'host':1,'method':1,'path':1,'scheme':1,'version':1};function escapeStringWin(str){const encapsChars=/[\r\n]/.test(str)?'^"':'"';return encapsChars+
str.replace(/\\/g,'\\\\').replace(/"/g,'\\"').replace(/[^a-zA-Z0-9\s_\-:=+~'\/.',?;()*`]/g,'^$&').replace(/%(?=[a-zA-Z0-9_])/g,'%^').replace(/\r\n|[\n\r]/g,'^\n\n')+
encapsChars;}
function escapeStringPosix(str){function escapeCharacter(x){let code=x.charCodeAt(0);if(code<256){return code<16?'\\x0'+code.toString(16):'\\x'+code.toString(16);}
code=code.toString(16);return'\\u'+('0000'+code).substr(code.length,4);}
if(/[^\x20-\x7E]|\'/.test(str)){return'$\''+
str.replace(/\\/g,'\\\\').replace(/\'/g,'\\\'').replace(/\n/g,'\\n').replace(/\r/g,'\\r').replace(/[^\x20-\x7E]/g,escapeCharacter)+'\'';}else{return'\''+str+'\'';}}
const escapeString=platform==='win'?escapeStringWin:escapeStringPosix;command.push(escapeString(request.url()).replace(/[[{}\]]/g,'\\$&'));let inferredMethod='GET';const data=[];const requestContentType=request.requestContentType();const formData=await request.requestFormData();if(requestContentType&&requestContentType.startsWith('application/x-www-form-urlencoded')&&formData){data.push('--data');data.push(escapeString(formData));ignoredHeaders['content-length']=true;inferredMethod='POST';}else if(formData){data.push('--data-binary');data.push(escapeString(formData));ignoredHeaders['content-length']=true;inferredMethod='POST';}
if(request.requestMethod!==inferredMethod){command.push('-X');command.push(request.requestMethod);}
const requestHeaders=request.requestHeaders();for(let i=0;i<requestHeaders.length;i++){const header=requestHeaders[i];const name=header.name.replace(/^:/,'');if(name.toLowerCase()in ignoredHeaders)
continue;command.push('-H');command.push(escapeString(name+': '+header.value));}
command=command.concat(data);command.push('--compressed');if(request.securityState()===Protocol.Security.SecurityState.Insecure)
command.push('--insecure');return command.join(' ');}
async _generatePowerShellCommand(request){const command=['Invoke-WebRequest'];const ignoredHeaders=new Set(['host','connection','proxy-connection','content-length','expect','range','content-type']);function escapeString(str){return'"'+
str.replace(/[`\$"]/g,'`$&').replace(/[^\x20-\x7E]/g,char=>'$([char]'+char.charCodeAt(0)+')')+'"';}
command.push('-Uri');command.push(escapeString(request.url()));if(request.requestMethod!=='GET'){command.push('-Method');command.push(escapeString(request.requestMethod));}
const requestHeaders=request.requestHeaders();const headerNameValuePairs=[];for(const header of requestHeaders){const name=header.name.replace(/^:/,'');if(ignoredHeaders.has(name.toLowerCase()))
continue;headerNameValuePairs.push(escapeString(name)+'='+escapeString(header.value));}
if(headerNameValuePairs.length){command.push('-Headers');command.push('@{'+headerNameValuePairs.join('; ')+'}');}
const contentTypeHeader=requestHeaders.find(({name})=>name.toLowerCase()==='content-type');if(contentTypeHeader){command.push('-ContentType');command.push(escapeString(contentTypeHeader.value));}
const formData=await request.requestFormData();if(formData){command.push('-Body');const body=escapeString(formData);if(/[^\x20-\x7E]/.test(formData))
command.push('([System.Text.Encoding]::UTF8.GetBytes('+body+'))');else
command.push(body);}
return command.join(' ');}};Network.NetworkLogView._isFilteredOutSymbol=Symbol('isFilteredOut');Network.NetworkLogView._networkNodeSymbol=Symbol('NetworkNode');Network.NetworkLogView.HTTPSchemas={'http':true,'https':true,'ws':true,'wss':true};Network.NetworkLogView.Events={RequestSelected:Symbol('RequestSelected')};Network.NetworkLogView.FilterType={Domain:'domain',HasResponseHeader:'has-response-header',Is:'is',LargerThan:'larger-than',Method:'method',MimeType:'mime-type',MixedContent:'mixed-content',Priority:'priority',Scheme:'scheme',SetCookieDomain:'set-cookie-domain',SetCookieName:'set-cookie-name',SetCookieValue:'set-cookie-value',StatusCode:'status-code'};Network.NetworkLogView.MixedContentFilterValues={All:'all',Displayed:'displayed',Blocked:'blocked',BlockOverridden:'block-overridden'};Network.NetworkLogView.IsFilterType={Running:'running',FromCache:'from-cache'};Network.NetworkLogView._searchKeys=Object.keys(Network.NetworkLogView.FilterType).map(key=>Network.NetworkLogView.FilterType[key]);Network.NetworkLogView.Filter;Network.GroupLookupInterface=function(){};Network.GroupLookupInterface.prototype={groupNodeForRequest:function(request){},reset:function(){}};;Network.NetworkLogViewColumns=class{constructor(networkLogView,timeCalculator,durationCalculator,networkLogLargeRowsSetting){this._networkLogView=networkLogView;this._persistantSettings=Common.settings.createSetting('networkLogColumns',{});this._networkLogLargeRowsSetting=networkLogLargeRowsSetting;this._networkLogLargeRowsSetting.addChangeListener(this._updateRowsSize,this);this._eventDividers=new Map();this._eventDividersShown=false;this._gridMode=true;this._columns=[];this._waterfallRequestsAreStale=false;this._waterfallScrollerWidthIsStale=true;this._popupLinkifier=new Components.Linkifier();this._calculatorsMap=new Map();this._calculatorsMap.set(Network.NetworkLogViewColumns._calculatorTypes.Time,timeCalculator);this._calculatorsMap.set(Network.NetworkLogViewColumns._calculatorTypes.Duration,durationCalculator);this._lastWheelTime=0;this._setupDataGrid();this._setupWaterfall();}
static _convertToDataGridDescriptor(columnConfig){return({id:columnConfig.id,title:columnConfig.title,sortable:columnConfig.sortable,align:columnConfig.align,nonSelectable:columnConfig.nonSelectable,weight:columnConfig.weight});}
wasShown(){this._updateRowsSize();}
willHide(){this._popoverHelper.hidePopover();}
reset(){if(this._popoverHelper)
this._popoverHelper.hidePopover();this._eventDividers.clear();}
_setupDataGrid(){const defaultColumns=Network.NetworkLogViewColumns._defaultColumns;const defaultColumnConfig=Network.NetworkLogViewColumns._defaultColumnConfig;this._columns=([]);for(const currentConfigColumn of defaultColumns){const columnConfig=(Object.assign({},defaultColumnConfig,currentConfigColumn));columnConfig.id=columnConfig.id;if(columnConfig.subtitle)
columnConfig.titleDOMFragment=this._makeHeaderFragment(columnConfig.title,columnConfig.subtitle);this._columns.push(columnConfig);}
this._loadCustomColumnsAndSettings();this._popoverHelper=new UI.PopoverHelper(this._networkLogView.element,this._getPopoverRequest.bind(this));this._popoverHelper.setHasPadding(true);this._popoverHelper.setTimeout(300,300);this._dataGrid=new DataGrid.SortableDataGrid(this._columns.map(Network.NetworkLogViewColumns._convertToDataGridDescriptor));this._dataGrid.element.addEventListener('mousedown',event=>{if(!this._dataGrid.selectedNode&&event.button)
event.consume();},true);this._dataGridScroller=this._dataGrid.scrollContainer;this._updateColumns();this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._sortHandler,this);this._dataGrid.setHeaderContextMenuCallback(this._innerHeaderContextMenu.bind(this));this._activeWaterfallSortId=Network.NetworkLogViewColumns.WaterfallSortIds.StartTime;this._dataGrid.markColumnAsSortedBy(Network.NetworkLogViewColumns._initialSortColumn,DataGrid.DataGrid.Order.Ascending);this._splitWidget=new UI.SplitWidget(true,true,'networkPanelSplitViewWaterfall',200);const widget=this._dataGrid.asWidget();widget.setMinimumSize(150,0);this._splitWidget.setMainWidget(widget);}
_setupWaterfall(){this._waterfallColumn=new Network.NetworkWaterfallColumn(this._networkLogView.calculator());this._waterfallColumn.element.addEventListener('contextmenu',handleContextMenu.bind(this));this._waterfallColumn.element.addEventListener('mousewheel',this._onMouseWheel.bind(this,false),{passive:true});this._dataGridScroller.addEventListener('mousewheel',this._onMouseWheel.bind(this,true),true);this._waterfallScroller=this._waterfallColumn.contentElement.createChild('div','network-waterfall-v-scroll');this._waterfallScrollerContent=this._waterfallScroller.createChild('div','network-waterfall-v-scroll-content');this._dataGrid.addEventListener(DataGrid.DataGrid.Events.PaddingChanged,()=>{this._waterfallScrollerWidthIsStale=true;this._syncScrollers();});this._dataGrid.addEventListener(DataGrid.ViewportDataGrid.Events.ViewportCalculated,this._redrawWaterfallColumn.bind(this));this._createWaterfallHeader();this._waterfallColumn.contentElement.classList.add('network-waterfall-view');this._waterfallColumn.setMinimumSize(100,0);this._splitWidget.setSidebarWidget(this._waterfallColumn);this.switchViewMode(false);function handleContextMenu(event){const node=this._waterfallColumn.getNodeFromPoint(event.offsetX,event.offsetY);if(!node)
return;const request=node.request();if(!request)
return;const contextMenu=new UI.ContextMenu(event);this._networkLogView.handleContextMenuForRequest(contextMenu,request);contextMenu.show();}}
_onMouseWheel(shouldConsume,event){if(shouldConsume)
event.consume(true);const hasRecentWheel=Date.now()-this._lastWheelTime<80;this._activeScroller.scrollBy({top:-event.wheelDeltaY,behavior:hasRecentWheel?'instant':'smooth'});this._syncScrollers();this._lastWheelTime=Date.now();}
_syncScrollers(){if(!this._waterfallColumn.isShowing())
return;this._waterfallScrollerContent.style.height=this._dataGridScroller.scrollHeight+'px';this._updateScrollerWidthIfNeeded();this._dataGridScroller.scrollTop=this._waterfallScroller.scrollTop;}
_updateScrollerWidthIfNeeded(){if(this._waterfallScrollerWidthIsStale){this._waterfallScrollerWidthIsStale=false;this._waterfallColumn.setRightPadding(this._waterfallScroller.offsetWidth-this._waterfallScrollerContent.offsetWidth);}}
_redrawWaterfallColumn(){if(!this._waterfallRequestsAreStale){this._updateScrollerWidthIfNeeded();this._waterfallColumn.update(this._activeScroller.scrollTop,this._eventDividersShown?this._eventDividers:undefined);return;}
this._syncScrollers();const nodes=this._networkLogView.flatNodesList();this._waterfallColumn.update(this._activeScroller.scrollTop,this._eventDividers,nodes);}
_createWaterfallHeader(){this._waterfallHeaderElement=this._waterfallColumn.contentElement.createChild('div','network-waterfall-header');this._waterfallHeaderElement.addEventListener('click',waterfallHeaderClicked.bind(this));this._waterfallHeaderElement.addEventListener('contextmenu',event=>this._innerHeaderContextMenu(new UI.ContextMenu(event)));const innerElement=this._waterfallHeaderElement.createChild('div');innerElement.textContent=Common.UIString('Waterfall');this._waterfallColumnSortIcon=UI.Icon.create('','sort-order-icon');this._waterfallHeaderElement.createChild('div','sort-order-icon-container').appendChild(this._waterfallColumnSortIcon);function waterfallHeaderClicked(){const sortOrders=DataGrid.DataGrid.Order;const sortOrder=this._dataGrid.sortOrder()===sortOrders.Ascending?sortOrders.Descending:sortOrders.Ascending;this._dataGrid.markColumnAsSortedBy('waterfall',sortOrder);this._sortHandler();}}
setCalculator(x){this._waterfallColumn.setCalculator(x);}
scheduleRefresh(){this._waterfallColumn.scheduleDraw();}
_updateRowsSize(){const largeRows=!!this._networkLogLargeRowsSetting.get();this._dataGrid.element.classList.toggle('small',!largeRows);this._dataGrid.scheduleUpdate();this._waterfallScrollerWidthIsStale=true;this._waterfallColumn.setRowHeight(largeRows?41:21);this._waterfallScroller.classList.toggle('small',!largeRows);this._waterfallHeaderElement.classList.toggle('small',!largeRows);this._waterfallColumn.setHeaderHeight(this._waterfallScroller.offsetTop);}
show(element){this._splitWidget.show(element);}
dataGrid(){return this._dataGrid;}
sortByCurrentColumn(){this._sortHandler();}
_sortHandler(){const columnId=this._dataGrid.sortColumnId();this._networkLogView.removeAllNodeHighlights();this._waterfallRequestsAreStale=true;if(columnId==='waterfall'){if(this._dataGrid.sortOrder()===DataGrid.DataGrid.Order.Ascending)
this._waterfallColumnSortIcon.setIconType('smallicon-triangle-up');else
this._waterfallColumnSortIcon.setIconType('smallicon-triangle-down');const sortFunction=Network.NetworkRequestNode.RequestPropertyComparator.bind(null,this._activeWaterfallSortId);this._dataGrid.sortNodes(sortFunction,!this._dataGrid.isSortOrderAscending());this._dataGridSortedForTest();return;}
this._waterfallColumnSortIcon.setIconType('');const columnConfig=this._columns.find(columnConfig=>columnConfig.id===columnId);if(!columnConfig||!columnConfig.sortingFunction)
return;this._dataGrid.sortNodes(columnConfig.sortingFunction,!this._dataGrid.isSortOrderAscending());this._dataGridSortedForTest();}
_dataGridSortedForTest(){}
_updateColumns(){if(!this._dataGrid)
return;const visibleColumns=({});if(this._gridMode){for(const columnConfig of this._columns)
visibleColumns[columnConfig.id]=columnConfig.visible;}else{visibleColumns.name=true;}
this._dataGrid.setColumnsVisiblity(visibleColumns);}
switchViewMode(gridMode){if(this._gridMode===gridMode)
return;this._gridMode=gridMode;if(gridMode){if(this._dataGrid.selectedNode)
this._dataGrid.selectedNode.selected=false;this._splitWidget.showBoth();this._activeScroller=this._waterfallScroller;this._waterfallScroller.scrollTop=this._dataGridScroller.scrollTop;this._dataGrid.setScrollContainer(this._waterfallScroller);}else{this._networkLogView.removeAllNodeHighlights();this._splitWidget.hideSidebar();this._activeScroller=this._dataGridScroller;this._dataGrid.setScrollContainer(this._dataGridScroller);}
this._networkLogView.element.classList.toggle('brief-mode',!gridMode);this._updateColumns();this._updateRowsSize();}
_toggleColumnVisibility(columnConfig){this._loadCustomColumnsAndSettings();columnConfig.visible=!columnConfig.visible;this._saveColumnsSettings();this._updateColumns();}
_saveColumnsSettings(){const saveableSettings={};for(const columnConfig of this._columns)
saveableSettings[columnConfig.id]={visible:columnConfig.visible,title:columnConfig.title};this._persistantSettings.set(saveableSettings);}
_loadCustomColumnsAndSettings(){const savedSettings=this._persistantSettings.get();const columnIds=Object.keys(savedSettings);for(const columnId of columnIds){const setting=savedSettings[columnId];let columnConfig=this._columns.find(columnConfig=>columnConfig.id===columnId);if(!columnConfig)
columnConfig=this._addCustomHeader(setting.title,columnId);if(columnConfig.hideable&&typeof setting.visible==='boolean')
columnConfig.visible=!!setting.visible;if(typeof setting.title==='string')
columnConfig.title=setting.title;}}
_makeHeaderFragment(title,subtitle){const fragment=createDocumentFragment();fragment.createTextChild(title);const subtitleDiv=fragment.createChild('div','network-header-subtitle');subtitleDiv.createTextChild(subtitle);return fragment;}
_innerHeaderContextMenu(contextMenu){const columnConfigs=this._columns.filter(columnConfig=>columnConfig.hideable);const nonResponseHeaders=columnConfigs.filter(columnConfig=>!columnConfig.isResponseHeader);for(const columnConfig of nonResponseHeaders){contextMenu.headerSection().appendCheckboxItem(columnConfig.title,this._toggleColumnVisibility.bind(this,columnConfig),columnConfig.visible);}
const responseSubMenu=contextMenu.footerSection().appendSubMenuItem(Common.UIString('Response Headers'));const responseHeaders=columnConfigs.filter(columnConfig=>columnConfig.isResponseHeader);for(const columnConfig of responseHeaders){responseSubMenu.defaultSection().appendCheckboxItem(columnConfig.title,this._toggleColumnVisibility.bind(this,columnConfig),columnConfig.visible);}
responseSubMenu.footerSection().appendItem(Common.UIString('Manage Header Columns\u2026'),this._manageCustomHeaderDialog.bind(this));const waterfallSortIds=Network.NetworkLogViewColumns.WaterfallSortIds;const waterfallSubMenu=contextMenu.footerSection().appendSubMenuItem(Common.UIString('Waterfall'));waterfallSubMenu.defaultSection().appendCheckboxItem(Common.UIString('Start Time'),setWaterfallMode.bind(this,waterfallSortIds.StartTime),this._activeWaterfallSortId===waterfallSortIds.StartTime);waterfallSubMenu.defaultSection().appendCheckboxItem(Common.UIString('Response Time'),setWaterfallMode.bind(this,waterfallSortIds.ResponseTime),this._activeWaterfallSortId===waterfallSortIds.ResponseTime);waterfallSubMenu.defaultSection().appendCheckboxItem(Common.UIString('End Time'),setWaterfallMode.bind(this,waterfallSortIds.EndTime),this._activeWaterfallSortId===waterfallSortIds.EndTime);waterfallSubMenu.defaultSection().appendCheckboxItem(Common.UIString('Total Duration'),setWaterfallMode.bind(this,waterfallSortIds.Duration),this._activeWaterfallSortId===waterfallSortIds.Duration);waterfallSubMenu.defaultSection().appendCheckboxItem(Common.UIString('Latency'),setWaterfallMode.bind(this,waterfallSortIds.Latency),this._activeWaterfallSortId===waterfallSortIds.Latency);contextMenu.show();function setWaterfallMode(sortId){let calculator=this._calculatorsMap.get(Network.NetworkLogViewColumns._calculatorTypes.Time);const waterfallSortIds=Network.NetworkLogViewColumns.WaterfallSortIds;if(sortId===waterfallSortIds.Duration||sortId===waterfallSortIds.Latency)
calculator=this._calculatorsMap.get(Network.NetworkLogViewColumns._calculatorTypes.Duration);this._networkLogView.setCalculator(calculator);this._activeWaterfallSortId=sortId;this._dataGrid.markColumnAsSortedBy('waterfall',DataGrid.DataGrid.Order.Ascending);this._sortHandler();}}
_manageCustomHeaderDialog(){const customHeaders=[];for(const columnConfig of this._columns){if(columnConfig.isResponseHeader)
customHeaders.push({title:columnConfig.title,editable:columnConfig.isCustomHeader});}
const manageCustomHeaders=new Network.NetworkManageCustomHeadersView(customHeaders,headerTitle=>!!this._addCustomHeader(headerTitle),this._changeCustomHeader.bind(this),this._removeCustomHeader.bind(this));const dialog=new UI.Dialog();manageCustomHeaders.show(dialog.contentElement);dialog.setSizeBehavior(UI.GlassPane.SizeBehavior.MeasureContent);dialog.show(this._networkLogView.element);}
_removeCustomHeader(headerId){headerId=headerId.toLowerCase();const index=this._columns.findIndex(columnConfig=>columnConfig.id===headerId);if(index===-1)
return false;this._columns.splice(index,1);this._dataGrid.removeColumn(headerId);this._saveColumnsSettings();this._updateColumns();return true;}
_addCustomHeader(headerTitle,headerId,index){if(!headerId)
headerId=headerTitle.toLowerCase();if(index===undefined)
index=this._columns.length-1;const currentColumnConfig=this._columns.find(columnConfig=>columnConfig.id===headerId);if(currentColumnConfig)
return null;const columnConfig=(Object.assign({},Network.NetworkLogViewColumns._defaultColumnConfig,{id:headerId,title:headerTitle,isResponseHeader:true,isCustomHeader:true,visible:true,sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,headerId)}));this._columns.splice(index,0,columnConfig);if(this._dataGrid)
this._dataGrid.addColumn(Network.NetworkLogViewColumns._convertToDataGridDescriptor(columnConfig),index);this._saveColumnsSettings();this._updateColumns();return columnConfig;}
_changeCustomHeader(oldHeaderId,newHeaderTitle,newHeaderId){if(!newHeaderId)
newHeaderId=newHeaderTitle.toLowerCase();oldHeaderId=oldHeaderId.toLowerCase();const oldIndex=this._columns.findIndex(columnConfig=>columnConfig.id===oldHeaderId);const oldColumnConfig=this._columns[oldIndex];const currentColumnConfig=this._columns.find(columnConfig=>columnConfig.id===newHeaderId);if(!oldColumnConfig||(currentColumnConfig&&oldHeaderId!==newHeaderId))
return false;this._removeCustomHeader(oldHeaderId);this._addCustomHeader(newHeaderTitle,newHeaderId,oldIndex);return true;}
_getPopoverRequest(event){if(!this._gridMode)
return null;const hoveredNode=this._networkLogView.hoveredNode();if(!hoveredNode)
return null;const anchor=event.target.enclosingNodeOrSelfWithClass('network-script-initiated');if(!anchor)
return null;const request=hoveredNode.request();const initiator=request?request.initiator():null;if(!initiator||!initiator.stack)
return null;return{box:anchor.boxInWindow(),show:popover=>{const manager=anchor.request?SDK.NetworkManager.forRequest(anchor.request):null;const content=Components.JSPresentationUtils.buildStackTracePreviewContents(manager?manager.target():null,this._popupLinkifier,initiator.stack,()=>popover.setSizeBehavior(UI.GlassPane.SizeBehavior.MeasureContent));popover.contentElement.appendChild(content);return Promise.resolve(true);},hide:this._popupLinkifier.reset.bind(this._popupLinkifier)};}
addEventDividers(times,className){let color='transparent';switch(className){case'network-blue-divider':color='hsla(240, 100%, 80%, 0.7)';break;case'network-red-divider':color='rgba(255, 0, 0, 0.5)';break;default:return;}
const currentTimes=this._eventDividers.get(color)||[];this._eventDividers.set(color,currentTimes.concat(times));this._networkLogView.scheduleRefresh();}
hideEventDividers(){this._eventDividersShown=true;this._redrawWaterfallColumn();}
showEventDividers(){this._eventDividersShown=false;this._redrawWaterfallColumn();}
selectFilmStripFrame(time){this._eventDividers.set(Network.NetworkLogViewColumns._filmStripDividerColor,[time]);this._redrawWaterfallColumn();}
clearFilmStripFrame(){this._eventDividers.delete(Network.NetworkLogViewColumns._filmStripDividerColor);this._redrawWaterfallColumn();}};Network.NetworkLogViewColumns._initialSortColumn='waterfall';Network.NetworkLogViewColumns.Descriptor;Network.NetworkLogViewColumns._calculatorTypes={Duration:'Duration',Time:'Time'};Network.NetworkLogViewColumns._defaultColumnConfig={subtitle:null,visible:false,weight:6,sortable:true,hideable:true,nonSelectable:true,isResponseHeader:false,alwaysVisible:false,isCustomHeader:false};Network.NetworkLogViewColumns._defaultColumns=[{id:'name',title:Common.UIString('Name'),subtitle:Common.UIString('Path'),visible:true,weight:20,hideable:false,nonSelectable:false,alwaysVisible:true,sortingFunction:Network.NetworkRequestNode.NameComparator},{id:'method',title:Common.UIString('Method'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'requestMethod')},{id:'status',title:Common.UIString('Status'),visible:true,subtitle:Common.UIString('Text'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'statusCode')},{id:'protocol',title:Common.UIString('Protocol'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'protocol')},{id:'scheme',title:Common.UIString('Scheme'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'scheme')},{id:'domain',title:Common.UIString('Domain'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'domain')},{id:'remoteaddress',title:Common.UIString('Remote Address'),weight:10,align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.RemoteAddressComparator},{id:'type',title:Common.UIString('Type'),visible:true,sortingFunction:Network.NetworkRequestNode.TypeComparator},{id:'initiator',title:Common.UIString('Initiator'),visible:true,weight:10,sortingFunction:Network.NetworkRequestNode.InitiatorComparator},{id:'cookies',title:Common.UIString('Cookies'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.RequestCookiesCountComparator},{id:'setcookies',title:Common.UIString('Set Cookies'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.ResponseCookiesCountComparator},{id:'size',title:Common.UIString('Size'),visible:true,subtitle:Common.UIString('Content'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.SizeComparator},{id:'time',title:Common.UIString('Time'),visible:true,subtitle:Common.UIString('Latency'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'duration')},{id:'priority',title:Common.UIString('Priority'),sortingFunction:Network.NetworkRequestNode.PriorityComparator},{id:'connectionid',title:Common.UIString('Connection ID'),sortingFunction:Network.NetworkRequestNode.RequestPropertyComparator.bind(null,'connectionId')},{id:'cache-control',isResponseHeader:true,title:Common.UIString('Cache-Control'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'cache-control')},{id:'connection',isResponseHeader:true,title:Common.UIString('Connection'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'connection')},{id:'content-encoding',isResponseHeader:true,title:Common.UIString('Content-Encoding'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'content-encoding')},{id:'content-length',isResponseHeader:true,title:Common.UIString('Content-Length'),align:DataGrid.DataGrid.Align.Right,sortingFunction:Network.NetworkRequestNode.ResponseHeaderNumberComparator.bind(null,'content-length')},{id:'etag',isResponseHeader:true,title:Common.UIString('ETag'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'etag')},{id:'keep-alive',isResponseHeader:true,title:Common.UIString('Keep-Alive'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'keep-alive')},{id:'last-modified',isResponseHeader:true,title:Common.UIString('Last-Modified'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderDateComparator.bind(null,'last-modified')},{id:'server',isResponseHeader:true,title:Common.UIString('Server'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'server')},{id:'vary',isResponseHeader:true,title:Common.UIString('Vary'),sortingFunction:Network.NetworkRequestNode.ResponseHeaderStringComparator.bind(null,'vary')},{id:'waterfall',title:'',visible:false,hideable:false}];Network.NetworkLogViewColumns._filmStripDividerColor='#fccc49';Network.NetworkLogViewColumns.WaterfallSortIds={StartTime:'startTime',ResponseTime:'responseReceivedTime',EndTime:'endTime',Duration:'duration',Latency:'latency'};;Network.NetworkFrameGrouper=class{constructor(parentView){this._parentView=parentView;this._activeGroups=new Map();}
groupNodeForRequest(request){const frame=SDK.ResourceTreeModel.frameForRequest(request);if(!frame||frame.isTopFrame())
return null;let groupNode=this._activeGroups.get(frame);if(groupNode)
return groupNode;groupNode=new Network.FrameGroupNode(this._parentView,frame);this._activeGroups.set(frame,groupNode);return groupNode;}
reset(){this._activeGroups.clear();}};Network.FrameGroupNode=class extends Network.NetworkGroupNode{constructor(parentView,frame){super(parentView);this._frame=frame;this._productBadge=null;}
displayName(){return new Common.ParsedURL(this._frame.url).domain()||this._frame.name||'<iframe>';}
renderCell(cell,columnId){super.renderCell(cell,columnId);if(columnId==='name'){const name=this.displayName();if(!this._productBadge){this._productBadge=this.parentView().badgePool.badgeForFrame(this._frame);this._productBadge.classList.add('network-frame-group-badge');}
cell.appendChild(UI.Icon.create('largeicon-navigator-frame','network-frame-group-icon'));cell.appendChild(this._productBadge);cell.createTextChild(name);cell.title=name;}}};;Network.NetworkManageCustomHeadersView=class extends UI.VBox{constructor(columnData,addHeaderColumnCallback,changeHeaderColumnCallback,removeHeaderColumnCallback){super(true);this.registerRequiredCSS('network/networkManageCustomHeadersView.css');this.contentElement.classList.add('custom-headers-wrapper');this.contentElement.createChild('div','header').textContent=Common.UIString('Manage Header Columns');this._list=new UI.ListWidget(this);this._list.element.classList.add('custom-headers-list');this._list.registerRequiredCSS('network/networkManageCustomHeadersView.css');const placeholder=createElementWithClass('div','custom-headers-list-list-empty');placeholder.textContent=Common.UIString('No custom headers');this._list.setEmptyPlaceholder(placeholder);this._list.show(this.contentElement);this.contentElement.appendChild(UI.createTextButton(Common.UIString('Add custom header\u2026'),this._addButtonClicked.bind(this),'add-button'));this._columnConfigs=new Map();columnData.forEach(columnData=>this._columnConfigs.set(columnData.title.toLowerCase(),columnData));this._addHeaderColumnCallback=addHeaderColumnCallback;this._changeHeaderColumnCallback=changeHeaderColumnCallback;this._removeHeaderColumnCallback=removeHeaderColumnCallback;this.contentElement.tabIndex=0;}
wasShown(){this._headersUpdated();}
_headersUpdated(){this._list.clear();this._columnConfigs.forEach(headerData=>this._list.appendItem({header:headerData.title},headerData.editable));}
_addButtonClicked(){this._list.addNewItem(this._columnConfigs.size,{header:''});}
renderItem(item,editable){const element=createElementWithClass('div','custom-headers-list-item');const header=element.createChild('div','custom-header-name');header.textContent=item.header;header.title=item.header;return element;}
removeItemRequested(item,index){this._removeHeaderColumnCallback(item.header);this._columnConfigs.delete(item.header.toLowerCase());this._headersUpdated();}
commitEdit(item,editor,isNew){const headerId=editor.control('header').value.trim();let success;if(isNew)
success=this._addHeaderColumnCallback(headerId);else
success=this._changeHeaderColumnCallback(item.header,headerId);if(success&&!isNew)
this._columnConfigs.delete(item.header.toLowerCase());if(success)
this._columnConfigs.set(headerId.toLowerCase(),{title:headerId,editable:true});this._headersUpdated();}
beginEdit(item){const editor=this._createEditor();editor.control('header').value=item.header;return editor;}
_createEditor(){if(this._editor)
return this._editor;const editor=new UI.ListWidget.Editor();this._editor=editor;const content=editor.contentElement();const titles=content.createChild('div','custom-headers-edit-row');titles.createChild('div','custom-headers-header').textContent=Common.UIString('Header Name');const fields=content.createChild('div','custom-headers-edit-row');fields.createChild('div','custom-headers-header').appendChild(editor.createInput('header','text','x-custom-header',validateHeader.bind(this)));return editor;function validateHeader(item,index,input){const headerId=editor.control('header').value.trim().toLowerCase();if(this._columnConfigs.has(headerId)&&item.header!==headerId)
return false;return true;}}};;Network.NetworkOverview=class extends PerfUI.TimelineOverviewBase{constructor(){super();this._selectedFilmStripTime=-1;this.element.classList.add('network-overview');this._numBands=1;this._updateScheduled=false;SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.Load,this._loadEventFired,this);SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.DOMContentLoaded,this._domContentLoadedEventFired,this);this.reset();}
setFilmStripModel(filmStripModel){this._filmStripModel=filmStripModel;this.scheduleUpdate();}
selectFilmStripFrame(time){this._selectedFilmStripTime=time;this.scheduleUpdate();}
clearFilmStripFrame(){this._selectedFilmStripTime=-1;this.scheduleUpdate();}
_loadEventFired(event){const time=(event.data.loadTime);if(time)
this._loadEvents.push(time*1000);this.scheduleUpdate();}
_domContentLoadedEventFired(event){const data=(event.data);if(data)
this._domContentLoadedEvents.push(data*1000);this.scheduleUpdate();}
_bandId(connectionId){if(!connectionId||connectionId==='0')
return-1;if(this._bandMap.has(connectionId))
return(this._bandMap.get(connectionId));const result=this._nextBand++;this._bandMap.set(connectionId,result);return result;}
updateRequest(request){if(!this._requestsSet.has(request)){this._requestsSet.add(request);this._requestsList.push(request);}
this.scheduleUpdate();}
wasShown(){this.onResize();}
onResize(){const width=this.element.offsetWidth;const height=this.element.offsetHeight;this.calculator().setDisplayWidth(width);this.resetCanvas();const numBands=(((height-1)/Network.NetworkOverview._bandHeight)-1)|0;this._numBands=(numBands>0)?numBands:1;this.scheduleUpdate();}
reset(){this._filmStripModel=null;this._span=1;this._lastBoundary=null;this._nextBand=0;this._bandMap=new Map();this._requestsList=[];this._requestsSet=new Set();this._loadEvents=[];this._domContentLoadedEvents=[];this.resetCanvas();}
scheduleUpdate(){if(this._updateScheduled||!this.isShowing())
return;this._updateScheduled=true;this.element.window().requestAnimationFrame(this.update.bind(this));}
update(){this._updateScheduled=false;const calculator=this.calculator();const newBoundary=new Network.NetworkTimeBoundary(calculator.minimumBoundary(),calculator.maximumBoundary());if(!this._lastBoundary||!newBoundary.equals(this._lastBoundary)){const span=calculator.boundarySpan();while(this._span<span)
this._span*=1.25;calculator.setBounds(calculator.minimumBoundary(),calculator.minimumBoundary()+this._span);this._lastBoundary=new Network.NetworkTimeBoundary(calculator.minimumBoundary(),calculator.maximumBoundary());}
const context=this.context();const linesByType={};const paddingTop=2;function drawLines(type,strokeStyle){const lines=linesByType[type];if(!lines)
return;const n=lines.length;context.beginPath();context.strokeStyle=strokeStyle;for(let i=0;i<n;){const y=lines[i++]*Network.NetworkOverview._bandHeight+paddingTop;const startTime=lines[i++];let endTime=lines[i++];if(endTime===Number.MAX_VALUE)
endTime=calculator.maximumBoundary();context.moveTo(calculator.computePosition(startTime),y);context.lineTo(calculator.computePosition(endTime)+1,y);}
context.stroke();}
function addLine(type,y,start,end){let lines=linesByType[type];if(!lines){lines=[];linesByType[type]=lines;}
lines.push(y,start,end);}
const requests=this._requestsList;const n=requests.length;for(let i=0;i<n;++i){const request=requests[i];const band=this._bandId(request.connectionId);const y=(band===-1)?0:(band%this._numBands+1);const timeRanges=Network.RequestTimingView.calculateRequestTimeRanges(request,this.calculator().minimumBoundary());for(let j=0;j<timeRanges.length;++j){const type=timeRanges[j].name;if(band!==-1||type===Network.RequestTimeRangeNames.Total)
addLine(type,y,timeRanges[j].start*1000,timeRanges[j].end*1000);}}
context.clearRect(0,0,this.width(),this.height());context.save();context.scale(window.devicePixelRatio,window.devicePixelRatio);context.lineWidth=2;drawLines(Network.RequestTimeRangeNames.Total,'#CCCCCC');drawLines(Network.RequestTimeRangeNames.Blocking,'#AAAAAA');drawLines(Network.RequestTimeRangeNames.Connecting,'#FF9800');drawLines(Network.RequestTimeRangeNames.ServiceWorker,'#FF9800');drawLines(Network.RequestTimeRangeNames.ServiceWorkerPreparation,'#FF9800');drawLines(Network.RequestTimeRangeNames.Push,'#8CDBff');drawLines(Network.RequestTimeRangeNames.Proxy,'#A1887F');drawLines(Network.RequestTimeRangeNames.DNS,'#009688');drawLines(Network.RequestTimeRangeNames.SSL,'#9C27B0');drawLines(Network.RequestTimeRangeNames.Sending,'#B0BEC5');drawLines(Network.RequestTimeRangeNames.Waiting,'#00C853');drawLines(Network.RequestTimeRangeNames.Receiving,'#03A9F4');const height=this.element.offsetHeight;context.lineWidth=1;context.beginPath();context.strokeStyle='#8080FF';for(let i=this._domContentLoadedEvents.length-1;i>=0;--i){const x=Math.round(calculator.computePosition(this._domContentLoadedEvents[i]))+0.5;context.moveTo(x,0);context.lineTo(x,height);}
context.stroke();context.beginPath();context.strokeStyle='#FF8080';for(let i=this._loadEvents.length-1;i>=0;--i){const x=Math.round(calculator.computePosition(this._loadEvents[i]))+0.5;context.moveTo(x,0);context.lineTo(x,height);}
context.stroke();if(this._selectedFilmStripTime!==-1){context.lineWidth=2;context.beginPath();context.strokeStyle='#FCCC49';const x=Math.round(calculator.computePosition(this._selectedFilmStripTime));context.moveTo(x,0);context.lineTo(x,height);context.stroke();}
context.restore();}};Network.NetworkOverview._bandHeight=3;Network.NetworkOverview.Window;;Network.NetworkSearchScope=class{performIndexing(progress){setImmediate(progress.done.bind(progress));}
async performSearch(searchConfig,progress,searchResultCallback,searchFinishedCallback){const promises=[];const requests=BrowserSDK.networkLog.requests().filter(request=>searchConfig.filePathMatchesFileQuery(request.url()));progress.setTotalWork(requests.length);for(const request of requests){const promise=this._searchRequest(searchConfig,request,progress);promises.push(promise);}
const results=await Promise.all(promises);if(progress.isCanceled()){searchFinishedCallback(false);return;}
for(const result of results.sort((r1,r2)=>r1.label().localeCompare(r2.label()))){if(result.matchesCount()>0)
searchResultCallback(result);}
progress.done();searchFinishedCallback(true);}
async _searchRequest(searchConfig,request,progress){let bodyMatches=[];if(request.contentType().isTextType()){bodyMatches=await request.searchInContent(searchConfig.query(),!searchConfig.ignoreCase(),searchConfig.isRegex());}
if(progress.isCanceled())
return null;const locations=[];if(stringMatchesQuery(request.url()))
locations.push(Network.UIRequestLocation.urlMatch(request));for(const header of request.requestHeaders()){if(headerMatchesQuery(header))
locations.push(Network.UIRequestLocation.requestHeaderMatch(request,header));}
for(const header of request.responseHeaders){if(headerMatchesQuery(header))
locations.push(Network.UIRequestLocation.responseHeaderMatch(request,header));}
for(const match of bodyMatches)
locations.push(Network.UIRequestLocation.bodyMatch(request,match));progress.worked();return new Network.NetworkSearchResult(request,locations);function headerMatchesQuery(header){return stringMatchesQuery(`${header.name}: ${header.value}`);}
function stringMatchesQuery(string){const flags=searchConfig.ignoreCase()?'i':'';const regExps=searchConfig.queries().map(query=>new RegExp(query,flags));let pos=0;for(const regExp of regExps){const match=string.substr(pos).match(regExp);if(!match)
return false;pos+=match.index+match[0].length;}
return true;}}
stopSearch(){}};Network.UIRequestLocation=class{constructor(request,requestHeader,responseHeader,searchMatch,urlMatch){this.request=request;this.requestHeader=requestHeader;this.responseHeader=responseHeader;this.searchMatch=searchMatch;this.isUrlMatch=urlMatch;}
static requestHeaderMatch(request,header){return new Network.UIRequestLocation(request,header,null,null,false);}
static responseHeaderMatch(request,header){return new Network.UIRequestLocation(request,null,header,null,false);}
static bodyMatch(request,searchMatch){return new Network.UIRequestLocation(request,null,null,searchMatch,false);}
static urlMatch(request){return new Network.UIRequestLocation(request,null,null,null,true);}};Network.NetworkSearchResult=class{constructor(request,locations){this._request=request;this._locations=locations;}
matchesCount(){return this._locations.length;}
label(){return this._request.displayName;}
description(){const parsedUrl=this._request.parsedURL;if(!parsedUrl)
return this._request.url();return parsedUrl.urlWithoutScheme();}
matchLineContent(index){const location=this._locations[index];if(location.isUrlMatch)
return this._request.url();const header=location.requestHeader||location.responseHeader;if(header)
return header.value;return location.searchMatch.lineContent;}
matchRevealable(index){return this._locations[index];}
matchLabel(index){const location=this._locations[index];if(location.isUrlMatch)
return Common.UIString('URL');const header=location.requestHeader||location.responseHeader;if(header)
return`${header.name}:`;return location.searchMatch.lineNumber+1;}};;Network.NetworkWaterfallColumn=class extends UI.VBox{constructor(calculator){super(false);this.registerRequiredCSS('network/networkWaterfallColumn.css');this._canvas=this.contentElement.createChild('canvas');this._canvas.tabIndex=0;this.setDefaultFocusedElement(this._canvas);this._canvasPosition=this._canvas.getBoundingClientRect();this._leftPadding=5;this._fontSize=10;this._rightPadding=0;this._scrollTop=0;this._headerHeight=0;this._calculator=calculator;this._rawRowHeight=0;this._rowHeight=0;this._offsetWidth=0;this._offsetHeight=0;this._startTime=this._calculator.minimumBoundary();this._endTime=this._calculator.maximumBoundary();this._popoverHelper=new UI.PopoverHelper(this.element,this._getPopoverRequest.bind(this));this._popoverHelper.setHasPadding(true);this._popoverHelper.setTimeout(300,300);this._nodes=[];this._hoveredNode=null;this._eventDividers=new Map();this._updateRequestID;this.element.addEventListener('mousemove',this._onMouseMove.bind(this),true);this.element.addEventListener('mouseleave',event=>this._setHoveredNode(null,false),true);this._styleForTimeRangeName=Network.NetworkWaterfallColumn._buildRequestTimeRangeStyle();const resourceStyleTuple=Network.NetworkWaterfallColumn._buildResourceTypeStyle();this._styleForWaitingResourceType=resourceStyleTuple[0];this._styleForDownloadingResourceType=resourceStyleTuple[1];const baseLineColor=UI.themeSupport.patchColorText('#a5a5a5',UI.ThemeSupport.ColorUsage.Foreground);this._wiskerStyle={borderColor:baseLineColor,lineWidth:1};this._hoverDetailsStyle={fillStyle:baseLineColor,lineWidth:1,borderColor:baseLineColor};this._pathForStyle=new Map();this._textLayers=[];}
static _buildRequestTimeRangeStyle(){const types=Network.RequestTimeRangeNames;const styleMap=new Map();styleMap.set(types.Connecting,{fillStyle:'#FF9800'});styleMap.set(types.SSL,{fillStyle:'#9C27B0'});styleMap.set(types.DNS,{fillStyle:'#009688'});styleMap.set(types.Proxy,{fillStyle:'#A1887F'});styleMap.set(types.Blocking,{fillStyle:'#AAAAAA'});styleMap.set(types.Push,{fillStyle:'#8CDBff'});styleMap.set(types.Queueing,{fillStyle:'white',lineWidth:2,borderColor:'lightgrey'});styleMap.set(types.Receiving,{fillStyle:'#03A9F4',lineWidth:2,borderColor:'#03A9F4'});styleMap.set(types.Waiting,{fillStyle:'#00C853'});styleMap.set(types.ReceivingPush,{fillStyle:'#03A9F4'});styleMap.set(types.ServiceWorker,{fillStyle:'orange'});styleMap.set(types.ServiceWorkerPreparation,{fillStyle:'orange'});return styleMap;}
static _buildResourceTypeStyle(){const baseResourceTypeColors=new Map([['document','hsl(215, 100%, 80%)'],['font','hsl(8, 100%, 80%)'],['media','hsl(90, 50%, 80%)'],['image','hsl(90, 50%, 80%)'],['script','hsl(31, 100%, 80%)'],['stylesheet','hsl(272, 64%, 80%)'],['texttrack','hsl(8, 100%, 80%)'],['websocket','hsl(0, 0%, 95%)'],['xhr','hsl(53, 100%, 80%)'],['fetch','hsl(53, 100%, 80%)'],['other','hsl(0, 0%, 95%)'],]);const waitingStyleMap=new Map();const downloadingStyleMap=new Map();for(const resourceType of Object.values(Common.resourceTypes)){let color=baseResourceTypeColors.get(resourceType.name());if(!color)
color=baseResourceTypeColors.get('other');const borderColor=toBorderColor(color);waitingStyleMap.set(resourceType,{fillStyle:toWaitingColor(color),lineWidth:1,borderColor:borderColor});downloadingStyleMap.set(resourceType,{fillStyle:color,lineWidth:1,borderColor:borderColor});}
return[waitingStyleMap,downloadingStyleMap];function toBorderColor(color){const parsedColor=Common.Color.parse(color);const hsla=parsedColor.hsla();hsla[1]/=2;hsla[2]-=Math.min(hsla[2],0.2);return parsedColor.asString(null);}
function toWaitingColor(color){const parsedColor=Common.Color.parse(color);const hsla=parsedColor.hsla();hsla[2]*=1.1;return parsedColor.asString(null);}}
_resetPaths(){this._pathForStyle.clear();this._pathForStyle.set(this._wiskerStyle,new Path2D());this._styleForTimeRangeName.forEach(style=>this._pathForStyle.set(style,new Path2D()));this._styleForWaitingResourceType.forEach(style=>this._pathForStyle.set(style,new Path2D()));this._styleForDownloadingResourceType.forEach(style=>this._pathForStyle.set(style,new Path2D()));this._pathForStyle.set(this._hoverDetailsStyle,new Path2D());}
willHide(){this._popoverHelper.hidePopover();}
wasShown(){this.update();}
_onMouseMove(event){this._setHoveredNode(this.getNodeFromPoint(event.offsetX,event.offsetY),event.shiftKey);}
_getPopoverRequest(event){if(!this._hoveredNode)
return null;const request=this._hoveredNode.request();if(!request)
return null;const useTimingBars=!Common.moduleSetting('networkColorCodeResourceTypes').get()&&!this._calculator.startAtZero;let range;let start;let end;if(useTimingBars){range=Network.RequestTimingView.calculateRequestTimeRanges(request,0).find(data=>data.name===Network.RequestTimeRangeNames.Total);start=this._timeToPosition(range.start);end=this._timeToPosition(range.end);}else{range=this._getSimplifiedBarRange(request,0);start=range.start;end=range.end;}
if(end-start<50){const halfWidth=(end-start)/2;start=start+halfWidth-25;end=end-halfWidth+25;}
if(event.clientX<this._canvasPosition.left+start||event.clientX>this._canvasPosition.left+end)
return null;const rowIndex=this._nodes.findIndex(node=>node.hovered());const barHeight=this._getBarHeight(range.name);const y=this._headerHeight+(this._rowHeight*rowIndex-this._scrollTop)+((this._rowHeight-barHeight)/2);if(event.clientY<this._canvasPosition.top+y||event.clientY>this._canvasPosition.top+y+barHeight)
return null;const anchorBox=this.element.boxInWindow();anchorBox.x+=start;anchorBox.y+=y;anchorBox.width=end-start;anchorBox.height=barHeight;return{box:anchorBox,show:popover=>{const content=Network.RequestTimingView.createTimingTable((request),this._calculator);popover.contentElement.appendChild(content);return Promise.resolve(true);}};}
_setHoveredNode(node,highlightInitiatorChain){if(this._hoveredNode)
this._hoveredNode.setHovered(false,false);this._hoveredNode=node;if(this._hoveredNode)
this._hoveredNode.setHovered(true,highlightInitiatorChain);}
setRowHeight(height){this._rawRowHeight=height;this._updateRowHeight();}
_updateRowHeight(){this._rowHeight=Math.round(this._rawRowHeight*window.devicePixelRatio)/window.devicePixelRatio;}
setHeaderHeight(height){this._headerHeight=height;}
setRightPadding(padding){this._rightPadding=padding;this._calculateCanvasSize();}
setCalculator(calculator){this._calculator=calculator;}
getNodeFromPoint(x,y){if(y<=this._headerHeight)
return null;return this._nodes[Math.floor((this._scrollTop+y-this._headerHeight)/this._rowHeight)];}
scheduleDraw(){if(this._updateRequestID)
return;this._updateRequestID=this.element.window().requestAnimationFrame(()=>this.update());}
update(scrollTop,eventDividers,nodes){if(scrollTop!==undefined&&this._scrollTop!==scrollTop){this._popoverHelper.hidePopover();this._scrollTop=scrollTop;}
if(nodes){this._nodes=nodes;this._calculateCanvasSize();}
if(eventDividers!==undefined)
this._eventDividers=eventDividers;if(this._updateRequestID){this.element.window().cancelAnimationFrame(this._updateRequestID);delete this._updateRequestID;}
this._startTime=this._calculator.minimumBoundary();this._endTime=this._calculator.maximumBoundary();this._resetCanvas();this._resetPaths();this._textLayers=[];this._draw();}
_resetCanvas(){const ratio=window.devicePixelRatio;this._canvas.width=this._offsetWidth*ratio;this._canvas.height=this._offsetHeight*ratio;this._canvas.style.width=this._offsetWidth+'px';this._canvas.style.height=this._offsetHeight+'px';}
onResize(){super.onResize();this._updateRowHeight();this._calculateCanvasSize();this.scheduleDraw();}
_calculateCanvasSize(){this._offsetWidth=this.contentElement.offsetWidth-this._rightPadding;this._offsetHeight=this.contentElement.offsetHeight;this._calculator.setDisplayWidth(this._offsetWidth);this._canvasPosition=this._canvas.getBoundingClientRect();}
_timeToPosition(time){const availableWidth=this._offsetWidth-this._leftPadding;const timeToPixel=availableWidth/(this._endTime-this._startTime);return Math.floor(this._leftPadding+(time-this._startTime)*timeToPixel);}
_didDrawForTest(){}
_draw(){const useTimingBars=!Common.moduleSetting('networkColorCodeResourceTypes').get()&&!this._calculator.startAtZero;const nodes=this._nodes;const context=this._canvas.getContext('2d');context.save();context.scale(window.devicePixelRatio,window.devicePixelRatio);context.translate(0,this._headerHeight);context.rect(0,0,this._offsetWidth,this._offsetHeight);context.clip();const firstRequestIndex=Math.floor(this._scrollTop/this._rowHeight);const lastRequestIndex=Math.min(nodes.length,firstRequestIndex+Math.ceil(this._offsetHeight/this._rowHeight));for(let i=firstRequestIndex;i<lastRequestIndex;i++){const rowOffset=this._rowHeight*i;const node=nodes[i];this._decorateRow(context,node,rowOffset-this._scrollTop);let drawNodes=[];if(node.hasChildren()&&!node.expanded)
drawNodes=(node.flatChildren());drawNodes.push(node);for(const drawNode of drawNodes){if(useTimingBars)
this._buildTimingBarLayers(drawNode,rowOffset-this._scrollTop);else
this._buildSimplifiedBarLayers(context,drawNode,rowOffset-this._scrollTop);}}
this._drawLayers(context);context.save();context.fillStyle=UI.themeSupport.patchColorText('#888',UI.ThemeSupport.ColorUsage.Foreground);for(const textData of this._textLayers)
context.fillText(textData.text,textData.x,textData.y);context.restore();this._drawEventDividers(context);context.restore();const freeZoneAtLeft=75;const freeZoneAtRight=18;const dividersData=PerfUI.TimelineGrid.calculateGridOffsets(this._calculator);PerfUI.TimelineGrid.drawCanvasGrid(context,dividersData);PerfUI.TimelineGrid.drawCanvasHeaders(context,dividersData,time=>this._calculator.formatValue(time,dividersData.precision),this._fontSize,this._headerHeight,freeZoneAtLeft);context.clearRect(this._offsetWidth-freeZoneAtRight,0,freeZoneAtRight,this._headerHeight);this._didDrawForTest();}
_drawLayers(context){for(const entry of this._pathForStyle){const style=(entry[0]);const path=(entry[1]);context.save();context.beginPath();if(style.lineWidth){context.lineWidth=style.lineWidth;context.strokeStyle=style.borderColor;context.stroke(path);}
if(style.fillStyle){context.fillStyle=style.fillStyle;context.fill(path);}
context.restore();}}
_drawEventDividers(context){context.save();context.lineWidth=1;for(const color of this._eventDividers.keys()){context.strokeStyle=color;for(const time of this._eventDividers.get(color)){context.beginPath();const x=this._timeToPosition(time);context.moveTo(x,0);context.lineTo(x,this._offsetHeight);}
context.stroke();}
context.restore();}
_getBarHeight(type){const types=Network.RequestTimeRangeNames;switch(type){case types.Connecting:case types.SSL:case types.DNS:case types.Proxy:case types.Blocking:case types.Push:case types.Queueing:return 7;default:return 13;}}
_getSimplifiedBarRange(request,borderOffset){const drawWidth=this._offsetWidth-this._leftPadding;const percentages=this._calculator.computeBarGraphPercentages(request);return{start:this._leftPadding+Math.floor((percentages.start/100)*drawWidth)+borderOffset,mid:this._leftPadding+Math.floor((percentages.middle/100)*drawWidth)+borderOffset,end:this._leftPadding+Math.floor((percentages.end/100)*drawWidth)+borderOffset};}
_buildSimplifiedBarLayers(context,node,y){const request=node.request();if(!request)
return;const borderWidth=1;const borderOffset=borderWidth%2===0?0:0.5;const ranges=this._getSimplifiedBarRange(request,borderOffset);const height=this._getBarHeight();y+=Math.floor(this._rowHeight/2-height/2+borderWidth)-borderWidth/2;const waitingStyle=this._styleForWaitingResourceType.get(request.resourceType());const waitingPath=this._pathForStyle.get(waitingStyle);waitingPath.rect(ranges.start,y,ranges.mid-ranges.start,height-borderWidth);const barWidth=Math.max(2,ranges.end-ranges.mid);const downloadingStyle=this._styleForDownloadingResourceType.get(request.resourceType());const downloadingPath=this._pathForStyle.get(downloadingStyle);downloadingPath.rect(ranges.mid,y,barWidth,height-borderWidth);let labels=null;if(node.hovered()){labels=this._calculator.computeBarGraphLabels(request);const barDotLineLength=10;const leftLabelWidth=context.measureText(labels.left).width;const rightLabelWidth=context.measureText(labels.right).width;const hoverLinePath=this._pathForStyle.get(this._hoverDetailsStyle);if(leftLabelWidth<ranges.mid-ranges.start){const midBarX=ranges.start+(ranges.mid-ranges.start-leftLabelWidth)/2;this._textLayers.push({text:labels.left,x:midBarX,y:y+this._fontSize});}else if(barDotLineLength+leftLabelWidth+this._leftPadding<ranges.start){this._textLayers.push({text:labels.left,x:ranges.start-leftLabelWidth-barDotLineLength-1,y:y+this._fontSize});hoverLinePath.moveTo(ranges.start-barDotLineLength,y+Math.floor(height/2));hoverLinePath.arc(ranges.start,y+Math.floor(height/2),2,0,2*Math.PI);hoverLinePath.moveTo(ranges.start-barDotLineLength,y+Math.floor(height/2));hoverLinePath.lineTo(ranges.start,y+Math.floor(height/2));}
const endX=ranges.mid+barWidth+borderOffset;if(rightLabelWidth<endX-ranges.mid){const midBarX=ranges.mid+(endX-ranges.mid-rightLabelWidth)/2;this._textLayers.push({text:labels.right,x:midBarX,y:y+this._fontSize});}else if(endX+barDotLineLength+rightLabelWidth<this._offsetWidth-this._leftPadding){this._textLayers.push({text:labels.right,x:endX+barDotLineLength+1,y:y+this._fontSize});hoverLinePath.moveTo(endX,y+Math.floor(height/2));hoverLinePath.arc(endX,y+Math.floor(height/2),2,0,2*Math.PI);hoverLinePath.moveTo(endX,y+Math.floor(height/2));hoverLinePath.lineTo(endX+barDotLineLength,y+Math.floor(height/2));}}
if(!this._calculator.startAtZero){const queueingRange=Network.RequestTimingView.calculateRequestTimeRanges(request,0).find(data=>data.name===Network.RequestTimeRangeNames.Total);const leftLabelWidth=labels?context.measureText(labels.left).width:0;const leftTextPlacedInBar=leftLabelWidth<ranges.mid-ranges.start;const wiskerTextPadding=13;const textOffset=(labels&&!leftTextPlacedInBar)?leftLabelWidth+wiskerTextPadding:0;const queueingStart=this._timeToPosition(queueingRange.start);if(ranges.start-textOffset>queueingStart){const wiskerPath=this._pathForStyle.get(this._wiskerStyle);wiskerPath.moveTo(queueingStart,y+Math.floor(height/2));wiskerPath.lineTo(ranges.start-textOffset,y+Math.floor(height/2));const wiskerHeight=height/2;wiskerPath.moveTo(queueingStart+borderOffset,y+wiskerHeight/2);wiskerPath.lineTo(queueingStart+borderOffset,y+height-wiskerHeight/2-1);}}}
_buildTimingBarLayers(node,y){const request=node.request();if(!request)
return;const ranges=Network.RequestTimingView.calculateRequestTimeRanges(request,0);for(const range of ranges){if(range.name===Network.RequestTimeRangeNames.Total||range.name===Network.RequestTimeRangeNames.Sending||range.end-range.start===0)
continue;const style=this._styleForTimeRangeName.get(range.name);const path=this._pathForStyle.get(style);const lineWidth=style.lineWidth||0;const height=this._getBarHeight(range.name);const middleBarY=y+Math.floor(this._rowHeight/2-height/2)+lineWidth/2;const start=this._timeToPosition(range.start);const end=this._timeToPosition(range.end);path.rect(start,middleBarY,end-start,height-lineWidth);}}
_decorateRow(context,node,y){context.save();context.beginPath();context.fillStyle=node.backgroundColor();context.rect(0,y,this._offsetWidth,this._rowHeight);context.fill();context.restore();}};Network.NetworkWaterfallColumn._LayerStyle;Network.NetworkWaterfallColumn._TextLayer;;Network.RequestCookiesView=class extends UI.VBox{constructor(request){super();this.registerRequiredCSS('network/requestCookiesView.css');this.element.classList.add('request-cookies-view');this._request=request;}
wasShown(){this._request.addEventListener(SDK.NetworkRequest.Events.RequestHeadersChanged,this._refreshCookies,this);this._request.addEventListener(SDK.NetworkRequest.Events.ResponseHeadersChanged,this._refreshCookies,this);if(!this._gotCookies){if(!this._emptyWidget){this._emptyWidget=new UI.EmptyWidget(Common.UIString('This request has no cookies.'));this._emptyWidget.show(this.element);}
return;}
if(!this._cookiesTable)
this._buildCookiesTable();}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.RequestHeadersChanged,this._refreshCookies,this);this._request.removeEventListener(SDK.NetworkRequest.Events.ResponseHeadersChanged,this._refreshCookies,this);}
get _gotCookies(){return(this._request.requestCookies&&this._request.requestCookies.length)||(this._request.responseCookies&&this._request.responseCookies.length);}
_buildCookiesTable(){this.detachChildWidgets();this._cookiesTable=new CookieTable.CookiesTable();this._cookiesTable.setCookieFolders([{folderName:Common.UIString('Request Cookies'),cookies:this._request.requestCookies},{folderName:Common.UIString('Response Cookies'),cookies:this._request.responseCookies}]);this._cookiesTable.show(this.element);}
_refreshCookies(){delete this._cookiesTable;if(!this._gotCookies||!this.isShowing())
return;this._buildCookiesTable();}};;Network.RequestHeadersView=class extends UI.VBox{constructor(request){super();this.registerRequiredCSS('network/requestHeadersView.css');this.element.classList.add('request-headers-view');this._request=request;this._decodeRequestParameters=true;this._showRequestHeadersText=false;this._showResponseHeadersText=false;this._highlightedElement=null;const root=new UI.TreeOutlineInShadow();root.registerRequiredCSS('network/requestHeadersTree.css');root.element.classList.add('request-headers-tree');root.setFocusable(false);root.makeDense();root.expandTreeElementsWhenArrowing=true;this.element.appendChild(root.element);const generalCategory=new Network.RequestHeadersView.Category(root,'general',Common.UIString('General'));generalCategory.hidden=false;this._urlItem=generalCategory.createLeaf();this._requestMethodItem=generalCategory.createLeaf();this._statusCodeItem=generalCategory.createLeaf();this._remoteAddressItem=generalCategory.createLeaf();this._remoteAddressItem.hidden=true;this._referrerPolicyItem=generalCategory.createLeaf();this._referrerPolicyItem.hidden=true;this._responseHeadersCategory=new Network.RequestHeadersView.Category(root,'responseHeaders','');this._requestHeadersCategory=new Network.RequestHeadersView.Category(root,'requestHeaders','');this._queryStringCategory=new Network.RequestHeadersView.Category(root,'queryString','');this._formDataCategory=new Network.RequestHeadersView.Category(root,'formData','');this._requestPayloadCategory=new Network.RequestHeadersView.Category(root,'requestPayload',Common.UIString('Request Payload'));}
wasShown(){this._clearHighlight();this._request.addEventListener(SDK.NetworkRequest.Events.RemoteAddressChanged,this._refreshRemoteAddress,this);this._request.addEventListener(SDK.NetworkRequest.Events.RequestHeadersChanged,this._refreshRequestHeaders,this);this._request.addEventListener(SDK.NetworkRequest.Events.ResponseHeadersChanged,this._refreshResponseHeaders,this);this._request.addEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._refreshHTTPInformation,this);this._refreshURL();this._refreshQueryString();this._refreshRequestHeaders();this._refreshResponseHeaders();this._refreshHTTPInformation();this._refreshRemoteAddress();this._refreshReferrerPolicy();}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.RemoteAddressChanged,this._refreshRemoteAddress,this);this._request.removeEventListener(SDK.NetworkRequest.Events.RequestHeadersChanged,this._refreshRequestHeaders,this);this._request.removeEventListener(SDK.NetworkRequest.Events.ResponseHeadersChanged,this._refreshResponseHeaders,this);this._request.removeEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._refreshHTTPInformation,this);}
_formatHeader(name,value){const fragment=createDocumentFragment();fragment.createChild('div','header-name').textContent=name+': ';fragment.createChild('span','header-separator');fragment.createChild('div','header-value source-code').textContent=value;return fragment;}
_formatParameter(value,className,decodeParameters){let errorDecoding=false;if(decodeParameters){value=value.replace(/\+/g,' ');if(value.indexOf('%')>=0){try{value=decodeURIComponent(value);}catch(e){errorDecoding=true;}}}
const div=createElementWithClass('div',className);if(value==='')
div.classList.add('empty-value');if(errorDecoding)
div.createChild('span','header-decode-error').textContent=Common.UIString('(unable to decode value)');else
div.textContent=value;return div;}
_refreshURL(){this._urlItem.title=this._formatHeader(Common.UIString('Request URL'),this._request.url());}
_refreshQueryString(){const queryString=this._request.queryString();const queryParameters=this._request.queryParameters;this._queryStringCategory.hidden=!queryParameters;if(queryParameters){this._refreshParams(Common.UIString('Query String Parameters'),queryParameters,queryString,this._queryStringCategory);}}
async _refreshFormData(){this._formDataCategory.hidden=true;this._requestPayloadCategory.hidden=true;const formData=await this._request.requestFormData();if(!formData)
return;const formParameters=await this._request.formParameters();if(formParameters){this._formDataCategory.hidden=false;this._refreshParams(Common.UIString('Form Data'),formParameters,formData,this._formDataCategory);}else{this._requestPayloadCategory.hidden=false;try{const json=JSON.parse(formData);this._refreshRequestJSONPayload(json,formData);}catch(e){this._populateTreeElementWithSourceText(this._requestPayloadCategory,formData);}}}
_populateTreeElementWithSourceText(treeElement,sourceText){const max_len=3000;const text=(sourceText||'').trim();const trim=text.length>max_len;const sourceTextElement=createElementWithClass('span','header-value source-code');sourceTextElement.textContent=trim?text.substr(0,max_len):text;const sourceTreeElement=new UI.TreeElement(sourceTextElement);sourceTreeElement.selectable=false;treeElement.removeChildren();treeElement.appendChild(sourceTreeElement);if(!trim)
return;const showMoreButton=createElementWithClass('button','request-headers-show-more-button');showMoreButton.textContent=Common.UIString('Show more');showMoreButton.addEventListener('click',()=>{showMoreButton.remove();sourceTextElement.textContent=text;});sourceTextElement.appendChild(showMoreButton);}
_refreshParams(title,params,sourceText,paramsTreeElement){paramsTreeElement.removeChildren();paramsTreeElement.listItemElement.removeChildren();paramsTreeElement.listItemElement.createTextChild(title);const headerCount=createElementWithClass('span','header-count');headerCount.textContent=Common.UIString('\u00A0(%d)',params.length);paramsTreeElement.listItemElement.appendChild(headerCount);function toggleViewSource(event){paramsTreeElement[Network.RequestHeadersView._viewSourceSymbol]=!paramsTreeElement[Network.RequestHeadersView._viewSourceSymbol];this._refreshParams(title,params,sourceText,paramsTreeElement);event.consume();}
paramsTreeElement.listItemElement.appendChild(this._createViewSourceToggle(paramsTreeElement[Network.RequestHeadersView._viewSourceSymbol],toggleViewSource.bind(this)));if(paramsTreeElement[Network.RequestHeadersView._viewSourceSymbol]){this._populateTreeElementWithSourceText(paramsTreeElement,sourceText);return;}
const toggleTitle=this._decodeRequestParameters?Common.UIString('view URL encoded'):Common.UIString('view decoded');const toggleButton=this._createToggleButton(toggleTitle);toggleButton.addEventListener('click',this._toggleURLDecoding.bind(this),false);paramsTreeElement.listItemElement.appendChild(toggleButton);for(let i=0;i<params.length;++i){const paramNameValue=createDocumentFragment();if(params[i].name!==''){const name=this._formatParameter(params[i].name+': ','header-name',this._decodeRequestParameters);const value=this._formatParameter(params[i].value,'header-value source-code',this._decodeRequestParameters);paramNameValue.appendChild(name);paramNameValue.createChild('span','header-separator');paramNameValue.appendChild(value);}else{paramNameValue.appendChild(this._formatParameter(Common.UIString('(empty)'),'empty-request-header',this._decodeRequestParameters));}
const paramTreeElement=new UI.TreeElement(paramNameValue);paramTreeElement.selectable=false;paramsTreeElement.appendChild(paramTreeElement);}}
_refreshRequestJSONPayload(parsedObject,sourceText){const treeElement=this._requestPayloadCategory;treeElement.removeChildren();const listItem=this._requestPayloadCategory.listItemElement;listItem.removeChildren();listItem.createTextChild(this._requestPayloadCategory.title);function toggleViewSource(event){treeElement[Network.RequestHeadersView._viewSourceSymbol]=!treeElement[Network.RequestHeadersView._viewSourceSymbol];this._refreshRequestJSONPayload(parsedObject,sourceText);event.consume();}
listItem.appendChild(this._createViewSourceToggle(treeElement[Network.RequestHeadersView._viewSourceSymbol],toggleViewSource.bind(this)));if(treeElement[Network.RequestHeadersView._viewSourceSymbol]){this._populateTreeElementWithSourceText(this._requestPayloadCategory,sourceText);}else{const object=SDK.RemoteObject.fromLocalObject(parsedObject);const section=new ObjectUI.ObjectPropertiesSection(object,object.description);section.expand();section.editable=false;treeElement.appendChild(new UI.TreeElement(section.element));}}
_createViewSourceToggle(viewSource,handler){const viewSourceToggleTitle=viewSource?Common.UIString('view parsed'):Common.UIString('view source');const viewSourceToggleButton=this._createToggleButton(viewSourceToggleTitle);viewSourceToggleButton.addEventListener('click',handler,false);return viewSourceToggleButton;}
_toggleURLDecoding(event){this._decodeRequestParameters=!this._decodeRequestParameters;this._refreshQueryString();this._refreshFormData();event.consume();}
_refreshRequestHeaders(){const treeElement=this._requestHeadersCategory;const headers=this._request.requestHeaders().slice();headers.sort(function(a,b){return a.name.toLowerCase().compareTo(b.name.toLowerCase());});const headersText=this._request.requestHeadersText();if(this._showRequestHeadersText&&headersText)
this._refreshHeadersText(Common.UIString('Request Headers'),headers.length,headersText,treeElement);else
this._refreshHeaders(Common.UIString('Request Headers'),headers,treeElement,headersText===undefined);if(headersText){const toggleButton=this._createHeadersToggleButton(this._showRequestHeadersText);toggleButton.addEventListener('click',this._toggleRequestHeadersText.bind(this),false);treeElement.listItemElement.appendChild(toggleButton);}
this._refreshFormData();}
_refreshResponseHeaders(){const treeElement=this._responseHeadersCategory;const headers=this._request.sortedResponseHeaders.slice();const headersText=this._request.responseHeadersText;if(this._showResponseHeadersText)
this._refreshHeadersText(Common.UIString('Response Headers'),headers.length,headersText,treeElement);else
this._refreshHeaders(Common.UIString('Response Headers'),headers,treeElement);if(headersText){const toggleButton=this._createHeadersToggleButton(this._showResponseHeadersText);toggleButton.addEventListener('click',this._toggleResponseHeadersText.bind(this),false);treeElement.listItemElement.appendChild(toggleButton);}}
_refreshHTTPInformation(){const requestMethodElement=this._requestMethodItem;requestMethodElement.hidden=!this._request.statusCode;const statusCodeElement=this._statusCodeItem;statusCodeElement.hidden=!this._request.statusCode;if(this._request.statusCode){const statusCodeFragment=createDocumentFragment();statusCodeFragment.createChild('div','header-name').textContent=Common.UIString('Status Code')+': ';statusCodeFragment.createChild('span','header-separator');const statusCodeImage=statusCodeFragment.createChild('label','resource-status-image','dt-icon-label');statusCodeImage.title=this._request.statusCode+' '+this._request.statusText;if(this._request.statusCode<300||this._request.statusCode===304)
statusCodeImage.type='smallicon-green-ball';else if(this._request.statusCode<400)
statusCodeImage.type='smallicon-orange-ball';else
statusCodeImage.type='smallicon-red-ball';requestMethodElement.title=this._formatHeader(Common.UIString('Request Method'),this._request.requestMethod);const statusTextElement=statusCodeFragment.createChild('div','header-value source-code');let statusText=this._request.statusCode+' '+this._request.statusText;if(this._request.fetchedViaServiceWorker){statusText+=' '+Common.UIString('(from ServiceWorker)');statusTextElement.classList.add('status-from-cache');}else if(this._request.redirectSource()&&this._request.redirectSource().signedExchangeInfo()){statusText+=' '+Common.UIString('(from signed-exchange)');statusTextElement.classList.add('status-from-cache');}else if(this._request.cached()){if(this._request.cachedInMemory())
statusText+=' '+Common.UIString('(from memory cache)');else
statusText+=' '+Common.UIString('(from disk cache)');statusTextElement.classList.add('status-from-cache');}
statusTextElement.textContent=statusText;statusCodeElement.title=statusCodeFragment;}}
_refreshHeadersTitle(title,headersTreeElement,headersLength){headersTreeElement.listItemElement.removeChildren();headersTreeElement.listItemElement.createTextChild(title);const headerCount=Common.UIString('\u00A0(%d)',headersLength);headersTreeElement.listItemElement.createChild('span','header-count').textContent=headerCount;}
_refreshHeaders(title,headers,headersTreeElement,provisionalHeaders){headersTreeElement.removeChildren();const length=headers.length;this._refreshHeadersTitle(title,headersTreeElement,length);if(provisionalHeaders){const cautionText=Common.UIString('Provisional headers are shown');const cautionFragment=createDocumentFragment();cautionFragment.createChild('label','','dt-icon-label').type='smallicon-warning';cautionFragment.createChild('div','caution').textContent=cautionText;const cautionTreeElement=new UI.TreeElement(cautionFragment);cautionTreeElement.selectable=false;headersTreeElement.appendChild(cautionTreeElement);}
headersTreeElement.hidden=!length&&!provisionalHeaders;for(let i=0;i<length;++i){const headerTreeElement=new UI.TreeElement(this._formatHeader(headers[i].name,headers[i].value));headerTreeElement.selectable=false;headersTreeElement.appendChild(headerTreeElement);headerTreeElement[Network.RequestHeadersView._headerNameSymbol]=headers[i].name;}}
_refreshHeadersText(title,count,headersText,headersTreeElement){this._populateTreeElementWithSourceText(headersTreeElement,headersText);this._refreshHeadersTitle(title,headersTreeElement,count);}
_refreshRemoteAddress(){const remoteAddress=this._request.remoteAddress();const treeElement=this._remoteAddressItem;treeElement.hidden=!remoteAddress;if(remoteAddress)
treeElement.title=this._formatHeader(Common.UIString('Remote Address'),remoteAddress);}
_refreshReferrerPolicy(){const referrerPolicy=this._request.referrerPolicy();const treeElement=this._referrerPolicyItem;treeElement.hidden=!referrerPolicy;if(referrerPolicy)
treeElement.title=this._formatHeader(Common.UIString('Referrer Policy'),referrerPolicy);}
_toggleRequestHeadersText(event){this._showRequestHeadersText=!this._showRequestHeadersText;this._refreshRequestHeaders();event.consume();}
_toggleResponseHeadersText(event){this._showResponseHeadersText=!this._showResponseHeadersText;this._refreshResponseHeaders();event.consume();}
_createToggleButton(title){const button=createElementWithClass('span','header-toggle');button.textContent=title;return button;}
_createHeadersToggleButton(isHeadersTextShown){const toggleTitle=isHeadersTextShown?Common.UIString('view parsed'):Common.UIString('view source');return this._createToggleButton(toggleTitle);}
_clearHighlight(){if(this._highlightedElement)
this._highlightedElement.listItemElement.classList.remove('header-highlight');this._highlightedElement=null;}
_revealAndHighlight(category,name){this._clearHighlight();for(const element of category.children()){if(element[Network.RequestHeadersView._headerNameSymbol]!==name)
continue;this._highlightedElement=element;element.reveal();element.listItemElement.classList.add('header-highlight');return;}}
revealRequestHeader(header){this._revealAndHighlight(this._requestHeadersCategory,header);}
revealResponseHeader(header){this._revealAndHighlight(this._responseHeadersCategory,header);}};Network.RequestHeadersView._headerNameSymbol=Symbol('HeaderName');Network.RequestHeadersView._viewSourceSymbol=Symbol('ViewSource');Network.RequestHeadersView.Category=class extends UI.TreeElement{constructor(root,name,title){super(title||'',true);this.selectable=false;this.toggleOnClick=true;this.hidden=true;this._expandedSetting=Common.settings.createSetting('request-info-'+name+'-category-expanded',true);this.expanded=this._expandedSetting.get();root.appendChild(this);}
createLeaf(){const leaf=new UI.TreeElement();leaf.selectable=false;this.appendChild(leaf);return leaf;}
onexpand(){this._expandedSetting.set(true);}
oncollapse(){this._expandedSetting.set(false);}};;Network.RequestHTMLView=class extends UI.VBox{constructor(dataURL){super(true);this.registerRequiredCSS('network/requestHTMLView.css');this._dataURL=dataURL;this.contentElement.classList.add('html','request-view');}
wasShown(){this._createIFrame();}
willHide(){this.contentElement.removeChildren();}
_createIFrame(){this.contentElement.removeChildren();const iframe=createElement('iframe');iframe.className='html-preview-frame';iframe.setAttribute('sandbox','');iframe.setAttribute('src',this._dataURL);iframe.setAttribute('tabIndex',-1);this.contentElement.appendChild(iframe);}};;Network.RequestResponseView=class extends UI.VBox{constructor(request){super();this.element.classList.add('request-view');this.request=request;this._contentViewPromise=null;}
static _hasTextContent(request,contentData){const mimeType=request.mimeType;let resourceType=Common.ResourceType.fromMimeType(mimeType);if(resourceType===Common.resourceTypes.Other)
resourceType=request.contentType();if(resourceType===Common.resourceTypes.Image)
return mimeType.startsWith('image/svg');if(resourceType.isTextType())
return true;if(contentData.error)
return false;if(resourceType===Common.resourceTypes.Other)
return!!contentData.content&&!contentData.encoded;return false;}
static async sourceViewForRequest(request){let sourceView=request[Network.RequestResponseView._sourceViewSymbol];if(sourceView!==undefined)
return sourceView;const contentData=await request.contentData();if(!Network.RequestResponseView._hasTextContent(request,contentData)){request[Network.RequestResponseView._sourceViewSymbol]=null;return null;}
const contentProvider=new Network.DecodingContentProvider(request);const highlighterType=request.resourceType().canonicalMimeType()||request.mimeType;sourceView=SourceFrame.ResourceSourceFrame.createSearchableView(contentProvider,highlighterType);request[Network.RequestResponseView._sourceViewSymbol]=sourceView;return sourceView;}
wasShown(){this._doShowPreview();}
_doShowPreview(){if(!this._contentViewPromise)
this._contentViewPromise=this.showPreview();return this._contentViewPromise;}
async showPreview(){const responseView=await this.createPreview();responseView.show(this.element);return responseView;}
async createPreview(){const contentData=await this.request.contentData();const sourceView=await Network.RequestResponseView.sourceViewForRequest(this.request);if((!contentData.content||!sourceView)&&!contentData.error)
return new UI.EmptyWidget(Common.UIString('This request has no response data available.'));if(contentData.content&&sourceView)
return sourceView;return new UI.EmptyWidget(Common.UIString('Failed to load response data'));}
async revealLine(line){const view=await this._doShowPreview();if(view instanceof SourceFrame.ResourceSourceFrame.SearchableContainer)
view.revealPosition(line);}};Network.RequestResponseView._sourceViewSymbol=Symbol('RequestResponseSourceView');Network.DecodingContentProvider=class{constructor(request){this._request=request;}
contentURL(){return this._request.contentURL();}
contentType(){return this._request.resourceType();}
contentEncoded(){return Promise.resolve(false);}
async requestContent(){const contentData=await this._request.contentData();return contentData.encoded?window.atob(contentData.content||''):contentData.content;}
searchInContent(query,caseSensitive,isRegex){return this._request.searchInContent(query,caseSensitive,isRegex);}};;Network.RequestPreviewView=class extends Network.RequestResponseView{constructor(request){super(request);}
async showPreview(){const view=await super.showPreview();if(!(view instanceof UI.SimpleView))
return view;const toolbar=new UI.Toolbar('network-item-preview-toolbar',this.element);for(const item of view.syncToolbarItems())
toolbar.appendToolbarItem(item);return view;}
async _htmlPreview(){const contentData=await this.request.contentData();if(contentData.error)
return new UI.EmptyWidget(Common.UIString('Failed to load response data'));const whitelist=new Set(['text/html','text/plain','application/xhtml+xml']);if(!whitelist.has(this.request.mimeType))
return null;const jsonView=await SourceFrame.JSONView.createView(contentData.content);if(jsonView)
return jsonView;const dataURL=Common.ContentProvider.contentAsDataURL(contentData.content,this.request.mimeType,contentData.encoded,contentData.encoded?'utf-8':null);return dataURL?new Network.RequestHTMLView(dataURL):null;}
async createPreview(){if(this.request.signedExchangeInfo())
return new Network.SignedExchangeInfoView(this.request);const htmlErrorPreview=await this._htmlPreview();if(htmlErrorPreview)
return htmlErrorPreview;const provided=await SourceFrame.PreviewFactory.createPreview(this.request,this.request.mimeType);if(provided)
return provided;const sourceView=await Network.RequestResponseView.sourceViewForRequest(this.request);if(sourceView)
return sourceView;return new UI.EmptyWidget(Common.UIString('Preview not available'));}};;Network.RequestTimingView=class extends UI.VBox{constructor(request,calculator){super();this.element.classList.add('resource-timing-view');this._request=request;this._calculator=calculator;}
static _timeRangeTitle(name){switch(name){case Network.RequestTimeRangeNames.Push:return Common.UIString('Receiving Push');case Network.RequestTimeRangeNames.Queueing:return Common.UIString('Queueing');case Network.RequestTimeRangeNames.Blocking:return Common.UIString('Stalled');case Network.RequestTimeRangeNames.Connecting:return Common.UIString('Initial connection');case Network.RequestTimeRangeNames.DNS:return Common.UIString('DNS Lookup');case Network.RequestTimeRangeNames.Proxy:return Common.UIString('Proxy negotiation');case Network.RequestTimeRangeNames.ReceivingPush:return Common.UIString('Reading Push');case Network.RequestTimeRangeNames.Receiving:return Common.UIString('Content Download');case Network.RequestTimeRangeNames.Sending:return Common.UIString('Request sent');case Network.RequestTimeRangeNames.ServiceWorker:return Common.UIString('Request to ServiceWorker');case Network.RequestTimeRangeNames.ServiceWorkerPreparation:return Common.UIString('ServiceWorker Preparation');case Network.RequestTimeRangeNames.SSL:return Common.UIString('SSL');case Network.RequestTimeRangeNames.Total:return Common.UIString('Total');case Network.RequestTimeRangeNames.Waiting:return Common.UIString('Waiting (TTFB)');default:return Common.UIString(name);}}
static calculateRequestTimeRanges(request,navigationStart){const result=[];function addRange(name,start,end){if(start<Number.MAX_VALUE&&start<=end)
result.push({name:name,start:start,end:end});}
function firstPositive(numbers){for(let i=0;i<numbers.length;++i){if(numbers[i]>0)
return numbers[i];}
return undefined;}
function addOffsetRange(name,start,end){if(start>=0&&end>=0)
addRange(name,startTime+(start/1000),startTime+(end/1000));}
const timing=request.timing;if(!timing){const start=request.issueTime()!==-1?request.issueTime():request.startTime!==-1?request.startTime:0;const middle=(request.responseReceivedTime===-1)?Number.MAX_VALUE:request.responseReceivedTime;const end=(request.endTime===-1)?Number.MAX_VALUE:request.endTime;addRange(Network.RequestTimeRangeNames.Total,start,end);addRange(Network.RequestTimeRangeNames.Blocking,start,middle);addRange(Network.RequestTimeRangeNames.Receiving,middle,end);return result;}
const issueTime=request.issueTime();const startTime=timing.requestTime;const endTime=firstPositive([request.endTime,request.responseReceivedTime])||startTime;addRange(Network.RequestTimeRangeNames.Total,issueTime<startTime?issueTime:startTime,endTime);if(timing.pushStart){const pushEnd=timing.pushEnd||endTime;if(pushEnd>navigationStart)
addRange(Network.RequestTimeRangeNames.Push,Math.max(timing.pushStart,navigationStart),pushEnd);}
if(issueTime<startTime)
addRange(Network.RequestTimeRangeNames.Queueing,issueTime,startTime);const responseReceived=(request.responseReceivedTime-startTime)*1000;if(request.fetchedViaServiceWorker){addOffsetRange(Network.RequestTimeRangeNames.Blocking,0,timing.workerStart);addOffsetRange(Network.RequestTimeRangeNames.ServiceWorkerPreparation,timing.workerStart,timing.workerReady);addOffsetRange(Network.RequestTimeRangeNames.ServiceWorker,timing.workerReady,timing.sendEnd);addOffsetRange(Network.RequestTimeRangeNames.Waiting,timing.sendEnd,responseReceived);}else if(!timing.pushStart){const blockingEnd=firstPositive([timing.dnsStart,timing.connectStart,timing.sendStart,responseReceived])||0;addOffsetRange(Network.RequestTimeRangeNames.Blocking,0,blockingEnd);addOffsetRange(Network.RequestTimeRangeNames.Proxy,timing.proxyStart,timing.proxyEnd);addOffsetRange(Network.RequestTimeRangeNames.DNS,timing.dnsStart,timing.dnsEnd);addOffsetRange(Network.RequestTimeRangeNames.Connecting,timing.connectStart,timing.connectEnd);addOffsetRange(Network.RequestTimeRangeNames.SSL,timing.sslStart,timing.sslEnd);addOffsetRange(Network.RequestTimeRangeNames.Sending,timing.sendStart,timing.sendEnd);addOffsetRange(Network.RequestTimeRangeNames.Waiting,Math.max(timing.sendEnd,timing.connectEnd,timing.dnsEnd,timing.proxyEnd,blockingEnd),responseReceived);}
if(request.endTime!==-1){addRange(timing.pushStart?Network.RequestTimeRangeNames.ReceivingPush:Network.RequestTimeRangeNames.Receiving,request.responseReceivedTime,endTime);}
return result;}
static createTimingTable(request,calculator){const tableElement=createElementWithClass('table','network-timing-table');UI.appendStyle(tableElement,'network/networkTimingTable.css');const colgroup=tableElement.createChild('colgroup');colgroup.createChild('col','labels');colgroup.createChild('col','bars');colgroup.createChild('col','duration');const timeRanges=Network.RequestTimingView.calculateRequestTimeRanges(request,calculator.minimumBoundary());const startTime=timeRanges.map(r=>r.start).reduce((a,b)=>Math.min(a,b));const endTime=timeRanges.map(r=>r.end).reduce((a,b)=>Math.max(a,b));const scale=100/(endTime-startTime);let connectionHeader;let dataHeader;let queueingHeader;let totalDuration=0;const startTimeHeader=tableElement.createChild('thead','network-timing-start');const queuedCell=startTimeHeader.createChild('tr').createChild('td');const startedCell=startTimeHeader.createChild('tr').createChild('td');queuedCell.colSpan=startedCell.colSpan=2;queuedCell.createTextChild(Common.UIString('Queued at %s',calculator.formatValue(request.issueTime(),2)));startedCell.createTextChild(Common.UIString('Started at %s',calculator.formatValue(request.startTime,2)));let right;for(let i=0;i<timeRanges.length;++i){const range=timeRanges[i];const rangeName=range.name;if(rangeName===Network.RequestTimeRangeNames.Total){totalDuration=range.end-range.start;continue;}
if(rangeName===Network.RequestTimeRangeNames.Push){createHeader(Common.UIString('Server Push'));}else if(rangeName===Network.RequestTimeRangeNames.Queueing){queueingHeader=tableElement.createChild('tr','network-timing-table-header');queueingHeader.createChild('td').createTextChild(Common.UIString('Resource Scheduling'));queueingHeader.createChild('td').createTextChild('');queueingHeader.createChild('td').createTextChild(Common.UIString('TIME'));}else if(Network.RequestTimingView.ConnectionSetupRangeNames.has(rangeName)){if(!connectionHeader)
connectionHeader=createHeader(Common.UIString('Connection Start'));}else{if(!dataHeader)
dataHeader=createHeader(Common.UIString('Request/Response'));}
const left=(scale*(range.start-startTime));right=(scale*(endTime-range.end));const duration=range.end-range.start;const tr=tableElement.createChild('tr');tr.createChild('td').createTextChild(Network.RequestTimingView._timeRangeTitle(rangeName));const row=tr.createChild('td').createChild('div','network-timing-row');const bar=row.createChild('span','network-timing-bar '+rangeName);bar.style.left=left+'%';bar.style.right=right+'%';bar.textContent='\u200B';const label=tr.createChild('td').createChild('div','network-timing-bar-title');label.textContent=Number.secondsToString(duration,true);}
if(!request.finished){const cell=tableElement.createChild('tr').createChild('td','caution');cell.colSpan=3;cell.createTextChild(Common.UIString('CAUTION: request is not finished yet!'));}
const footer=tableElement.createChild('tr','network-timing-footer');const note=footer.createChild('td');note.colSpan=1;note.appendChild(UI.createDocumentationLink('network-performance/reference#timing-explanation',Common.UIString('Explanation')));footer.createChild('td');footer.createChild('td').createTextChild(Number.secondsToString(totalDuration,true));const serverTimings=request.serverTimings;if(!serverTimings)
return tableElement;const lastTimingRightEdge=right===undefined?100:right;const breakElement=tableElement.createChild('tr','network-timing-table-header').createChild('td');breakElement.colSpan=3;breakElement.createChild('hr','break');const serverHeader=tableElement.createChild('tr','network-timing-table-header');serverHeader.createChild('td').createTextChild(Common.UIString('Server Timing'));serverHeader.createChild('td');serverHeader.createChild('td').createTextChild(Common.UIString('TIME'));serverTimings.filter(item=>item.metric.toLowerCase()!=='total').forEach(item=>addTiming(item,lastTimingRightEdge));serverTimings.filter(item=>item.metric.toLowerCase()==='total').forEach(item=>addTiming(item,lastTimingRightEdge));return tableElement;function addTiming(serverTiming,right){const colorGenerator=new Common.Color.Generator({min:0,max:360,count:36},{min:50,max:80},80);const isTotal=serverTiming.metric.toLowerCase()==='total';const tr=tableElement.createChild('tr',isTotal?'network-timing-footer':'');const metric=tr.createChild('td','network-timing-metric');metric.createTextChild(serverTiming.description||serverTiming.metric);const row=tr.createChild('td').createChild('div','network-timing-row');if(serverTiming.value===null)
return;const left=scale*(endTime-startTime-(serverTiming.value/1000));if(left>=0){const bar=row.createChild('span','network-timing-bar server-timing');bar.style.left=left+'%';bar.style.right=right+'%';bar.textContent='\u200B';if(!isTotal)
bar.style.backgroundColor=colorGenerator.colorForID(serverTiming.metric);}
const label=tr.createChild('td').createChild('div','network-timing-bar-title');label.textContent=Number.millisToString(serverTiming.value,true);}
function createHeader(title){const dataHeader=tableElement.createChild('tr','network-timing-table-header');dataHeader.createChild('td').createTextChild(title);dataHeader.createChild('td').createTextChild('');dataHeader.createChild('td').createTextChild(Common.UIString('TIME'));return dataHeader;}}
wasShown(){this._request.addEventListener(SDK.NetworkRequest.Events.TimingChanged,this._refresh,this);this._request.addEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._refresh,this);this._calculator.addEventListener(Network.NetworkTimeCalculator.Events.BoundariesChanged,this._refresh,this);this._refresh();}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.TimingChanged,this._refresh,this);this._request.removeEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._refresh,this);this._calculator.removeEventListener(Network.NetworkTimeCalculator.Events.BoundariesChanged,this._refresh,this);}
_refresh(){if(this._tableElement)
this._tableElement.remove();this._tableElement=Network.RequestTimingView.createTimingTable(this._request,this._calculator);this._tableElement.classList.add('resource-timing-table');this.element.appendChild(this._tableElement);}};Network.RequestTimeRangeNames={Push:'push',Queueing:'queueing',Blocking:'blocking',Connecting:'connecting',DNS:'dns',Proxy:'proxy',Receiving:'receiving',ReceivingPush:'receiving-push',Sending:'sending',ServiceWorker:'serviceworker',ServiceWorkerPreparation:'serviceworker-preparation',SSL:'ssl',Total:'total',Waiting:'waiting'};Network.RequestTimingView.ConnectionSetupRangeNames=new Set([Network.RequestTimeRangeNames.Queueing,Network.RequestTimeRangeNames.Blocking,Network.RequestTimeRangeNames.Connecting,Network.RequestTimeRangeNames.DNS,Network.RequestTimeRangeNames.Proxy,Network.RequestTimeRangeNames.SSL]);Network.RequestTimeRange;;Network.ResourceWebSocketFrameView=class extends UI.VBox{constructor(request){super();this.registerRequiredCSS('network/webSocketFrameView.css');this.element.classList.add('websocket-frame-view');this._request=request;this._splitWidget=new UI.SplitWidget(false,true,'resourceWebSocketFrameSplitViewState');this._splitWidget.show(this.element);const columns=([{id:'data',title:Common.UIString('Data'),sortable:false,weight:88},{id:'length',title:Common.UIString('Length'),sortable:false,align:DataGrid.DataGrid.Align.Right,weight:5},{id:'time',title:Common.UIString('Time'),sortable:true,weight:7}]);this._dataGrid=new DataGrid.SortableDataGrid(columns);this._dataGrid.setRowContextMenuCallback(onRowContextMenu.bind(this));this._dataGrid.setStickToBottom(true);this._dataGrid.setCellClass('websocket-frame-view-td');this._timeComparator=(Network.ResourceWebSocketFrameNodeTimeComparator);this._dataGrid.sortNodes(this._timeComparator,false);this._dataGrid.markColumnAsSortedBy('time',DataGrid.DataGrid.Order.Ascending);this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,this._sortItems,this);this._dataGrid.setName('ResourceWebSocketFrameView');this._dataGrid.addEventListener(DataGrid.DataGrid.Events.SelectedNode,this._onFrameSelected,this);this._dataGrid.addEventListener(DataGrid.DataGrid.Events.DeselectedNode,this._onFrameDeselected,this);this._mainToolbar=new UI.Toolbar('');this._clearAllButton=new UI.ToolbarButton(Common.UIString('Clear All'),'largeicon-clear');this._clearAllButton.addEventListener(UI.ToolbarButton.Events.Click,this._clearFrames,this);this._mainToolbar.appendToolbarItem(this._clearAllButton);this._filterTypeCombobox=new UI.ToolbarComboBox(this._updateFilterSetting.bind(this));for(const filterItem of Network.ResourceWebSocketFrameView._filterTypes){const option=this._filterTypeCombobox.createOption(filterItem.label,filterItem.label,filterItem.name);this._filterTypeCombobox.addOption(option);}
this._mainToolbar.appendToolbarItem(this._filterTypeCombobox);this._filterType=null;const placeholder='Enter regex, for example: (web)?socket';this._filterTextInput=new UI.ToolbarInput(Common.UIString(placeholder),0.4);this._filterTextInput.addEventListener(UI.ToolbarInput.Event.TextChanged,this._updateFilterSetting,this);this._mainToolbar.appendToolbarItem(this._filterTextInput);this._filterRegex=null;const mainContainer=new UI.VBox();mainContainer.element.appendChild(this._mainToolbar.element);this._dataGrid.asWidget().show(mainContainer.element);this._splitWidget.setMainWidget(mainContainer);this._frameEmptyWidget=new UI.EmptyWidget(Common.UIString('Select frame to browse its content.'));this._splitWidget.setSidebarWidget(this._frameEmptyWidget);this._selectedNode=null;function onRowContextMenu(contextMenu,node){contextMenu.clipboardSection().appendItem(Common.UIString('Copy message'),InspectorFrontendHost.copyText.bind(InspectorFrontendHost,node.data.data));contextMenu.footerSection().appendItem(Common.UIString('Clear all'),this._clearFrames.bind(this));}}
static opCodeDescription(opCode,mask){const rawDescription=Network.ResourceWebSocketFrameView.opCodeDescriptions[opCode]||'';const localizedDescription=Common.UIString(rawDescription);return Common.UIString('%s (Opcode %d%s)',localizedDescription,opCode,(mask?', mask':''));}
wasShown(){this.refresh();this._request.addEventListener(SDK.NetworkRequest.Events.WebsocketFrameAdded,this._frameAdded,this);}
willHide(){this._request.removeEventListener(SDK.NetworkRequest.Events.WebsocketFrameAdded,this._frameAdded,this);}
_frameAdded(event){const frame=(event.data);if(!this._frameFilter(frame))
return;this._dataGrid.insertChild(new Network.ResourceWebSocketFrameNode(this._request.url(),frame));}
_frameFilter(frame){if(this._filterType&&frame.type!==this._filterType)
return false;return!this._filterRegex||this._filterRegex.test(frame.text);}
_clearFrames(){this._request[Network.ResourceWebSocketFrameView._clearFrameOffsetSymbol]=this._request.frames().length;this.refresh();}
_updateFilterSetting(){const text=this._filterTextInput.value();const type=this._filterTypeCombobox.selectedOption().value;this._filterRegex=text?new RegExp(text,'i'):null;this._filterType=type==='all'?null:type;this.refresh();}
async _onFrameSelected(event){const selectedNode=(event.data);this._currentSelectedNode=selectedNode;const contentProvider=selectedNode.contentProvider();const content=await contentProvider.requestContent();const jsonView=await SourceFrame.JSONView.createView(content);if(this._currentSelectedNode!==selectedNode)
return;if(jsonView)
this._splitWidget.setSidebarWidget(jsonView);else
this._splitWidget.setSidebarWidget(new SourceFrame.ResourceSourceFrame(contentProvider));}
_onFrameDeselected(event){this._currentSelectedNode=null;this._splitWidget.setSidebarWidget(this._frameEmptyWidget);}
refresh(){this._dataGrid.rootNode().removeChildren();const url=this._request.url();let frames=this._request.frames();const offset=this._request[Network.ResourceWebSocketFrameView._clearFrameOffsetSymbol]||0;frames=frames.slice(offset);frames=frames.filter(this._frameFilter.bind(this));frames.forEach(frame=>this._dataGrid.insertChild(new Network.ResourceWebSocketFrameNode(url,frame)));}
_sortItems(){this._dataGrid.sortNodes(this._timeComparator,!this._dataGrid.isSortOrderAscending());}};Network.ResourceWebSocketFrameView.OpCodes={ContinuationFrame:0,TextFrame:1,BinaryFrame:2,ConnectionCloseFrame:8,PingFrame:9,PongFrame:10};Network.ResourceWebSocketFrameView.opCodeDescriptions=(function(){const opCodes=Network.ResourceWebSocketFrameView.OpCodes;const map=[];map[opCodes.ContinuationFrame]='Continuation Frame';map[opCodes.TextFrame]='Text Frame';map[opCodes.BinaryFrame]='Binary Frame';map[opCodes.ContinuationFrame]='Connection Close Frame';map[opCodes.PingFrame]='Ping Frame';map[opCodes.PongFrame]='Pong Frame';return map;})();Network.ResourceWebSocketFrameView._filterTypes=[{name:'all',label:Common.UIString('All')},{name:'send',label:Common.UIString('Send')},{name:'receive',label:Common.UIString('Receive')},];Network.ResourceWebSocketFrameNode=class extends DataGrid.SortableDataGridNode{constructor(url,frame){let dataText=frame.text;const length=frame.text.length;const time=new Date(frame.time*1000);const timeText=('0'+time.getHours()).substr(-2)+':'+('0'+time.getMinutes()).substr(-2)+':'+
('0'+time.getSeconds()).substr(-2)+'.'+('00'+time.getMilliseconds()).substr(-3);const timeNode=createElement('div');timeNode.createTextChild(timeText);timeNode.title=time.toLocaleString();const isTextFrame=frame.opCode===Network.ResourceWebSocketFrameView.OpCodes.TextFrame;if(!isTextFrame)
dataText=Network.ResourceWebSocketFrameView.opCodeDescription(frame.opCode,frame.mask);super({data:dataText,length:length,time:timeNode});this._url=url;this._frame=frame;this._isTextFrame=isTextFrame;this._dataText=dataText;}
createCells(element){element.classList.toggle('websocket-frame-view-row-error',this._frame.type===SDK.NetworkRequest.WebSocketFrameType.Error);element.classList.toggle('websocket-frame-view-row-send',this._frame.type===SDK.NetworkRequest.WebSocketFrameType.Send);element.classList.toggle('websocket-frame-view-row-receive',this._frame.type===SDK.NetworkRequest.WebSocketFrameType.Receive);element.classList.toggle('websocket-frame-view-row-opcode',!this._isTextFrame);super.createCells(element);}
nodeSelfHeight(){return 21;}
contentProvider(){return Common.StaticContentProvider.fromString(this._url,Common.resourceTypes.WebSocket,this._dataText);}};Network.ResourceWebSocketFrameNodeTimeComparator=function(a,b){return a._frame.time-b._frame.time;};Network.ResourceWebSocketFrameView._clearFrameOffsetSymbol=Symbol('ClearFrameOffset');;Network.SignedExchangeInfoView=class extends UI.VBox{constructor(request){super();const signedExchangeInfo=request.signedExchangeInfo();console.assert(signedExchangeInfo);this.registerRequiredCSS('network/signedExchangeInfoView.css');this.element.classList.add('signed-exchange-info-view');const root=new UI.TreeOutlineInShadow();root.registerRequiredCSS('network/signedExchangeInfoTree.css');root.element.classList.add('signed-exchange-info-tree');root.setFocusable(false);root.makeDense();root.expandTreeElementsWhenArrowing=true;this.element.appendChild(root.element);const errorFieldSetMap=new Map();if(signedExchangeInfo.errors&&signedExchangeInfo.errors.length){const errorMessagesCategory=new Network.SignedExchangeInfoView.Category(root,Common.UIString('Errors'));for(const error of signedExchangeInfo.errors){const fragment=createDocumentFragment();fragment.appendChild(UI.Icon.create('smallicon-error','prompt-icon'));fragment.createChild('div','error-log').textContent=error.message;errorMessagesCategory.createLeaf(fragment);if(error.errorField){let errorFieldSet=errorFieldSetMap.get(error.signatureIndex);if(!errorFieldSet){errorFieldSet=new Set();errorFieldSetMap.set(error.signatureIndex,errorFieldSet);}
errorFieldSet.add(error.errorField);}}}
const titleElement=createDocumentFragment();titleElement.createChild('div','header-name').textContent=Common.UIString('Signed HTTP exchange');const learnMoreNode=UI.XLink.create('https://github.com/WICG/webpackage',Common.UIString('Learn\xa0more'),'header-toggle');titleElement.appendChild(learnMoreNode);const headerCategory=new Network.SignedExchangeInfoView.Category(root,titleElement);if(signedExchangeInfo.header){const header=signedExchangeInfo.header;const redirectDestination=request.redirectDestination();const requestURLElement=this._formatHeader(Common.UIString('Request URL'),header.requestUrl);if(redirectDestination){const viewRequestLink=Components.Linkifier.linkifyRevealable(redirectDestination,'View request');viewRequestLink.classList.add('header-toggle');requestURLElement.appendChild(viewRequestLink);}
headerCategory.createLeaf(requestURLElement);headerCategory.createLeaf(this._formatHeader(Common.UIString('Request method'),header.requestMethod));headerCategory.createLeaf(this._formatHeader(Common.UIString('Response code'),header.responseCode+''));this._responseHeadersItem=headerCategory.createLeaf(this._formatHeader(Common.UIString('Response headers'),''));const responseHeaders=header.responseHeaders;for(const name in responseHeaders){const headerTreeElement=new UI.TreeElement(this._formatHeader(name,responseHeaders[name]));headerTreeElement.selectable=false;this._responseHeadersItem.appendChild(headerTreeElement);}
this._responseHeadersItem.expand();for(let i=0;i<header.signatures.length;++i){const errorFieldSet=errorFieldSetMap.get(i)||new Set();const signature=header.signatures[i];const signatureCategory=new Network.SignedExchangeInfoView.Category(root,Common.UIString('Signature'));signatureCategory.createLeaf(this._formatHeader(Common.UIString('Label'),signature.label));signatureCategory.createLeaf(this._formatHeaderForHexData(Common.UIString('Signature'),signature.signature,errorFieldSet.has(Protocol.Network.SignedExchangeErrorField.SignatureSig)));if(signature.certUrl){const certURLElement=this._formatHeader(Common.UIString('Certificate URL'),signature.certUrl,errorFieldSet.has(Protocol.Network.SignedExchangeErrorField.SignatureCertUrl));if(signature.certificates){const viewCertLink=certURLElement.createChild('span','devtools-link header-toggle');viewCertLink.textContent=Common.UIString('View certificate');viewCertLink.addEventListener('click',InspectorFrontendHost.showCertificateViewer.bind(null,signature.certificates),false);}
signatureCategory.createLeaf(certURLElement);}
signatureCategory.createLeaf(this._formatHeader(Common.UIString('Integrity'),signature.integrity,errorFieldSet.has(Protocol.Network.SignedExchangeErrorField.SignatureIntegrity)));if(signature.certSha256){signatureCategory.createLeaf(this._formatHeaderForHexData(Common.UIString('Certificate SHA256'),signature.certSha256,errorFieldSet.has(Protocol.Network.SignedExchangeErrorField.SignatureCertSha256)));}
signatureCategory.createLeaf(this._formatHeader(Common.UIString('Validity URL'),signature.validityUrl,errorFieldSet.has(Protocol.Network.SignedExchangeErrorField.SignatureValidityUrl)));signatureCategory.createLeaf().title=this._formatHeader(Common.UIString('Date'),new Date(1000*signature.date).toUTCString(),errorFieldSet.has(Protocol.Network.SignedExchangeErrorField.SignatureTimestamps));signatureCategory.createLeaf().title=this._formatHeader(Common.UIString('Expires'),new Date(1000*signature.expires).toUTCString(),errorFieldSet.has(Protocol.Network.SignedExchangeErrorField.SignatureTimestamps));}}
if(signedExchangeInfo.securityDetails){const securityDetails=signedExchangeInfo.securityDetails;const securityCategory=new Network.SignedExchangeInfoView.Category(root,Common.UIString('Certificate'));securityCategory.createLeaf(this._formatHeader(Common.UIString('Subject'),securityDetails.subjectName));securityCategory.createLeaf(this._formatHeader(Common.UIString('Valid from'),new Date(1000*securityDetails.validFrom).toUTCString()));securityCategory.createLeaf(this._formatHeader(Common.UIString('Valid until'),new Date(1000*securityDetails.validTo).toUTCString()));securityCategory.createLeaf(this._formatHeader(Common.UIString('Issuer'),securityDetails.issuer));}}
_formatHeader(name,value,highlighted){const fragment=createDocumentFragment();const nameElement=fragment.createChild('div','header-name');nameElement.textContent=name+': ';fragment.createChild('span','header-separator');const valueElement=fragment.createChild('div','header-value source-code');valueElement.textContent=value;if(highlighted){nameElement.classList.add('error-field');valueElement.classList.add('error-field');}
return fragment;}
_formatHeaderForHexData(name,value,highlighted){const fragment=createDocumentFragment();const nameElement=fragment.createChild('div','header-name');nameElement.textContent=name+': ';fragment.createChild('span','header-separator');const valueElement=fragment.createChild('div','header-value source-code hex-data');valueElement.textContent=value.replace(/(.{2})/g,'$1 ');if(highlighted){nameElement.classList.add('error-field');valueElement.classList.add('error-field');}
return fragment;}};Network.SignedExchangeInfoView.Category=class extends UI.TreeElement{constructor(root,title){super(title,true);this.selectable=false;this.toggleOnClick=true;this.expanded=true;root.appendChild(this);}
createLeaf(title){const leaf=new UI.TreeElement(title);leaf.selectable=false;this.appendChild(leaf);return leaf;}};;Network.NetworkPanel=class extends UI.Panel{constructor(){super('network');this.registerRequiredCSS('network/networkPanel.css');this._networkLogShowOverviewSetting=Common.settings.createSetting('networkLogShowOverview',true);this._networkLogLargeRowsSetting=Common.settings.createSetting('networkLogLargeRows',false);this._networkRecordFilmStripSetting=Common.settings.createSetting('networkRecordFilmStripSetting',false);this._toggleRecordAction=(UI.actionRegistry.action('network.toggle-recording'));this._pendingStopTimer;this._networkItemView=null;this._filmStripView=null;this._filmStripRecorder=null;const panel=new UI.VBox();this._panelToolbar=new UI.Toolbar('',panel.contentElement);this._filterBar=new UI.FilterBar('networkPanel',true);this._filterBar.show(panel.contentElement);this._filmStripPlaceholderElement=panel.contentElement.createChild('div','network-film-strip-placeholder');this._overviewPane=new PerfUI.TimelineOverviewPane('network');this._overviewPane.addEventListener(PerfUI.TimelineOverviewPane.Events.WindowChanged,this._onWindowChanged.bind(this));this._overviewPane.element.id='network-overview-panel';this._networkOverview=new Network.NetworkOverview();this._overviewPane.setOverviewControls([this._networkOverview]);this._overviewPlaceholderElement=panel.contentElement.createChild('div');this._calculator=new Network.NetworkTransferTimeCalculator();this._splitWidget=new UI.SplitWidget(true,false,'networkPanelSplitViewState');this._splitWidget.hideMain();this._splitWidget.show(panel.contentElement);panel.setDefaultFocusedChild(this._filterBar);const initialSidebarWidth=225;const splitWidget=new UI.SplitWidget(true,false,'networkPanelSidebarState',initialSidebarWidth);splitWidget.hideSidebar();splitWidget.enableShowModeSaving();splitWidget.element.tabIndex=0;splitWidget.show(this.element);this._sidebarLocation=UI.viewManager.createTabbedLocation(async()=>{UI.viewManager.showView('network');splitWidget.showBoth();},'network-sidebar',true);const tabbedPane=this._sidebarLocation.tabbedPane();tabbedPane.setMinimumSize(100,25);tabbedPane.element.classList.add('network-tabbed-pane');tabbedPane.element.addEventListener('keydown',event=>{if(event.key!=='Escape')
return;splitWidget.hideSidebar();event.consume();});const closeSidebar=new UI.ToolbarButton(Common.UIString('Close'),'largeicon-delete');closeSidebar.addEventListener(UI.ToolbarButton.Events.Click,()=>splitWidget.hideSidebar());tabbedPane.rightToolbar().appendToolbarItem(closeSidebar);splitWidget.setSidebarWidget(tabbedPane);splitWidget.setMainWidget(panel);splitWidget.setDefaultFocusedChild(panel);this.setDefaultFocusedChild(splitWidget);this._progressBarContainer=createElement('div');this._networkLogView=new Network.NetworkLogView(this._filterBar,this._progressBarContainer,this._networkLogLargeRowsSetting);this._splitWidget.setSidebarWidget(this._networkLogView);this._detailsWidget=new UI.VBox();this._detailsWidget.element.classList.add('network-details-view');this._splitWidget.setMainWidget(this._detailsWidget);this._closeButtonElement=createElement('div','dt-close-button');this._closeButtonElement.addEventListener('click',this._showRequest.bind(this,null),false);this._closeButtonElement.style.margin='0 5px';this._networkLogShowOverviewSetting.addChangeListener(this._toggleShowOverview,this);this._networkLogLargeRowsSetting.addChangeListener(this._toggleLargerRequests,this);this._networkRecordFilmStripSetting.addChangeListener(this._toggleRecordFilmStrip,this);this._preserveLogSetting=Common.moduleSetting('network_log.preserve-log');this._offlineCheckbox=MobileThrottling.throttlingManager().createOfflineToolbarCheckbox();this._throttlingSelect=this._createThrottlingConditionsSelect();this._setupToolbarButtons(splitWidget);this._toggleRecord(true);this._toggleShowOverview();this._toggleLargerRequests();this._toggleRecordFilmStrip();this._updateUI();SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.WillReloadPage,this._willReloadPage,this);SDK.targetManager.addModelListener(SDK.ResourceTreeModel,SDK.ResourceTreeModel.Events.Load,this._load,this);this._networkLogView.addEventListener(Network.NetworkLogView.Events.RequestSelected,this._onRequestSelected,this);BrowserSDK.networkLog.addEventListener(BrowserSDK.NetworkLog.Events.RequestAdded,this._onUpdateRequest,this);BrowserSDK.networkLog.addEventListener(BrowserSDK.NetworkLog.Events.RequestUpdated,this._onUpdateRequest,this);BrowserSDK.networkLog.addEventListener(BrowserSDK.NetworkLog.Events.Reset,this._onNetworkLogReset,this);}
static revealAndFilter(filters){const panel=Network.NetworkPanel._instance();let filterString='';for(const filter of filters)
filterString+=`${filter.filterType}:${filter.filterValue} `;panel._networkLogView.setTextFilterValue(filterString);UI.viewManager.showView('network');}
static _instance(){return(self.runtime.sharedInstance(Network.NetworkPanel));}
offlineCheckboxForTest(){return this._offlineCheckbox;}
throttlingSelectForTest(){return this._throttlingSelect;}
_onWindowChanged(event){const startTime=Math.max(this._calculator.minimumBoundary(),event.data.startTime/1000);const endTime=Math.min(this._calculator.maximumBoundary(),event.data.endTime/1000);this._networkLogView.setWindow(startTime,endTime);}
_setupToolbarButtons(splitWidget){const searchToggle=new UI.ToolbarToggle('Search','largeicon-search');function updateSidebarToggle(){searchToggle.setToggled(splitWidget.showMode()!==UI.SplitWidget.ShowMode.OnlyMain);}
this._panelToolbar.appendToolbarItem(UI.Toolbar.createActionButton(this._toggleRecordAction));const clearButton=new UI.ToolbarButton(Common.UIString('Clear'),'largeicon-clear');clearButton.addEventListener(UI.ToolbarButton.Events.Click,()=>BrowserSDK.networkLog.reset(),this);this._panelToolbar.appendToolbarItem(clearButton);this._panelToolbar.appendSeparator();const recordFilmStripButton=new UI.ToolbarSettingToggle(this._networkRecordFilmStripSetting,'largeicon-camera',Common.UIString('Capture screenshots'));this._panelToolbar.appendToolbarItem(recordFilmStripButton);this._panelToolbar.appendToolbarItem(this._filterBar.filterButton());updateSidebarToggle();splitWidget.addEventListener(UI.SplitWidget.Events.ShowModeChanged,updateSidebarToggle);searchToggle.addEventListener(UI.ToolbarButton.Events.Click,()=>{if(splitWidget.showMode()===UI.SplitWidget.ShowMode.OnlyMain)
splitWidget.showBoth();else
splitWidget.hideSidebar();});this._panelToolbar.appendToolbarItem(searchToggle);this._panelToolbar.appendSeparator();this._panelToolbar.appendText(Common.UIString('View:'));const largerRequestsButton=new UI.ToolbarSettingToggle(this._networkLogLargeRowsSetting,'largeicon-large-list',Common.UIString('Use large request rows'),Common.UIString('Use small request rows'));this._panelToolbar.appendToolbarItem(largerRequestsButton);const showOverviewButton=new UI.ToolbarSettingToggle(this._networkLogShowOverviewSetting,'largeicon-waterfall',Common.UIString('Show overview'),Common.UIString('Hide overview'));this._panelToolbar.appendToolbarItem(showOverviewButton);this._panelToolbar.appendToolbarItem(new UI.ToolbarSettingCheckbox(Common.moduleSetting('network.group-by-frame'),'',Common.UIString('Group by frame')));this._panelToolbar.appendSeparator();this._panelToolbar.appendToolbarItem(new UI.ToolbarSettingCheckbox(this._preserveLogSetting,Common.UIString('Do not clear log on page reload / navigation'),Common.UIString('Preserve log')));const disableCacheCheckbox=new UI.ToolbarSettingCheckbox(Common.moduleSetting('cacheDisabled'),Common.UIString('Disable cache (while DevTools is open)'),Common.UIString('Disable cache'));this._panelToolbar.appendToolbarItem(disableCacheCheckbox);this._panelToolbar.appendSeparator();this._panelToolbar.appendToolbarItem(this._offlineCheckbox);this._panelToolbar.appendToolbarItem(this._throttlingSelect);this._panelToolbar.appendToolbarItem(new UI.ToolbarItem(this._progressBarContainer));}
_createThrottlingConditionsSelect(){const toolbarItem=new UI.ToolbarComboBox(null);toolbarItem.setTitle(ls`Throttling`);toolbarItem.setMaxWidth(160);MobileThrottling.throttlingManager().decorateSelectWithNetworkThrottling(toolbarItem.selectElement());return toolbarItem;}
_toggleRecording(){if(!this._preserveLogSetting.get()&&!this._toggleRecordAction.toggled())
BrowserSDK.networkLog.reset();this._toggleRecord(!this._toggleRecordAction.toggled());}
_toggleRecord(toggled){this._toggleRecordAction.setToggled(toggled);this._networkLogView.setRecording(toggled);if(!toggled&&this._filmStripRecorder)
this._filmStripRecorder.stopRecording(this._filmStripAvailable.bind(this));BrowserSDK.networkLog.setIsRecording(toggled);}
_filmStripAvailable(filmStripModel){if(!filmStripModel)
return;const calculator=this._networkLogView.timeCalculator();this._filmStripView.setModel(filmStripModel,calculator.minimumBoundary()*1000,calculator.boundarySpan()*1000);this._networkOverview.setFilmStripModel(filmStripModel);const timestamps=filmStripModel.frames().map(mapTimestamp);function mapTimestamp(frame){return frame.timestamp/1000;}
this._networkLogView.addFilmStripFrames(timestamps);}
_onNetworkLogReset(){Network.BlockedURLsPane.reset();if(!this._preserveLogSetting.get()){this._calculator.reset();this._overviewPane.reset();}
if(this._filmStripView)
this._resetFilmStripView();}
_willReloadPage(event){this._toggleRecord(true);if(this._pendingStopTimer){clearTimeout(this._pendingStopTimer);delete this._pendingStopTimer;}
if(this.isShowing()&&this._filmStripRecorder)
this._filmStripRecorder.startRecording();}
_load(event){if(this._filmStripRecorder&&this._filmStripRecorder.isRecording()){this._pendingStopTimer=setTimeout(this._stopFilmStripRecording.bind(this),Network.NetworkPanel.displayScreenshotDelay);}}
_stopFilmStripRecording(){this._filmStripRecorder.stopRecording(this._filmStripAvailable.bind(this));delete this._pendingStopTimer;}
_toggleLargerRequests(){this._updateUI();}
_toggleShowOverview(){const toggled=this._networkLogShowOverviewSetting.get();if(toggled)
this._overviewPane.show(this._overviewPlaceholderElement);else
this._overviewPane.detach();this.doResize();}
_toggleRecordFilmStrip(){const toggled=this._networkRecordFilmStripSetting.get();if(toggled&&!this._filmStripRecorder){this._filmStripView=new PerfUI.FilmStripView();this._filmStripView.setMode(PerfUI.FilmStripView.Modes.FrameBased);this._filmStripView.element.classList.add('network-film-strip');this._filmStripRecorder=new Network.NetworkPanel.FilmStripRecorder(this._networkLogView.timeCalculator(),this._filmStripView);this._filmStripView.show(this._filmStripPlaceholderElement);this._filmStripView.addEventListener(PerfUI.FilmStripView.Events.FrameSelected,this._onFilmFrameSelected,this);this._filmStripView.addEventListener(PerfUI.FilmStripView.Events.FrameEnter,this._onFilmFrameEnter,this);this._filmStripView.addEventListener(PerfUI.FilmStripView.Events.FrameExit,this._onFilmFrameExit,this);this._resetFilmStripView();}
if(!toggled&&this._filmStripRecorder){this._filmStripView.detach();this._filmStripView=null;this._filmStripRecorder=null;}}
_resetFilmStripView(){this._filmStripView.reset();this._filmStripView.setStatusText(Common.UIString('Hit %s to reload and capture filmstrip.',UI.shortcutRegistry.shortcutDescriptorsForAction('inspector_main.reload')[0].name));}
elementsToRestoreScrollPositionsFor(){return this._networkLogView.elementsToRestoreScrollPositionsFor();}
wasShown(){UI.context.setFlavor(Network.NetworkPanel,this);}
willHide(){UI.context.setFlavor(Network.NetworkPanel,null);}
revealAndHighlightRequest(request){this._showRequest(null);if(request)
this._networkLogView.revealAndHighlightRequest(request);}
async selectRequest(request){await UI.viewManager.showView('network');this._networkLogView.selectRequest(request);return this._networkItemView;}
_onRowSizeChanged(event){this._updateUI();}
_onRequestSelected(event){const request=(event.data);this._showRequest(request);}
_showRequest(request){if(this._networkItemView){this._networkItemView.detach();this._networkItemView=null;}
if(request){this._networkItemView=new Network.NetworkItemView(request,this._networkLogView.timeCalculator());this._networkItemView.leftToolbar().appendToolbarItem(new UI.ToolbarItem(this._closeButtonElement));this._networkItemView.show(this._detailsWidget.element);this._splitWidget.showBoth();}else{this._splitWidget.hideMain();this._networkLogView.clearSelection();}
this._updateUI();}
_updateUI(){this._detailsWidget.element.classList.toggle('network-details-view-tall-header',this._networkLogLargeRowsSetting.get());this._networkLogView.switchViewMode(!this._splitWidget.isResizable());}
appendApplicableItems(event,contextMenu,target){function reveal(request){UI.viewManager.showView('network').then(this.revealAndHighlightRequest.bind(this,request));}
function appendRevealItem(request){contextMenu.revealSection().appendItem(Common.UIString('Reveal in Network panel'),reveal.bind(this,request));}
if(event.target.isSelfOrDescendant(this.element))
return;if(target instanceof SDK.Resource){const resource=(target);if(resource.request)
appendRevealItem.call(this,resource.request);return;}
if(target instanceof Workspace.UISourceCode){const uiSourceCode=(target);const resource=Bindings.resourceForURL(uiSourceCode.url());if(resource&&resource.request)
appendRevealItem.call(this,resource.request);return;}
if(!(target instanceof SDK.NetworkRequest))
return;const request=(target);if(this._networkItemView&&this._networkItemView.isShowing()&&this._networkItemView.request()===request)
return;appendRevealItem.call(this,request);}
_onFilmFrameSelected(event){const timestamp=(event.data);this._overviewPane.setWindowTimes(0,timestamp);}
_onFilmFrameEnter(event){const timestamp=(event.data);this._networkOverview.selectFilmStripFrame(timestamp);this._networkLogView.selectFilmStripFrame(timestamp/1000);}
_onFilmFrameExit(event){this._networkOverview.clearFilmStripFrame();this._networkLogView.clearFilmStripFrame();}
_onUpdateRequest(event){const request=(event.data);this._calculator.updateBoundaries(request);this._overviewPane.setBounds(this._calculator.minimumBoundary()*1000,this._calculator.maximumBoundary()*1000);this._networkOverview.updateRequest(request);this._overviewPane.scheduleUpdate();}
resolveLocation(locationName){if(locationName==='network-sidebar')
return this._sidebarLocation;return null;}};Network.NetworkPanel.displayScreenshotDelay=1000;Network.NetworkPanel.ContextMenuProvider=class{appendApplicableItems(event,contextMenu,target){Network.NetworkPanel._instance().appendApplicableItems(event,contextMenu,target);}};Network.NetworkPanel.RequestRevealer=class{reveal(request){if(!(request instanceof SDK.NetworkRequest))
return Promise.reject(new Error('Internal error: not a network request'));const panel=Network.NetworkPanel._instance();return UI.viewManager.showView('network').then(panel.revealAndHighlightRequest.bind(panel,request));}};Network.NetworkPanel.FilmStripRecorder=class{constructor(timeCalculator,filmStripView){this._tracingManager=null;this._resourceTreeModel=null;this._timeCalculator=timeCalculator;this._filmStripView=filmStripView;this._tracingModel=null;this._callback=null;}
traceEventsCollected(events){if(this._tracingModel)
this._tracingModel.addEvents(events);}
tracingComplete(){if(!this._tracingModel||!this._tracingManager)
return;this._tracingModel.tracingComplete();this._tracingManager=null;this._callback(new SDK.FilmStripModel(this._tracingModel,this._timeCalculator.minimumBoundary()*1000));this._callback=null;if(this._resourceTreeModel)
this._resourceTreeModel.resumeReload();this._resourceTreeModel=null;}
tracingBufferUsage(){}
eventsRetrievalProgress(progress){}
startRecording(){this._filmStripView.reset();this._filmStripView.setStatusText(Common.UIString('Recording frames...'));const tracingManagers=SDK.targetManager.models(SDK.TracingManager);if(this._tracingManager||!tracingManagers.length)
return;this._tracingManager=tracingManagers[0];this._resourceTreeModel=this._tracingManager.target().model(SDK.ResourceTreeModel);if(this._tracingModel)
this._tracingModel.dispose();this._tracingModel=new SDK.TracingModel(new Bindings.TempFileBackingStorage());this._tracingManager.start(this,'-*,disabled-by-default-devtools.screenshot','');}
isRecording(){return!!this._tracingManager;}
stopRecording(callback){if(!this._tracingManager)
return;this._tracingManager.stop();if(this._resourceTreeModel)
this._resourceTreeModel.suspendReload();this._callback=callback;this._filmStripView.setStatusText(Common.UIString('Fetching frames...'));}};Network.NetworkPanel.ActionDelegate=class{handleAction(context,actionId){const panel=UI.context.flavor(Network.NetworkPanel);console.assert(panel&&panel instanceof Network.NetworkPanel);switch(actionId){case'network.toggle-recording':panel._toggleRecording();return true;case'network.hide-request-details':if(!panel._networkItemView)
return false;panel._showRequest(null);return true;case'network.search':const selection=UI.inspectorView.element.window().getSelection();let queryCandidate='';if(selection.rangeCount)
queryCandidate=selection.toString().replace(/\r?\n.*/,'');Network.SearchNetworkView.openSearch(queryCandidate);return true;}
return false;}};Network.NetworkPanel.RequestLocationRevealer=class{async reveal(match){const location=(match);const view=await Network.NetworkPanel._instance().selectRequest(location.request);if(!view)
return;if(location.searchMatch)
await view.revealResponseBody(location.searchMatch.lineNumber);if(location.requestHeader)
view.revealRequestHeader(location.requestHeader.name);if(location.responseHeader)
view.revealResponseHeader(location.responseHeader.name);}};Network.SearchNetworkView=class extends Search.SearchView{constructor(){super('network');}
static async openSearch(query,searchImmediately){await UI.viewManager.showView('network.search-network-tab');const searchView=(self.runtime.sharedInstance(Network.SearchNetworkView));searchView.toggle(query,!!searchImmediately);return searchView;}
createScope(){return new Network.NetworkSearchScope();}};;Runtime.cachedResources["network/blockedURLsPane.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.list {\n    border: none !important;\n    border-top: var(--divider-border) !important;\n}\n\n.blocking-disabled {\n    pointer-events: none;\n    opacity: 0.8;\n}\n\n.editor-container {\n    padding: 0 4px;\n}\n\n.no-blocked-urls, .blocked-urls {\n    overflow-x: hidden;\n    overflow-y: auto;\n}\n\n.no-blocked-urls {\n    display: flex;\n    justify-content: center;\n    padding: 10px;\n}\n\n.no-blocked-urls > span {\n    white-space: pre;\n}\n\n.blocked-url {\n    display: flex;\n    flex-direction: row;\n    align-items: center;\n    flex: auto;\n}\n\n.blocked-url-count {\n    flex: none;\n    padding-right: 9px;\n}\n\n.blocked-url-checkbox {\n    margin-left: 8px;\n    flex: none;\n}\n\n.blocked-url-label {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    flex: auto;\n    padding: 0 3px;\n}\n\n.blocked-url-edit-row {\n    flex: none;\n    display: flex;\n    flex-direction: row;\n    margin: 7px 5px 0 5px;\n    align-items: center;\n}\n\n.blocked-url-edit-value {\n    -webkit-user-select: none;\n    flex: 1 1 0px;\n}\n\n.blocked-url-edit-row input {\n    width: 100%;\n    text-align: inherit;\n    height: 22px;\n}\n\n/*# sourceURL=network/blockedURLsPane.css */";Runtime.cachedResources["network/eventSourceMessagesView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.event-source-messages-view .data-grid {\n    flex: auto;\n    border: none;\n}\n\n/*# sourceURL=network/eventSourceMessagesView.css */";Runtime.cachedResources["network/networkConfigView.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.network-config {\n    padding: 12px;\n    display: block;\n}\n\n.network-config-group {\n    display: flex;\n    margin-bottom: 10px;\n    flex-wrap: wrap;\n    flex: 0 0 auto;\n    min-height: 30px;\n}\n\n.network-config-title {\n    margin-right: 16px;\n    width: 130px;\n}\n\n.network-config-fields {\n    flex: 2 0 200px;\n}\n\n.panel-section-separator {\n    height: 1px;\n    margin-bottom: 10px;\n    background: #f0f0f0;\n}\n\n/* Disable cache */\n\n.network-config-disable-cache {\n    line-height: 28px;\n    border-top: none;\n    padding-top: 0;\n}\n\n/* Network throttling */\n\n.network-config-throttling .chrome-select {\n    width: 100%;\n    max-width: 250px;\n}\n\n.network-config-throttling > .network-config-title {\n    line-height: 24px;\n}\n\n/* User agent */\n\n.network-config-ua > .network-config-title {\n    line-height: 20px;\n}\n\n.network-config-ua label[is=\"dt-radio\"].checked > * {\n    display: none\n}\n\n.network-config-ua input:not(.dt-radio-button) {\n    display: block;\n    width: calc(100% - 20px);\n    max-width: 250px;\n}\n\n.network-config-ua input[readonly] {\n    background-color: rgb(235, 235, 228);\n}\n\n.network-config-ua input[type=text], .network-config-ua .chrome-select {\n    margin-top: 8px;\n}\n\n.network-config-ua .chrome-select {\n    width: calc(100% - 20px);\n    max-width: 250px;\n}\n\n.network-config-ua label[is=\"dt-radio\"] {\n    display: block;\n}\n\n.network-config-ua-auto, .network-config-ua-custom {\n    opacity: 0.5;\n}\n\n.network-config-ua-auto.checked, .network-config-ua-custom.checked {\n    opacity: 1;\n}\n\n/*# sourceURL=network/networkConfigView.css */";Runtime.cachedResources["network/networkLogView.css"]="/*\n * Copyright (C) 2013 Google Inc. All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are\n * met:\n *\n *     * Redistributions of source code must retain the above copyright\n * notice, this list of conditions and the following disclaimer.\n *     * Redistributions in binary form must reproduce the above\n * copyright notice, this list of conditions and the following disclaimer\n * in the documentation and/or other materials provided with the\n * distribution.\n *     * Neither the name of Google Inc. nor the names of its\n * contributors may be used to endorse or promote products derived from\n * this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n * \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.network-log-grid.data-grid {\n    border: none;\n    flex: auto;\n}\n\n.network-summary-bar {\n    flex: 0 0 27px;\n    line-height: 27px;\n    padding-left: 5px;\n    background-color: #eee;\n    border-top: 1px solid #ccc;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n}\n\n.network-summary-bar label[is=dt-icon-label] {\n    margin-right: 6px;\n}\n\n.network-summary-bar > * {\n    flex: none;\n}\n\n.network-log-grid.data-grid table.data {\n    background: transparent;\n}\n\n.network-log-grid.data-grid td {\n    height: 41px;\n    border-left: 1px solid #e1e1e1;\n    vertical-align: middle;\n}\n\n.network-log-grid.data-grid .corner {\n    display: none;\n}\n\n.network-log-grid.data-grid.small td {\n    height: 21px;\n}\n\n.network-waterfall-header, .network-log-grid.data-grid th {\n    border-bottom: 1px solid rgb(205, 205, 205);\n    border-left: 1px solid rgb(205, 205, 205);\n}\n\n.network-waterfall-header, .network-log-grid.data-grid .header-container {\n    height: 31px;\n    background-color: var(--toolbar-bg-color);\n}\n\n.network-log-grid.data-grid .data-container {\n    top: 31px;\n}\n\n.network-waterfall-header.small, .network-log-grid.data-grid.small .header-container {\n    height: 27px;\n}\n\n.network-log-grid.data-grid.small .data-container {\n    top: 27px;\n}\n\n.network-log-grid.data-grid select {\n    -webkit-appearance: none;\n    border: none;\n    width: 100%;\n    color: inherit;\n}\n\n.network-log-grid.data-grid .name-column {\n    cursor: pointer;\n}\n\n.network-log-grid.data-grid .waterfall-column {\n    padding: 1px 0;\n}\n\n.network-log-grid.data-grid .waterfall-column .sort-order-icon-container {\n    right: 15px;\n    pointer-events: none;\n}\n\n.network-log-grid.data-grid th.sortable:active {\n    background-image: none !important;\n}\n\n.network-cell-subtitle {\n    font-weight: normal;\n    color: gray;\n}\n\n.network-badge {\n    margin-right: 4px;\n}\n\n.network-error-row,\n.network-error-row .network-cell-subtitle {\n    color: rgb(230, 0, 0);\n}\n\n.initiator-column .devtools-link {\n    color: inherit;\n}\n\n.network-log-grid.data-grid tr.selected,\n.network-log-grid.data-grid tr.selected .network-cell-subtitle,\n.network-log-grid.data-grid tr.selected .network-dim-cell {\n    color: inherit !important;\n}\n\n.network-log-grid.data-grid:focus tr.selected,\n.network-log-grid.data-grid:focus tr.selected .network-cell-subtitle,\n.network-log-grid.data-grid:focus tr.selected .network-dim-cell {\n    color: var(--selection-fg-color) !important;\n}\n\n.network-log-grid tr.highlighted-row {\n    -webkit-animation: network-row-highlight-fadeout 2s 0s;\n}\n\n@-webkit-keyframes network-row-highlight-fadeout {\n    from {background-color: rgba(255, 255, 120, 1); }\n    to { background-color: rgba(255, 255, 120, 0); }\n}\n\n.network-header-subtitle {\n    color: gray;\n}\n\n.network-log-grid.data-grid.small .network-cell-subtitle,\n.network-log-grid.data-grid.small .network-header-subtitle {\n    display: none;\n}\n\n/* Resource preview icons */\n\n.network-log-grid.data-grid .icon {\n    content: url(Images/resourcePlainIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon {\n    content: url(Images/resourcePlainIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.script {\n    content: url(Images/resourceJSIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.script {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.document {\n    content: url(Images/resourceDocumentIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.document {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.stylesheet {\n    content: url(Images/resourceCSSIcon.png);\n}\n\n.network-log-grid.data-grid.small .icon.stylesheet {\n    content: url(Images/resourceDocumentIconSmall.png);\n}\n\n.network-log-grid.data-grid .icon.media {\n    content: url(Images/resourcePlainIcon.png); /* FIXME: media icon */\n}\n\n.network-log-grid.data-grid.small .icon.media {\n    content: url(Images/resourcePlainIconSmall.png); /* FIXME: media icon */\n}\n.network-log-grid.data-grid .icon.texttrack {\n    content: url(Images/resourcePlainIcon.png); /* FIXME: vtt icon */\n}\n\n.network-log-grid.data-grid.small .icon.texttrack {\n    content: url(Images/resourcePlainIconSmall.png); /* FIXME: vtt icon */\n}\n\n.network-log-grid.data-grid .icon.image {\n    position: relative;\n    background-image: url(Images/resourcePlainIcon.png);\n    background-repeat: no-repeat;\n    content: \"\";\n}\n\n.network-log-grid.data-grid.small .icon.image {\n    background-image: url(Images/resourcePlainIconSmall.png);\n    content: \"\";\n}\n\n.network-log-grid.data-grid .icon {\n    float: left;\n    width: 32px;\n    height: 32px;\n    margin-top: 1px;\n    margin-right: 3px;\n}\n\n.network-log-grid.data-grid.small .icon {\n    width: 16px;\n    height: 16px;\n}\n\n.network-log-grid.data-grid .image-network-icon-preview {\n    position: absolute;\n    margin: auto;\n    top: 3px;\n    bottom: 4px;\n    left: 5px;\n    right: 5px;\n    max-width: 18px;\n    max-height: 21px;\n    min-width: 1px;\n    min-height: 1px;\n}\n\n.network-log-grid.data-grid.small .image-network-icon-preview {\n    top: 2px;\n    bottom: 1px;\n    left: 3px;\n    right: 3px;\n    max-width: 8px;\n    max-height: 11px;\n}\n\n.network-dim-cell {\n    color: grey;\n}\n\n.network-summary-bar .summary-red {\n    color: red;\n}\n\n.network-frame-divider {\n    width: 2px;\n    background-color: #FCCC49;\n    z-index: 10;\n    visibility: hidden;\n}\n\n#network-container:not(.brief-mode) .data-container {\n    overflow: hidden;\n}\n\n.network-summary-bar .summary-blue {\n    color: blue;\n}\n\n.-theme-with-dark-background .network-summary-bar .summary-blue {\n    color: #03A9F4;\n}\n\n.network-log-grid.data-grid .resources-dividers {\n    z-index: 0;\n}\n\n.network-log-grid.data-grid .resources-dividers-label-bar {\n    background-color: transparent;\n    border: none;\n    height: 30px;\n    pointer-events: none;\n}\n\n#network-container {\n    overflow: hidden;\n}\n\n.network-status-pane {\n    color: #777;\n    background-color: white;\n    z-index: 500;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    text-align: center;\n    padding: 0 20px;\n    overflow: auto;\n}\n\n.network-status-pane > .recording-hint {\n    font-size: 14px;\n    text-align: center;\n    line-height: 28px;\n}\n\n.network-waterfall-header {\n    position: absolute;\n    border-left: 0px;\n    width: 100%;\n    display: table;\n    z-index: 200;\n}\n\n.network-waterfall-header:hover {\n    background-color: hsla(0, 0%, 10%, 0.1);\n}\n\n.network-waterfall-header div {\n    display: table-cell;\n    line-height: 14px;\n    margin: auto 0px;\n    vertical-align: middle;\n    text-align: left;\n    font-weight: normal;\n    padding: 0px 4px;\n}\n\n.network-waterfall-header .sort-order-icon-container {\n    position: absolute;\n    top: 1px;\n    right: 0;\n    bottom: 1px;\n    display: flex;\n    align-items: center;\n}\n\n.network-waterfall-header .sort-order-icon {\n    align-items: center;\n    margin-right: 4px;\n    margin-bottom: -2px;\n}\n\n.network-frame-group-icon {\n    display: inline-block;\n    margin: -8px -2px;\n}\n\n.network-frame-group-badge {\n    margin-right: 4px;\n}\n\n/*# sourceURL=network/networkLogView.css */";Runtime.cachedResources["network/networkManageCustomHeadersView.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n.custom-headers-list {\n    height: 272px;\n    width: 250px;\n}\n\n.custom-headers-wrapper{\n    margin: 10px;\n}\n\n.header {\n    padding: 0 0 6px;\n    font-size: 18px;\n    font-weight: normal;\n    flex: none;\n}\n\n.custom-headers-header {\n    padding:2px;\n}\n\n.custom-headers-list-item {\n    padding-left: 5px;\n}\n\n.editor-container {\n    padding: 5px 0px 0px 5px;\n}\n\n.add-button {\n    width: 150px;\n    margin: auto;\n    margin-top: 5px;\n}\n\n/*# sourceURL=network/networkManageCustomHeadersView.css */";Runtime.cachedResources["network/networkPanel.css"]="/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n.panel.network .toolbar {\n    background-color: var(--toolbar-bg-color);\n    border-bottom: var(--divider-border);\n}\n\n.network-details-view {\n    background: rgb(203, 203, 203);\n}\n\n.network-details-view-tall-header {\n    margin-top: 4px;\n}\n\n.network-item-view {\n    display: flex;\n    background: white;\n}\n\n.network-item-preview-toolbar {\n    border-top: 1px solid #ccc;\n    background-color: #eee;\n}\n\n.resource-timing-view {\n    display: block;\n    margin: 6px;\n    color: rgb(30%, 30%, 30%);\n}\n\n.resource-timing-table {\n    width: 100% !important;\n}\n\n#network-overview-panel {\n    flex: none;\n    position: relative;\n}\n\n#network-overview-container {\n    overflow: hidden;\n    flex: auto;\n    display: flex;\n    flex-direction: column;\n    position: relative;\n    border-bottom: 1px solid #CDCDCD;\n}\n\n#network-overview-container canvas {\n    width: 100%;\n    height: 100%;\n}\n\n#network-overview-grid .resources-dividers-label-bar {\n    pointer-events: auto;\n}\n\n.network .network-overview {\n    flex: 0 0 60px;\n}\n\n.network-overview .overview-grid-window,\n.network-overview .overview-grid-dividers-background {\n    height: 100%;\n}\n\n.network-overview .resources-dividers-label-bar {\n    background-color: rgba(255, 255, 255, 0.95);\n}\n\n.network-overview .resources-dividers-label-bar .resources-divider {\n    background-color: transparent;\n}\n\n.network-overview .resources-dividers {\n    z-index: 250;\n}\n\n.request-view.html iframe {\n    width: 100%;\n    height: 100%;\n    position: absolute;\n}\n\n.network-film-strip {\n    border-bottom: solid 1px #cdcdcd;\n    flex: none !important;\n}\n\n.network-film-strip-placeholder {\n    flex-shrink: 0;\n}\n\n.network-blocked-urls {\n    border-top: var(--divider-border);\n    flex: 104px 0 0;\n}\n\n.open-search-view {\n    align-items: center;\n    background-color: hsl(50, 100%, 88%);\n    border-bottom: var(--divider-border);\n    cursor: pointer;\n    flex-grow: 0;\n    padding: 4px;\n}\n\n.open-search-view > * {\n    margin: 0 4px;\n}\n\n.open-search-view .search-suggestion {\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n}\n\n.network-tabbed-pane {\n    background-color: var(--toolbar-bg-color);\n}\n\n/*# sourceURL=network/networkPanel.css */";Runtime.cachedResources["network/networkTimingTable.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.network-timing-table {\n    width: 380px;\n    border-spacing: 0;\n    padding-left: 10px;\n    padding-right: 10px;\n    line-height: initial;\n}\n\n.network-timing-start {\n    border-top: 5px solid transparent;\n}\n.network-timing-table-header td, .network-timing-footer td {\n    border-top: 10px solid transparent;\n}\n\n.network-timing-table-header td {\n    color: #bbb;\n}\n\n.network-timing-table-header td:last-child {\n    text-align: right;\n}\n\n.network-timing-table col.labels {\n    width: 156px;\n}\n\n.network-timing-table col.duration {\n    width: 80px;\n}\n\n.network-timing-table td {\n    padding: 4px 0;\n}\n\n.network-timing-table td.caution {\n    font-weight: bold;\n    color: rgb(255, 128, 0);\n    padding: 2px 0;\n}\n\n.network-timing-table hr.break {\n    border: 0;\n    height: 1px;\n    background-image: linear-gradient(to right, #eee, #bbb, #eee);\n}\n\n.network-timing-footer td:last-child {\n    font-weight: bold;\n    text-align: right;\n}\n\n.network-timing-row {\n    position: relative;\n    height: 15px;\n}\n\n.network-timing-bar {\n    position: absolute;\n    min-width: 1px;\n    top: 0;\n    bottom: 0;\n}\n\n.network-timing-bar-title {\n    color: #222;\n    white-space: nowrap;\n    text-align: right;\n}\n\n.network-timing-bar.queueing,\n.network-timing-bar.total {\n    border: 1px solid rgba(0, 0, 0, 0.1);\n}\n\n.network-timing-bar.blocking, -theme-preserve {\n    background-color: #AAAAAA;\n}\n\n.network-timing-bar.proxy, -theme-preserve {\n    background-color: #A1887F;\n}\n\n.network-timing-bar.dns, -theme-preserve {\n    background-color: #009688;\n}\n\n.network-timing-bar.connecting,\n.network-timing-bar.serviceworker,\n.network-timing-bar.serviceworker-preparation, -theme-preserve {\n    background-color: #FF9800;\n}\n\n.network-timing-bar.ssl, -theme-preserve {\n    background-color: #9C27B0;\n}\n\n.network-timing-bar.sending, -theme-preserve {\n    background-color: #B0BEC5;\n}\n\n.network-timing-bar.waiting, -theme-preserve {\n    background-color: #00C853;\n}\n\n.network-timing-bar.receiving, -theme-preserve,\n.network-timing-bar.receiving-push, -theme-preserve {\n    background-color: #03A9F4;\n}\n\n.network-timing-bar.push, -theme-preserve {\n    background-color: #8CDBff;\n}\n\n.network-timing-bar.server-timing, -theme-preserve {\n    background-color: #ddd;\n}\n\n.network-timing-table td.network-timing-metric {\n    white-space: nowrap;\n    max-width: 150px;\n    overflow-x: hidden;\n    text-overflow: ellipsis;\n}\n\n.network-timing-bar.proxy,\n.network-timing-bar.dns,\n.network-timing-bar.ssl,\n.network-timing-bar.connecting,\n.network-timing-bar.blocking {\n    height: 10px;\n    margin: auto;\n}\n\n/*# sourceURL=network/networkTimingTable.css */";Runtime.cachedResources["network/networkWaterfallColumn.css"]="/* Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n.network-waterfall-v-scroll {\n    position: absolute;\n    top: 0;\n    right: 0;\n    bottom: 0;\n    overflow-x: hidden;\n    margin-top: 31px;\n    z-index: 200;\n}\n\n.network-waterfall-v-scroll.small {\n    margin-top: 27px;\n}\n\n.network-waterfall-v-scroll-content {\n    width: 15px;\n    pointer-events: none;\n}\n\n/*# sourceURL=network/networkWaterfallColumn.css */";Runtime.cachedResources["network/requestCookiesView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.request-cookies-view {\n    display: flex;\n    overflow: auto;\n    margin: 12px;\n    height: 100%;\n}\n\n.request-cookies-view .data-grid {\n    flex: auto;\n    height: 100%;\n}\n\n.request-cookies-view .data-grid .row-group {\n    font-weight: bold;\n}\n\n/*# sourceURL=network/requestCookiesView.css */";Runtime.cachedResources["network/requestHeadersTree.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline {\n    padding-left: 0;\n}\n\n.tree-outline > ol {\n    padding-bottom: 5px;\n    border-bottom: solid 1px #e0e0e0;\n}\n\n.tree-outline > .parent {\n    -webkit-user-select: none;\n    font-weight: bold;\n    color: #616161;\n    margin-top: -1px;\n    height: 20px;\n    display: flex;\n    align-items: center;\n    height: 26px;\n}\n\n.tree-outline li {\n    display: block;\n    padding-left: 5px;\n    line-height: 20px;\n}\n\n.tree-outline li:not(.parent) {\n    margin-left: 10px;\n}\n\n.tree-outline li:not(.parent)::before {\n    display: none;\n}\n\n.tree-outline .caution {\n    margin-left: 4px;\n    display: inline-block;\n    font-weight: bold;\n}\n\n.tree-outline li.expanded .header-count {\n    display: none;\n}\n\n.tree-outline li .header-toggle {\n    display: none;\n}\n\n.tree-outline li .status-from-cache {\n    color: gray;\n}\n\n.tree-outline li.expanded .header-toggle {\n    display: inline;\n    margin-left: 30px;\n    font-weight: normal;\n    color: rgb(45%, 45%, 45%);\n}\n\n.tree-outline li .header-toggle:hover {\n    color: rgb(20%, 20%, 45%);\n    cursor: pointer;\n}\n\n.tree-outline .header-name {\n    color: rgb(33%, 33%, 33%);\n    display: inline-block;\n    margin-right: 0.25em;\n    font-weight: bold;\n    vertical-align: top;\n    white-space: pre-wrap;\n}\n\n.tree-outline .header-separator {\n    user-select: none;\n}\n\n.tree-outline .header-value {\n    display: inline;\n    margin-right: 1em;\n    white-space: pre-wrap;\n    word-break: break-all;\n    margin-top: 1px;\n}\n\n.tree-outline .empty-request-header {\n    color: rgba(33%, 33%, 33%, 0.5);\n}\n\n.request-headers-show-more-button {\n    border: none;\n    border-radius: 3px;\n    display: inline-block;\n    font-size: 12px;\n    font-family: sans-serif;\n    cursor: pointer;\n    margin: 0 4px;\n    padding: 2px 4px;\n}\n\n.header-highlight {\n    background-color: #FFFF78\n}\n\n/*# sourceURL=network/requestHeadersTree.css */";Runtime.cachedResources["network/requestHeadersView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.request-headers-view {\n    -webkit-user-select: text;\n    overflow: auto;\n}\n\n.resource-status-image {\n    margin-top: -2px;\n    margin-right: 3px;\n}\n\n.request-headers-view .filter-input {\n    outline: none !important;\n    border: none;\n    border-bottom: solid 1px #ccc;\n    flex: 0 0 19px;\n    padding: 0 4px;\n}\n\n.request-headers-tree {\n    flex-grow: 1;\n    overflow-y: auto;\n    margin: 0;\n}\n\n.header-decode-error {\n    color: red;\n}\n\n.-theme-with-dark-background .header-decode-error {\n    color: hsl(0, 100%, 65%);\n}\n\n/*# sourceURL=network/requestHeadersView.css */";Runtime.cachedResources["network/requestHTMLView.css"]="/*\n * Copyright (c) 2018 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n.html-preview-frame {\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.5);\n  flex-grow: 1;\n  margin: 20px;\n}\n\n/*# sourceURL=network/requestHTMLView.css */";Runtime.cachedResources["network/signedExchangeInfoTree.css"]="/*\n * Copyright 2018 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline {\n    padding-left: 0;\n}\n\n.tree-outline > ol {\n    padding-bottom: 5px;\n    border-bottom: solid 1px #e0e0e0;\n}\n\n.tree-outline > .parent {\n    -webkit-user-select: none;\n    font-weight: bold;\n    color: #616161;\n    margin-top: -1px;\n    height: 20px;\n    display: flex;\n    align-items: center;\n    height: 26px;\n}\n\n.tree-outline li {\n    display: block;\n    padding-left: 5px;\n    line-height: 20px;\n}\n\n.tree-outline li:not(.parent) {\n    margin-left: 10px;\n}\n\n.tree-outline li:not(.parent)::before {\n    display: none;\n}\n\n.tree-outline .header-name {\n    color: rgb(33%, 33%, 33%);\n    display: inline-block;\n    margin-right: 0.25em;\n    font-weight: bold;\n    vertical-align: top;\n    white-space: pre-wrap;\n}\n\n.tree-outline .header-separator {\n    user-select: none;\n}\n\n.tree-outline .header-value {\n    display: inline;\n    margin-right: 1em;\n    white-space: pre-wrap;\n    word-break: break-all;\n    margin-top: 1px;\n}\n\n.tree-outline .header-toggle {\n    display: inline;\n    margin-left: 30px;\n    font-weight: normal;\n    color: rgb(45%, 45%, 45%);\n}\n\n.tree-outline .header-toggle:hover {\n    color: rgb(20%, 20%, 45%);\n    cursor: pointer;\n}\n\n.tree-outline .error-log {\n    color: red;\n    display: inline-block;\n    margin-right: 0.25em;\n    margin-left: 0.25em;\n    font-weight: bold;\n    vertical-align: top;\n    white-space: pre-wrap;\n}\n\n.tree-outline .hex-data {\n    display: block;\n    word-break: break-word;\n    margin-left: 20px;\n}\n\n.tree-outline .error-field {\n    color: red;\n}\n\n/*# sourceURL=network/signedExchangeInfoTree.css */";Runtime.cachedResources["network/signedExchangeInfoView.css"]="/*\n * Copyright (c) 2018 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.signed-exchange-info-view {\n    -webkit-user-select: text;\n    overflow: auto;\n}\n\n.signed-exchange-info-tree {\n    flex-grow: 1;\n    overflow-y: auto;\n    margin: 0;\n}\n\n/*# sourceURL=network/signedExchangeInfoView.css */";Runtime.cachedResources["network/webSocketFrameView.css"]="/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.websocket-frame-view {\n    -webkit-user-select: text;\n}\n\n.websocket-frame-view .data-grid {\n    flex: auto;\n    border: none;\n}\n\n.websocket-frame-view .data-grid .data {\n    background-image: none;\n}\n\n.websocket-frame-view-td {\n    border-bottom: 1px solid #ccc;\n}\n\n.websocket-frame-view .data-grid tr.selected {\n    background-color: #def;\n}\n\n.websocket-frame-view .data-grid td,\n.websocket-frame-view .data-grid th {\n    border-left-color: #ccc;\n}\n\n.websocket-frame-view-row-send td:first-child::before {\n    content: \"\\2B06 \";\n    color: #080;\n}\n\n.websocket-frame-view-row-receive td:first-child::before {\n    content: \"\\2B07 \";\n    color: #E65100;\n}\n\n.data-grid:focus .websocket-frame-view-row-send.selected td:first-child::before,\n.data-grid:focus .websocket-frame-view-row-receive.selected td:first-child::before {\n    color: white;\n}\n\n.websocket-frame-view-row-send {\n    background-color: rgb(226, 247, 218);\n}\n\n.websocket-frame-view-row-opcode {\n    background-color: rgb(255, 255, 232);\n    color: rgb(170, 111, 71);\n}\n\n.websocket-frame-view-row-error {\n    background-color: rgb(255, 237, 237);\n    color: rgb(182, 0, 0);\n}\n\n.websocket-frame-view .toolbar {\n    border-bottom: var(--divider-border);\n}\n\n/*# sourceURL=network/webSocketFrameView.css */";