/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public abstract class FieldOffsetStrategy {
    protected final String field;
    protected final PhraseHelper phraseHelper;
    protected final BytesRef[] terms;
    protected final CharacterRunAutomaton[] automata;

    public FieldOffsetStrategy(String field, BytesRef[] queryTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata) {
        this.field = field;
        this.terms = queryTerms;
        this.phraseHelper = phraseHelper;
        this.automata = automata;
    }

    public String getField() {
        return this.field;
    }

    public abstract UnifiedHighlighter.OffsetSource getOffsetSource();

    public abstract OffsetsEnum getOffsetsEnum(IndexReader var1, int var2, String var3) throws IOException;

    protected OffsetsEnum createOffsetsEnumFromReader(LeafReader leafReader, int doc) throws IOException {
        BytesRef[] insensitiveTerms;
        Terms termsIndex = leafReader.terms(this.field);
        if (termsIndex == null) {
            return OffsetsEnum.EMPTY;
        }
        ArrayList<OffsetsEnum> offsetsEnums = new ArrayList<OffsetsEnum>(this.terms.length + this.automata.length);
        if (this.phraseHelper.hasPositionSensitivity()) {
            insensitiveTerms = this.phraseHelper.getAllPositionInsensitiveTerms();
            assert (insensitiveTerms.length <= this.terms.length) : "insensitive terms should be smaller set of all terms";
        } else {
            insensitiveTerms = this.terms;
        }
        if (insensitiveTerms.length > 0) {
            this.createOffsetsEnumsForTerms(insensitiveTerms, termsIndex, doc, offsetsEnums);
        }
        if (this.phraseHelper.hasPositionSensitivity()) {
            this.phraseHelper.createOffsetsEnumsForSpans(leafReader, doc, offsetsEnums);
        }
        if (this.automata.length > 0) {
            this.createOffsetsEnumsForAutomata(termsIndex, doc, offsetsEnums);
        }
        return new OffsetsEnum.MultiOffsetsEnum(offsetsEnums);
    }

    protected void createOffsetsEnumsForTerms(BytesRef[] sourceTerms, Terms termsIndex, int doc, List<OffsetsEnum> results) throws IOException {
        TermsEnum termsEnum = termsIndex.iterator();
        for (BytesRef term : sourceTerms) {
            if (!termsEnum.seekExact(term)) continue;
            PostingsEnum postingsEnum = termsEnum.postings(null, 56);
            if (postingsEnum == null) {
                throw new IllegalArgumentException("field '" + this.field + "' was indexed without offsets, cannot highlight");
            }
            if (doc != postingsEnum.advance(doc)) continue;
            results.add(new OffsetsEnum.OfPostings(term, postingsEnum));
        }
    }

    protected void createOffsetsEnumsForAutomata(Terms termsIndex, int doc, List<OffsetsEnum> results) throws IOException {
        CharacterRunAutomaton automaton;
        int i;
        BytesRef term;
        ArrayList automataPostings = new ArrayList(this.automata.length);
        for (int i2 = 0; i2 < this.automata.length; ++i2) {
            automataPostings.add(new ArrayList());
        }
        TermsEnum termsEnum = termsIndex.iterator();
        CharsRefBuilder refBuilder = new CharsRefBuilder();
        while ((term = termsEnum.next()) != null) {
            for (i = 0; i < this.automata.length; ++i) {
                PostingsEnum postings;
                automaton = this.automata[i];
                refBuilder.copyUTF8Bytes(term);
                if (!automaton.run(refBuilder.chars(), 0, refBuilder.length()) || doc != (postings = termsEnum.postings(null, 56)).advance(doc)) continue;
                ((List)automataPostings.get(i)).add(postings);
            }
        }
        for (i = 0; i < this.automata.length; ++i) {
            automaton = this.automata[i];
            List postingsEnums = (List)automataPostings.get(i);
            if (postingsEnums.isEmpty()) continue;
            BytesRef wildcardTerm = new BytesRef((CharSequence)automaton.toString());
            int sumFreq = 0;
            for (PostingsEnum postingsEnum : postingsEnums) {
                sumFreq += postingsEnum.freq();
            }
            for (PostingsEnum postingsEnum : postingsEnums) {
                results.add(new OffsetsEnum.OfPostings(wildcardTerm, sumFreq, postingsEnum));
            }
        }
    }
}

