/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import io.reactivex.subscribers.DisposableSubscriber;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindowBoundarySelector<T, B, V>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final Publisher<B> open;
    final Function<? super B, ? extends Publisher<V>> close;
    final int bufferSize;

    public FlowableWindowBoundarySelector(Flowable<T> source, Publisher<B> open, Function<? super B, ? extends Publisher<V>> close, int bufferSize) {
        super(source);
        this.open = open;
        this.close = close;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Flowable<T>> s) {
        this.source.subscribe(new WindowBoundaryMainSubscriber(new SerializedSubscriber<Flowable<T>>(s), this.open, this.close, this.bufferSize));
    }

    static final class OperatorWindowBoundaryCloseSubscriber<T, V>
    extends DisposableSubscriber<V> {
        final WindowBoundaryMainSubscriber<T, ?, V> parent;
        final UnicastProcessor<T> w;
        boolean done;

        OperatorWindowBoundaryCloseSubscriber(WindowBoundaryMainSubscriber<T, ?, V> parent, UnicastProcessor<T> w) {
            this.parent = parent;
            this.w = w;
        }

        public void onNext(V t) {
            this.cancel();
            this.onComplete();
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.error(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.close(this);
        }
    }

    static final class OperatorWindowBoundaryOpenSubscriber<T, B>
    extends DisposableSubscriber<B> {
        final WindowBoundaryMainSubscriber<T, B, ?> parent;

        OperatorWindowBoundaryOpenSubscriber(WindowBoundaryMainSubscriber<T, B, ?> parent) {
            this.parent = parent;
        }

        public void onNext(B t) {
            this.parent.open(t);
        }

        public void onError(Throwable t) {
            this.parent.error(t);
        }

        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class WindowOperation<T, B> {
        final UnicastProcessor<T> w;
        final B open;

        WindowOperation(UnicastProcessor<T> w, B open) {
            this.w = w;
            this.open = open;
        }
    }

    static final class WindowBoundaryMainSubscriber<T, B, V>
    extends QueueDrainSubscriber<T, Object, Flowable<T>>
    implements Subscription {
        final Publisher<B> open;
        final Function<? super B, ? extends Publisher<V>> close;
        final int bufferSize;
        final CompositeDisposable resources;
        Subscription s;
        final AtomicReference<Disposable> boundary = new AtomicReference();
        final List<UnicastProcessor<T>> ws;
        final AtomicLong windows = new AtomicLong();

        WindowBoundaryMainSubscriber(Subscriber<? super Flowable<T>> actual, Publisher<B> open, Function<? super B, ? extends Publisher<V>> close, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.open = open;
            this.close = close;
            this.bufferSize = bufferSize;
            this.resources = new CompositeDisposable();
            this.ws = new ArrayList<UnicastProcessor<T>>();
            this.windows.lazySet(1L);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                if (this.cancelled) {
                    return;
                }
                OperatorWindowBoundaryOpenSubscriber os = new OperatorWindowBoundaryOpenSubscriber(this);
                if (this.boundary.compareAndSet(null, os)) {
                    this.windows.getAndIncrement();
                    s.request(Long.MAX_VALUE);
                    this.open.subscribe(os);
                }
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.fastEnter()) {
                for (UnicastProcessor<T> w : this.ws) {
                    w.onNext(t);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            if (this.windows.decrementAndGet() == 0L) {
                this.resources.dispose();
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            if (this.windows.decrementAndGet() == 0L) {
                this.resources.dispose();
            }
            this.actual.onComplete();
        }

        void error(Throwable t) {
            this.s.cancel();
            this.resources.dispose();
            DisposableHelper.dispose(this.boundary);
            this.actual.onError(t);
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            this.cancelled = true;
        }

        void dispose() {
            this.resources.dispose();
            DisposableHelper.dispose(this.boundary);
        }

        void drainLoop() {
            SimplePlainQueue q = this.queue;
            Subscriber a = this.actual;
            List<UnicastProcessor<T>> ws = this.ws;
            int missed = 1;
            block2: while (true) {
                boolean empty;
                boolean d = this.done;
                Object o = q.poll();
                boolean bl = empty = o == null;
                if (d && empty) {
                    this.dispose();
                    Throwable e = this.error;
                    if (e != null) {
                        for (UnicastProcessor<T> w : ws) {
                            w.onError(e);
                        }
                    } else {
                        for (UnicastProcessor<T> w : ws) {
                            w.onComplete();
                        }
                    }
                    ws.clear();
                    return;
                }
                if (!empty) {
                    UnicastProcessor w;
                    if (o instanceof WindowOperation) {
                        Publisher<V> p;
                        WindowOperation wo = (WindowOperation)o;
                        w = wo.w;
                        if (w != null) {
                            if (!ws.remove(wo.w)) continue;
                            wo.w.onComplete();
                            if (this.windows.decrementAndGet() != 0L) continue;
                            this.dispose();
                            return;
                        }
                        if (this.cancelled) continue;
                        w = UnicastProcessor.create(this.bufferSize);
                        long r = this.requested();
                        if (r != 0L) {
                            ws.add(w);
                            a.onNext(w);
                            if (r != Long.MAX_VALUE) {
                                this.produced(1L);
                            }
                        } else {
                            this.cancelled = true;
                            a.onError((Throwable)new MissingBackpressureException("Could not deliver new window due to lack of requests"));
                            continue;
                        }
                        try {
                            p = ObjectHelper.requireNonNull(this.close.apply(wo.open), "The publisher supplied is null");
                        }
                        catch (Throwable e) {
                            this.cancelled = true;
                            a.onError(e);
                            continue;
                        }
                        OperatorWindowBoundaryCloseSubscriber cl = new OperatorWindowBoundaryCloseSubscriber(this, w);
                        if (!this.resources.add(cl)) continue;
                        this.windows.getAndIncrement();
                        p.subscribe(cl);
                        continue;
                    }
                    Iterator<UnicastProcessor<T>> iterator = ws.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        w = iterator.next();
                        w.onNext(NotificationLite.getValue(o));
                    }
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        @Override
        public boolean accept(Subscriber<? super Flowable<T>> a, Object v) {
            return false;
        }

        void open(B b) {
            this.queue.offer(new WindowOperation(null, b));
            if (this.enter()) {
                this.drainLoop();
            }
        }

        void close(OperatorWindowBoundaryCloseSubscriber<T, V> w) {
            this.resources.delete(w);
            this.queue.offer(new WindowOperation(w.w, null));
            if (this.enter()) {
                this.drainLoop();
            }
        }
    }
}

