/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ResourceFile;
import jadx.api.ResourceFileContent;
import jadx.api.ResourceType;
import jadx.core.codegen.CodeWriter;
import jadx.core.xmlgen.ResContainer;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.utils.NLS;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class JResource
extends JLoadableNode
implements Comparable<JResource> {
    private static final long serialVersionUID = -201018424302612434L;
    private static final ImageIcon ROOT_ICON = Utils.openIcon("cf_obj");
    private static final ImageIcon FOLDER_ICON = Utils.openIcon("folder");
    private static final ImageIcon FILE_ICON = Utils.openIcon("file_obj");
    private static final ImageIcon MANIFEST_ICON = Utils.openIcon("template_obj");
    private static final ImageIcon JAVA_ICON = Utils.openIcon("java_ovr");
    private static final ImageIcon ERROR_ICON = Utils.openIcon("error_co");
    private final transient String name;
    private final transient String shortName;
    private final transient List<JResource> files = new ArrayList<JResource>(1);
    private final transient JResType type;
    private final transient ResourceFile resFile;
    private transient boolean loaded;
    private transient String content;
    private transient Map<Integer, Integer> lineMapping;

    public JResource(ResourceFile resFile, String name, JResType type) {
        this(resFile, name, name, type);
    }

    public JResource(ResourceFile resFile, String name, String shortName, JResType type) {
        this.resFile = resFile;
        this.name = name;
        this.shortName = shortName;
        this.type = type;
        this.loaded = false;
    }

    public final void update() {
        this.removeAllChildren();
        if (!this.loaded) {
            if (this.type == JResType.DIR || this.type == JResType.ROOT || this.resFile.getType() == ResourceType.ARSC) {
                this.add(new TextNode(NLS.str("tree.loading")));
            }
        } else {
            this.loadContent();
            for (JResource res : this.files) {
                res.update();
                this.add(res);
            }
        }
    }

    @Override
    public void loadNode() {
        this.loadContent();
        this.loaded = true;
        this.update();
    }

    private void loadContent() {
        this.getContent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<JResource> getFiles() {
        return this.files;
    }

    @Override
    public String getContent() {
        if (!this.loaded && this.resFile != null && this.type == JResType.FILE) {
            ResContainer rc;
            this.loaded = true;
            if (JResource.isSupportedForView(this.resFile.getType()) && (rc = this.resFile.loadContent()) != null) {
                this.addSubFiles(rc, this, 0);
            }
        }
        return this.content;
    }

    private void addSubFiles(ResContainer rc, JResource root, int depth) {
        List subFiles;
        CodeWriter cw = rc.getContent();
        if (cw != null) {
            if (depth == 0) {
                root.lineMapping = cw.getLineMapping();
                root.content = cw.toString();
            } else {
                String resName = rc.getName();
                String[] path = resName.split("/");
                String resShortName = path.length == 0 ? resName : path[path.length - 1];
                ResourceFileContent fileContent = ResourceFileContent.createResourceFileContentInstance((String)resShortName, (ResourceType)ResourceType.XML, (CodeWriter)cw);
                if (fileContent != null) {
                    JResource.addPath(path, root, new JResource((ResourceFile)fileContent, resName, resShortName, JResType.FILE));
                }
            }
        }
        if (!(subFiles = rc.getSubFiles()).isEmpty()) {
            for (ResContainer subFile : subFiles) {
                this.addSubFiles(subFile, root, depth + 1);
            }
        }
    }

    private static void addPath(String[] path, JResource root, JResource jResource) {
        if (path.length == 1) {
            root.getFiles().add(jResource);
            return;
        }
        JResource currentRoot = root;
        int last = path.length - 1;
        for (int i = 0; i <= last; ++i) {
            String f = path[i];
            if (i == last) {
                currentRoot.getFiles().add(jResource);
                continue;
            }
            currentRoot = JResource.getResDir(currentRoot, f);
        }
    }

    private static JResource getResDir(JResource root, String dirName) {
        for (JResource file : root.getFiles()) {
            if (!file.getName().equals(dirName)) continue;
            return file;
        }
        JResource resDir = new JResource(null, dirName, JResType.DIR);
        root.getFiles().add(resDir);
        return resDir;
    }

    @Override
    public Integer getSourceLine(int line) {
        if (this.lineMapping == null) {
            return null;
        }
        return this.lineMapping.get(line);
    }

    @Override
    public String getSyntaxName() {
        if (this.resFile == null) {
            return null;
        }
        switch (this.resFile.getType()) {
            case CODE: {
                return super.getSyntaxName();
            }
            case MANIFEST: 
            case XML: {
                return "text/xml";
            }
        }
        String syntax = this.getSyntaxByExtension(this.resFile.getName());
        if (syntax != null) {
            return syntax;
        }
        return super.getSyntaxName();
    }

    private String getSyntaxByExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        String ext = name.substring(dot + 1);
        if (ext.equals("js")) {
            return "text/javascript";
        }
        if (ext.equals("css")) {
            return "text/css";
        }
        if (ext.equals("html")) {
            return "text/html";
        }
        if (ext.equals("arsc")) {
            return "text/xml";
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        switch (this.type) {
            case ROOT: {
                return ROOT_ICON;
            }
            case DIR: {
                return FOLDER_ICON;
            }
            case FILE: {
                ResourceType resType = this.resFile.getType();
                if (resType == ResourceType.MANIFEST) {
                    return MANIFEST_ICON;
                }
                if (resType == ResourceType.CODE) {
                    return new OverlayIcon(FILE_ICON, ERROR_ICON, JAVA_ICON);
                }
                if (!JResource.isSupportedForView(resType)) {
                    return new OverlayIcon(FILE_ICON, ERROR_ICON);
                }
                return FILE_ICON;
            }
        }
        return FILE_ICON;
    }

    public static boolean isSupportedForView(ResourceType type) {
        switch (type) {
            case CODE: 
            case FONT: 
            case LIB: {
                return false;
            }
            case MANIFEST: 
            case XML: 
            case ARSC: 
            case IMG: 
            case UNKNOWN: {
                return true;
            }
        }
        return true;
    }

    public ResourceFile getResFile() {
        return this.resFile;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public int compareTo(@NotNull JResource o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public String makeString() {
        return this.shortName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name.equals(((JResource)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum JResType {
        ROOT,
        DIR,
        FILE;

    }
}

