/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadGpsTask
extends AbstractDownloadTask<GpxData> {
    private DownloadTask downloadTask;
    private GpxLayer gpxLayer;
    protected String newLayerName;

    @Override
    public String[] getPatterns() {
        return (String[])Arrays.stream(OsmServerLocationReader.GpxUrlPattern.values()).map(OsmServerLocationReader.GpxUrlPattern::pattern).toArray(String[]::new);
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download GPS", new Object[0]);
    }

    @Override
    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(settings, new BoundingBoxDownloader(downloadArea), progressMonitor);
        return MainApplication.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        Optional<String> mappedUrl = Stream.of(OsmServerLocationReader.GpxUrlPattern.USER_TRACE_ID, OsmServerLocationReader.GpxUrlPattern.EDIT_TRACE_ID).map(p -> Pattern.compile(p.pattern()).matcher(url)).filter(Matcher::matches).map(m -> "https://www.openstreetmap.org/trace/" + m.group(2) + "/data").findFirst();
        if (mappedUrl.isPresent()) {
            return this.loadUrl(settings, mappedUrl.get(), progressMonitor);
        }
        if (Stream.of(OsmServerLocationReader.GpxUrlPattern.TRACE_ID, OsmServerLocationReader.GpxUrlPattern.EXTERNAL_GPX_SCRIPT, OsmServerLocationReader.GpxUrlPattern.EXTERNAL_GPX_FILE, OsmServerLocationReader.GpxUrlPattern.TASKING_MANAGER).anyMatch(p -> url.matches(p.pattern()))) {
            this.downloadTask = new DownloadTask(settings, new OsmServerLocationReader(url), progressMonitor);
            Matcher matcher = Pattern.compile(OsmServerLocationReader.GpxUrlPattern.EXTERNAL_GPX_FILE.pattern()).matcher(url);
            this.newLayerName = matcher.matches() ? matcher.group(1) : null;
            return MainApplication.worker.submit(this.downloadTask);
        }
        if (url.matches(OsmServerLocationReader.GpxUrlPattern.TRACKPOINTS_BBOX.pattern())) {
            String[] table = url.split("\\?|=|&");
            for (int i = 0; i < table.length; ++i) {
                if (!"bbox".equals(table[i]) || i >= table.length - 1) continue;
                return this.download(settings, new Bounds(table[i + 1], ",", Bounds.ParseMethod.LEFT_BOTTOM_RIGHT_TOP), progressMonitor);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public ProjectionBounds getDownloadProjectionBounds() {
        return this.gpxLayer != null ? this.gpxLayer.getViewProjectionBounds() : null;
    }

    @Override
    public String getConfirmationMessage(URL url) {
        return null;
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private final OsmServerReader reader;
        private GpxData rawData;
        private final boolean newLayer;

        DownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data", new Object[0]), progressMonitor, false);
            this.reader = reader;
            this.newLayer = settings.isNewLayer();
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                this.rawData = this.reader.parseRawGps(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (OsmTransferException e) {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                DownloadGpsTask.this.rememberException(e);
            }
        }

        @Override
        protected void finish() {
            DownloadGpsTask.this.rememberDownloadedData(this.rawData);
            if (this.rawData == null) {
                return;
            }
            String name = DownloadGpsTask.this.newLayerName != null ? DownloadGpsTask.this.newLayerName : I18n.tr("Downloaded GPX Data", new Object[0]);
            GpxImporter.GpxImporterData layers = GpxImporter.loadLayers(this.rawData, this.reader.isGpxParsedProperly(), name, I18n.tr("Markers from {0}", name));
            DownloadGpsTask.this.gpxLayer = layers.getGpxLayer();
            this.addOrMergeLayer(DownloadGpsTask.this.gpxLayer, this.findGpxMergeLayer());
            this.addOrMergeLayer(layers.getMarkerLayer(), this.findMarkerMergeLayer(DownloadGpsTask.this.gpxLayer));
            layers.getPostLayerTask().run();
        }

        private <L extends Layer> L addOrMergeLayer(L layer, L mergeLayer) {
            if (layer == null) {
                return null;
            }
            if (this.newLayer || mergeLayer == null) {
                MainApplication.getLayerManager().addLayer(layer, DownloadGpsTask.this.zoomAfterDownload);
                return layer;
            }
            mergeLayer.mergeFrom(layer);
            mergeLayer.invalidate();
            MapFrame map = MainApplication.getMap();
            if (map != null && DownloadGpsTask.this.zoomAfterDownload && layer instanceof GpxLayer) {
                map.mapView.scheduleZoomTo(new ViewportData(layer.getViewProjectionBounds()));
            }
            return mergeLayer;
        }

        private GpxLayer findGpxMergeLayer() {
            boolean merge = Config.getPref().getBoolean("download.gps.mergeWithLocal", false);
            Layer active = MainApplication.getLayerManager().getActiveLayer();
            if (active instanceof GpxLayer && (merge || ((GpxLayer)active).data.fromServer)) {
                return (GpxLayer)active;
            }
            for (GpxLayer l : MainApplication.getLayerManager().getLayersOfType(GpxLayer.class)) {
                if (!merge && !l.data.fromServer) continue;
                return l;
            }
            return null;
        }

        private MarkerLayer findMarkerMergeLayer(GpxLayer fromLayer) {
            for (MarkerLayer l : MainApplication.getLayerManager().getLayersOfType(MarkerLayer.class)) {
                if (fromLayer == null || l.fromLayer != fromLayer) continue;
                return l;
            }
            return null;
        }

        @Override
        protected void cancel() {
            DownloadGpsTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        public ProgressTaskId canRunInBackground() {
            return ProgressTaskIds.DOWNLOAD_GPS;
        }
    }
}

