/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFile;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileSource;

public class NTV2GridShiftFileWrapper {
    private NTV2GridShiftFile instance;
    private final String gridFileName;
    public static final float NTV2_SOURCE_PRIORITY_LOCAL = 10.0f;
    public static final float NTV2_SOURCE_PRIORITY_DOWNLOAD = 5.0f;
    private static Map<Float, NTV2GridShiftFileSource> sources = new TreeMap(Collections.reverseOrder());

    public static void registerNTV2GridShiftFileSource(float priority, NTV2GridShiftFileSource source) {
        sources.put(Float.valueOf(priority), source);
    }

    public NTV2GridShiftFileWrapper(String filename) {
        this.gridFileName = filename;
    }

    public synchronized NTV2GridShiftFile getShiftFile() throws IOException {
        if (this.instance == null) {
            for (Map.Entry<Float, NTV2GridShiftFileSource> entry : sources.entrySet()) {
                NTV2GridShiftFileSource source = entry.getValue();
                InputStream is = source.getNTV2GridShiftFile(this.gridFileName);
                Throwable throwable = null;
                try {
                    if (is == null) continue;
                    NTV2GridShiftFile ntv2 = new NTV2GridShiftFile();
                    ntv2.loadGridShiftFile(is, false);
                    this.instance = ntv2;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        return this.instance;
    }
}

