/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class HelpAction
extends AbstractAction {
    private final JTable tagTable;
    private final IntFunction<String> tagKeySupplier;
    private final IntFunction<Map<String, Integer>> tagValuesSupplier;
    private final JTable membershipTable;
    private final IntFunction<IRelation<?>> memberValueSupplier;

    public HelpAction(JTable tagTable, IntFunction<String> tagKeySupplier, IntFunction<Map<String, Integer>> tagValuesSupplier, JTable membershipTable, IntFunction<IRelation<?>> memberValueSupplier) {
        this.tagTable = Objects.requireNonNull(tagTable);
        this.tagKeySupplier = Objects.requireNonNull(tagKeySupplier);
        this.tagValuesSupplier = Objects.requireNonNull(tagValuesSupplier);
        this.membershipTable = membershipTable;
        this.memberValueSupplier = memberValueSupplier;
        this.putValue("Name", I18n.tr("Go to OSM wiki for tag help", new Object[0]));
        this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help for selected object", new Object[0]));
        new ImageProvider("dialogs", "search").getResource().attachImageIcon(this, true);
        this.putValue("AcceleratorKey", this.getKeyStroke());
    }

    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(112, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.tagTable.getSelectedRowCount() == 1) {
            int row = this.tagTable.getSelectedRow();
            String key = Utils.encodeUrl(this.tagKeySupplier.apply(row));
            Map<String, Integer> m = this.tagValuesSupplier.apply(row);
            if (!m.isEmpty()) {
                String val = Utils.encodeUrl(m.entrySet().iterator().next().getKey());
                MainApplication.worker.execute(() -> HelpAction.displayTagHelp(key, val));
            }
        } else if (this.membershipTable != null && this.membershipTable.getSelectedRowCount() == 1) {
            int row = this.membershipTable.getSelectedRow();
            IRelation<?> relation = this.memberValueSupplier.apply(row);
            MainApplication.worker.execute(() -> HelpAction.displayRelationHelp(relation));
        } else {
            MainApplication.worker.execute(HelpAction::displayGenericHelp);
        }
    }

    public static void displayTagHelp(String key, String val) {
        String lang = LanguageInfo.getWikiLanguagePrefix();
        List<String> pages = Arrays.asList(String.format("%sTag:%s=%s", lang, key, val), String.format("Tag:%s=%s", key, val), String.format("%sKey:%s", lang, key), String.format("Key:%s", key), String.format("%sMap_Features", lang), "Map_Features");
        HelpAction.displayHelp(pages);
    }

    public static void displayRelationHelp(IRelation<?> rel) {
        String lang = LanguageInfo.getWikiLanguagePrefix();
        ArrayList<String> pages = new ArrayList<String>();
        String type = rel.get("type");
        if (type != null) {
            type = Utils.encodeUrl(type);
        }
        if (type != null && !type.isEmpty()) {
            pages.add(String.format("%sRelation:%s", lang, type));
            pages.add(String.format("Relation:%s", type));
        }
        pages.add(String.format("%sRelations", lang));
        pages.add("Relations");
        HelpAction.displayHelp(pages);
    }

    public static void displayGenericHelp() {
        String lang = LanguageInfo.getWikiLanguagePrefix();
        List<String> pages = Arrays.asList(String.format("%sMap_Features", lang), "Map_Features");
        HelpAction.displayHelp(pages);
    }

    public static void displayHelp(List<String> pages) {
        try {
            Document document;
            URL url = new URL(Config.getUrls().getOSMWiki() + "/w/api.php?action=query&format=xml&titles=" + pages.stream().map(Utils::encodeUrl).collect(Collectors.joining("|")));
            HttpClient.Response conn = HttpClient.create(url).connect();
            InputStream content = conn.getContent();
            Object object = null;
            try {
                document = XmlUtils.parseSafeDOM(content);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (content != null) {
                    if (object != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        content.close();
                    }
                }
            }
            conn.disconnect();
            XPath xPath = XPathFactory.newInstance().newXPath();
            for (String page : pages) {
                Node node;
                String normalized = xPath.evaluate("/api/query/normalized/n[@from='" + page + "']/@to", document);
                if (normalized == null || normalized.isEmpty()) {
                    normalized = page;
                }
                if ((node = (Node)xPath.evaluate("/api/query/pages/page[@title='" + normalized + "']", document, XPathConstants.NODE)) == null || node.getAttributes().getNamedItem("missing") != null || node.getAttributes().getNamedItem("invalid") != null) continue;
                OpenBrowser.displayUrl(Config.getUrls().getOSMWiki() + "/wiki/" + page);
                break;
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e1) {
            Logging.error(e1);
        }
    }
}

