'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _treemapLeaf = require('./treemap-leaf');

var _treemapLeaf2 = _interopRequireDefault(_treemapLeaf);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2016 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.


var TreemapDOM = function (_React$Component) {
  _inherits(TreemapDOM, _React$Component);

  function TreemapDOM() {
    _classCallCheck(this, TreemapDOM);

    return _possibleConstructorReturn(this, (TreemapDOM.__proto__ || Object.getPrototypeOf(TreemapDOM)).apply(this, arguments));
  }

  _createClass(TreemapDOM, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          animation = _props.animation,
          className = _props.className,
          height = _props.height,
          hideRootNode = _props.hideRootNode,
          getLabel = _props.getLabel,
          mode = _props.mode,
          nodes = _props.nodes,
          width = _props.width,
          scales = _props.scales,
          style = _props.style;

      var useCirclePacking = mode === 'circlePack';
      return _react2.default.createElement(
        'div',
        {
          className: 'rv-treemap ' + (useCirclePacking ? 'rv-treemap-circle-packed' : '') + ' ' + className,
          style: { height: height, width: width } },
        nodes.map(function (node, index) {
          // throw out the rootest node
          if (hideRootNode && !index) {
            return null;
          }

          var nodeProps = _extends({
            animation: animation,
            node: node,
            getLabel: getLabel
          }, _this2.props, {
            x0: useCirclePacking ? node.x : node.x0,
            x1: useCirclePacking ? node.x : node.x1,
            y0: useCirclePacking ? node.y : node.y0,
            y1: useCirclePacking ? node.y : node.y1,
            r: useCirclePacking ? node.r : 1,
            scales: scales,
            style: style
          });
          return _react2.default.createElement(_treemapLeaf2.default, _extends({}, nodeProps, { key: 'leaf-' + index }));
        })
      );
    }
  }]);

  return TreemapDOM;
}(_react2.default.Component);

TreemapDOM.displayName = 'TreemapDOM';
exports.default = TreemapDOM;