/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.lib.uno.typedesc.FieldDescription;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.lib.util.WeakMap;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.IMapping;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XCurrentContext;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnoRuntime {
    public static final boolean DEBUG = false;
    private static final WeakHashMap<Object, String> oidMap = new WeakHashMap();
    private static final String uniqueKeyHostPrefix = Integer.toString(new Object().hashCode(), 16) + ":";
    private static final Object uniqueKeyLock = new Object();
    private static long uniqueKeyTime = System.currentTimeMillis();
    private static long uniqueKeyCount = Long.MIN_VALUE;
    private static final String oidSuffix = ";java[];" + UnoRuntime.getUniqueKey();
    private static final ThreadLocal<XCurrentContext> currentContext = new ThreadLocal();
    private static final WeakMap<String, IEnvironment> environments = new WeakMap();
    private static final WeakMap<String, IBridge> bridges = new WeakMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueKey() {
        Object object = uniqueKeyLock;
        synchronized (object) {
            if (uniqueKeyCount == Long.MAX_VALUE) {
                long l = System.currentTimeMillis();
                while (l == uniqueKeyTime) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                uniqueKeyTime = l;
                uniqueKeyCount = Long.MIN_VALUE;
            }
            long l = uniqueKeyCount++;
            return uniqueKeyHostPrefix + Long.toString(uniqueKeyTime, 16) + ":" + Long.toString(l, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateOid(Object object) {
        String string = null;
        if (object instanceof IQueryInterface) {
            string = ((IQueryInterface)object).getOid();
        }
        if (string == null) {
            WeakHashMap<Object, String> weakHashMap = oidMap;
            synchronized (weakHashMap) {
                string = oidMap.get(object);
                if (string == null) {
                    string = UUID.randomUUID().toString() + oidSuffix;
                    oidMap.put(object, string);
                }
            }
        }
        return string;
    }

    public static Object queryInterface(Type type, Object object) {
        Object object2;
        if (object instanceof Any && ((Any)(object2 = (Any)object)).getType().getTypeClass() == TypeClass.INTERFACE) {
            object = ((Any)object2).getObject();
        }
        if (object instanceof IQueryInterface && (object = ((IQueryInterface)object).queryInterface(type)) instanceof Any) {
            object2 = (Any)object;
            Object object3 = object = ((Any)object2).getType().getTypeClass() == TypeClass.INTERFACE ? ((Any)object2).getObject() : null;
        }
        if ((object2 = type.getZClass()) == null || !((Class)object2).isInstance(object)) {
            object = null;
        }
        return object;
    }

    public static <T> T queryInterface(Class<T> clazz, Object object) {
        return (T)UnoRuntime.queryInterface(new Type(clazz), object);
    }

    public static boolean areSame(Object object, Object object2) {
        Any any = Any.complete(object);
        Any any2 = Any.complete(object2);
        Type type = any.getType();
        if (!any2.getType().equals(type)) {
            return false;
        }
        Object object3 = any.getObject();
        Object object4 = any2.getObject();
        switch (type.getTypeClass().getValue()) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return object3.equals(object4);
            }
            case 20: {
                int n = Array.getLength(object3);
                if (n != Array.getLength(object4)) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (UnoRuntime.areSame(Array.get(object3, i), Array.get(object4, i))) continue;
                    return false;
                }
                return true;
            }
            case 15: {
                return object3 == object4;
            }
            case 17: 
            case 19: {
                FieldDescription[] fieldDescriptionArray;
                try {
                    fieldDescriptionArray = TypeDescription.getTypeDescription(type).getFieldDescriptions();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new java.lang.RuntimeException(classNotFoundException);
                }
                for (int i = 0; i < fieldDescriptionArray.length; ++i) {
                    Type type2 = new Type(fieldDescriptionArray[i].getTypeDescription());
                    try {
                        if (UnoRuntime.areSame(UnoRuntime.completeValue(type2, fieldDescriptionArray[i].getField().get(object3)), UnoRuntime.completeValue(type2, fieldDescriptionArray[i].getField().get(object4)))) continue;
                        return false;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new java.lang.RuntimeException(illegalAccessException);
                    }
                }
                return true;
            }
            case 22: {
                return object3 == object4 || object3 instanceof IQueryInterface && ((IQueryInterface)object3).isSame(object4) || object4 instanceof IQueryInterface && ((IQueryInterface)object4).isSame(object3);
            }
        }
        throw new java.lang.RuntimeException("com.sun.star.uno.Any has bad com.sun.star.uno.TypeClass");
    }

    public static final Object completeValue(Type type, Object object) {
        if (object != null) {
            return object;
        }
        switch (type.getTypeClass().getValue()) {
            case 2: {
                return Boolean.FALSE;
            }
            case 3: {
                return (byte)0;
            }
            case 4: 
            case 5: {
                return (short)0;
            }
            case 6: 
            case 7: {
                return 0;
            }
            case 8: 
            case 9: {
                return 0L;
            }
            case 10: {
                return new Float(0.0f);
            }
            case 11: {
                return new Double(0.0);
            }
            case 1: {
                return new Character('\u0000');
            }
            case 12: {
                return "";
            }
            case 13: {
                return Type.VOID;
            }
            case 14: 
            case 22: {
                return null;
            }
            case 20: {
                return Array.newInstance(type.getZClass().getComponentType(), 0);
            }
            case 17: {
                try {
                    return type.getZClass().getConstructor(null).newInstance(null);
                }
                catch (java.lang.RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new java.lang.RuntimeException(exception);
                }
            }
            case 15: {
                try {
                    return type.getZClass().getMethod("getDefault", null).invoke(null, (Object[])null);
                }
                catch (java.lang.RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new java.lang.RuntimeException(exception);
                }
            }
        }
        throw new IllegalArgumentException("com.sun.star.uno.UnoRuntime.completeValue called with bad com.sun.star.uno.Type");
    }

    public static XCurrentContext getCurrentContext() {
        return currentContext.get();
    }

    public static void setCurrentContext(XCurrentContext xCurrentContext) {
        if (xCurrentContext == null) {
            currentContext.remove();
        } else {
            currentContext.set(xCurrentContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IEnvironment getEnvironment(String string, Object object) throws Exception {
        WeakMap<String, IEnvironment> weakMap = environments;
        synchronized (weakMap) {
            IEnvironment iEnvironment = (IEnvironment)WeakMap.getValue(environments.get(string + object));
            if (iEnvironment == null) {
                Class<?> clazz = Class.forName("com.sun.star.lib.uno.environments." + string + "." + string + "_environment");
                Constructor<?> constructor = clazz.getConstructor(Object.class);
                iEnvironment = (IEnvironment)constructor.newInstance(object);
                environments.put((Object)(string + object), (Object)iEnvironment);
            }
            return iEnvironment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBridge getBridge(IEnvironment iEnvironment, IEnvironment iEnvironment2, Object[] objectArray) throws Exception {
        WeakMap<String, IBridge> weakMap = bridges;
        synchronized (weakMap) {
            String string = iEnvironment.getName() + "_" + iEnvironment2.getName();
            String string2 = iEnvironment.getName() + iEnvironment.getContext() + "_" + iEnvironment2.getName() + iEnvironment2.getContext();
            IBridge iBridge = (IBridge)WeakMap.getValue(bridges.get(string2));
            if (iBridge == null) {
                Class<?> clazz = null;
                String string3 = string + "_bridge";
                try {
                    clazz = Class.forName(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    string3 = "com.sun.star.lib.uno.bridges." + string + "." + string3;
                    clazz = Class.forName(string3);
                }
                Class[] classArray = new Class[]{IEnvironment.class, IEnvironment.class, objectArray.getClass()};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray2 = new Object[]{iEnvironment, iEnvironment2, objectArray};
                iBridge = (IBridge)constructor.newInstance(objectArray2);
                bridges.put((Object)string2, (Object)iBridge);
            }
            return iBridge;
        }
    }

    public static IBridge getBridgeByName(String string, Object object, String string2, Object object2, Object[] objectArray) throws Exception {
        return UnoRuntime.getBridge(UnoRuntime.getEnvironment(string, object), UnoRuntime.getEnvironment(string2, object2), objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBridge[] getBridges() {
        ArrayList<IBridge> arrayList = new ArrayList<IBridge>();
        WeakMap<String, IBridge> weakMap = bridges;
        synchronized (weakMap) {
            Iterator<WeakReference<IBridge>> iterator = bridges.values().iterator();
            while (iterator.hasNext()) {
                IBridge iBridge = (IBridge)WeakMap.getValue(iterator.next());
                if (iBridge == null) continue;
                arrayList.add(iBridge);
            }
        }
        return arrayList.toArray(new IBridge[arrayList.size()]);
    }

    public static IMapping getMapping(IEnvironment iEnvironment, IEnvironment iEnvironment2) throws Exception {
        IBridge iBridge;
        try {
            iBridge = UnoRuntime.getBridge(iEnvironment, iEnvironment2, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iBridge = new BridgeTurner(UnoRuntime.getBridge(iEnvironment2, iEnvironment, null));
        }
        return new MappingWrapper(iBridge);
    }

    public static IMapping getMappingByName(String string, String string2) throws Exception {
        return UnoRuntime.getMapping(UnoRuntime.getEnvironment(string, null), UnoRuntime.getEnvironment(string2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reset() {
        WeakMap<String, IBridge> weakMap = bridges;
        synchronized (weakMap) {
            Iterator<WeakReference<IBridge>> iterator = bridges.values().iterator();
            while (iterator.hasNext()) {
                IBridge iBridge = (IBridge)WeakMap.getValue(iterator.next());
                if (iBridge == null) continue;
                try {
                    iBridge.dispose();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread();
                    Thread.interrupted();
                    throw new RuntimeException("Unexpected exception in UnoRuntime.reset: " + interruptedException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Unexpected exception in UnoRuntime.reset: " + iOException);
                }
            }
            bridges.clear();
        }
        environments.clear();
        return bridges.isEmpty() && environments.isEmpty();
    }

    private static final class MappingWrapper
    implements IMapping {
        private final IBridge bridge;

        public MappingWrapper(IBridge iBridge) {
            this.bridge = iBridge;
        }

        public Object mapInterface(Object object, Type type) {
            return this.bridge.mapInterfaceTo(object, type);
        }
    }

    private static final class BridgeTurner
    implements IBridge {
        private final IBridge bridge;

        public BridgeTurner(IBridge iBridge) {
            this.bridge = iBridge;
        }

        public Object mapInterfaceTo(Object object, Type type) {
            return this.bridge.mapInterfaceFrom(object, type);
        }

        public Object mapInterfaceFrom(Object object, Type type) {
            return this.bridge.mapInterfaceTo(object, type);
        }

        public IEnvironment getSourceEnvironment() {
            return this.bridge.getTargetEnvironment();
        }

        public IEnvironment getTargetEnvironment() {
            return this.bridge.getSourceEnvironment();
        }

        public void acquire() {
            this.bridge.acquire();
        }

        public void release() {
            this.bridge.release();
        }

        public void dispose() throws InterruptedException, IOException {
            this.bridge.dispose();
        }
    }
}

