/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.SectionLayoutController;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.OfficeGroup;
import org.libreoffice.report.pentaho.model.OfficeReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeTableTemplateLayoutController
extends SectionLayoutController {
    private Node[] nodes;

    @Override
    public void initialize(Object object, FlowController flowController, LayoutController layoutController) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        Section section = new Section();
        section.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
        section.setType("template");
        super.initialize(section, flowController, layoutController);
        OfficeReport officeReport = (OfficeReport)object;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (officeReport.getPageHeader() != null) {
            this.addFromSection(arrayList, (Section)officeReport.getPageHeader());
        }
        if (officeReport.getReportHeader() != null) {
            this.addFromSection(arrayList, (Section)officeReport.getReportHeader());
        }
        this.addPBody(arrayList, (Section)officeReport.getPreBodySection());
        this.addFromBody(arrayList, (Section)officeReport.getBodySection());
        this.addPBody(arrayList, (Section)officeReport.getPostBodySection());
        if (officeReport.getReportFooter() != null) {
            this.addFromSection(arrayList, (Section)officeReport.getReportFooter());
        }
        if (officeReport.getPageFooter() != null) {
            this.addFromSection(arrayList, (Section)officeReport.getPageFooter());
        }
        this.nodes = arrayList.toArray(new Node[arrayList.size()]);
    }

    private void addPBody(List<Node> list, Section section) {
        if (section != null) {
            Node[] nodeArray = section.getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                list.add(node);
            }
        }
    }

    private void addFromBody(List<Node> list, Section section) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            if (!(node instanceof Section)) continue;
            Section section2 = (Section)node;
            if (node instanceof OfficeGroup) {
                this.addFromGroup(list, section2);
                continue;
            }
            this.addFromSection(list, section2);
        }
    }

    private void addFromGroup(List<Node> list, Section section) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            if (!(node instanceof Section)) continue;
            Section section2 = (Section)node;
            if ("http://jfreereport.sourceforge.net/namespaces/engine".equals(section2.getNamespace()) && "group-body".equals(section2.getType())) {
                this.addFromBody(list, section2);
                continue;
            }
            this.addFromSection(list, section2);
        }
    }

    private void addFromSection(List<Node> list, Section section) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Element element;
            Node node = nodeArray[i];
            if (!(node instanceof Element) || !"urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals((element = (Element)node).getNamespace()) || !"table".equals(element.getType())) continue;
            list.add(element);
        }
    }

    @Override
    public Node[] getNodes() {
        return this.nodes;
    }
}

