/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.util;

import java.util.HashMap;
import java.util.Map;
import org.libreoffice.report.JobDefinitionException;
import org.libreoffice.report.JobProperties;
import org.libreoffice.report.ReportEngineMetaData;

public class DefaultJobProperties
implements JobProperties {
    private final ReportEngineMetaData metaData;
    private final Map<String, Object> properties;

    public DefaultJobProperties(ReportEngineMetaData reportEngineMetaData) {
        if (reportEngineMetaData == null) {
            throw new NullPointerException();
        }
        this.properties = new HashMap<String, Object>();
        this.metaData = reportEngineMetaData;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) throws JobDefinitionException {
        Class clazz = this.metaData.getParameterType(string);
        if (clazz == null) {
            throw new JobDefinitionException("The parameter name is not known: " + string);
        }
        if (!clazz.isInstance(object)) {
            throw new JobDefinitionException("The parameter value is not understood");
        }
        this.properties.put(string, object);
    }

    public JobProperties copy() {
        DefaultJobProperties defaultJobProperties = new DefaultJobProperties(this.metaData);
        defaultJobProperties.properties.putAll(this.properties);
        return defaultJobProperties;
    }
}

