/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.jfree.report.util.beans.ArrayValueConverter;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.BigDecimalValueConverter;
import org.jfree.report.util.beans.BigIntegerValueConverter;
import org.jfree.report.util.beans.BooleanValueConverter;
import org.jfree.report.util.beans.ByteValueConverter;
import org.jfree.report.util.beans.CharacterValueConverter;
import org.jfree.report.util.beans.ClassValueConverter;
import org.jfree.report.util.beans.ColorValueConverter;
import org.jfree.report.util.beans.DoubleValueConverter;
import org.jfree.report.util.beans.FloatValueConverter;
import org.jfree.report.util.beans.IntegerValueConverter;
import org.jfree.report.util.beans.LongValueConverter;
import org.jfree.report.util.beans.ShortValueConverter;
import org.jfree.report.util.beans.StringValueConverter;
import org.jfree.report.util.beans.ValueConverter;

public final class ConverterRegistry {
    private static ConverterRegistry instance;
    private HashMap registeredClasses = new HashMap();

    public static synchronized ConverterRegistry getInstance() {
        if (instance == null) {
            instance = new ConverterRegistry();
        }
        return instance;
    }

    private ConverterRegistry() {
        this.registeredClasses.put(BigDecimal.class, new BigDecimalValueConverter());
        this.registeredClasses.put(BigInteger.class, new BigIntegerValueConverter());
        this.registeredClasses.put(Boolean.class, new BooleanValueConverter());
        this.registeredClasses.put(Boolean.TYPE, new BooleanValueConverter());
        this.registeredClasses.put(Byte.class, new ByteValueConverter());
        this.registeredClasses.put(Byte.TYPE, new ByteValueConverter());
        this.registeredClasses.put(Character.class, new CharacterValueConverter());
        this.registeredClasses.put(Character.TYPE, new CharacterValueConverter());
        this.registeredClasses.put(Color.class, new ColorValueConverter());
        this.registeredClasses.put(Double.class, new DoubleValueConverter());
        this.registeredClasses.put(Double.TYPE, new DoubleValueConverter());
        this.registeredClasses.put(Float.class, new FloatValueConverter());
        this.registeredClasses.put(Float.TYPE, new FloatValueConverter());
        this.registeredClasses.put(Integer.class, new IntegerValueConverter());
        this.registeredClasses.put(Integer.TYPE, new IntegerValueConverter());
        this.registeredClasses.put(Long.class, new LongValueConverter());
        this.registeredClasses.put(Long.TYPE, new LongValueConverter());
        this.registeredClasses.put(Short.class, new ShortValueConverter());
        this.registeredClasses.put(Short.TYPE, new ShortValueConverter());
        this.registeredClasses.put(String.class, new StringValueConverter());
        this.registeredClasses.put(Number.class, new BigDecimalValueConverter());
        this.registeredClasses.put(Class.class, new ClassValueConverter());
    }

    public ValueConverter getValueConverter(Class clazz) {
        Class<?> clazz2;
        ValueConverter valueConverter;
        ValueConverter valueConverter2 = (ValueConverter)this.registeredClasses.get(clazz);
        if (valueConverter2 != null) {
            return valueConverter2;
        }
        if (clazz.isArray() && (valueConverter = this.getValueConverter(clazz2 = clazz.getComponentType())) != null) {
            return new ArrayValueConverter(clazz2, valueConverter);
        }
        return null;
    }

    public static String toAttributeValue(Object object) throws BeanException {
        if (object == null) {
            return null;
        }
        ValueConverter valueConverter = ConverterRegistry.getInstance().getValueConverter(object.getClass());
        if (valueConverter == null) {
            return null;
        }
        return valueConverter.toAttributeValue(object);
    }

    public static Object toPropertyValue(String string, Class clazz) throws BeanException {
        if (string == null) {
            return null;
        }
        ValueConverter valueConverter = ConverterRegistry.getInstance().getValueConverter(clazz);
        if (valueConverter == null) {
            return null;
        }
        return valueConverter.toPropertyValue(string);
    }
}

