/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.xslt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.converter.dom.DOMDocument;
import org.openoffice.xmerge.converter.xml.xslt.GenericOfficeDocument;
import org.openoffice.xmerge.converter.xml.xslt.PluginFactoryImpl;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.registry.ConverterInfo;

public final class DocumentDeserializerImpl
implements DocumentDeserializer,
URIResolver {
    private final ConvertData cd;
    private final PluginFactoryImpl pluginFactory;

    public DocumentDeserializerImpl(PluginFactoryImpl pluginFactoryImpl, ConvertData convertData) {
        this.cd = convertData;
        this.pluginFactory = pluginFactoryImpl;
    }

    public Document deserialize() throws ConvertException, IOException {
        this.log("\nFound the XSLT deserializer");
        Iterator<Object> iterator = this.cd.getDocumentEnumeration();
        org.w3c.dom.Document document = null;
        DOMDocument dOMDocument = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        GenericOfficeDocument genericOfficeDocument = new GenericOfficeDocument("output");
        while (iterator.hasNext()) {
            dOMDocument = (DOMDocument)iterator.next();
        }
        if (dOMDocument != null) {
            try {
                document = dOMDocument.getContentDOM();
                byteArrayOutputStream = this.transform(document);
                genericOfficeDocument.initContentDOM();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                genericOfficeDocument.setContentDOM(documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
            }
            catch (Exception exception) {
                System.out.println("The following error occurred:" + exception);
            }
        }
        return genericOfficeDocument;
    }

    public Source resolve(String string, String string2) throws TransformerException {
        if (string != null) {
            if (string.equals("javax.xml.transform.dom.DOMSource") || string.length() == 0) {
                return null;
            }
            try {
                ConverterInfo converterInfo = this.pluginFactory.getConverterInfo();
                String string3 = "jar:" + converterInfo.getJarName() + "!/" + string;
                StreamSource streamSource = new StreamSource(string3);
                return streamSource;
            }
            catch (Exception exception) {
                System.out.println("\nException in Xslt Resolver " + exception);
                return null;
            }
        }
        return null;
    }

    private ByteArrayOutputStream transform(org.w3c.dom.Document document) {
        this.log("\nTransforming...");
        ConverterInfo converterInfo = this.pluginFactory.getConverterInfo();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String string = converterInfo.getXsltDeserial();
            string = string.substring(0, 6);
            org.w3c.dom.Document document2 = null;
            if (string.equals("http:/") || string.equals("file:/") || string.equals("jar://")) {
                this.log(converterInfo.getXsltDeserial());
                document2 = documentBuilder.parse(converterInfo.getXsltDeserial());
            } else {
                this.log(converterInfo.getJarName() + "!/" + converterInfo.getXsltDeserial());
                document2 = documentBuilder.parse("jar:" + converterInfo.getJarName() + "!/" + converterInfo.getXsltDeserial());
            }
            DOMSource dOMSource = new DOMSource(document2);
            DOMSource dOMSource2 = new DOMSource(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(this);
            Transformer transformer = transformerFactory.newTransformer(dOMSource);
            transformer.transform(dOMSource2, new StreamResult(byteArrayOutputStream));
            this.log("\n** Transform Complete ***");
        }
        catch (StackOverflowError stackOverflowError) {
            System.out.println("\nERROR : Stack Overflow Error During Transformation\n Try increasing the stack size by passing the -Xss1m option to the JRE.");
            throw stackOverflowError;
        }
        catch (Exception exception) {
            System.out.println("An error occurred in the transformation : " + exception);
        }
        return byteArrayOutputStream;
    }

    private void log(String string) {
        Debug.log(4, string);
    }
}

