/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventprocessorhost.AzureStorageCheckpointLeaseManager;
import com.microsoft.azure.eventprocessorhost.AzureStoragePartitionManagerOptions;
import com.microsoft.azure.eventprocessorhost.DefaultEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.EventProcessorOptions;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.IEventProcessor;
import com.microsoft.azure.eventprocessorhost.IEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.ILeaseManager;
import com.microsoft.azure.eventprocessorhost.PartitionManager;
import com.microsoft.azure.eventprocessorhost.PartitionManagerOptions;
import com.microsoft.azure.storage.StorageException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventProcessorHost {
    private boolean initializeLeaseManager = false;
    private boolean unregistered = false;
    private PartitionManager partitionManager;
    private PartitionManagerOptions partitionManagerOptions = null;
    private final boolean weOwnExecutor;
    private final ScheduledExecutorService executorService;
    private final int executorServicePoolSize = 8;
    private final HostContext hostContext;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(EventProcessorHost.class);
    private static final Object uuidSynchronizer = new Object();

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, storageConnectionString, storageContainerName, (ScheduledExecutorService)null);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName, ScheduledExecutorService executorService) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, storageConnectionString, storageContainerName, (String)null, executorService);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName, String storageBlobPrefix) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, storageConnectionString, storageContainerName, storageBlobPrefix, (ScheduledExecutorService)null);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName, String storageBlobPrefix, ScheduledExecutorService executorService) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, new AzureStorageCheckpointLeaseManager(storageConnectionString, storageContainerName, storageBlobPrefix), executorService);
        this.initializeLeaseManager = true;
        this.partitionManagerOptions = new AzureStoragePartitionManagerOptions();
    }

    private EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, AzureStorageCheckpointLeaseManager combinedManager, ScheduledExecutorService executorService) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, combinedManager, combinedManager, executorService, null);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, ICheckpointManager checkpointManager, ILeaseManager leaseManager) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, checkpointManager, leaseManager, null, null);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, ICheckpointManager checkpointManager, ILeaseManager leaseManager, ScheduledExecutorService executorService, RetryPolicy retryPolicy) {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName argument must not be null or empty string");
        }
        if (consumerGroupName == null || consumerGroupName.isEmpty()) {
            throw new IllegalArgumentException("consumerGroupName argument must not be null or empty");
        }
        if (eventHubConnectionString == null || eventHubConnectionString.isEmpty()) {
            throw new IllegalArgumentException("eventHubConnectionString argument must not be null or empty");
        }
        ConnectionStringBuilder providedCSB = new ConnectionStringBuilder(eventHubConnectionString);
        String extractedEntityPath = providedCSB.getEventHubName();
        String effectiveEventHubPath = eventHubPath;
        String effectiveEventHubConnectionString = eventHubConnectionString;
        if (effectiveEventHubPath != null && !effectiveEventHubPath.isEmpty()) {
            if (extractedEntityPath != null) {
                if (effectiveEventHubPath.compareTo(extractedEntityPath) != 0) {
                    throw new IllegalArgumentException("Provided EventHub path in eventHubPath parameter conflicts with the path in provided EventHub connection string");
                }
            } else {
                ConnectionStringBuilder rebuildCSB = new ConnectionStringBuilder().setEndpoint(providedCSB.getEndpoint()).setEventHubName(effectiveEventHubPath).setSasKeyName(providedCSB.getSasKeyName()).setSasKey(providedCSB.getSasKey());
                rebuildCSB.setOperationTimeout(providedCSB.getOperationTimeout());
                effectiveEventHubConnectionString = rebuildCSB.toString();
            }
        } else if (extractedEntityPath != null && !extractedEntityPath.isEmpty()) {
            effectiveEventHubPath = extractedEntityPath;
        } else {
            throw new IllegalArgumentException("Provide EventHub entity path in either eventHubPath argument or in eventHubConnectionString");
        }
        if (checkpointManager == null) {
            throw new IllegalArgumentException("Must provide an object which implements ICheckpointManager");
        }
        if (leaseManager == null) {
            throw new IllegalArgumentException("Must provide an object which implements ILeaseManager");
        }
        if (this.partitionManagerOptions == null) {
            this.partitionManagerOptions = new PartitionManagerOptions();
        }
        if (executorService != null) {
            this.weOwnExecutor = false;
            this.executorService = executorService;
        } else {
            this.weOwnExecutor = true;
            this.executorService = Executors.newScheduledThreadPool(this.executorServicePoolSize);
        }
        this.hostContext = new HostContext(this.executorService, this, hostName, effectiveEventHubPath, consumerGroupName, effectiveEventHubConnectionString, retryPolicy, leaseManager, checkpointManager);
        this.partitionManager = new PartitionManager(this.hostContext);
        TRACE_LOGGER.info(this.hostContext.withHost("New EventProcessorHost created."));
    }

    public String getHostName() {
        return this.hostContext.getHostName();
    }

    void setPartitionManager(PartitionManager pm) {
        this.partitionManager = pm;
    }

    HostContext getHostContext() {
        return this.hostContext;
    }

    public PartitionManagerOptions getPartitionManagerOptions() {
        return this.partitionManagerOptions;
    }

    public void setPartitionManagerOptions(PartitionManagerOptions options) {
        this.partitionManagerOptions = options;
    }

    public <T extends IEventProcessor> CompletableFuture<Void> registerEventProcessor(Class<T> eventProcessorType) {
        DefaultEventProcessorFactory<T> defaultFactory = new DefaultEventProcessorFactory<T>();
        defaultFactory.setEventProcessorClass(eventProcessorType);
        return this.registerEventProcessorFactory(defaultFactory, EventProcessorOptions.getDefaultOptions());
    }

    public <T extends IEventProcessor> CompletableFuture<Void> registerEventProcessor(Class<T> eventProcessorType, EventProcessorOptions processorOptions) {
        DefaultEventProcessorFactory<T> defaultFactory = new DefaultEventProcessorFactory<T>();
        defaultFactory.setEventProcessorClass(eventProcessorType);
        return this.registerEventProcessorFactory(defaultFactory, processorOptions);
    }

    public CompletableFuture<Void> registerEventProcessorFactory(IEventProcessorFactory<?> factory) {
        return this.registerEventProcessorFactory(factory, EventProcessorOptions.getDefaultOptions());
    }

    public CompletableFuture<Void> registerEventProcessorFactory(IEventProcessorFactory<?> factory, EventProcessorOptions processorOptions) {
        if (this.unregistered) {
            throw new IllegalStateException("Register cannot be called on an EventProcessorHost after unregister. Please create a new EventProcessorHost instance.");
        }
        if (this.hostContext.getEventProcessorFactory() != null) {
            throw new IllegalStateException("Register has already been called on this EventProcessorHost");
        }
        this.hostContext.setEventProcessorFactory(factory);
        this.hostContext.setEventProcessorOptions(processorOptions);
        if (this.executorService.isShutdown() || this.executorService.isTerminated()) {
            TRACE_LOGGER.warn(this.hostContext.withHost("Calling registerEventProcessor/Factory after executor service has been shut down."));
            throw new RejectedExecutionException("EventProcessorHost executor service has been shut down");
        }
        if (this.initializeLeaseManager) {
            try {
                ((AzureStorageCheckpointLeaseManager)this.hostContext.getLeaseManager()).initialize(this.hostContext);
            }
            catch (StorageException | URISyntaxException | InvalidKeyException e) {
                TRACE_LOGGER.error(this.hostContext.withHost("Failure initializing default lease and checkpoint manager."));
                throw new RuntimeException("Failure initializing Storage lease manager", e);
            }
        }
        TRACE_LOGGER.info(this.hostContext.withHost("Starting event processing."));
        return this.partitionManager.initialize();
    }

    public CompletableFuture<Void> unregisterEventProcessor() {
        TRACE_LOGGER.info(this.hostContext.withHost("Stopping event processing"));
        this.unregistered = true;
        CompletionStage<Void> result = this.partitionManager.stopPartitions();
        if (this.weOwnExecutor) {
            result = result.thenRunAsync(() -> {
                this.executorService.shutdown();
                try {
                    this.executorService.awaitTermination(10L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    throw new CompletionException(e);
                }
            }, ForkJoinPool.commonPool());
        }
        return result;
    }

    public static String createHostName(String prefix) {
        String usePrefix = prefix;
        if (usePrefix == null || usePrefix.isEmpty()) {
            usePrefix = "javahost";
        }
        return usePrefix + "-" + EventProcessorHost.safeCreateUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String safeCreateUUID() {
        Object object = uuidSynchronizer;
        synchronized (object) {
            UUID newUuid = UUID.randomUUID();
            return newUuid.toString();
        }
    }
}

