/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.PartitionReceiveHandler;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.ReceiverDisconnectedException;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventprocessorhost.CloseReason;
import com.microsoft.azure.eventprocessorhost.ExceptionWithAction;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.IEventProcessor;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionPump
implements PartitionReceiveHandler {
    protected final HostContext hostContext;
    protected Lease lease = null;
    private EventHubClient eventHubClient = null;
    private PartitionReceiver partitionReceiver = null;
    private final CompletableFuture<Void> shutdownTriggerFuture;
    private final CompletableFuture<Void> shutdownFinishedFuture;
    private CloseReason shutdownReason;
    private CompletableFuture<?> internalOperationFuture = null;
    private IEventProcessor processor = null;
    private PartitionContext partitionContext = null;
    private final Object processingSynchronizer;
    private ScheduledFuture<?> leaseRenewerFuture = null;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(PartitionPump.class);

    PartitionPump(HostContext hostContext, Lease lease) {
        this.hostContext = hostContext;
        this.lease = lease;
        this.processingSynchronizer = new Object();
        this.shutdownTriggerFuture = new CompletableFuture();
        this.shutdownFinishedFuture = ((CompletableFuture)((CompletableFuture)this.shutdownTriggerFuture.handleAsync((r, e) -> this.cancelPendingOperations(), (Executor)this.hostContext.getExecutor())).thenComposeAsync(empty -> this.cleanUpAll(this.shutdownReason), (Executor)this.hostContext.getExecutor())).thenComposeAsync(empty -> this.releaseLeaseOnShutdown(), (Executor)this.hostContext.getExecutor());
    }

    void setLease(Lease newLease) {
        this.lease = newLease;
        if (this.partitionContext != null) {
            this.partitionContext.setLease(newLease);
        }
    }

    CompletableFuture<Void> startPump() {
        this.setupPartitionContext();
        ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> this.openProcessor(), this.hostContext.getExecutor()).thenComposeAsync(empty -> this.openClientsRetryWrapper(), (Executor)this.hostContext.getExecutor())).thenRunAsync(() -> this.scheduleLeaseRenewer(), this.hostContext.getExecutor())).whenCompleteAsync((r, e) -> {
            if (e != null) {
                this.internalShutdown(CloseReason.Shutdown, (Throwable)e);
            }
        }, (Executor)this.hostContext.getExecutor());
        return this.shutdownFinishedFuture;
    }

    protected void setupPartitionContext() {
        this.partitionContext = new PartitionContext(this.hostContext, this.lease.getPartitionId());
        this.partitionContext.setLease(this.lease);
    }

    private void openProcessor() {
        TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "Creating and opening event processor instance"));
        String action = "Creating Event Processor";
        try {
            this.processor = this.hostContext.getEventProcessorFactory().createEventProcessor(this.partitionContext);
            action = "Opening Event Processor";
            this.processor.onOpen(this.partitionContext);
        }
        catch (Exception e) {
            this.processor = null;
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Failed " + action), (Throwable)e);
            this.hostContext.getEventProcessorOptions().notifyOfException(this.hostContext.getHostName(), e, action, this.lease.getPartitionId());
            throw new CompletionException(e);
        }
    }

    private CompletableFuture<Void> openClientsRetryWrapper() {
        CompletionStage<Boolean> retryResult = this.openClients();
        for (int i = 1; i < 5; ++i) {
            retryResult = ((CompletableFuture)retryResult.handleAsync((r, e) -> {
                if (e != null) {
                    Exception notifyWith = (Exception)LoggingUtils.unwrapException(e, null);
                    if (notifyWith instanceof ReceiverDisconnectedException) {
                        throw new CompletionException(notifyWith);
                    }
                    TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Failure creating client or receiver, retrying"), e);
                }
                return e == null ? r : false;
            }, (Executor)this.hostContext.getExecutor())).thenComposeAsync(done -> done != false ? CompletableFuture.completedFuture(done) : this.openClients(), (Executor)this.hostContext.getExecutor());
        }
        return retryResult.handleAsync((r, e) -> {
            if (e != null) {
                Exception notifyWith = (Exception)LoggingUtils.unwrapException(e, null);
                if (notifyWith instanceof ReceiverDisconnectedException) {
                    TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Receiver disconnected on create, bad epoch?"), (Throwable)notifyWith);
                } else {
                    TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Failure creating client or receiver, out of retries"), e);
                }
                this.processor.onError(this.partitionContext, new ExceptionWithAction(notifyWith, "Creating Event Hub Client"));
                throw LoggingUtils.wrapException(notifyWith, "Creating Event Hub Client");
            }
            this.partitionReceiver.setReceiveHandler((PartitionReceiveHandler)this, this.hostContext.getEventProcessorOptions().getInvokeProcessorAfterReceiveTimeout().booleanValue());
            return null;
        }, (Executor)this.hostContext.getExecutor());
    }

    protected void scheduleLeaseRenewer() {
        int seconds = this.hostContext.getPartitionManagerOptions().getLeaseRenewIntervalInSeconds();
        this.leaseRenewerFuture = this.hostContext.getExecutor().schedule(() -> this.leaseRenewer(), (long)seconds, TimeUnit.SECONDS);
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(this.lease, "scheduling leaseRenewer in " + seconds));
    }

    private CompletableFuture<Boolean> openClients() {
        TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "Opening EH client"));
        CompletableFuture startOpeningFuture = null;
        try {
            startOpeningFuture = EventHubClient.create((String)this.hostContext.getEventHubConnectionString(), (RetryPolicy)this.hostContext.getRetryPolicy(), (Executor)this.hostContext.getExecutor());
        }
        catch (EventHubException | IOException e2) {
            startOpeningFuture = new CompletableFuture();
            startOpeningFuture.completeExceptionally(e2);
        }
        this.internalOperationFuture = startOpeningFuture;
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)startOpeningFuture.whenCompleteAsync((ehclient, e) -> {
            if (ehclient != null && e == null) {
                this.eventHubClient = ehclient;
            } else {
                TRACE_LOGGER.error(this.hostContext.withHostAndPartition(this.partitionContext, "EventHubClient creation failed"), e);
            }
            this.internalOperationFuture = null;
        }, (Executor)this.hostContext.getExecutor())).thenComposeAsync(empty -> this.partitionContext.getInitialOffset(), (Executor)this.hostContext.getExecutor())).thenComposeAsync(startAt -> {
            ReceiverOptions options = new ReceiverOptions();
            options.setReceiverRuntimeMetricEnabled(this.hostContext.getEventProcessorOptions().getReceiverRuntimeMetricEnabled());
            long epoch = this.lease.getEpoch();
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "Opening EH receiver with epoch " + epoch + " at location " + startAt));
            CompletableFuture receiverFuture = null;
            try {
                receiverFuture = this.eventHubClient.createEpochReceiver(this.partitionContext.getConsumerGroupName(), this.partitionContext.getPartitionId(), startAt, epoch, options);
            }
            catch (EventHubException e) {
                receiverFuture = new CompletableFuture();
                receiverFuture.completeExceptionally(e);
            }
            return receiverFuture;
        }, (Executor)this.hostContext.getExecutor())).whenCompleteAsync((receiver, e) -> {
            if (receiver != null && e == null) {
                this.partitionReceiver = receiver;
            } else if (this.eventHubClient != null) {
                if (e instanceof ReceiverDisconnectedException) {
                    TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "PartitionReceiver disconnected during startup"));
                } else {
                    TRACE_LOGGER.error(this.hostContext.withHostAndPartition(this.partitionContext, "PartitionReceiver creation failed"), e);
                }
            }
            this.internalOperationFuture = null;
        }, (Executor)this.hostContext.getExecutor())).thenApplyAsync(receiver -> {
            try {
                this.partitionReceiver.setPrefetchCount(this.hostContext.getEventProcessorOptions().getPrefetchCount());
            }
            catch (Exception e1) {
                TRACE_LOGGER.error(this.hostContext.withHostAndPartition(this.partitionContext, "PartitionReceiver failed setting prefetch count"), (Throwable)e1);
                throw new CompletionException(e1);
            }
            this.partitionReceiver.setReceiveTimeout(this.hostContext.getEventProcessorOptions().getReceiveTimeOut());
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "EH client and receiver creation finished"));
            return true;
        }, (Executor)this.hostContext.getExecutor());
    }

    private CompletableFuture<Void> cleanUpAll(CloseReason reason) {
        return this.cleanUpClients().thenRunAsync(() -> {
            if (this.processor != null) {
                try {
                    Object object = this.processingSynchronizer;
                    synchronized (object) {
                        this.processor.onClose(this.partitionContext, reason);
                    }
                }
                catch (Exception e) {
                    TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Failure closing processor"), (Throwable)e);
                    this.hostContext.getEventProcessorOptions().notifyOfException(this.hostContext.getHostName(), e, "Closing Event Processor", this.lease.getPartitionId());
                }
            }
        }, this.hostContext.getExecutor());
    }

    private CompletableFuture<Void> cleanUpClients() {
        CompletionStage cleanupFuture = null;
        if (this.partitionReceiver != null) {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "Setting receive handler to null"));
            cleanupFuture = this.partitionReceiver.setReceiveHandler(null);
        } else {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(this.partitionContext, "partitionReceiver is null in cleanup"));
            cleanupFuture = CompletableFuture.completedFuture(null);
        }
        cleanupFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)cleanupFuture.handleAsync((empty, e) -> {
            if (e != null) {
                TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Got exception when ReceiveHandler is set to null."), LoggingUtils.unwrapException(e, null));
            }
            return null;
        }, (Executor)this.hostContext.getExecutor())).thenApplyAsync(empty -> {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "Closing EH receiver"));
            PartitionReceiver partitionReceiverTemp = this.partitionReceiver;
            this.partitionReceiver = null;
            return partitionReceiverTemp;
        }, (Executor)this.hostContext.getExecutor())).thenComposeAsync(partitionReceiverTemp -> partitionReceiverTemp != null ? partitionReceiverTemp.close() : CompletableFuture.completedFuture(null), (Executor)this.hostContext.getExecutor())).handleAsync((empty, e) -> {
            if (e != null) {
                TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Closing EH receiver failed."), LoggingUtils.unwrapException(e, null));
            }
            return null;
        }, (Executor)this.hostContext.getExecutor())).thenApplyAsync(empty -> {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "Closing EH client"));
            EventHubClient eventHubClientTemp = this.eventHubClient;
            this.eventHubClient = null;
            if (eventHubClientTemp == null) {
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(this.partitionContext, "eventHubClient is null in cleanup"));
            }
            return eventHubClientTemp;
        }, (Executor)this.hostContext.getExecutor())).thenComposeAsync(eventHubClientTemp -> eventHubClientTemp != null ? eventHubClientTemp.close() : CompletableFuture.completedFuture(null), (Executor)this.hostContext.getExecutor())).handleAsync((empty, e) -> {
            if (e != null) {
                TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Closing EH client failed."), LoggingUtils.unwrapException(e, null));
            }
            return null;
        }, (Executor)this.hostContext.getExecutor());
        return cleanupFuture;
    }

    protected Void cancelPendingOperations() {
        ScheduledFuture<?> capturedLeaseRenewer;
        CompletableFuture<?> captured = this.internalOperationFuture;
        if (captured != null) {
            captured.cancel(true);
        }
        if ((capturedLeaseRenewer = this.leaseRenewerFuture) != null) {
            this.leaseRenewerFuture.cancel(true);
        }
        return null;
    }

    private CompletableFuture<Void> releaseLeaseOnShutdown() {
        CompletionStage<Object> result = CompletableFuture.completedFuture(null);
        if (this.shutdownReason != CloseReason.LeaseLost) {
            result = this.hostContext.getLeaseManager().releaseLease(this.partitionContext.getLease()).handleAsync((empty, e) -> {
                if (e != null) {
                    TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Failure releasing lease on pump shutdown"), LoggingUtils.unwrapException(e, null));
                }
                return null;
            }, (Executor)this.hostContext.getExecutor());
        }
        return result;
    }

    protected void internalShutdown(CloseReason reason, Throwable e) {
        this.shutdownReason = reason;
        if (e == null) {
            this.shutdownTriggerFuture.complete(null);
        } else {
            this.shutdownTriggerFuture.completeExceptionally(e);
        }
    }

    CompletableFuture<Void> shutdown(CloseReason reason) {
        TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "pump shutdown for reason " + reason.toString()));
        this.internalShutdown(reason, null);
        return this.shutdownFinishedFuture;
    }

    private void leaseRenewer() {
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(this.lease, "leaseRenewer()"));
        if (this.leaseRenewerFuture.isCancelled()) {
            return;
        }
        ((CompletableFuture)this.hostContext.getLeaseManager().renewLease(this.lease).thenApplyAsync(renewed -> {
            Boolean scheduleNext = true;
            if (!renewed.booleanValue()) {
                TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.lease, "Lease lost, shutting down pump"));
                this.internalShutdown(CloseReason.LeaseLost, null);
                scheduleNext = false;
            }
            return scheduleNext;
        }, (Executor)this.hostContext.getExecutor())).whenCompleteAsync((scheduleNext, e) -> {
            if (e != null) {
                Exception notifyWith = (Exception)LoggingUtils.unwrapException(e, null);
                TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.lease, "Transient failure renewing lease"), (Throwable)notifyWith);
                this.hostContext.getEventProcessorOptions().notifyOfException(this.hostContext.getHostName(), notifyWith, "Renewing Lease", this.lease.getPartitionId());
            }
            if (scheduleNext != null && scheduleNext.booleanValue() && !this.leaseRenewerFuture.isCancelled()) {
                this.scheduleLeaseRenewer();
            }
        }, (Executor)this.hostContext.getExecutor());
    }

    public int getMaxEventCount() {
        return this.hostContext.getEventProcessorOptions().getMaxBatchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Iterable<EventData> events) {
        Iterable<EventData> effectiveEvents;
        if (this.hostContext.getEventProcessorOptions().getReceiverRuntimeMetricEnabled()) {
            this.partitionContext.setRuntimeInformation(this.partitionReceiver.getRuntimeInformation());
        }
        if ((effectiveEvents = events) == null) {
            effectiveEvents = new ArrayList<EventData>();
        }
        Iterator<EventData> iter = effectiveEvents.iterator();
        EventData last = null;
        while (iter.hasNext()) {
            last = iter.next();
        }
        if (last != null) {
            this.partitionContext.setOffsetAndSequenceNumber(last);
        }
        try {
            Object object = this.processingSynchronizer;
            synchronized (object) {
                this.processor.onEvents(this.partitionContext, effectiveEvents);
            }
        }
        catch (Exception e) {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "Got exception from onEvents"), (Throwable)e);
        }
    }

    public void onError(Throwable error) {
        if (error == null) {
            error = new Throwable("No error info supplied by EventHub client");
        }
        if (error instanceof ReceiverDisconnectedException) {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionContext, "EventHub client disconnected, probably another host took the partition"));
        } else {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "EventHub client error: " + error.toString()));
            if (error instanceof Exception) {
                TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(this.partitionContext, "EventHub client error continued"), (Throwable)((Exception)error));
            }
        }
        Throwable capturedError = error;
        CompletableFuture.runAsync(() -> this.processor.onError(this.partitionContext, capturedError), this.hostContext.getExecutor()).thenRunAsync(() -> this.internalShutdown(CloseReason.Shutdown, capturedError), this.hostContext.getExecutor());
    }
}

