/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultContinuationType;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.ServiceClient;
import com.microsoft.azure.storage.ServiceProperties;
import com.microsoft.azure.storage.ServiceStats;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobRequest;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.ContainerListHandler;
import com.microsoft.azure.storage.blob.ContainerListingDetails;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.LazySegmentedIterable;
import com.microsoft.azure.storage.core.ListResponse;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.SegmentedStorageRequest;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;

public final class CloudBlobClient
extends ServiceClient {
    private String directoryDelimiter = "/";
    private BlobRequestOptions defaultRequestOptions = new BlobRequestOptions();

    public CloudBlobClient(URI baseUri) {
        this(new StorageUri(baseUri), null);
    }

    public CloudBlobClient(StorageUri baseUri) {
        this(baseUri, null);
    }

    public CloudBlobClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri), credentials);
    }

    public CloudBlobClient(StorageUri storageUri, StorageCredentials credentials) {
        super(storageUri, credentials);
        BlobRequestOptions.applyDefaults(this.defaultRequestOptions, BlobType.UNSPECIFIED);
    }

    public CloudBlobContainer getContainerReference(String containerName) throws URISyntaxException, StorageException {
        return new CloudBlobContainer(containerName, this);
    }

    public String getDirectoryDelimiter() {
        return this.directoryDelimiter;
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers() {
        return this.listContainersWithPrefix(null, ContainerListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers(String prefix) {
        return this.listContainersWithPrefix(prefix, ContainerListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers(String prefix, ContainerListingDetails detailsIncluded, BlobRequestOptions options, OperationContext opContext) {
        return this.listContainersWithPrefix(prefix, detailsIncluded, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented() throws StorageException {
        return this.listContainersSegmented(null, ContainerListingDetails.NONE, null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented(String prefix) throws StorageException {
        return this.listContainersWithPrefixSegmented(prefix, ContainerListingDetails.NONE, null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented(String prefix, ContainerListingDetails detailsIncluded, Integer maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.listContainersWithPrefixSegmented(prefix, detailsIncluded, maxResults, continuationToken, options, opContext);
    }

    private Iterable<CloudBlobContainer> listContainersWithPrefix(String prefix, ContainerListingDetails detailsIncluded, BlobRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.UNSPECIFIED, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudBlobClient, Object, CloudBlobContainer>(this.listContainersWithPrefixSegmentedImpl(prefix, detailsIncluded, null, options, segmentedRequest), this, null, options.getRetryPolicyFactory(), opContext);
    }

    private ResultSegment<CloudBlobContainer> listContainersWithPrefixSegmented(String prefix, ContainerListingDetails detailsIncluded, Integer maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.UNSPECIFIED, this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.CONTAINER);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this, null, this.listContainersWithPrefixSegmentedImpl(prefix, detailsIncluded, maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>> listContainersWithPrefixSegmentedImpl(String prefix, final ContainerListingDetails detailsIncluded, Integer maxResults, final BlobRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.CONTAINER);
        final ListingContext listingContext = new ListingContext(prefix, maxResults);
        StorageRequest<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>> getRequest = new StorageRequest<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, Void parentObject, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return BlobRequest.listContainers(client.getCredentials().transformUri(client.getStorageUri()).getUri(this.getCurrentLocation()), options, context, listingContext, detailsIncluded);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<CloudBlobContainer> preProcessResponse(Void parentObject, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<CloudBlobContainer> postProcessResponse(HttpURLConnection connection, Void container, CloudBlobClient client, OperationContext context, ResultSegment<CloudBlobContainer> storageObject) throws Exception {
                ListResponse<CloudBlobContainer> response = ContainerListHandler.getContainerList(this.getConnection().getInputStream(), client);
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.CONTAINER);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<CloudBlobContainer> resSegment = new ResultSegment<CloudBlobContainer>(response.getResults(), response.getMaxResults(), newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats() throws StorageException {
        return this.getServiceStats(null, null);
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.UNSPECIFIED, this);
        return ExecutionEngine.executeWithRetry(this, null, this.getServiceStatsImpl(options, false), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties() throws StorageException {
        return this.downloadServiceProperties(null, null);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.UNSPECIFIED, this);
        return ExecutionEngine.executeWithRetry(this, null, this.downloadServicePropertiesImpl(options, false), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.UNSPECIFIED, this);
        Utility.assertNotNull("properties", properties);
        if (properties.getDeleteRetentionPolicy() != null && properties.getDeleteRetentionPolicy().getEnabled()) {
            Utility.assertNotNull("RetentionIntervalInDays", properties.getDeleteRetentionPolicy().getRetentionIntervalInDays());
        }
        ExecutionEngine.executeWithRetry(this, null, this.uploadServicePropertiesImpl(properties, options, opContext, false), options.getRetryPolicyFactory(), opContext);
    }

    public void setDirectoryDelimiter(String directoryDelimiter) {
        Utility.assertNotNullOrEmpty("directoryDelimiter", directoryDelimiter);
        this.directoryDelimiter = directoryDelimiter;
    }

    @Override
    public BlobRequestOptions getDefaultRequestOptions() {
        return this.defaultRequestOptions;
    }

    public void setDefaultRequestOptions(BlobRequestOptions defaultRequestOptions) {
        Utility.assertNotNull("defaultRequestOptions", defaultRequestOptions);
        this.defaultRequestOptions = defaultRequestOptions;
    }

    @Override
    protected boolean isUsePathStyleUris() {
        return super.isUsePathStyleUris();
    }
}

