/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.AuthorizationFailedException;
import com.microsoft.azure.eventhubs.ErrorContext;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.IllegalEntityException;
import com.microsoft.azure.eventhubs.PayloadSizeExceededException;
import com.microsoft.azure.eventhubs.QuotaExceededException;
import com.microsoft.azure.eventhubs.ReceiverDisconnectedException;
import com.microsoft.azure.eventhubs.ServerBusyException;
import com.microsoft.azure.eventhubs.TimeoutException;
import com.microsoft.azure.eventhubs.impl.AmqpErrorCode;
import com.microsoft.azure.eventhubs.impl.AmqpException;
import com.microsoft.azure.eventhubs.impl.AmqpResponseCode;
import com.microsoft.azure.eventhubs.impl.ClientConstants;
import com.microsoft.azure.eventhubs.impl.ErrorContextProvider;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public final class ExceptionUtil {
    static Exception toException(ErrorCondition errorCondition) {
        if (errorCondition == null) {
            throw new IllegalArgumentException("'null' errorCondition cannot be translated to EventHubException");
        }
        if (errorCondition.getCondition() == ClientConstants.TIMEOUT_ERROR) {
            return new EventHubException(true, (Throwable)new TimeoutException(errorCondition.getDescription()));
        }
        if (errorCondition.getCondition() == ClientConstants.SERVER_BUSY_ERROR) {
            return new ServerBusyException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.NotFound) {
            return new IllegalEntityException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.ENTITY_DISABLED_ERROR) {
            return new IllegalEntityException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.Stolen) {
            return new ReceiverDisconnectedException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.UnauthorizedAccess) {
            return new AuthorizationFailedException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.PayloadSizeExceeded) {
            return new PayloadSizeExceededException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.InternalError) {
            return new EventHubException(true, (Throwable)new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == ClientConstants.ARGUMENT_ERROR) {
            return new EventHubException(false, errorCondition.getDescription(), new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == ClientConstants.ARGUMENT_OUT_OF_RANGE_ERROR) {
            return new EventHubException(false, errorCondition.getDescription(), new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == AmqpErrorCode.NotImplemented) {
            return new UnsupportedOperationException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.NotAllowed) {
            return new UnsupportedOperationException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.PARTITION_NOT_OWNED_ERROR) {
            return new EventHubException(false, errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.STORE_LOCK_LOST_ERROR) {
            return new EventHubException(false, errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.AmqpLinkDetachForced) {
            return new EventHubException(true, (Throwable)new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == AmqpErrorCode.ResourceLimitExceeded) {
            return new QuotaExceededException(new AmqpException(errorCondition));
        }
        return new EventHubException(true, errorCondition.getDescription());
    }

    static Exception amqpResponseCodeToException(int statusCode, String statusDescription) {
        AmqpResponseCode amqpResponseCode = AmqpResponseCode.valueOf(statusCode);
        if (amqpResponseCode == null) {
            return new EventHubException(true, String.format("Put token failed. status-code: %s, status-description: %s", statusCode, statusDescription));
        }
        switch (amqpResponseCode) {
            case BAD_REQUEST: {
                return new IllegalArgumentException(String.format("Put token failed. status-code: %s, status-description: %s", statusCode, statusDescription));
            }
            case NOT_FOUND: {
                return new IllegalEntityException(statusDescription);
            }
            case FORBIDDEN: {
                return new QuotaExceededException(String.format("Put token failed. status-code: %s, status-description: %s", statusCode, statusDescription));
            }
            case UNAUTHORIZED: {
                return new AuthorizationFailedException(String.format("Put token failed. status-code: %s, status-description: %s", statusCode, statusDescription));
            }
        }
        return new EventHubException(true, String.format("Put token failed. status-code: %s, status-description: %s", statusCode, statusDescription));
    }

    static <T> void completeExceptionally(CompletableFuture<T> future, Exception exception, ErrorContextProvider contextProvider) {
        if (exception != null && exception instanceof EventHubException) {
            ErrorContext errorContext = contextProvider.getContext();
            ((EventHubException)exception).setContext(errorContext);
        }
        future.completeExceptionally(exception);
    }

    static boolean isGeneralSendError(Symbol amqpError) {
        return amqpError == ClientConstants.SERVER_BUSY_ERROR || amqpError == ClientConstants.TIMEOUT_ERROR || amqpError == AmqpErrorCode.ResourceLimitExceeded;
    }

    static String getTrackingIDAndTimeToLog() {
        return String.format(Locale.US, "TrackingId: %s, at: %s", UUID.randomUUID().toString(), ZonedDateTime.now());
    }

    public static String toStackTraceString(Throwable exception, String customErrorMessage) {
        Throwable innerException;
        StringBuilder builder = new StringBuilder();
        if (!StringUtil.isNullOrEmpty(customErrorMessage)) {
            builder.append(customErrorMessage);
            builder.append(System.lineSeparator());
        }
        builder.append(exception.getMessage());
        StackTraceElement[] stackTraceElements = exception.getStackTrace();
        if (stackTraceElements != null) {
            for (StackTraceElement ste : stackTraceElements) {
                builder.append(System.lineSeparator());
                builder.append(ste.toString());
            }
        }
        if ((innerException = exception.getCause()) != null) {
            builder.append("Cause: " + innerException.getMessage());
            StackTraceElement[] innerStackTraceElements = innerException.getStackTrace();
            if (innerStackTraceElements != null) {
                for (StackTraceElement ste : innerStackTraceElements) {
                    builder.append(System.lineSeparator());
                    builder.append(ste.toString());
                }
            }
        }
        return builder.toString();
    }

    public static Throwable getExceptionFromCompletedFuture(CompletableFuture<?> exceptionallyCompletedFuture) {
        try {
            exceptionallyCompletedFuture.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable cause = exception.getCause();
            return cause == null ? exception : cause;
        }
        catch (Exception exception) {
            return exception;
        }
        return null;
    }

    private static void handle(Exception exception) throws EventHubException {
        Throwable throwable;
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if ((throwable = exception.getCause()) instanceof EventHubException) {
            throw (EventHubException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
        throw new RuntimeException(exception);
    }

    public static <T> T sync(SyncFactory<T> factory) throws EventHubException {
        try {
            return factory.execute();
        }
        catch (InterruptedException | ExecutionException exception) {
            ExceptionUtil.handle(exception);
            return null;
        }
    }

    public static <T> T syncWithIOException(SyncFactoryWithIOException<T> factory) throws IOException, EventHubException {
        try {
            return factory.execute();
        }
        catch (InterruptedException | ExecutionException exception) {
            ExceptionUtil.handle(exception);
            return null;
        }
    }

    public static void syncVoid(SyncFactoryVoid factory) throws EventHubException {
        try {
            factory.execute();
        }
        catch (InterruptedException | ExecutionException exception) {
            ExceptionUtil.handle(exception);
        }
    }

    public static <T> T syncWithIllegalArgException(SyncFactoryWithIllegalArgException<T> factory) throws EventHubException {
        try {
            return factory.execute();
        }
        catch (InterruptedException | ExecutionException exception) {
            ExceptionUtil.handle(exception);
            return null;
        }
    }

    @FunctionalInterface
    public static interface SyncFactoryWithIllegalArgException<T> {
        public T execute() throws IllegalArgumentException, EventHubException, ExecutionException, InterruptedException;
    }

    @FunctionalInterface
    public static interface SyncFactoryVoid {
        public void execute() throws EventHubException, ExecutionException, InterruptedException;
    }

    @FunctionalInterface
    public static interface SyncFactoryWithIOException<T> {
        public T execute() throws IOException, EventHubException, ExecutionException, InterruptedException;
    }

    @FunctionalInterface
    public static interface SyncFactory<T> {
        public T execute() throws EventHubException, ExecutionException, InterruptedException;
    }
}

