/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.attribute.KeyObjectAttributeExtractor;
import net.sf.ehcache.search.attribute.ValueObjectAttributeExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Searchable {
    private final Map<String, SearchAttribute> searchAttributes = new HashMap<String, SearchAttribute>();
    private boolean frozen;

    public Searchable() {
        this.addDefaultKeyValueAttributes();
    }

    private void addDefaultKeyValueAttributes() {
        String keyAttr = Query.KEY.getAttributeName();
        this.searchAttributes.put(keyAttr, new SearchAttribute().name(keyAttr).className(KeyObjectAttributeExtractor.class.getName()));
        String valueAttr = Query.VALUE.getAttributeName();
        this.searchAttributes.put(valueAttr, new SearchAttribute().name(valueAttr).className(ValueObjectAttributeExtractor.class.getName()));
    }

    public void addSearchAttribute(SearchAttribute searchAttribute) throws InvalidConfigurationException {
        this.checkDynamicChange();
        String attributeName = searchAttribute.getName();
        if (attributeName == null) {
            throw new InvalidConfigurationException("Search attribute has null name");
        }
        this.disallowBuiltins(attributeName);
        if (this.searchAttributes.containsKey(attributeName)) {
            throw new InvalidConfigurationException("Repeated searchAttribute name: " + attributeName);
        }
        this.searchAttributes.put(attributeName, searchAttribute);
    }

    private void disallowBuiltins(String attributeName) {
        if (Query.KEY.getAttributeName().equals(attributeName) || Query.VALUE.getAttributeName().equals(attributeName)) {
            throw new InvalidConfigurationException("\"" + attributeName + "\" is a reserved attribute name");
        }
    }

    private void checkDynamicChange() {
        if (this.frozen) {
            throw new CacheException("Dynamic configuration changes are disabled for this cache");
        }
    }

    public Map<String, SearchAttribute> getSearchAttributes() {
        return Collections.unmodifiableMap(this.searchAttributes);
    }

    public Searchable searchAttribute(SearchAttribute searchAttribute) {
        this.addSearchAttribute(searchAttribute);
        return this;
    }

    public void freezeConfiguration() {
        this.frozen = true;
    }

    public Map<String, SearchAttribute> getUserDefinedSearchAttributes() {
        HashMap<String, SearchAttribute> copy = new HashMap<String, SearchAttribute>(this.searchAttributes);
        copy.remove(Query.KEY.getAttributeName());
        copy.remove(Query.VALUE.getAttributeName());
        return copy;
    }
}

