/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import net.sf.ehcache.transaction.AbstractTransactionStore;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.TransactionAwareAttributeExtractor;
import net.sf.ehcache.transaction.TransactionException;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.transaction.TransactionInterruptedException;
import net.sf.ehcache.transaction.TransactionTimeoutException;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import net.sf.ehcache.transaction.xa.EhcacheXAResourceImpl;
import net.sf.ehcache.transaction.xa.XAExecutionListener;
import net.sf.ehcache.transaction.xa.XATransactionContext;
import net.sf.ehcache.transaction.xa.commands.StorePutCommand;
import net.sf.ehcache.transaction.xa.commands.StoreRemoveCommand;
import net.sf.ehcache.util.LargeSet;
import net.sf.ehcache.util.SetWrapperList;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XATransactionStore
extends AbstractTransactionStore {
    private static final Logger LOG = LoggerFactory.getLogger(XATransactionStore.class.getName());
    private static final long MILLISECOND_PER_SECOND = 1000L;
    private final TransactionManagerLookup transactionManagerLookup;
    private final TransactionIDFactory transactionIdFactory;
    private final SoftLockFactory softLockFactory;
    private final Ehcache cache;
    private final ReadWriteCopyStrategy<Element> copyStrategy;
    private final ConcurrentHashMap<Transaction, EhcacheXAResource> transactionToXAResourceMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Transaction, Long> transactionToTimeoutMap = new ConcurrentHashMap();

    public XATransactionStore(TransactionManagerLookup transactionManagerLookup, SoftLockFactory softLockFactory, TransactionIDFactory transactionIdFactory, Ehcache cache, Store store, ReadWriteCopyStrategy<Element> copyStrategy) {
        super(store);
        this.transactionManagerLookup = transactionManagerLookup;
        this.transactionIdFactory = transactionIdFactory;
        if (transactionManagerLookup.getTransactionManager() == null) {
            throw new TransactionException("no JTA transaction manager could be located, cannot bind twopc cache with JTA");
        }
        this.softLockFactory = softLockFactory;
        this.cache = cache;
        this.copyStrategy = copyStrategy;
    }

    private Transaction getCurrentTransaction() throws SystemException {
        Transaction transaction = this.transactionManagerLookup.getTransactionManager().getTransaction();
        if (transaction == null) {
            throw new TransactionException("JTA transaction not started");
        }
        return transaction;
    }

    public EhcacheXAResourceImpl getOrCreateXAResource() throws SystemException {
        Transaction transaction = this.getCurrentTransaction();
        EhcacheXAResourceImpl xaResource = (EhcacheXAResourceImpl)this.transactionToXAResourceMap.get(transaction);
        if (xaResource == null) {
            LOG.debug("creating new XAResource");
            xaResource = new EhcacheXAResourceImpl(this.cache, this.underlyingStore, this.transactionManagerLookup, this.softLockFactory, this.transactionIdFactory);
            this.transactionToXAResourceMap.put(transaction, xaResource);
            xaResource.addTwoPcExecutionListener(new CleanupXAResource(this.getCurrentTransaction()));
        }
        return xaResource;
    }

    private XATransactionContext getTransactionContext() {
        try {
            Transaction transaction = this.getCurrentTransaction();
            EhcacheXAResourceImpl xaResource = (EhcacheXAResourceImpl)this.transactionToXAResourceMap.get(transaction);
            if (xaResource == null) {
                return null;
            }
            XATransactionContext transactionContext = xaResource.getCurrentTransactionContext();
            if (transactionContext == null) {
                this.transactionManagerLookup.register(xaResource);
                LOG.debug("creating new XA context");
                transactionContext = xaResource.createTransactionContext();
                xaResource.addTwoPcExecutionListener(new UnregisterXAResource());
            } else {
                transactionContext = xaResource.getCurrentTransactionContext();
            }
            LOG.debug("using XA context {}", (Object)transactionContext);
            return transactionContext;
        }
        catch (SystemException e) {
            throw new TransactionException("cannot get the current transaction", e);
        }
        catch (RollbackException e) {
            throw new TransactionException("transaction rolled back", e);
        }
    }

    private XATransactionContext getOrCreateTransactionContext() {
        try {
            EhcacheXAResourceImpl xaResource = this.getOrCreateXAResource();
            XATransactionContext transactionContext = xaResource.getCurrentTransactionContext();
            if (transactionContext == null) {
                this.transactionManagerLookup.register(xaResource);
                LOG.debug("creating new XA context");
                transactionContext = xaResource.createTransactionContext();
                xaResource.addTwoPcExecutionListener(new UnregisterXAResource());
            } else {
                transactionContext = xaResource.getCurrentTransactionContext();
            }
            LOG.debug("using XA context {}", (Object)transactionContext);
            return transactionContext;
        }
        catch (SystemException e) {
            throw new TransactionException("cannot get the current transaction", e);
        }
        catch (RollbackException e) {
            throw new TransactionException("transaction rolled back", e);
        }
    }

    private long assertNotTimedOut() {
        try {
            if (Thread.interrupted()) {
                throw new TransactionInterruptedException("transaction interrupted");
            }
            Transaction transaction = this.getCurrentTransaction();
            EhcacheXAResource xaResource = this.transactionToXAResourceMap.get(transaction);
            Long timeoutTimestamp = this.transactionToTimeoutMap.get(transaction);
            if (xaResource != null && timeoutTimestamp == null) {
                int xaResourceTimeout = xaResource.getTransactionTimeout();
                timeoutTimestamp = System.currentTimeMillis() + (long)xaResourceTimeout * 1000L;
                this.transactionToTimeoutMap.put(transaction, timeoutTimestamp);
            } else if (timeoutTimestamp == null) {
                timeoutTimestamp = System.currentTimeMillis() + 30000L;
                this.transactionToTimeoutMap.put(transaction, timeoutTimestamp);
            }
            if (timeoutTimestamp <= System.currentTimeMillis()) {
                throw new TransactionTimeoutException("transaction timed out");
            }
            return timeoutTimestamp - System.currentTimeMillis();
        }
        catch (SystemException e) {
            throw new TransactionException("cannot get the current transaction", e);
        }
        catch (XAException e) {
            throw new TransactionException("cannot get the XAResource transaction timeout", e);
        }
    }

    private Element copyElementForWrite(Element element) {
        return this.copyStrategy.copyForWrite(element);
    }

    private Element copyElementForRead(Element element) {
        return this.copyStrategy.copyForRead(element);
    }

    @Override
    public Element get(Object key) {
        Element element;
        LOG.debug("cache {} get {}", (Object)this.cache.getName(), key);
        XATransactionContext context = this.getTransactionContext();
        if (context == null) {
            element = this.getQuietFromUnderlyingStore(key);
        } else {
            element = context.get(key);
            if (element == null && !context.isRemoved(key)) {
                element = this.getFromUnderlyingStore(key);
            }
        }
        return this.copyElementForRead(element);
    }

    @Override
    public Element getQuiet(Object key) {
        Element element;
        LOG.debug("cache {} getQuiet {}", (Object)this.cache.getName(), key);
        XATransactionContext context = this.getTransactionContext();
        if (context == null) {
            element = this.getQuietFromUnderlyingStore(key);
        } else {
            element = context.get(key);
            if (element == null && !context.isRemoved(key)) {
                element = this.getQuietFromUnderlyingStore(key);
            }
        }
        return this.copyElementForRead(element);
    }

    @Override
    public int getSize() {
        LOG.debug("cache {} getSize", (Object)this.cache.getName());
        XATransactionContext context = this.getOrCreateTransactionContext();
        int size = this.underlyingStore.getSize();
        return size + context.getSizeModifier();
    }

    @Override
    public int getTerracottaClusteredSize() {
        LOG.debug("cache {} getTerracottaClusteredSize", (Object)this.cache.getName());
        XATransactionContext context = this.getOrCreateTransactionContext();
        int size = this.underlyingStore.getSize();
        return size + context.getSizeModifier();
    }

    @Override
    public boolean containsKey(Object key) {
        LOG.debug("cache {} containsKey", (Object)this.cache.getName(), key);
        XATransactionContext context = this.getOrCreateTransactionContext();
        return !context.isRemoved(key) && (context.getAddedKeys().contains(key) || this.underlyingStore.containsKey(key));
    }

    @Override
    public List getKeys() {
        LOG.debug("cache {} getKeys", (Object)this.cache.getName());
        XATransactionContext context = this.getOrCreateTransactionContext();
        LargeSet<Object> keys = new LargeSet<Object>(){

            @Override
            public int sourceSize() {
                return XATransactionStore.this.underlyingStore.getSize();
            }

            @Override
            public Iterator<Object> sourceIterator() {
                return XATransactionStore.this.underlyingStore.getKeys().iterator();
            }
        };
        keys.addAll(context.getAddedKeys());
        keys.removeAll(context.getRemovedKeys());
        return new SetWrapperList(keys);
    }

    private Element getFromUnderlyingStore(Object key) {
        Element element;
        while (true) {
            long timeLeft = this.assertNotTimedOut();
            LOG.debug("cache {} underlying.get key {} not timed out, time left: " + timeLeft, (Object)this.cache.getName(), key);
            element = this.underlyingStore.get(key);
            if (element == null) {
                return null;
            }
            Object value = element.getObjectValue();
            if (!(value instanceof SoftLock)) break;
            SoftLock softLock = (SoftLock)value;
            try {
                LOG.debug("cache {} key {} soft locked, awaiting unlock...", (Object)this.cache.getName(), key);
                boolean gotLock = softLock.tryLock(timeLeft);
                if (!gotLock) continue;
                softLock.clearTryLock();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return element;
    }

    private Element getQuietFromUnderlyingStore(Object key) {
        Element element;
        while (true) {
            long timeLeft = this.assertNotTimedOut();
            LOG.debug("cache {} underlying.getQuiet key {} not timed out, time left: " + timeLeft, (Object)this.cache.getName(), key);
            element = this.underlyingStore.getQuiet(key);
            if (element == null) {
                return null;
            }
            Object value = element.getObjectValue();
            if (!(value instanceof SoftLock)) break;
            SoftLock softLock = (SoftLock)value;
            try {
                LOG.debug("cache {} key {} soft locked, awaiting unlock...", (Object)this.cache.getName(), key);
                boolean gotLock = softLock.tryLock(timeLeft);
                if (!gotLock) continue;
                softLock.clearTryLock();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return element;
    }

    private Element getCurrentElement(Object key, XATransactionContext context) {
        Element previous = context.get(key);
        if (previous == null && !context.isRemoved(key)) {
            previous = this.getQuietFromUnderlyingStore(key);
        }
        return previous;
    }

    @Override
    public boolean put(Element element) throws CacheException {
        LOG.debug("cache {} put {}", (Object)this.cache.getName(), (Object)element);
        Element oldElement = this.getQuietFromUnderlyingStore(element.getObjectKey());
        return this.internalPut(new StorePutCommand(oldElement, this.copyElementForWrite(element)));
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        LOG.debug("cache {} putWithWriter {}", (Object)this.cache.getName(), (Object)element);
        Element oldElement = this.getQuietFromUnderlyingStore(element.getObjectKey());
        if (writerManager != null) {
            writerManager.put(element);
        } else {
            this.cache.getWriterManager().put(element);
        }
        return this.internalPut(new StorePutCommand(oldElement, this.copyElementForWrite(element)));
    }

    private boolean internalPut(StorePutCommand putCommand) {
        boolean isNull;
        Element element = putCommand.getElement();
        if (element == null) {
            return true;
        }
        XATransactionContext context = this.getOrCreateTransactionContext();
        boolean bl = isNull = this.underlyingStore.get(element.getKey()) == null;
        if (isNull) {
            isNull = context.get(element.getKey()) == null;
        }
        context.addCommand(putCommand, element);
        return isNull;
    }

    @Override
    public Element remove(Object key) {
        LOG.debug("cache {} remove {}", (Object)this.cache.getName(), key);
        Element oldElement = this.getQuietFromUnderlyingStore(key);
        return this.removeInternal(new StoreRemoveCommand(key, oldElement));
    }

    private Element removeInternal(StoreRemoveCommand command) {
        Element element = command.getEntry().getElement();
        this.getOrCreateTransactionContext().addCommand(command, element);
        return this.copyElementForRead(element);
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        LOG.debug("cache {} removeWithWriter {}", (Object)this.cache.getName(), key);
        Element oldElement = this.getQuietFromUnderlyingStore(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, null));
        } else {
            this.cache.getWriterManager().remove(new CacheEntry(key, null));
        }
        return this.removeInternal(new StoreRemoveCommand(key, oldElement));
    }

    @Override
    public void removeAll() throws CacheException {
        LOG.debug("cache {} removeAll", (Object)this.cache.getName());
        List keys = this.getKeys();
        for (Object key : keys) {
            this.remove(key);
        }
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        LOG.debug("cache {} putIfAbsent {}", (Object)this.cache.getName(), (Object)element);
        XATransactionContext context = this.getOrCreateTransactionContext();
        Element previous = this.getCurrentElement(element.getObjectKey(), context);
        if (previous == null) {
            Element oldElement = this.getQuietFromUnderlyingStore(element.getObjectKey());
            Element elementForWrite = this.copyElementForWrite(element);
            context.addCommand(new StorePutCommand(oldElement, elementForWrite), elementForWrite);
        }
        return this.copyElementForRead(previous);
    }

    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        LOG.debug("cache {} removeElement {}", (Object)this.cache.getName(), (Object)element);
        XATransactionContext context = this.getOrCreateTransactionContext();
        Element previous = this.getCurrentElement(element.getKey(), context);
        Element elementForWrite = this.copyElementForWrite(element);
        if (previous != null && comparator.equals(previous, elementForWrite)) {
            Element oldElement = this.getQuietFromUnderlyingStore(element.getObjectKey());
            context.addCommand(new StoreRemoveCommand(element.getObjectKey(), oldElement), elementForWrite);
            return this.copyElementForRead(previous);
        }
        return null;
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        LOG.debug("cache {} replace2 {}", (Object)this.cache.getName(), (Object)element);
        XATransactionContext context = this.getOrCreateTransactionContext();
        Element previous = this.getCurrentElement(element.getKey(), context);
        boolean replaced = false;
        if (previous != null && comparator.equals(previous, this.copyElementForWrite(old))) {
            Element oldElement = this.getQuietFromUnderlyingStore(element.getObjectKey());
            Element elementForWrite = this.copyElementForWrite(element);
            context.addCommand(new StorePutCommand(oldElement, elementForWrite), elementForWrite);
            replaced = true;
        }
        return replaced;
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        LOG.debug("cache {} replace1 {}", (Object)this.cache.getName(), (Object)element);
        XATransactionContext context = this.getOrCreateTransactionContext();
        Element previous = this.getCurrentElement(element.getKey(), context);
        if (previous != null) {
            Element oldElement = this.getQuietFromUnderlyingStore(element.getObjectKey());
            Element elementForWrite = this.copyElementForWrite(element);
            context.addCommand(new StorePutCommand(oldElement, elementForWrite), elementForWrite);
        }
        return this.copyElementForRead(previous);
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        HashMap<String, AttributeExtractor> wrappedExtractors = new HashMap<String, AttributeExtractor>(extractors.size());
        for (Map.Entry<String, AttributeExtractor> e : extractors.entrySet()) {
            wrappedExtractors.put(e.getKey(), new TransactionAwareAttributeExtractor(this.copyStrategy, e.getValue()));
        }
        this.underlyingStore.setAttributeExtractors(wrappedExtractors);
    }

    private final class UnregisterXAResource
    implements XAExecutionListener {
        private UnregisterXAResource() {
        }

        public void beforePrepare(EhcacheXAResource xaResource) {
        }

        public void afterCommitOrRollback(EhcacheXAResource xaResource) {
            XATransactionStore.this.transactionManagerLookup.unregister(xaResource);
        }
    }

    private final class CleanupXAResource
    implements XAExecutionListener {
        private final Transaction transaction;

        private CleanupXAResource(Transaction transaction) {
            this.transaction = transaction;
        }

        public void beforePrepare(EhcacheXAResource xaResource) {
        }

        public void afterCommitOrRollback(EhcacheXAResource xaResource) {
            XATransactionStore.this.transactionToXAResourceMap.remove(this.transaction);
            XATransactionStore.this.transactionToTimeoutMap.remove(this.transaction);
        }
    }
}

