/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.HeadersProviderFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class HeadersFrame
extends HeadersProviderFrame {
    private static final ThreadCache.CachedTypeIndex<HeadersFrame> CACHE_IDX = ThreadCache.obtainIndex(HeadersFrame.class, 8);
    public static final int TYPE = 8;
    public static final byte FLAG_FIN = 1;
    private int streamId;

    private HeadersFrame() {
    }

    static HeadersFrame create() {
        HeadersFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new HeadersFrame();
        }
        return frame;
    }

    static HeadersFrame create(SpdyHeader header) {
        HeadersFrame frame = HeadersFrame.create();
        frame.initialize(header);
        frame.streamId = header.buffer.getInt() & Integer.MAX_VALUE;
        return frame;
    }

    public static HeadersFrameBuilder builder() {
        return new HeadersFrameBuilder();
    }

    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public void recycle() {
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Object buffer = memoryManager.allocate(12);
        buffer.putInt(-2147287032);
        buffer.putInt(this.flags << 24 | this.compressedHeaders.remaining() + 4);
        buffer.putInt(this.streamId & Integer.MAX_VALUE);
        buffer.trim();
        CompositeBuffer cb = CompositeBuffer.newBuffer(memoryManager, new Buffer[]{buffer});
        cb.append(this.compressedHeaders);
        cb.allowBufferDispose(true);
        cb.allowInternalBuffersDispose(true);
        return cb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HeadersFrame");
        sb.append("{streamId=").append(this.streamId);
        sb.append(", compressedHeaders=").append(this.compressedHeaders);
        sb.append(", fin=").append(this.isFlagSet((byte)1));
        sb.append('}');
        return sb.toString();
    }

    public static class HeadersFrameBuilder
    extends HeadersProviderFrame.HeadersProviderFrameBuilder<HeadersFrameBuilder> {
        private final HeadersFrame headersFrame;

        protected HeadersFrameBuilder() {
            super(HeadersFrame.create());
            this.headersFrame = (HeadersFrame)this.frame;
        }

        public HeadersFrameBuilder streamId(int streamId) {
            this.headersFrame.streamId = streamId;
            return this;
        }

        public HeadersFrameBuilder last(boolean last) {
            if (last) {
                this.headersFrame.setFlag((byte)1);
            }
            return this;
        }

        public HeadersFrame build() {
            return this.headersFrame;
        }

        @Override
        protected HeadersFrameBuilder getThis() {
            return this;
        }
    }
}

