/*
 * Decompiled with CFR 0.152.
 */
package com.projity.algorithm.buffer;

import com.projity.algorithm.buffer.CalculatedValues;
import com.projity.algorithm.buffer.Point;
import com.projity.algorithm.buffer.SeriesCallback;
import com.projity.pm.calendar.WorkCalendar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.ListIterator;

public class GroupedCalculatedValues
implements CalculatedValues,
Serializable {
    static final long serialVersionUID = 8900927827L;
    ArrayList values = new ArrayList();
    double yScale;
    private static final Double ZERO = new Double(0.0);

    public GroupedCalculatedValues(double d) {
        this.yScale = d;
    }

    public GroupedCalculatedValues() {
        this(1.0);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void set(int n, long l, long l2, double d, WorkCalendar workCalendar) {
        if (l == 0L) {
            return;
        }
        if (n > this.values.size() - 1) {
            this.values.add(n, new Point(l, d));
        } else {
            Point point = (Point)this.values.get(n);
            if (point == null) {
                this.values.set(n, new Point(l, d));
            } else {
                point.addValue(d);
            }
        }
    }

    @Override
    public Long getDate(int n) {
        Point point = (Point)this.values.get(n);
        if (point == null) {
            return null;
        }
        return new Long(point.date);
    }

    public void setValue(int n, double d) {
        Point point = (Point)this.values.get(n);
        if (point == null) {
            return;
        }
        point.value = d;
    }

    public final double getUnscaledValue(int n) {
        if (this.values.isEmpty()) {
            System.out.println("empty values in GroupedCalculatedValues");
            return 0.0;
        }
        if (n >= this.values.size()) {
            System.out.println("index out of bounds in GroupedCalculatedValues " + n);
            return 0.0;
        }
        Point point = (Point)this.values.get(n);
        if (point == null) {
            return 0.0;
        }
        return point.value;
    }

    @Override
    public Double getValue(int n) {
        if (this.values.isEmpty()) {
            System.out.println("empty values in GroupedCalculatedValues");
            return ZERO;
        }
        if (n >= this.values.size()) {
            System.out.println("index out of bounds in GroupedCalculatedValues " + n);
            return ZERO;
        }
        Point point = (Point)this.values.get(n);
        if (point == null) {
            return null;
        }
        return new Double(point.value / this.yScale);
    }

    @Override
    public void makeSeries(boolean bl, SeriesCallback seriesCallback) {
        Long[] longArray = new Long[this.values.size()];
        Double[] doubleArray = new Double[this.values.size()];
        Point point = null;
        double d = 0.0;
        for (int i = 0; i < this.values.size(); ++i) {
            point = (Point)this.values.get(i);
            seriesCallback.add(i, point.date, point.value + (bl ? d : 0.0));
            d += point.value;
        }
    }

    @Override
    public void makeRectilinearSeries(SeriesCallback seriesCallback) {
        double d = 0.0;
        for (int i = 0; i < this.values.size(); ++i) {
            Point point = (Point)this.values.get(i);
            seriesCallback.add(2 * i, point.getDate(), d);
            d = point.getValue();
            seriesCallback.add(2 * i + 1, point.getDate(), d);
        }
    }

    @Override
    public void makeCumulative(boolean bl) {
        double d = 0.0;
        for (int i = 0; i < this.values.size(); ++i) {
            Point point = (Point)this.values.get(i);
            if (bl) {
                point.value = d += point.value;
                continue;
            }
            point.value -= d;
            d += point.value;
        }
    }

    @Override
    public void dump() {
        for (int i = 0; i < this.values.size(); ++i) {
            System.out.println(i + " " + new Date(this.getDate(i)) + " " + this.getValue(i));
        }
    }

    public ListIterator iterator(int n) {
        return this.values.listIterator(n);
    }

    public static GroupedCalculatedValues union(GroupedCalculatedValues groupedCalculatedValues, GroupedCalculatedValues groupedCalculatedValues2) {
        GroupedCalculatedValues groupedCalculatedValues3;
        GroupedCalculatedValues groupedCalculatedValues4;
        if (groupedCalculatedValues.size() >= groupedCalculatedValues2.size()) {
            groupedCalculatedValues4 = groupedCalculatedValues;
            groupedCalculatedValues3 = groupedCalculatedValues2;
        } else {
            groupedCalculatedValues4 = groupedCalculatedValues2;
            groupedCalculatedValues3 = groupedCalculatedValues;
        }
        GroupedCalculatedValues groupedCalculatedValues5 = new GroupedCalculatedValues();
        ListIterator listIterator = groupedCalculatedValues4.values.listIterator();
        ListIterator listIterator2 = groupedCalculatedValues3.values.listIterator();
        Point point = null;
        while (listIterator.hasNext()) {
            Point point2 = (Point)listIterator.next();
            while (listIterator2.hasNext()) {
                point = (Point)listIterator2.next();
                if (point.date < point2.date) {
                    groupedCalculatedValues5.values.add(point);
                    continue;
                }
                if (point.date <= point2.date) break;
                listIterator2.previous();
                break;
            }
            if (point != null && point2.date == point.date) {
                groupedCalculatedValues5.values.add(new Point(point2.date, point2.value + point.value));
                continue;
            }
            groupedCalculatedValues5.values.add(point2);
        }
        while (listIterator2.hasNext()) {
            groupedCalculatedValues5.values.add((Point)listIterator2.next());
        }
        return groupedCalculatedValues5;
    }

    public void mergeIn(GroupedCalculatedValues groupedCalculatedValues) {
        Point point;
        ListIterator listIterator = this.values.listIterator();
        ListIterator listIterator2 = groupedCalculatedValues.values.listIterator();
        Point point2 = listIterator.hasNext() ? (Point)listIterator.next() : null;
        long l = point2.date;
        Point point3 = null;
        Point point4 = point = listIterator2.hasNext() ? (Point)listIterator2.next() : null;
        while (point2 != null && point != null) {
            double d;
            if (point2.compareTo(point) >= 0) {
                if (point.date >= l) {
                    point2.value += point.value;
                    if (point2.date == l && point3 != null && (d = ((double)point.date - (double)l) / (double)(point.date - point3.date)) > 0.0) {
                        point2.value += point3.value * d;
                    }
                }
                point3 = point;
                point = listIterator2.hasNext() ? (Point)listIterator2.next() : null;
                continue;
            }
            if (listIterator.hasNext()) {
                point2 = (Point)listIterator.next();
                continue;
            }
            if (point3 != null && (d = (double)(point2.date - point3.date) / (double)(point.date - point3.date)) > 0.0) {
                point2.value += point.value * d;
            }
            point2 = null;
        }
    }

    public GroupedCalculatedValues dayByDayConvert() {
        GroupedCalculatedValues groupedCalculatedValues = new GroupedCalculatedValues();
        for (Point point : this.values) {
            groupedCalculatedValues.values.add(new Point(point.date, point.value * 3600000.0));
        }
        return groupedCalculatedValues;
    }

    public final ArrayList getValues() {
        return this.values;
    }
}

