/*
 * Decompiled with CFR 0.152.
 */
package com.projity.configuration;

import com.projity.configuration.ChartDefinition;
import com.projity.configuration.ConfigurationReader;
import com.projity.configuration.NamedItem;
import com.projity.configuration.ProvidesDigesterEvents;
import com.projity.configuration.ReportDefinition;
import com.projity.graphic.configuration.ActionLists;
import com.projity.graphic.configuration.BarFormat;
import com.projity.graphic.configuration.BarStyles;
import com.projity.graphic.configuration.CellStyles;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.grouping.core.transform.TransformList;
import com.projity.grouping.core.transform.ViewConfiguration;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.script.ContextStore;
import com.projity.scripting.FormulaFactory;
import com.projity.strings.Messages;
import com.projity.util.ClassUtils;
import com.projity.util.Environment;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.apache.commons.digester.Digester;

public class Dictionary
implements ProvidesDigesterEvents {
    private static Dictionary instance = null;
    private Hashtable mainMap = new Hashtable();
    private static Comparator namedItemComparator = new NamedItemComparator();

    public static synchronized Dictionary getInstance() {
        if (instance == null) {
            String[] stringArray;
            instance = new Dictionary();
            for (String string : stringArray = Messages.getMetaString("DictionaryFiles").split(";")) {
                ConfigurationReader.read(string, instance);
            }
            if (Environment.isClientSide()) {
                Dictionary.precompileCommonFormulas();
            }
        }
        return instance;
    }

    public static void add(NamedItem namedItem) {
        Dictionary.add(namedItem, false);
    }

    public static void add(NamedItem namedItem, boolean bl) {
        String[] stringArray = namedItem.getCategory().split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Hashtable<String, NamedItem> hashtable = (Hashtable<String, NamedItem>)Dictionary.getInstance().mainMap.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable<String, NamedItem>();
                Dictionary.getInstance().mainMap.put(string, hashtable);
            }
            if (!hashtable.contains(namedItem)) {
                hashtable.put(namedItem.getName(), namedItem);
                continue;
            }
            if (!bl) continue;
            hashtable.put(namedItem.getName(), namedItem);
        }
    }

    public static void remove(NamedItem namedItem) {
        String[] stringArray = namedItem.getCategory().split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Hashtable hashtable = (Hashtable)Dictionary.getInstance().mainMap.get(string);
            hashtable.remove(namedItem.getName());
        }
    }

    public static NamedItem get(Object object, String string) {
        Hashtable hashtable = (Hashtable)Dictionary.getInstance().mainMap.get(object);
        if (hashtable == null) {
            return null;
        }
        return (NamedItem)hashtable.get(string);
    }

    public static Object[] getAll(Object object) {
        Hashtable hashtable = (Hashtable)Dictionary.getInstance().mainMap.get(object);
        Object[] objectArray = hashtable.values().toArray();
        Arrays.sort(objectArray, namedItemComparator);
        return objectArray;
    }

    public static Object[] allCalendars() {
        return Dictionary.getAll("Calendar");
    }

    public static WorkCalendar findCalendar(String string) {
        if (string == null) {
            return null;
        }
        return (WorkCalendar)Dictionary.get("Calendar", string);
    }

    @Override
    public void addDigesterEvents(Digester digester) {
        SpreadSheetFieldArray.addDigesterEvents(digester);
        BarFormat.addDigesterEvents(digester);
        BarStyles.addDigesterEvents(digester);
        TransformList.addDigesterEvents(digester);
        CellStyles.addDigesterEvents(digester);
        ActionLists.addDigesterEvents(digester);
        ViewConfiguration.addDigesterEvents(digester);
        ReportDefinition.addDigesterEvents(digester);
        ContextStore.addDigesterEvents(digester);
        ChartDefinition.addDigesterEvents(digester);
    }

    private static void precompileCommonFormulas() {
        FormulaFactory.precompileClass("BarStyle" + Messages.getString("Styles.Bar.standard"));
    }

    public static String generateUniqueName(NamedItem namedItem) {
        String string = namedItem.getName();
        while (Dictionary.get(namedItem.getCategory(), string) != null) {
            string = string + "*";
        }
        return string;
    }

    public static void rename(NamedItem namedItem, String string) {
        Dictionary.remove(namedItem);
        ClassUtils.setSimpleProperty(namedItem, "name", string);
        Dictionary.add(namedItem);
    }

    public static String getCategoryText(String string) {
        return Messages.getString("Category." + string);
    }

    private static class NamedItemComparator
    implements Comparator {
        private NamedItemComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((NamedItem)object).getName().compareTo(((NamedItem)object2).getName());
        }
    }
}

