/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.util;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.projity.configuration.Configuration;
import com.projity.dialog.FieldDialog;
import com.projity.dialog.util.ComponentFactory;
import com.projity.field.Field;
import com.projity.field.ObjectRef;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.grouping.core.model.WalkersNodeModel;
import com.projity.help.HelpUtil;
import com.projity.pm.task.BelongsToDocument;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class FieldComponentMap
implements ObjectRef {
    private Object object;
    private Node node = null;
    private NodeModel nodeModel = null;
    private Collection collection = null;
    private HashMap map = new HashMap();
    private FieldDialog fieldDialog;
    private NodeModelDataFactory dataFactory;

    public FieldComponentMap(Object object) {
        this.object = object;
        this.setDataFactoryFromObject(object);
    }

    public FieldComponentMap(Node node, NodeModel nodeModel) {
        this.node = node;
        this.nodeModel = nodeModel;
        this.dataFactory = nodeModel.getDataFactory();
    }

    public FieldComponentMap(Collection collection) {
        this.collection = collection;
        if (collection != null && collection.size() > 0) {
            this.setDataFactoryFromObject(collection.iterator().next());
        }
    }

    private void setDataFactoryFromObject(Object object) {
        if (object instanceof BelongsToDocument) {
            this.dataFactory = (NodeModelDataFactory)((Object)((BelongsToDocument)object).getDocument());
        }
    }

    public JComponent getComponent(String string, int n) {
        JComponent jComponent = (JComponent)this.map.get(string);
        if (jComponent == null) {
            Field field = Configuration.getFieldFromId(string);
            jComponent = ComponentFactory.componentFor(field, this, n);
            this.map.put(string, jComponent);
        }
        return jComponent;
    }

    public String getLabel(String string) {
        Field field = Configuration.getFieldFromId(string);
        return field.getName();
    }

    public void updateAll() {
        for (String string : this.map.keySet()) {
            Field field = Configuration.getFieldFromId(string);
            JComponent jComponent = this.getComponent(string, 0);
            ComponentFactory.updateValueOfComponent(jComponent, field, this);
        }
    }

    public JComponent append(DefaultFormBuilder defaultFormBuilder, String string) {
        return this.appendField(defaultFormBuilder, string, 0);
    }

    public void append(DefaultFormBuilder defaultFormBuilder, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.appendField(defaultFormBuilder, ((Field)iterator.next()).getId(), 0);
            defaultFormBuilder.nextLine(2);
        }
    }

    public JComponent appendReadOnly(DefaultFormBuilder defaultFormBuilder, String string) {
        return this.appendField(defaultFormBuilder, string, 1);
    }

    public JComponent appendSometimesReadOnly(DefaultFormBuilder defaultFormBuilder, String string) {
        return this.appendField(defaultFormBuilder, string, 2);
    }

    public JComponent appendField(DefaultFormBuilder defaultFormBuilder, String string, int n) {
        Field field = Configuration.getFieldFromId(string);
        if (field == null) {
            return null;
        }
        JComponent jComponent = this.getComponent(string, n);
        if (jComponent instanceof JCheckBox) {
            defaultFormBuilder.append(jComponent);
        } else {
            defaultFormBuilder.append(this.getLabel(string) + ":", (Component)jComponent);
        }
        String string2 = field.getHelp();
        if (string2 != null) {
            HelpUtil.addDocHelp(jComponent, string2);
        }
        return jComponent;
    }

    public JComponent append(DefaultFormBuilder defaultFormBuilder, String string, int n) {
        Field field = Configuration.getFieldFromId(string);
        if (field == null) {
            return null;
        }
        JComponent jComponent = this.getComponent(string, 0);
        boolean bl = jComponent instanceof JCheckBox;
        CellConstraints cellConstraints = new CellConstraints().xyw(defaultFormBuilder.getColumn() + (bl ? 0 : 2), defaultFormBuilder.getRow(), n);
        if (jComponent instanceof JCheckBox) {
            defaultFormBuilder.add((Component)jComponent, cellConstraints);
        } else {
            defaultFormBuilder.addLabel(this.getLabel(string) + ":");
            defaultFormBuilder.nextColumn(2);
            defaultFormBuilder.add((Component)jComponent, cellConstraints);
            defaultFormBuilder.nextColumn(1);
        }
        String string2 = field.getHelp();
        if (string2 != null) {
            HelpUtil.addDocHelp(jComponent, string2);
        }
        return jComponent;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public WalkersNodeModel getNodeModel() {
        return this.nodeModel;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public void setFieldDialog(FieldDialog fieldDialog) {
        this.fieldDialog = fieldDialog;
    }

    @Override
    public NodeModelDataFactory getDataFactory() {
        return this.dataFactory;
    }
}

