/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class CvsVfsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.util.CvsVfsUtil");

    public static VirtualFile findFileByPath(String path) {
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    public static VirtualFile findChild(VirtualFile file, String name) {
        if (file == null) {
            return LocalFileSystem.getInstance().findFileByIoFile(new File(name));
        }
        return file.findChild(name);
    }

    public static VirtualFile getParentFor(File file) {
        return CvsVfsUtil.findFileByIoFile(file.getParentFile());
    }

    public static File getFileFor(VirtualFile file) {
        if (file == null) {
            return null;
        }
        return new File(file.getPath());
    }

    public static File getFileFor(VirtualFile parent, String name) {
        if (parent == null) {
            return new File(name);
        }
        return new File(parent.getPath(), name);
    }

    public static VirtualFile findFileByIoFile(File file) {
        if (file == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public static VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        if (file == null) {
            CvsVfsUtil.$$$reportNull$$$0(0);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @NotNull
    public static VirtualFile[] getChildrenOf(VirtualFile directory) {
        if (!directory.isValid()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                CvsVfsUtil.$$$reportNull$$$0(1);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] children = directory.getChildren();
        VirtualFile[] virtualFileArray = children == null ? VirtualFile.EMPTY_ARRAY : children;
        if (virtualFileArray == null) {
            CvsVfsUtil.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    public static long getTimeStamp(VirtualFile file) {
        return file.getTimeStamp();
    }

    public static boolean isWritable(VirtualFile virtualFile) {
        return virtualFile.isWritable();
    }

    public static String getPresentablePathFor(VirtualFile root) {
        return root.getPresentableUrl();
    }

    public static VirtualFile refreshAndfFindChild(VirtualFile parent, String fileName) {
        return CvsVfsUtil.refreshAndFindFileByIoFile(new File(CvsVfsUtil.getFileFor(parent), fileName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cvsSupport2/util/CvsVfsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cvsSupport2/util/CvsVfsUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

