/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitPreservingProcess;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.LegacySingleAccountActionGroup;
import org.jetbrains.plugins.github.api.GithubApiTaskExecutor;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubRebaseAction
extends LegacySingleAccountActionGroup {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_PERFORM_GITHUB_REBASE = "Can't perform GitHub rebase";

    public GithubRebaseAction() {
        super("Rebase my GitHub fork", "Rebase your GitHub forked repository relative to the origin", AllIcons.Vcs.Vendors.Github);
    }

    @Override
    public void actionPerformed(@NotNull Project project, @Nullable VirtualFile file, @NotNull GitRepository gitRepository, @NotNull GithubAccount account) {
        if (project == null) {
            GithubRebaseAction.$$$reportNull$$$0(0);
        }
        if (gitRepository == null) {
            GithubRebaseAction.$$$reportNull$$$0(1);
        }
        if (account == null) {
            GithubRebaseAction.$$$reportNull$$$0(2);
        }
        BasicAction.saveAll();
        new RebaseTask(project, GithubApiTaskExecutor.getInstance(), Git.getInstance(), gitRepository, account, "upstream/master").queue();
    }

    @Override
    @Nullable
    protected Pair<GitRemote, String> getRemote(@NotNull GithubServerPath server, @NotNull GitRepository repository) {
        if (server == null) {
            GithubRebaseAction.$$$reportNull$$$0(3);
        }
        if (repository == null) {
            GithubRebaseAction.$$$reportNull$$$0(4);
        }
        for (GitRemote gitRemote : repository.getRemotes()) {
            String remoteName = gitRemote.getName();
            if (!"upstream".equals(remoteName)) continue;
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!server.matches(remoteUrl)) continue;
                return Pair.pair((Object)gitRemote, (Object)remoteUrl);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/github/GithubRebaseAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRemote";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class RebaseTask
    extends Task.Backgroundable {
        @NotNull
        private final GithubApiTaskExecutor myApiTaskExecutor;
        @NotNull
        private final Git myGit;
        @NotNull
        private final GitRepository myRepository;
        @NotNull
        private final GithubAccount myAccount;
        @NotNull
        private final String myOnto;

        public RebaseTask(@NotNull Project project, @NotNull GithubApiTaskExecutor apiTaskExecutor, @NotNull Git git, @NotNull GitRepository repository, @NotNull GithubAccount account, String rebaseOnto) {
            if (project == null) {
                RebaseTask.$$$reportNull$$$0(0);
            }
            if (apiTaskExecutor == null) {
                RebaseTask.$$$reportNull$$$0(1);
            }
            if (git == null) {
                RebaseTask.$$$reportNull$$$0(2);
            }
            if (repository == null) {
                RebaseTask.$$$reportNull$$$0(3);
            }
            if (account == null) {
                RebaseTask.$$$reportNull$$$0(4);
            }
            if (rebaseOnto == null) {
                RebaseTask.$$$reportNull$$$0(5);
            }
            super(project, "Rebasing GitHub Fork...");
            this.myApiTaskExecutor = apiTaskExecutor;
            this.myGit = git;
            this.myRepository = repository;
            this.myAccount = account;
            this.myOnto = rebaseOnto;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            String upstreamRemoteUrl;
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(6);
            }
            this.myRepository.update();
            Pair<GitRemote, String> remote = GithubRebaseAction.this.getRemote(this.myAccount.getServer(), this.myRepository);
            String string = upstreamRemoteUrl = remote != null ? (String)remote.second : null;
            if (upstreamRemoteUrl == null) {
                indicator.setText("Configuring upstream remote...");
                LOG.info("Configuring upstream remote");
                upstreamRemoteUrl = this.configureUpstreamRemote(indicator);
                if (upstreamRemoteUrl == null) {
                    return;
                }
            }
            if (this.isUpstreamWithSameUsername(indicator, upstreamRemoteUrl)) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Configured upstream seems to be your own repository: " + upstreamRemoteUrl);
                return;
            }
            LOG.info("Fetching upstream");
            indicator.setText("Fetching upstream...");
            if (!this.fetchParent(indicator)) {
                return;
            }
            LOG.info("Rebasing current branch");
            indicator.setText("Rebasing current branch...");
            this.rebaseCurrentBranch(indicator);
        }

        private boolean isUpstreamWithSameUsername(@NotNull ProgressIndicator indicator, @NotNull String upstreamRemoteUrl) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(7);
            }
            if (upstreamRemoteUrl == null) {
                RebaseTask.$$$reportNull$$$0(8);
            }
            try {
                GithubFullPath userAndRepo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(upstreamRemoteUrl);
                if (userAndRepo == null) {
                    GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't validate upstream remote: " + upstreamRemoteUrl);
                    return true;
                }
                String username = (String)this.myApiTaskExecutor.execute(indicator, this.myAccount, c -> GithubApiUtil.getCurrentUser(c).getLogin());
                return userAndRepo.getUser().equals(username);
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't get user information");
                return true;
            }
        }

        @Nullable
        private GithubFullPath findGithubRepositoryPath() {
            for (GitRemote gitRemote : this.myRepository.getRemotes()) {
                for (String remoteUrl : gitRemote.getUrls()) {
                    GithubFullPath fullPath;
                    if (!this.myAccount.getServer().matches(remoteUrl) || (fullPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl)) == null) continue;
                    return fullPath;
                }
            }
            return null;
        }

        @Nullable
        private String configureUpstreamRemote(@NotNull ProgressIndicator indicator) {
            GithubFullPath fullPath;
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(9);
            }
            if ((fullPath = this.findGithubRepositoryPath()) == null) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Can't find GitHub remote");
                return null;
            }
            GithubRepoDetailed repositoryInfo = this.loadRepositoryInfo(indicator, fullPath);
            if (repositoryInfo == null) {
                return null;
            }
            if (!repositoryInfo.isFork() || repositoryInfo.getParent() == null) {
                GithubNotifications.showWarningURL(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "GitHub repository ", "'" + repositoryInfo.getName() + "'", " is not a fork", repositoryInfo.getHtmlUrl());
                return null;
            }
            String parentRepoUrl = GithubGitHelper.getInstance().getRemoteUrl(this.myAccount.getServer(), fullPath);
            LOG.info("Adding GitHub parent as a remote host");
            indicator.setText("Adding GitHub parent as a remote host...");
            try {
                this.myGit.addRemote(this.myRepository, "upstream", parentRepoUrl).getOutputOrThrow(new int[0]);
            }
            catch (VcsException e) {
                GithubNotifications.showError(this.myProject, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Could not configure \"upstream\" remote:\n" + e.getMessage());
                return null;
            }
            this.myRepository.update();
            return parentRepoUrl;
        }

        @Nullable
        private GithubRepoDetailed loadRepositoryInfo(@NotNull ProgressIndicator indicator, @NotNull GithubFullPath fullPath) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(10);
            }
            if (fullPath == null) {
                RebaseTask.$$$reportNull$$$0(11);
            }
            try {
                return (GithubRepoDetailed)this.myApiTaskExecutor.execute(indicator, this.myAccount, c -> {
                    if (fullPath == null) {
                        RebaseTask.$$$reportNull$$$0(16);
                    }
                    return GithubApiUtil.getDetailedRepoInfo(c, fullPath.getUser(), fullPath.getRepository());
                });
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, "Can't load repository info", e);
                return null;
            }
        }

        private boolean fetchParent(@NotNull ProgressIndicator indicator) {
            GitFetchResult result;
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(12);
            }
            if (!(result = new GitFetcher(this.myProject, indicator, false).fetch(this.myRepository.getRoot(), "upstream", null)).isSuccess()) {
                GitFetcher.displayFetchResult((Project)this.myProject, (GitFetchResult)result, null, (Collection)result.getErrors());
                return false;
            }
            return true;
        }

        private void rebaseCurrentBranch(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(13);
            }
            try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"Rebase");){
                List<VirtualFile> rootsToSave = Collections.singletonList(this.myRepository.getRoot());
                GitPreservingProcess process = new GitPreservingProcess(this.myProject, this.myGit, rootsToSave, "Rebasing", this.myOnto, GitVcsSettings.UpdateChangesPolicy.STASH, indicator, () -> {
                    if (indicator == null) {
                        RebaseTask.$$$reportNull$$$0(15);
                    }
                    this.doRebaseCurrentBranch(indicator);
                });
                process.execute();
            }
        }

        private void doRebaseCurrentBranch(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                RebaseTask.$$$reportNull$$$0(14);
            }
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)this.myProject);
            GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, indicator);
            VirtualFile root = this.myRepository.getRoot();
            GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{this.myOnto});
            GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
            handler.addLineListener((GitLineHandlerListener)rebaseConflictDetector);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
            GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
            handler.addLineListener((GitLineHandlerListener)untrackedFilesDetector);
            handler.addLineListener((GitLineHandlerListener)localChangesDetector);
            handler.addLineListener(GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator));
            String oldText = indicator.getText();
            indicator.setText("Rebasing onto " + this.myOnto + "...");
            GitCommandResult rebaseResult = this.myGit.runCommand(handler);
            indicator.setText(oldText);
            repositoryManager.updateRepository(root);
            if (rebaseResult.success()) {
                root.refresh(false, true);
                GithubNotifications.showInfo(this.myProject, "Success", "Successfully rebased GitHub fork");
            } else {
                GitUpdateResult result = rebaser.handleRebaseFailure(handler, root, rebaseResult, rebaseConflictDetector, (GitMessageWithFilesDetector)untrackedFilesDetector, localChangesDetector);
                if (result == GitUpdateResult.NOTHING_TO_UPDATE || result == GitUpdateResult.SUCCESS || result == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
                    GithubNotifications.showInfo(this.myProject, "Success", "Successfully rebased GitHub fork");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "apiTaskExecutor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "account";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rebaseOnto";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upstreamRemoteUrl";
                    break;
                }
                case 11: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullPath";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/github/GithubRebaseAction$RebaseTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUpstreamWithSameUsername";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureUpstreamRemote";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadRepositoryInfo";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchParent";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rebaseCurrentBranch";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doRebaseCurrentBranch";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$rebaseCurrentBranch$2";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$loadRepositoryInfo$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

