/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.python.run.PyVirtualEnvReader;
import com.jetbrains.python.run.PyVirtualEnvReaderKt;
import com.jetbrains.python.sdk.PyVirtualEnvTerminalSettings;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/sdk/PyVirtualEnvTerminalCustomizer;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "()V", "customizeCommandAndEnvironment", "", "", "project", "Lcom/intellij/openapi/project/Project;", "command", "envs", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;Ljava/util/Map;)[Ljava/lang/String;", "findSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "getDefaultFolder", "intellij.python.terminal"})
public final class PyVirtualEnvTerminalCustomizer
extends LocalTerminalCustomizer {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public String[] customizeCommandAndEnvironment(@NotNull Project project, @NotNull String[] command, @NotNull Map<String, String> envs) {
        void $receiver$iv$iv;
        Object shellPath;
        String path;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull(envs, (String)"envs");
        Sdk sdk = this.findSdk(project);
        if (sdk != null && (PythonSdkType.isVirtualEnv((Sdk)sdk) || PythonSdkType.isCondaVirtualEnv((Sdk)sdk)) && PyVirtualEnvTerminalSettings.Companion.getInstance(project).getVirtualEnvActivate() && (path = sdk.getHomePath()) != null) {
            shellPath = command[0];
            String shellName = new File((String)shellPath).getName();
            if (Intrinsics.areEqual((Object)shellName, (Object)"bash") || SystemInfo.isMac && Intrinsics.areEqual((Object)shellName, (Object)"sh") || Intrinsics.areEqual((Object)shellName, (Object)"zsh") || Intrinsics.areEqual((Object)shellName, (Object)"fish") && PythonSdkType.isVirtualEnv((Sdk)sdk)) {
                Pair pair = PyVirtualEnvReaderKt.findActivateScript((String)path, (String)shellPath);
                if (pair != null) {
                    Pair pair2;
                    Pair activate = pair2 = pair;
                    String pathEnv = (String)EnvironmentUtil.getEnvironmentMap().get("PATH");
                    if (pathEnv != null) {
                        envs.put("PATH", pathEnv);
                    }
                    envs.put("JEDITERM_SOURCE", activate.getSecond() != null ? (String)activate.getFirst() + ' ' + (String)activate.getSecond() : (String)activate.getFirst());
                }
            } else {
                PyVirtualEnvReader reader = new PyVirtualEnvReader(path);
                Pair pair = reader.getActivate();
                if (pair != null) {
                    Map map;
                    void $receiver$iv$iv2;
                    Map $receiver$iv;
                    Pair pair3;
                    Pair it = pair3 = pair;
                    Map $i$a$1$let = reader.readPythonEnv();
                    Map<String, String> map2 = envs;
                    void var13_15 = $receiver$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
                    Iterable $receiver$iv$iv$iv = $receiver$iv$iv2.entrySet();
                    for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                        void it$iv$iv;
                        String string;
                        void k;
                        String string2;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        map = destination$iv$iv;
                        String string3 = string2 = (String)k.getKey();
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3.toUpperCase(), (String)"(this as java.lang.String).toUpperCase()");
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        String string4 = string;
                        Map map3 = map;
                        Object v = it$iv$iv.getValue();
                        map3.put(string4, v);
                    }
                    $receiver$iv = map = destination$iv$iv;
                    LinkedHashMap result$iv = new LinkedHashMap();
                    destination$iv$iv = $receiver$iv;
                    for (Map.Entry entry$iv : destination$iv$iv.entrySet()) {
                        String k = (String)entry$iv.getKey();
                        if (!PyVirtualEnvReader.Companion.getVirtualEnvVars().contains(k)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                    map2.putAll(map);
                }
            }
        }
        Object $receiver$iv = command;
        shellPath = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            void arg = element$iv$iv;
            if (!(Intrinsics.areEqual((Object)arg, (Object)"--login") ^ true && Intrinsics.areEqual((Object)arg, (Object)"-l") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private final Sdk findSdk(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module m : moduleManager.getModules()) {
            Sdk sdk = PythonSdkType.findPythonSdk((Module)m);
            if (sdk == null || PythonSdkType.isRemote((Sdk)sdk)) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    protected String getDefaultFolder(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public UnnamedConfigurable getConfigurable(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return new UnnamedConfigurable(project){
            @NotNull
            private final PyVirtualEnvTerminalSettings settings;
            @NotNull
            private JCheckBox myCheckbox;
            final /* synthetic */ Project $project;

            @NotNull
            public final PyVirtualEnvTerminalSettings getSettings() {
                return this.settings;
            }

            @NotNull
            public final JCheckBox getMyCheckbox() {
                return this.myCheckbox;
            }

            public final void setMyCheckbox(@NotNull JCheckBox jCheckBox) {
                Intrinsics.checkParameterIsNotNull((Object)jCheckBox, (String)"<set-?>");
                this.myCheckbox = jCheckBox;
            }

            @NotNull
            public JCheckBox createComponent() {
                return this.myCheckbox;
            }

            public boolean isModified() {
                return this.myCheckbox.isSelected() != this.settings.getVirtualEnvActivate();
            }

            public void apply() {
                this.settings.setVirtualEnvActivate(this.myCheckbox.isSelected());
            }

            public void reset() {
                this.myCheckbox.setSelected(this.settings.getVirtualEnvActivate());
            }
            {
                this.$project = $captured_local_variable$0;
                this.settings = PyVirtualEnvTerminalSettings.Companion.getInstance($captured_local_variable$0);
                this.myCheckbox = new JCheckBox("Activate virtualenv");
            }
        };
    }
}

