/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.RangeMarkerSpy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.Contract;

class CompletionAssertions {
    CompletionAssertions() {
    }

    static void assertCommitSuccessful(Editor editor, PsiFile psiFile) {
        FileASTNode node;
        boolean committed;
        Document document = editor.getDocument();
        int docLength = document.getTextLength();
        int psiLength = psiFile.getTextLength();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        boolean bl = committed = !manager.isUncommited(document);
        if (docLength == psiLength && committed) {
            return;
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        String message = "unsuccessful commit:";
        message = message + "\nmatching=" + (psiFile == manager.getPsiFile(document));
        message = message + "\ninjectedEditor=" + (editor instanceof EditorWindow);
        message = message + "\ninjectedFile=" + InjectedLanguageManager.getInstance((Project)psiFile.getProject()).isInjectedFragment(psiFile);
        message = message + "\ncommitted=" + committed;
        message = message + "\nfile=" + psiFile.getName();
        message = message + "\nfile class=" + psiFile.getClass();
        message = message + "\nfile.valid=" + psiFile.isValid();
        message = message + "\nfile.physical=" + psiFile.isPhysical();
        message = message + "\nfile.eventSystemEnabled=" + viewProvider.isEventSystemEnabled();
        message = message + "\nlanguage=" + psiFile.getLanguage();
        message = message + "\ndoc.length=" + docLength;
        message = message + "\npsiFile.length=" + psiLength;
        String fileText = psiFile.getText();
        if (fileText != null) {
            message = message + "\npsiFile.text.length=" + fileText.length();
        }
        if ((node = psiFile.getNode()) != null) {
            message = message + "\nnode.length=" + node.getTextLength();
            String nodeText = node.getText();
            message = message + "\nnode.text.length=" + nodeText.length();
        }
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        message = message + "\nvirtualFile=" + virtualFile;
        message = message + "\nvirtualFile.class=" + virtualFile.getClass();
        message = message + "\n" + DebugUtil.currentStackTrace();
        throw new RuntimeExceptionWithAttachments("Commit unsuccessful", message, new Attachment[]{new Attachment(virtualFile.getPath() + "_file.txt", StringUtil.notNullize((String)fileText)), CompletionAssertions.createAstAttachment(psiFile, psiFile), new Attachment("docText.txt", document.getText())});
    }

    static void checkEditorValid(Editor editor) {
        if (!CompletionAssertions.isEditorValid(editor)) {
            throw new AssertionError();
        }
    }

    static boolean isEditorValid(Editor editor) {
        return !(editor instanceof EditorWindow) || ((EditorWindow)editor).isValid();
    }

    private static Attachment createAstAttachment(PsiFile fileCopy, PsiFile originalFile) {
        return new Attachment(originalFile.getViewProvider().getVirtualFile().getPath() + " syntactic tree.txt", DebugUtil.psiToString((PsiElement)fileCopy, false, true));
    }

    private static Attachment createFileTextAttachment(PsiFile fileCopy, PsiFile originalFile) {
        return new Attachment(originalFile.getViewProvider().getVirtualFile().getPath(), fileCopy.getText());
    }

    static void assertInjectedOffsets(int hostStartOffset, PsiFile injected, DocumentWindow documentWindow) {
        assert (documentWindow != null) : "no DocumentWindow for an injected fragment";
        TextRange host = InjectedLanguageManager.getInstance((Project)injected.getProject()).injectedToHost((PsiElement)injected, injected.getTextRange());
        assert (hostStartOffset >= host.getStartOffset()) : "startOffset before injected";
        assert (hostStartOffset <= host.getEndOffset()) : "startOffset after injected";
    }

    static void assertHostInfo(PsiFile hostCopy, OffsetMap hostMap) {
        PsiUtilCore.ensureValid((PsiElement)hostCopy);
        if (hostMap.getOffset(CompletionInitializationContext.START_OFFSET) > hostCopy.getTextLength()) {
            throw new AssertionError((Object)("startOffset outside the host file: " + hostMap.getOffset(CompletionInitializationContext.START_OFFSET) + "; " + hostCopy));
        }
    }

    @Contract(value="_,_,_,null->fail")
    static void assertCompletionPositionPsiConsistent(OffsetsInFile offsets, int offset, PsiFile originalFile, PsiElement insertedElement) {
        PsiFile fileCopy = offsets.getFile();
        if (insertedElement == null) {
            throw new RuntimeExceptionWithAttachments("No element at insertion offset", "offset=" + offset, new Attachment[]{CompletionAssertions.createFileTextAttachment(fileCopy, originalFile), CompletionAssertions.createAstAttachment(fileCopy, originalFile)});
        }
        TextRange range2 = insertedElement.getTextRange();
        CharSequence fileCopyText = fileCopy.getViewProvider().getContents();
        if (range2.getEndOffset() > fileCopyText.length() || !fileCopyText.subSequence(range2.getStartOffset(), range2.getEndOffset()).toString().equals(insertedElement.getText())) {
            throw new RuntimeExceptionWithAttachments("Inconsistent completion tree", "range=" + range2, new Attachment[]{CompletionAssertions.createFileTextAttachment(fileCopy, originalFile), CompletionAssertions.createAstAttachment(fileCopy, originalFile), new Attachment("Element at caret.txt", insertedElement.getText())});
        }
    }

    static void assertCorrectOriginalFile(String prefix, PsiFile file2, PsiFile copy) {
        if (copy.getOriginalFile() != file2) {
            throw new AssertionError((Object)(prefix + " copied file doesn't have correct original: noOriginal=" + (copy.getOriginalFile() == copy) + "\n file " + CompletionAssertions.fileInfo(file2) + "\n copy " + CompletionAssertions.fileInfo(copy)));
        }
    }

    private static String fileInfo(PsiFile file2) {
        return file2 + " of " + file2.getClass() + " in " + file2.getViewProvider() + ", languages=" + file2.getViewProvider().getLanguages() + ", physical=" + file2.isPhysical();
    }

    static class WatchingInsertionContext
    extends InsertionContext {
        private RangeMarkerEx tailWatcher;
        Throwable invalidateTrace;
        DocumentEvent killer;
        private RangeMarkerSpy spy;

        public WatchingInsertionContext(OffsetMap offsetMap, PsiFile file2, char completionChar, List<LookupElement> items, Editor editor) {
            super(offsetMap, completionChar, items.toArray(LookupElement.EMPTY_ARRAY), file2, editor, completionChar != '\u0000' && completionChar != '\t' && completionChar != '\n');
        }

        public void setTailOffset(int offset) {
            super.setTailOffset(offset);
            this.watchTail(offset);
        }

        private void watchTail(int offset) {
            this.stopWatching();
            this.tailWatcher = (RangeMarkerEx)this.getDocument().createRangeMarker(offset, offset);
            if (!this.tailWatcher.isValid()) {
                throw new AssertionError((Object)(this.getDocument() + "; offset=" + offset));
            }
            this.tailWatcher.setGreedyToRight(true);
            this.spy = new RangeMarkerSpy(this.tailWatcher){

                @Override
                protected void invalidated(DocumentEvent e) {
                    if (invalidateTrace == null) {
                        invalidateTrace = new Throwable();
                        killer = e;
                    }
                }
            };
            this.getDocument().addDocumentListener((DocumentListener)this.spy);
        }

        void stopWatching() {
            if (this.tailWatcher != null) {
                this.getDocument().removeDocumentListener((DocumentListener)this.spy);
                this.tailWatcher.dispose();
            }
        }

        public int getTailOffset() {
            if (!this.getOffsetMap().containsOffset(TAIL_OFFSET) && this.invalidateTrace != null) {
                throw new RuntimeExceptionWithAttachments("Tail offset invalid", new Attachment[]{new Attachment("invalidated", this.invalidateTrace)});
            }
            int offset = super.getTailOffset();
            if (this.tailWatcher.getStartOffset() != this.tailWatcher.getEndOffset() && offset > 0) {
                this.watchTail(offset);
            }
            return offset;
        }
    }
}

