/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEqTypedHandler
extends TypedHandlerDelegate {
    private boolean needToInsertQuotes = false;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (project == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(3);
        }
        if (c == '=' && WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file2, false);
            if (atParent instanceof XmlAttribute && ((XmlAttribute)atParent).getValueElement() == null) {
                this.needToInsertQuotes = ((XmlAttribute)atParent).getValueElement() == null;
            }
        }
        TypedHandlerDelegate.Result result2 = super.beforeCharTyped(c, project, editor, file2, fileType);
        if (result2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(4);
        }
        return result2;
    }

    @Nullable
    private static PsiElement getAttributeCandidate(@NotNull Editor editor, @NotNull PsiFile file2, boolean typed) {
        int newOffset;
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(6);
        }
        if ((newOffset = editor.getCaretModel().getOffset() - (typed ? 2 : 1)) < 0) {
            return null;
        }
        PsiElement at = file2.findElementAt(newOffset);
        return at != null ? at.getParent() : null;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(9);
        }
        if (this.needToInsertQuotes) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement fileContext = file2.getContext();
            String toInsert = XmlEqTypedHandler.tryCompleteQuotes(fileContext);
            boolean showPopup = true;
            if (toInsert == null) {
                String quote = XmlEqTypedHandler.getDefaultQuote(file2);
                XmlExtension.AttributeValuePresentation presentation = XmlEqTypedHandler.getValuePresentation(editor, file2, quote);
                toInsert = presentation.getPrefix() + presentation.getPostfix();
                showPopup = presentation.showAutoPopup();
            }
            editor.getDocument().insertString(offset, (CharSequence)toInsert);
            editor.getCaretModel().moveToOffset(offset + toInsert.length() / 2);
            if (showPopup) {
                AutoPopupController.getInstance(project).scheduleAutoPopup(editor);
            }
            this.needToInsertQuotes = false;
        }
        TypedHandlerDelegate.Result result2 = super.charTyped(c, project, editor, file2);
        if (result2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(10);
        }
        return result2;
    }

    @Nullable
    private static String tryCompleteQuotes(@Nullable PsiElement fileContext) {
        if (fileContext != null) {
            if (fileContext.getText().startsWith("\"")) {
                return "''";
            }
            if (fileContext.getText().startsWith("'")) {
                return "\"\"";
            }
        }
        return null;
    }

    @NotNull
    private static String getDefaultQuote(@NotNull PsiFile file2) {
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(11);
        }
        String string = XmlEditUtil.getAttributeQuote(file2);
        if (string == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation getValuePresentation(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull String quote) {
        PsiElement atParent;
        if (editor == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(14);
        }
        if (quote == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(15);
        }
        XmlAttributeDescriptor descriptor2 = (atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file2, true)) instanceof XmlAttribute ? ((XmlAttribute)atParent).getDescriptor() : null;
        XmlExtension.AttributeValuePresentation attributeValuePresentation = XmlExtension.getExtension(file2).getAttributeValuePresentation(descriptor2, quote);
        if (attributeValuePresentation == null) {
            XmlEqTypedHandler.$$$reportNull$$$0(16);
        }
        return attributeValuePresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlEqTypedHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlEqTypedHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultQuote";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeCandidate";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultQuote";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getValuePresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

