/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Document document;
        String text2;
        int offset;
        CodeDocumentationAwareCommenter commenter;
        Language language;
        if (file2 == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(4);
        }
        if ((language = EnterHandler.getLanguage(dataContext)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Commenter languageCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        CodeDocumentationAwareCommenter codeDocumentationAwareCommenter = commenter = languageCommenter instanceof CodeDocumentationAwareCommenter ? (CodeDocumentationAwareCommenter)languageCommenter : null;
        if (commenter == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        if (EnterInLineCommentHandler.isInLineComment(editor, caretOffset, commenter) && (offset = CharArrayUtil.shiftForward((CharSequence)(text2 = (document = editor.getDocument()).getText()), (int)caretOffset, (String)" \t")) < document.getTextLength() && text2.charAt(offset) != '\n') {
            String prefix = commenter.getLineCommentPrefix();
            assert (prefix != null) : "Line Comment type is set but Line Comment Prefix is null!";
            if (!StringUtil.startsWith((CharSequence)text2, (int)offset, (CharSequence)prefix)) {
                if (text2.charAt(caretOffset) != ' ' && !prefix.endsWith(" ")) {
                    prefix = prefix + " ";
                }
                document.insertString(caretOffset, (CharSequence)prefix);
                return EnterHandlerDelegate.Result.Default;
            }
            int afterPrefix = offset + prefix.length();
            if (afterPrefix < document.getTextLength() && text2.charAt(afterPrefix) != ' ') {
                document.insertString(afterPrefix, (CharSequence)" ");
            }
            caretOffsetRef.set((Object)offset);
            return EnterHandlerDelegate.Result.Default;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isInLineComment(@NotNull Editor editor, int offset, @NotNull CodeDocumentationAwareCommenter commenter) {
        if (editor == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(5);
        }
        if (commenter == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(6);
        }
        if (offset < 1) {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        String prefix = commenter.getLineCommentPrefix();
        return iterator.getTokenType() == commenter.getLineCommentTokenType() && iterator.getStart() + (prefix == null ? 0 : prefix.length()) <= offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInLineComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

