/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RowIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionHintComponent
implements Disposable,
ScrollAwareHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionHintComponent.ListPopupRunnable");
    private static final Icon ourInactiveArrowIcon = EmptyIcon.create((Icon)AllIcons.General.ArrowDown);
    private static final int NORMAL_BORDER_SIZE = 6;
    private static final int SMALL_BORDER_SIZE = 4;
    private static final Border INACTIVE_BORDER = BorderFactory.createEmptyBorder(6, 6, 6, 6);
    private static final Border INACTIVE_BORDER_SMALL = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private final CachedIntentions myCachedIntentions;
    private final Editor myEditor;
    private static final Alarm myAlarm = new Alarm();
    private final RowIcon myHighlightedIcon;
    private final JLabel myIconLabel;
    private final RowIcon myInactiveIcon;
    private static final int DELAY = 500;
    private final MyComponentHint myComponentHint;
    private volatile boolean myPopupShown;
    private boolean myDisposed;
    private volatile ListPopup myPopup;
    private final PsiFile myFile;
    private final JPanel myPanel;
    private PopupMenuListener myOuterComboboxPopupListener;

    public CachedIntentions getCachedIntentions() {
        return this.myCachedIntentions;
    }

    private static Border createActiveBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IntentionHintComponent.getBorderColor(), 1), BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private static Border createActiveBorderSmall() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IntentionHintComponent.getBorderColor(), 1), BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    private static Color getBorderColor() {
        return EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.SELECTED_TEARLINE_COLOR);
    }

    public boolean isVisible() {
        return this.myPanel.isVisible();
    }

    @NotNull
    public static IntentionHintComponent showIntentionHint(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor, boolean showExpanded, @NotNull CachedIntentions cachedIntentions) {
        if (project == null) {
            IntentionHintComponent.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            IntentionHintComponent.$$$reportNull$$$0(2);
        }
        if (cachedIntentions == null) {
            IntentionHintComponent.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Point position = IntentionHintComponent.getHintPosition(editor);
        ApplicationManager.getApplication().assertIsDispatchThread();
        IntentionHintComponent component = new IntentionHintComponent(project, file2, editor, cachedIntentions);
        if (editor.getSettings().isShowIntentionBulb()) {
            component.showIntentionHintImpl(!showExpanded, position);
        }
        Disposer.register((Disposable)project, (Disposable)component);
        if (showExpanded) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (editor == null) {
                    IntentionHintComponent.$$$reportNull$$$0(18);
                }
                if (!editor.isDisposed() && editor.getComponent().isShowing()) {
                    component.showPopup(false);
                }
            }, project.getDisposed());
        }
        IntentionHintComponent intentionHintComponent = component;
        if (intentionHintComponent == null) {
            IntentionHintComponent.$$$reportNull$$$0(4);
        }
        return intentionHintComponent;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposed = true;
        this.myComponentHint.hide();
        this.myPanel.hide();
        if (this.myOuterComboboxPopupListener != null) {
            Container ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, this.myEditor.getContentComponent());
            if (ancestor != null) {
                ((JComboBox)ancestor).removePopupMenuListener(this.myOuterComboboxPopupListener);
            }
            this.myOuterComboboxPopupListener = null;
        }
    }

    @Override
    public void editorScrolled() {
        this.closePopup();
    }

    public boolean isForEditor(@NotNull Editor editor) {
        if (editor == null) {
            IntentionHintComponent.$$$reportNull$$$0(5);
        }
        return editor == this.myEditor;
    }

    @NotNull
    public PopupUpdateResult getPopupUpdateResult(boolean actionsChanged) {
        if (this.myPopup.isDisposed() || !this.myFile.isValid()) {
            PopupUpdateResult popupUpdateResult = PopupUpdateResult.HIDE_AND_RECREATE;
            if (popupUpdateResult == null) {
                IntentionHintComponent.$$$reportNull$$$0(6);
            }
            return popupUpdateResult;
        }
        if (!actionsChanged) {
            PopupUpdateResult popupUpdateResult = PopupUpdateResult.NOTHING_CHANGED;
            if (popupUpdateResult == null) {
                IntentionHintComponent.$$$reportNull$$$0(7);
            }
            return popupUpdateResult;
        }
        PopupUpdateResult popupUpdateResult = this.myPopupShown ? PopupUpdateResult.HIDE_AND_RECREATE : PopupUpdateResult.CHANGED_INVISIBLE;
        if (popupUpdateResult == null) {
            IntentionHintComponent.$$$reportNull$$$0(8);
        }
        return popupUpdateResult;
    }

    public void recreate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ListPopupStep step = this.myPopup.getListStep();
        this.recreateMyPopup(step);
    }

    @Nullable
    public IntentionAction getAction(int index) {
        if (this.myPopup == null || this.myPopup.isDisposed()) {
            return null;
        }
        List<IntentionActionWithTextCaching> values = this.myCachedIntentions.getAllActions();
        if (values.size() <= index) {
            return null;
        }
        return values.get(index).getAction();
    }

    private void showIntentionHintImpl(boolean delay, @NotNull Point position) {
        if (position == null) {
            IntentionHintComponent.$$$reportNull$$$0(9);
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        this.myComponentHint.setShouldDelay(delay);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        PriorityQuestionAction action = new PriorityQuestionAction(){

            public boolean execute() {
                IntentionHintComponent.this.showPopup(false);
                return true;
            }

            @Override
            public int getPriority() {
                return -10;
            }
        };
        if (hintManager.canShowQuestionAction(action)) {
            hintManager.showQuestionHint(this.myEditor, position, offset, offset, this.myComponentHint, action, (short)1);
        }
    }

    @NotNull
    private static Point getHintPosition(Editor editor) {
        Point realPoint;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Point point = new Point();
            if (point == null) {
                IntentionHintComponent.$$$reportNull$$$0(10);
            }
            return point;
        }
        int offset = editor.getCaretModel().getOffset();
        VisualPosition pos = editor.offsetToVisualPosition(offset);
        int line = pos.line;
        Point position = editor.visualPositionToXY(new VisualPosition(line, 0));
        LOG.assertTrue(editor.getComponent().isDisplayable());
        JComponent convertComponent = editor.getContentComponent();
        boolean oneLineEditor = editor.isOneLineMode();
        if (oneLineEditor) {
            JComponent contentComponent = editor.getContentComponent();
            Container ancestorOfClass = SwingUtilities.getAncestorOfClass(JComboBox.class, contentComponent);
            if (ancestorOfClass != null) {
                convertComponent = (JComponent)ancestorOfClass;
            } else {
                ancestorOfClass = SwingUtilities.getAncestorOfClass(JTextField.class, contentComponent);
                if (ancestorOfClass != null) {
                    convertComponent = (JComponent)ancestorOfClass;
                }
            }
            realPoint = new Point(-(AllIcons.Actions.RealIntentionBulb.getIconWidth() / 2) - 4, -(AllIcons.Actions.RealIntentionBulb.getIconHeight() / 2));
        } else {
            int yShift = -(6 + AllIcons.Actions.RealIntentionBulb.getIconHeight());
            if (IntentionHintComponent.canPlaceBulbOnTheSameLine(editor)) {
                yShift = -(6 + (AllIcons.Actions.RealIntentionBulb.getIconHeight() - editor.getLineHeight()) / 2 + 3);
            } else if (position.y < editor.getScrollingModel().getVisibleArea().y + editor.getLineHeight()) {
                yShift = editor.getLineHeight() - 6;
            }
            int xShift = AllIcons.Actions.RealIntentionBulb.getIconWidth();
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            realPoint = new Point(Math.max(0, visibleArea.x - xShift), position.y + yShift);
        }
        Point location = SwingUtilities.convertPoint(convertComponent, realPoint, editor.getComponent().getRootPane().getLayeredPane());
        Point point = new Point(location.x, location.y);
        if (point == null) {
            IntentionHintComponent.$$$reportNull$$$0(11);
        }
        return point;
    }

    private static boolean canPlaceBulbOnTheSameLine(Editor editor) {
        if (ApplicationManager.getApplication().isUnitTestMode() || editor.isOneLineMode()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        VisualPosition pos = editor.offsetToVisualPosition(offset);
        int line = pos.line;
        int firstNonSpaceColumnOnTheLine = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, line);
        if (firstNonSpaceColumnOnTheLine == -1) {
            return false;
        }
        Point point = editor.visualPositionToXY(new VisualPosition(line, firstNonSpaceColumnOnTheLine));
        return point.x > AllIcons.Actions.RealIntentionBulb.getIconWidth() + (editor.isOneLineMode() ? 4 : 6) * 2;
    }

    private IntentionHintComponent(@NotNull Project project, @NotNull PsiFile file2, final @NotNull Editor editor, @NotNull CachedIntentions cachedIntentions) {
        boolean showFix;
        if (project == null) {
            IntentionHintComponent.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            IntentionHintComponent.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            IntentionHintComponent.$$$reportNull$$$0(14);
        }
        if (cachedIntentions == null) {
            IntentionHintComponent.$$$reportNull$$$0(15);
        }
        this.myPanel = new JPanel(){

            @Override
            public synchronized void addMouseListener(MouseListener l) {
            }
        };
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFile = file2;
        this.myEditor = editor;
        this.myCachedIntentions = cachedIntentions;
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.setOpaque(false);
        boolean showRefactoringsBulb = ContainerUtil.exists(cachedIntentions.getInspectionFixes(), descriptor2 -> descriptor2.getAction() instanceof BaseRefactoringIntentionAction);
        boolean bl = showFix = !showRefactoringsBulb && ContainerUtil.exists(cachedIntentions.getErrorFixes(), descriptor2 -> IntentionManagerSettings.getInstance().isShowLightBulb(descriptor2.getAction()));
        Icon smartTagIcon = showRefactoringsBulb ? AllIcons.Actions.RefactoringBulb : (showFix ? AllIcons.Actions.QuickfixBulb : AllIcons.Actions.IntentionBulb);
        this.myHighlightedIcon = new RowIcon(new Icon[]{smartTagIcon, AllIcons.General.ArrowDown});
        this.myInactiveIcon = new RowIcon(new Icon[]{smartTagIcon, ourInactiveArrowIcon});
        this.myIconLabel = new JLabel((Icon)this.myInactiveIcon);
        this.myIconLabel.setOpaque(false);
        this.myPanel.add((Component)this.myIconLabel, "Center");
        this.myPanel.setBorder(editor.isOneLineMode() ? INACTIVE_BORDER_SMALL : INACTIVE_BORDER);
        this.myIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!e.isPopupTrigger() && e.getButton() == 1) {
                    IntentionHintComponent.this.showPopup(true);
                }
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                IntentionHintComponent.this.onMouseEnter(editor.isOneLineMode());
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                IntentionHintComponent.this.onMouseExit(editor.isOneLineMode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseEntered";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myComponentHint = new MyComponentHint(this.myPanel);
        IntentionListStep step = new IntentionListStep(this, this.myEditor, this.myFile, project, this.myCachedIntentions);
        this.recreateMyPopup(step);
        EditorUtil.disposeWithEditor(this.myEditor, this);
    }

    public void hide() {
        this.myDisposed = true;
        Disposer.dispose((Disposable)this);
    }

    private void onMouseExit(boolean small) {
        Window ancestor = SwingUtilities.getWindowAncestor(this.myPopup.getContent());
        if (ancestor == null) {
            this.myIconLabel.setIcon((Icon)this.myInactiveIcon);
            this.myPanel.setBorder(small ? INACTIVE_BORDER_SMALL : INACTIVE_BORDER);
        }
    }

    private void onMouseEnter(boolean small) {
        this.myIconLabel.setIcon((Icon)this.myHighlightedIcon);
        this.myPanel.setBorder(small ? IntentionHintComponent.createActiveBorderSmall() : IntentionHintComponent.createActiveBorder());
        String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (!acceleratorsText.isEmpty()) {
            this.myIconLabel.setToolTipText(CodeInsightBundle.message((String)"lightbulb.tooltip", (Object[])new Object[]{acceleratorsText}));
        }
    }

    public LightweightHint getComponentHint() {
        return this.myComponentHint;
    }

    private void closePopup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPopup.cancel();
        this.myPopupShown = false;
    }

    private void showPopup(boolean mouseClick) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPopup == null || this.myPopup.isDisposed()) {
            return;
        }
        if (mouseClick && this.myPanel.isShowing()) {
            RelativePoint swCorner = RelativePoint.getSouthWestOf((JComponent)this.myPanel);
            int yOffset = IntentionHintComponent.canPlaceBulbOnTheSameLine(this.myEditor) ? 0 : this.myEditor.getLineHeight() - (this.myEditor.isOneLineMode() ? 4 : 6);
            this.myPopup.show(new RelativePoint(swCorner.getComponent(), new Point(swCorner.getPoint().x, swCorner.getPoint().y + yOffset)));
        } else {
            this.myPopup.showInBestPositionFor(this.myEditor);
        }
        this.myPopupShown = true;
    }

    private void recreateMyPopup(@NotNull ListPopupStep step) {
        Container ancestor;
        boolean committed;
        if (step == null) {
            IntentionHintComponent.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPopup != null) {
            Disposer.dispose((Disposable)this.myPopup);
        }
        this.myPopup = JBPopupFactory.getInstance().createListPopup(step);
        if (this.myPopup instanceof WizardPopup) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions").getShortcuts()) {
                KeyboardShortcut keyboardShortcut;
                if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
                ((WizardPopup)this.myPopup).registerAction("activateSelectedElement", keyboardShortcut.getFirstKeyStroke(), new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IntentionHintComponent.this.myPopup.handleSelect(true);
                    }
                });
            }
        }
        PsiFile injectedFile = (committed = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).isCommitted(this.myEditor.getDocument())) ? InjectedLanguageUtil.findInjectedPsiNoCommit(this.myFile, this.myEditor.getCaretModel().getOffset()) : null;
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
        final ScopeHighlighter highlighter = new ScopeHighlighter(this.myEditor);
        final ScopeHighlighter injectionHighlighter = new ScopeHighlighter(injectedEditor);
        this.myPopup.addListener(new JBPopupListener(){

            public void onClosed(LightweightWindowEvent event) {
                highlighter.dropHighlight();
                injectionHighlighter.dropHighlight();
                IntentionHintComponent.this.myPopupShown = false;
            }
        });
        this.myPopup.addListSelectionListener(e -> {
            Object selectedItem;
            Object source = e.getSource();
            highlighter.dropHighlight();
            injectionHighlighter.dropHighlight();
            if (source instanceof DataProvider && (selectedItem = PlatformDataKeys.SELECTED_ITEM.getData((DataProvider)source)) instanceof IntentionActionWithTextCaching) {
                IntentionAction action = ((IntentionActionWithTextCaching)selectedItem).getAction();
                if (action instanceof IntentionActionDelegate) {
                    action = ((IntentionActionDelegate)action).getDelegate();
                }
                if (action instanceof SuppressIntentionActionFromFix) {
                    if (injectedFile != null && ((SuppressIntentionActionFromFix)action).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
                        PsiElement at = injectedFile.findElementAt(injectedEditor.getCaretModel().getOffset());
                        PsiElement container = ((SuppressIntentionActionFromFix)action).getContainer(at);
                        if (container != null) {
                            injectionHighlighter.highlight(container, Collections.singletonList(container));
                        }
                    } else {
                        PsiElement at = this.myFile.findElementAt(this.myEditor.getCaretModel().getOffset());
                        PsiElement container = ((SuppressIntentionActionFromFix)action).getContainer(at);
                        if (container != null) {
                            highlighter.highlight(container, Collections.singletonList(container));
                        }
                    }
                }
            }
        });
        if (this.myEditor.isOneLineMode() && (ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, this.myEditor.getContentComponent())) != null) {
            JComboBox comboBox = (JComboBox)ancestor;
            this.myOuterComboboxPopupListener = new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    IntentionHintComponent.this.hide();
                }
            };
            comboBox.addPopupMenuListener(this.myOuterComboboxPopupListener);
        }
        Disposer.register((Disposable)this, (Disposable)this.myPopup);
        Disposer.register((Disposable)this.myPopup, () -> ((Application)ApplicationManager.getApplication()).assertIsDispatchThread());
    }

    void canceled(@NotNull ListPopupStep intentionListStep) {
        if (intentionListStep == null) {
            IntentionHintComponent.$$$reportNull$$$0(17);
        }
        if (this.myPopup.getListStep() != intentionListStep || this.myDisposed) {
            return;
        }
        this.recreateMyPopup(intentionListStep);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedIntentions";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionListStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "showIntentionHint";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupUpdateResult";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showIntentionHint";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isForEditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showIntentionHintImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "recreateMyPopup";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canceled";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showIntentionHint$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyComponentHint
    extends LightweightHint {
        private boolean myVisible;
        private boolean myShouldDelay;

        private MyComponentHint(JComponent component) {
            super(component);
        }

        @Override
        public void show(@NotNull JComponent parentComponent, int x, int y, JComponent focusBackComponent, @NotNull HintHint hintHint) {
            if (parentComponent == null) {
                MyComponentHint.$$$reportNull$$$0(0);
            }
            if (hintHint == null) {
                MyComponentHint.$$$reportNull$$$0(1);
            }
            this.myVisible = true;
            if (this.myShouldDelay) {
                myAlarm.cancelAllRequests();
                myAlarm.addRequest(() -> {
                    if (parentComponent == null) {
                        MyComponentHint.$$$reportNull$$$0(2);
                    }
                    this.showImpl(parentComponent, x, y, focusBackComponent);
                }, 500);
            } else {
                this.showImpl(parentComponent, x, y, focusBackComponent);
            }
        }

        private void showImpl(JComponent parentComponent, int x, int y, JComponent focusBackComponent) {
            if (!parentComponent.isShowing()) {
                return;
            }
            super.show(parentComponent, x, y, focusBackComponent, new HintHint(parentComponent, new Point(x, y)));
        }

        @Override
        public void hide() {
            super.hide();
            this.myVisible = false;
            myAlarm.cancelAllRequests();
        }

        @Override
        public boolean isVisible() {
            return this.myVisible || super.isVisible();
        }

        private void setShouldDelay(boolean shouldDelay) {
            this.myShouldDelay = shouldDelay;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintHint";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionHintComponent$MyComponentHint";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$show$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum PopupUpdateResult {
        NOTHING_CHANGED,
        CHANGED_INVISIBLE,
        HIDE_AND_RECREATE;

    }
}

