/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MethodUpDownUtil {
    private MethodUpDownUtil() {
    }

    public static int[] getNavigationOffsets(PsiFile file2, int caretOffset) {
        for (MethodNavigationOffsetProvider provider : (MethodNavigationOffsetProvider[])Extensions.getExtensions((ExtensionPointName)MethodNavigationOffsetProvider.EP_NAME)) {
            int[] offsets = provider.getMethodNavigationOffsets(file2, caretOffset);
            if (offsets == null || offsets.length <= 0) continue;
            return offsets;
        }
        THashSet array = new THashSet();
        MethodUpDownUtil.addNavigationElements((Collection<PsiElement>)array, file2);
        return MethodUpDownUtil.offsetsFromElements((Collection<PsiElement>)array);
    }

    public static int[] offsetsFromElements(Collection<PsiElement> array) {
        TIntArrayList offsets = new TIntArrayList(array.size());
        for (PsiElement element : array) {
            int offset = element.getTextOffset();
            assert (offset >= 0) : element + " (" + element.getClass() + "); offset: " + offset;
            offsets.add(offset);
        }
        offsets.sort();
        return offsets.toNativeArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNavigationElements(Collection<PsiElement> array, PsiFile element) {
        StructureViewBuilder structureViewBuilder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(element);
        if (structureViewBuilder instanceof TreeBasedStructureViewBuilder) {
            TreeBasedStructureViewBuilder builder2 = (TreeBasedStructureViewBuilder)structureViewBuilder;
            StructureViewModel model = builder2.createStructureViewModel(null);
            try {
                MethodUpDownUtil.addStructureViewElements((TreeElement)model.getRoot(), array, element);
            }
            finally {
                Disposer.dispose((Disposable)model);
            }
        }
    }

    private static void addStructureViewElements(TreeElement parent, Collection<PsiElement> array, @NotNull PsiFile file2) {
        if (file2 == null) {
            MethodUpDownUtil.$$$reportNull$$$0(0);
        }
        for (TreeElement treeElement : parent.getChildren()) {
            Object value = ((StructureViewTreeElement)treeElement).getValue();
            if (value instanceof PsiElement) {
                PsiElement element = (PsiElement)value;
                if (array.contains(element) || !file2.equals(element.getContainingFile())) continue;
                array.add(element);
            }
            MethodUpDownUtil.addStructureViewElements(treeElement, array, file2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/MethodUpDownUtil", "addStructureViewElements"));
    }
}

