/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.JdomKt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.Convertor;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveTemplateTree
extends CheckboxTree
implements DataProvider,
CopyProvider,
PasteProvider {
    private final TemplateListPanel myConfigurable;

    LiveTemplateTree(CheckboxTree.CheckboxTreeCellRenderer renderer, CheckedTreeNode root, TemplateListPanel configurable) {
        super(renderer, root);
        this.myConfigurable = configurable;
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
        }
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof TemplateImpl) {
            ((TemplateImpl)obj).setDeactivated(!node.isChecked());
        }
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, (Convertor<TreePath, String>)((Convertor)o -> {
            Object object = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
            if (object instanceof TemplateGroup) {
                return ((TemplateGroup)object).getName();
            }
            if (object instanceof TemplateImpl) {
                TemplateImpl template = (TemplateImpl)object;
                return StringUtil.notNullize((String)template.getGroupName()) + " " + StringUtil.notNullize((String)template.getKey()) + " " + StringUtil.notNullize((String)template.getDescription()) + " " + template.getTemplateText();
            }
            return "";
        }), true).setComparator(new SubstringSpeedSearchComparator());
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(0);
        }
        Set<TemplateImpl> templates = this.myConfigurable.getSelectedTemplates().keySet();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(templates, template -> JDOMUtil.writeElement((Element)TemplateSettings.serializeTemplate(template, templateSettings.getDefaultTemplate((TemplateImpl)template), TemplateContext.getIdToType())), (String)SystemProperties.getLineSeparator())));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(1);
        }
        return !this.myConfigurable.getSelectedTemplates().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(2);
        }
        return this.isCopyEnabled(dataContext);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(3);
        }
        if (this.myConfigurable.getSingleSelectedGroup() == null) {
            return false;
        }
        String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        return s != null && s.trim().startsWith("<template ");
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(4);
        }
        return this.isPastePossible(dataContext);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(5);
        }
        TemplateGroup group = this.myConfigurable.getSingleSelectedGroup();
        assert (group != null);
        String buffer = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        assert (buffer != null);
        try {
            for (Element templateElement : JdomKt.loadElement((CharSequence)("<root>" + buffer + "</root>")).getChildren("template")) {
                TemplateImpl template = TemplateSettings.readTemplateFromElement(group.getName(), templateElement, ((Object)((Object)this)).getClass().getClassLoader());
                while (group.containsTemplate(template.getKey(), template.getId())) {
                    template.setKey(template.getKey() + "1");
                    if (template.getId() == null) continue;
                    template.setId(template.getId() + "1");
                }
                this.myConfigurable.addTemplate(template);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SubstringSpeedSearchComparator
    extends SpeedSearchComparator {
        private SubstringSpeedSearchComparator() {
        }

        @Override
        public int matchingDegree(String pattern, String text2) {
            return this.matchingFragments(pattern, text2) != null ? 1 : 0;
        }

        @Override
        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text2) {
            int index;
            if (pattern == null) {
                SubstringSpeedSearchComparator.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                SubstringSpeedSearchComparator.$$$reportNull$$$0(1);
            }
            return (index = StringUtil.indexOfIgnoreCase((String)text2, (String)pattern, (int)0)) >= 0 ? Collections.singleton(TextRange.from((int)index, (int)pattern.length())) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/impl/LiveTemplateTree$SubstringSpeedSearchComparator";
            objectArray[2] = "matchingFragments";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

