/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.intellij.credentialStore.kdbx.HeaderType;
import com.intellij.credentialStore.kdbx.KdbxHeader;
import com.intellij.credentialStore.kdbx.KdbxHeaderKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\nH\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"FILE_VERSION_32", "", "FILE_VERSION_CRITICAL_MASK", "SIG1", "SIG2", "checkStartBytes", "", "kdbxHeader", "Lcom/intellij/credentialStore/kdbx/KdbxHeader;", "decryptedInputStream", "Ljava/io/InputStream;", "getByteArray", "", "input", "Lcom/google/common/io/LittleEndianDataInputStream;", "getInt", "getLong", "", "readKdbxHeader", "inputStream", "verifyFileVersion", "", "verifyMagicNumber", "writeKdbxHeader", "outputStream", "Ljava/io/OutputStream;", "intellij.platform.credentialStore"})
public final class KdbxSerializerKt {
    private static final int SIG1 = -1700603645;
    private static final int SIG2 = -1253311641;
    private static final int FILE_VERSION_CRITICAL_MASK = -65536;
    private static final int FILE_VERSION_32 = 196609;

    private static final void checkStartBytes(KdbxHeader kdbxHeader, InputStream decryptedInputStream) {
        byte[] startBytes = new byte[32];
        new LittleEndianDataInputStream(decryptedInputStream).readFully(startBytes);
        if (!Arrays.equals(startBytes, kdbxHeader.getStreamStartBytes())) {
            throw (Throwable)new IllegalStateException("Inconsistent stream bytes");
        }
    }

    private static final boolean verifyMagicNumber(LittleEndianDataInputStream input) {
        int sig1 = input.readInt();
        int sig2 = input.readInt();
        return sig1 == SIG1 && sig2 == SIG2;
    }

    private static final boolean verifyFileVersion(LittleEndianDataInputStream input) {
        return (input.readInt() & FILE_VERSION_CRITICAL_MASK) <= (FILE_VERSION_32 & FILE_VERSION_CRITICAL_MASK);
    }

    @NotNull
    public static final KdbxHeader readKdbxHeader(@NotNull KdbxHeader kdbxHeader, @NotNull InputStream inputStream) {
        byte headerType;
        Intrinsics.checkParameterIsNotNull((Object)kdbxHeader, (String)"kdbxHeader");
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        MessageDigest digest = KdbxHeaderKt.sha256MessageDigest();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, digest);
        LittleEndianDataInputStream input = new LittleEndianDataInputStream((InputStream)digestInputStream);
        if (!KdbxSerializerKt.verifyMagicNumber(input)) {
            throw (Throwable)new IllegalStateException("Magic number did not match");
        }
        if (!KdbxSerializerKt.verifyFileVersion(input)) {
            throw (Throwable)new IllegalStateException("File version did not match");
        }
        while ((headerType = input.readByte()) != HeaderType.INSTANCE.getEND$intellij_platform_credentialStore()) {
            byte by = headerType;
            if (by == HeaderType.INSTANCE.getCOMMENT$intellij_platform_credentialStore()) {
                KdbxSerializerKt.getByteArray(input);
                continue;
            }
            if (by == HeaderType.INSTANCE.getCIPHER_ID$intellij_platform_credentialStore()) {
                kdbxHeader.setCipherUuid(KdbxSerializerKt.getByteArray(input));
                continue;
            }
            if (by == HeaderType.INSTANCE.getCOMPRESSION_FLAGS$intellij_platform_credentialStore()) {
                kdbxHeader.setCompressionFlags(KdbxSerializerKt.getInt(input));
                continue;
            }
            if (by == HeaderType.INSTANCE.getMASTER_SEED$intellij_platform_credentialStore()) {
                kdbxHeader.setMasterSeed(KdbxSerializerKt.getByteArray(input));
                continue;
            }
            if (by == HeaderType.INSTANCE.getTRANSFORM_SEED$intellij_platform_credentialStore()) {
                kdbxHeader.setTransformSeed(KdbxSerializerKt.getByteArray(input));
                continue;
            }
            if (by == HeaderType.INSTANCE.getTRANSFORM_ROUNDS$intellij_platform_credentialStore()) {
                kdbxHeader.setTransformRounds(KdbxSerializerKt.getLong(input));
                continue;
            }
            if (by == HeaderType.INSTANCE.getENCRYPTION_IV$intellij_platform_credentialStore()) {
                kdbxHeader.setEncryptionIv(KdbxSerializerKt.getByteArray(input));
                continue;
            }
            if (by == HeaderType.INSTANCE.getPROTECTED_STREAM_KEY$intellij_platform_credentialStore()) {
                kdbxHeader.setProtectedStreamKey(KdbxSerializerKt.getByteArray(input));
                continue;
            }
            if (by == HeaderType.INSTANCE.getSTREAM_START_BYTES$intellij_platform_credentialStore()) {
                kdbxHeader.setStreamStartBytes(KdbxSerializerKt.getByteArray(input));
                continue;
            }
            if (by == HeaderType.INSTANCE.getINNER_RANDOM_STREAM_ID$intellij_platform_credentialStore()) {
                kdbxHeader.setInnerRandomStreamId(KdbxSerializerKt.getInt(input));
                continue;
            }
            throw (Throwable)new IllegalStateException("Unknown File Header");
        }
        KdbxSerializerKt.getByteArray(input);
        kdbxHeader.setHeaderHash(digest.digest());
        return kdbxHeader;
    }

    public static final void writeKdbxHeader(@NotNull KdbxHeader kdbxHeader, @NotNull OutputStream outputStream) {
        Intrinsics.checkParameterIsNotNull((Object)kdbxHeader, (String)"kdbxHeader");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        MessageDigest messageDigest = KdbxHeaderKt.sha256MessageDigest();
        DigestOutputStream digestOutputStream = new DigestOutputStream(outputStream, messageDigest);
        LittleEndianDataOutputStream output = new LittleEndianDataOutputStream((OutputStream)digestOutputStream);
        output.writeInt(SIG1);
        output.writeInt(SIG2);
        output.writeInt(FILE_VERSION_32);
        output.writeByte((int)HeaderType.INSTANCE.getCIPHER_ID$intellij_platform_credentialStore());
        output.writeShort(16);
        byte[] b = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putLong(kdbxHeader.getCipherUuid().getMostSignificantBits());
        bb.putLong(8, kdbxHeader.getCipherUuid().getLeastSignificantBits());
        output.write(b);
        output.writeByte((int)HeaderType.INSTANCE.getCOMPRESSION_FLAGS$intellij_platform_credentialStore());
        output.writeShort(4);
        output.writeInt(kdbxHeader.getCompressionFlags().ordinal());
        output.writeByte((int)HeaderType.INSTANCE.getMASTER_SEED$intellij_platform_credentialStore());
        output.writeShort(kdbxHeader.getMasterSeed().length);
        output.write(kdbxHeader.getMasterSeed());
        output.writeByte((int)HeaderType.INSTANCE.getTRANSFORM_SEED$intellij_platform_credentialStore());
        output.writeShort(kdbxHeader.getTransformSeed().length);
        output.write(kdbxHeader.getTransformSeed());
        output.writeByte((int)HeaderType.INSTANCE.getTRANSFORM_ROUNDS$intellij_platform_credentialStore());
        output.writeShort(8);
        output.writeLong(kdbxHeader.getTransformRounds());
        output.writeByte((int)HeaderType.INSTANCE.getENCRYPTION_IV$intellij_platform_credentialStore());
        output.writeShort(kdbxHeader.getEncryptionIv().length);
        output.write(kdbxHeader.getEncryptionIv());
        output.writeByte((int)HeaderType.INSTANCE.getPROTECTED_STREAM_KEY$intellij_platform_credentialStore());
        output.writeShort(kdbxHeader.getProtectedStreamKey().length);
        output.write(kdbxHeader.getProtectedStreamKey());
        output.writeByte((int)HeaderType.INSTANCE.getSTREAM_START_BYTES$intellij_platform_credentialStore());
        output.writeShort(kdbxHeader.getStreamStartBytes().length);
        output.write(kdbxHeader.getStreamStartBytes());
        output.writeByte((int)HeaderType.INSTANCE.getINNER_RANDOM_STREAM_ID$intellij_platform_credentialStore());
        output.writeShort(4);
        output.writeInt(kdbxHeader.getProtectedStreamAlgorithm().ordinal());
        output.writeByte((int)HeaderType.INSTANCE.getEND$intellij_platform_credentialStore());
        output.writeShort(0);
        kdbxHeader.setHeaderHash(digestOutputStream.getMessageDigest().digest());
    }

    private static final int getInt(LittleEndianDataInputStream input) {
        short fieldLength = input.readShort();
        if (fieldLength != 4) {
            throw (Throwable)new IllegalStateException("Int required but length was " + fieldLength);
        }
        return input.readInt();
    }

    private static final long getLong(LittleEndianDataInputStream input) {
        short fieldLength = input.readShort();
        if (fieldLength != 8) {
            throw (Throwable)new IllegalStateException("Long required but length was " + fieldLength);
        }
        return input.readLong();
    }

    private static final byte[] getByteArray(LittleEndianDataInputStream input) {
        byte[] value = new byte[input.readShort()];
        input.readFully(value);
        return value;
    }

    static {
        SIG1 = (int)2594363651L;
        SIG2 = (int)3041655655L;
        FILE_VERSION_CRITICAL_MASK = (int)0xFFFF0000L;
        FILE_VERSION_32 = 196609;
    }

    public static final /* synthetic */ void access$checkStartBytes(@NotNull KdbxHeader kdbxHeader, @NotNull InputStream decryptedInputStream) {
        KdbxSerializerKt.checkStartBytes(kdbxHeader, decryptedInputStream);
    }
}

