/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.actions.impl.NextDifferenceAction;
import com.intellij.diff.actions.impl.PrevDifferenceAction;
import com.intellij.diff.merge.ErrorMergeTool;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeContextEx;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeRequestProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MergeRequestProcessor.class);
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final MergeContext myContext;
    @NotNull
    private final List<MergeTool> myAvailableTools;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    private final Wrapper myContentPanel;
    @NotNull
    private final Wrapper myToolbarPanel;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final MergeRequest myRequest;
    @NotNull
    private MergeTool.MergeViewer myViewer;
    @Nullable
    private BooleanGetter myCloseHandler;
    @Nullable
    private BottomActions myBottomActions;
    private boolean myConflictResolved;

    public MergeRequestProcessor(@Nullable Project project, @NotNull MergeRequest request) {
        MergeTool.MergeViewer viewer;
        if (request == null) {
            MergeRequestProcessor.$$$reportNull$$$0(0);
        }
        this.myConflictResolved = false;
        this.myProject = project;
        this.myRequest = request;
        this.myContext = new MyDiffContext();
        this.myContext.putUserData(DiffUserDataKeys.PLACE, (Object)"Merge");
        this.myAvailableTools = DiffManagerEx.getInstance().getMergeTools();
        this.myMainPanel = new MyPanel();
        this.myContentPanel = new Wrapper();
        this.myToolbarPanel = new Wrapper();
        this.myToolbarPanel.setFocusable(true);
        this.myToolbarStatusPanel = new Wrapper();
        this.myPanel = JBUI.Panels.simplePanel((Component)this.myMainPanel);
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel((Component)this.myToolbarPanel).addToRight((Component)this.myToolbarStatusPanel);
        this.myMainPanel.add((Component)topPanel, "North");
        this.myMainPanel.add((Component)this.myContentPanel, "Center");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        try {
            viewer = this.getFittedTool().createComponent(this.myContext, this.myRequest);
        }
        catch (Throwable e) {
            LOG.error(e);
            viewer = ErrorMergeTool.INSTANCE.createComponent(this.myContext, this.myRequest);
        }
        this.myViewer = viewer;
        this.updateBottomActions();
    }

    public void init() {
        this.setTitle(this.myRequest.getTitle());
        this.initViewer();
    }

    private void initViewer() {
        this.myContentPanel.setContent(this.myViewer.getComponent());
        MergeTool.ToolbarComponents toolbarComponents = this.myViewer.init();
        this.buildToolbar(toolbarComponents.toolbarActions);
        this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
        this.myCloseHandler = toolbarComponents.closeHandler;
    }

    private void destroyViewer() {
        Disposer.dispose((Disposable)this.myViewer);
        ActionUtil.clearActions((JComponent)this.myMainPanel);
        this.myContentPanel.setContent(null);
        this.myToolbarPanel.setContent(null);
        this.myToolbarStatusPanel.setContent(null);
        this.myCloseHandler = null;
        this.myBottomActions = null;
    }

    private void updateBottomActions() {
        this.myBottomActions = new BottomActions();
        this.myBottomActions.applyLeft = this.myViewer.getResolveAction(MergeResult.LEFT);
        this.myBottomActions.applyRight = this.myViewer.getResolveAction(MergeResult.RIGHT);
        this.myBottomActions.resolveAction = this.myViewer.getResolveAction(MergeResult.RESOLVED);
        this.myBottomActions.cancelAction = this.myViewer.getResolveAction(MergeResult.CANCEL);
    }

    @NotNull
    protected DefaultActionGroup collectToolbarActions(@Nullable List<AnAction> viewerActions) {
        DefaultActionGroup group = new DefaultActionGroup();
        List navigationActions = ContainerUtil.list((Object[])new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction()});
        DiffUtil.addActionBlock(group, navigationActions);
        DiffUtil.addActionBlock(group, viewerActions);
        List requestContextActions = (List)this.myRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(group, requestContextActions);
        List contextActions = (List)this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(group, contextActions);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            MergeRequestProcessor.$$$reportNull$$$0(1);
        }
        return defaultActionGroup;
    }

    protected void buildToolbar(@Nullable List<AnAction> viewerActions) {
        DefaultActionGroup group = this.collectToolbarActions(viewerActions);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", (ActionGroup)group, true);
        toolbar.setShowSeparatorTitles(true);
        DataManager.registerDataProvider((JComponent)toolbar.getComponent(), (DataProvider)this.myMainPanel);
        toolbar.setTargetComponent(toolbar.getComponent());
        this.myToolbarPanel.setContent(toolbar.getComponent());
        ActionUtil.recursiveRegisterShortcutSet((ActionGroup)group, (JComponent)this.myMainPanel, null);
    }

    @NotNull
    private MergeTool getFittedTool() {
        for (MergeTool tool : this.myAvailableTools) {
            MergeTool mergeTool;
            try {
                if (!tool.canShow(this.myContext, this.myRequest)) continue;
                mergeTool = tool;
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (mergeTool == null) {
                MergeRequestProcessor.$$$reportNull$$$0(2);
            }
            return mergeTool;
        }
        ErrorMergeTool errorMergeTool = ErrorMergeTool.INSTANCE;
        if (errorMergeTool == null) {
            MergeRequestProcessor.$$$reportNull$$$0(3);
        }
        return errorMergeTool;
    }

    private void setTitle(@Nullable String title) {
        if (title == null) {
            title = "Merge";
        }
        this.setWindowTitle(title);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.destroyViewer();
            this.applyRequestResult(MergeResult.CANCEL);
        });
    }

    private void applyRequestResult(@NotNull MergeResult result2) {
        if (result2 == null) {
            MergeRequestProcessor.$$$reportNull$$$0(4);
        }
        if (this.myConflictResolved) {
            return;
        }
        this.myConflictResolved = true;
        try {
            this.myRequest.applyResult(result2);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            new Notification("Merge", "Can't Finish Merge Resolve", e.getMessage(), NotificationType.ERROR).notify(this.myProject);
        }
    }

    private void reopenWithTool(@NotNull MergeTool tool) {
        MergeTool.MergeViewer newViewer;
        if (tool == null) {
            MergeRequestProcessor.$$$reportNull$$$0(5);
        }
        if (this.myConflictResolved) {
            LOG.warn("Can't reopen with " + tool + " - conflict already resolved");
            return;
        }
        if (!tool.canShow(this.myContext, this.myRequest)) {
            LOG.warn("Can't reopen with " + tool + " - " + this.myRequest);
            return;
        }
        try {
            newViewer = tool.createComponent(this.myContext, this.myRequest);
        }
        catch (Throwable e) {
            LOG.error(e);
            return;
        }
        DiffUtil.runPreservingFocus((FocusableContext)this.myContext, () -> {
            this.destroyViewer();
            this.myViewer = newViewer;
            this.updateBottomActions();
            this.rebuildSouthPanel();
            this.initViewer();
        });
    }

    protected void onDispose() {
    }

    protected void setWindowTitle(@NotNull String title) {
        if (title == null) {
            MergeRequestProcessor.$$$reportNull$$$0(6);
        }
    }

    protected abstract void rebuildSouthPanel();

    public abstract void closeDialog();

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key) {
        if (key == null) {
            MergeRequestProcessor.$$$reportNull$$$0(7);
        }
        return (T)this.myContext.getUserData(key);
    }

    public <T> void putContextUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            MergeRequestProcessor.$$$reportNull$$$0(8);
        }
        this.myContext.putUserData(key, value);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            MergeRequestProcessor.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component = this.myViewer.getPreferredFocusedComponent();
        return component != null ? component : this.myToolbarPanel.getTargetComponent();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public MergeContext getContext() {
        MergeContext mergeContext = this.myContext;
        if (mergeContext == null) {
            MergeRequestProcessor.$$$reportNull$$$0(10);
        }
        return mergeContext;
    }

    public boolean checkCloseAction() {
        return this.myConflictResolved || this.myCloseHandler == null || this.myCloseHandler.get();
    }

    @NotNull
    public BottomActions getBottomActions() {
        BottomActions bottomActions = this.myBottomActions != null ? this.myBottomActions : new BottomActions();
        if (bottomActions == null) {
            MergeRequestProcessor.$$$reportNull$$$0(11);
        }
        return bottomActions;
    }

    @Nullable
    public String getHelpId() {
        return (String)PlatformDataKeys.HELP_ID.getData((DataProvider)this.myMainPanel);
    }

    private boolean isFocusedInWindow() {
        return DiffUtil.isFocusedComponentInWindow(this.myPanel);
    }

    private void requestFocusInWindow() {
        DiffUtil.requestFocusInWindow(this.getPreferredFocusedComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeRequestProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectToolbarActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFittedTool";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottomActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyRequestResult";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reopenWithTool";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setWindowTitle";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContextUserData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putContextUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BottomActions {
        @Nullable
        public Action applyLeft;
        @Nullable
        public Action applyRight;
        @Nullable
        public Action resolveAction;
        @Nullable
        public Action cancelAction;
    }

    private class MyDiffContext
    extends MergeContextEx {
        private MyDiffContext() {
        }

        @Nullable
        public Project getProject() {
            return MergeRequestProcessor.this.getProject();
        }

        public boolean isFocusedInWindow() {
            return MergeRequestProcessor.this.isFocusedInWindow();
        }

        public void requestFocusInWindow() {
            MergeRequestProcessor.this.requestFocusInWindow();
        }

        public void finishMerge(@NotNull MergeResult result2) {
            if (result2 == null) {
                MyDiffContext.$$$reportNull$$$0(0);
            }
            MergeRequestProcessor.this.applyRequestResult(result2);
            MergeRequestProcessor.this.closeDialog();
        }

        @Override
        public void reopenWithTool(@NotNull MergeTool tool) {
            if (tool == null) {
                MyDiffContext.$$$reportNull$$$0(1);
            }
            MergeRequestProcessor.this.reopenWithTool(tool);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor$MyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finishMerge";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reopenWithTool";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponentImpl(Container focusCycleRoot) {
            JComponent component = MergeRequestProcessor.this.getPreferredFocusedComponent();
            if (component == null) {
                return null;
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component, this);
        }
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            Object data;
            DataProvider contentProvider = DataManagerImpl.getDataProviderEx(MergeRequestProcessor.this.myContentPanel.getTargetComponent());
            if (contentProvider != null && (data = contentProvider.getData(dataId)) != null) {
                return data;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return MergeRequestProcessor.this.myProject;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                if (MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.HELP_ID) != null) {
                    return MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.HELP_ID);
                }
                return "procedures.vcWithIDEA.commonVcsOps.integrateDiffs.resolveConflict";
            }
            if (DiffDataKeys.MERGE_VIEWER.is(dataId)) {
                return MergeRequestProcessor.this.myViewer;
            }
            DataProvider requestProvider = (DataProvider)MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (requestProvider != null && (data = requestProvider.getData(dataId)) != null) {
                return data;
            }
            DataProvider contextProvider = (DataProvider)MergeRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (contextProvider != null && (data = contextProvider.getData(dataId)) != null) {
                return data;
            }
            return null;
        }
    }

    private static class MyPrevDifferenceAction
    extends PrevDifferenceAction {
        private MyPrevDifferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPrevDifferenceAction.$$$reportNull$$$0(0);
            }
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabled(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext());
            if (iterable != null && iterable.canGoPrev()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable;
            if (e == null) {
                MyPrevDifferenceAction.$$$reportNull$$$0(1);
            }
            if ((iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext())) != null && iterable.canGoPrev()) {
                iterable.goPrev();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor$MyPrevDifferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyNextDifferenceAction
    extends NextDifferenceAction {
        private MyNextDifferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNextDifferenceAction.$$$reportNull$$$0(0);
            }
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabled(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext());
            if (iterable != null && iterable.canGoNext()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable;
            if (e == null) {
                MyNextDifferenceAction.$$$reportNull$$$0(1);
            }
            if ((iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext())) != null && iterable.canGoNext()) {
                iterable.goNext();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor$MyNextDifferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

