/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.findUsages.PsiElement2UsageTargetComposite;
import com.intellij.find.findUsages.UsageHistory;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findParameterUsages.FindUsagesManager");
    private static final Key<String> KEY_START_USAGE_AGAIN = Key.create((String)"KEY_START_USAGE_AGAIN");
    @NonNls
    private static final String VALUE_START_USAGE_AGAIN = "START_AGAIN";
    private final Project myProject;
    private final UsageViewManager myAnotherManager;
    private PsiElement2UsageTargetComposite myLastSearchInFileData;
    private final UsageHistory myHistory;

    public FindUsagesManager(@NotNull Project project, @NotNull UsageViewManager anotherManager) {
        if (project == null) {
            FindUsagesManager.$$$reportNull$$$0(0);
        }
        if (anotherManager == null) {
            FindUsagesManager.$$$reportNull$$$0(1);
        }
        this.myHistory = new UsageHistory();
        this.myProject = project;
        this.myAnotherManager = anotherManager;
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            FindUsagesManager.$$$reportNull$$$0(2);
        }
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            try {
                if (!factory.canFindUsages(element)) continue;
                return true;
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    public void clearFindingNextUsageInFile() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = null;
    }

    public boolean findNextUsageInFile(@NotNull FileEditor editor) {
        if (editor == null) {
            FindUsagesManager.$$$reportNull$$$0(3);
        }
        return this.findUsageInFile(editor, FileSearchScope.AFTER_CARET);
    }

    public boolean findPreviousUsageInFile(@NotNull FileEditor editor) {
        if (editor == null) {
            FindUsagesManager.$$$reportNull$$$0(4);
        }
        return this.findUsageInFile(editor, FileSearchScope.BEFORE_CARET);
    }

    private boolean findUsageInFile(@NotNull FileEditor editor, @NotNull FileSearchScope direction) {
        if (editor == null) {
            FindUsagesManager.$$$reportNull$$$0(5);
        }
        if (direction == null) {
            FindUsagesManager.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLastSearchInFileData == null) {
            return false;
        }
        PsiElement[] primaryElements = this.myLastSearchInFileData.getPrimaryElements();
        PsiElement[] secondaryElements = this.myLastSearchInFileData.getSecondaryElements();
        if (primaryElements.length == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.searched.elements.have.been.changed.error", new Object[0]), (String)FindBundle.message("cannot.search.for.usages.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return false;
        }
        TextEditor textEditor = (TextEditor)editor;
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        FindUsagesHandler handler2 = this.getFindUsagesHandler(primaryElements[0], false);
        if (handler2 == null) {
            return false;
        }
        this.findUsagesInEditor(primaryElements, secondaryElements, handler2, psiFile, direction, this.myLastSearchInFileData.myOptions, (FileEditor)textEditor);
        return true;
    }

    private void initLastSearchElement(@NotNull FindUsagesOptions findUsagesOptions, @NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements) {
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(7);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(8);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = new PsiElement2UsageTargetComposite(primaryElements, secondaryElements, findUsagesOptions);
    }

    @Nullable
    public FindUsagesHandler getFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            FindUsagesManager.$$$reportNull$$$0(10);
        }
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            if (!factory.canFindUsages(element)) continue;
            FindUsagesHandler handler2 = factory.createFindUsagesHandler(element, forHighlightUsages);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    public FindUsagesHandler getNewFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            FindUsagesManager.$$$reportNull$$$0(11);
        }
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            if (!factory.canFindUsages(element)) continue;
            Class<?> aClass = factory.getClass();
            FindUsagesHandlerFactory copy = (FindUsagesHandlerFactory)new CachingConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass).getComponentInstance(this.myProject.getPicoContainer());
            FindUsagesHandler handler2 = copy.createFindUsagesHandler(element, forHighlightUsages);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    public void findUsages(@NotNull PsiElement psiElement, @Nullable PsiFile scopeFile, FileEditor editor, boolean showDialog, @Nullable(value="null means default (stored in options)") SearchScope searchScope) {
        FindUsagesHandler handler2;
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(12);
        }
        if ((handler2 = this.getFindUsagesHandler(psiElement, false)) == null) {
            return;
        }
        boolean singleFile = scopeFile != null;
        AbstractFindUsagesDialog dialog2 = handler2.getFindUsagesDialog(singleFile, this.shouldOpenInNewTab(), this.mustOpenInNewTab());
        if (showDialog) {
            if (!dialog2.showAndGet()) {
                return;
            }
        } else {
            dialog2.close(0);
        }
        this.setOpenInNewTab(dialog2.isShowInSeparateWindow());
        FindUsagesOptions findUsagesOptions = dialog2.calcFindUsagesOptions();
        if (searchScope != null) {
            findUsagesOptions.searchScope = searchScope;
        }
        this.clearFindingNextUsageInFile();
        this.startFindUsages(findUsagesOptions, handler2, scopeFile, editor);
    }

    void startFindUsages(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions findUsagesOptions, PsiFile scopeFile, FileEditor editor) {
        FindUsagesHandler handler2;
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(13);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(14);
        }
        if ((handler2 = this.getFindUsagesHandler(psiElement, false)) == null) {
            return;
        }
        this.startFindUsages(findUsagesOptions, handler2, scopeFile, editor);
    }

    private void startFindUsages(@NotNull FindUsagesOptions findUsagesOptions, @NotNull FindUsagesHandler handler2, PsiFile scopeFile, FileEditor editor) {
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(15);
        }
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(16);
        }
        boolean singleFile = scopeFile != null;
        this.clearFindingNextUsageInFile();
        LOG.assertTrue(handler2.getPsiElement().isValid());
        PsiElement[] primaryElements = handler2.getPrimaryElements();
        FindUsagesManager.checkNotNull(primaryElements, handler2, "getPrimaryElements()");
        PsiElement[] secondaryElements = handler2.getSecondaryElements();
        FindUsagesManager.checkNotNull(secondaryElements, handler2, "getSecondaryElements()");
        if (singleFile) {
            editor.putUserData(KEY_START_USAGE_AGAIN, null);
            this.findUsagesInEditor(primaryElements, secondaryElements, handler2, scopeFile, FileSearchScope.FROM_START, findUsagesOptions.clone(), editor);
        } else {
            boolean skipResultsWithOneUsage = FindSettings.getInstance().isSkipResultsWithOneUsage();
            this.findUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, skipResultsWithOneUsage);
        }
    }

    public static void showSettingsAndFindUsages(@NotNull NavigationItem[] targets) {
        if (targets == null) {
            FindUsagesManager.$$$reportNull$$$0(17);
        }
        if (targets.length == 0) {
            return;
        }
        NavigationItem target2 = targets[0];
        if (!(target2 instanceof ConfigurableUsageTarget)) {
            return;
        }
        ((ConfigurableUsageTarget)target2).showSettings();
    }

    private static void checkNotNull(@NotNull PsiElement[] elements, @NotNull FindUsagesHandler handler2, @NonNls @NotNull String methodName) {
        if (elements == null) {
            FindUsagesManager.$$$reportNull$$$0(18);
        }
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(19);
        }
        if (methodName == null) {
            FindUsagesManager.$$$reportNull$$$0(20);
        }
        for (PsiElement element : elements) {
            if (element != null) continue;
            LOG.error(handler2 + "." + methodName + " has returned array with null elements: " + Arrays.asList(elements));
        }
    }

    @NotNull
    public static ProgressIndicator startProcessUsages(final @NotNull FindUsagesHandler handler2, final @NotNull PsiElement[] primaryElements, final @NotNull PsiElement[] secondaryElements, final @NotNull Processor<Usage> processor2, final @NotNull FindUsagesOptions findUsagesOptions, @NotNull Runnable onComplete) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(21);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(22);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(23);
        }
        if (processor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(24);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(25);
        }
        if (onComplete == null) {
            FindUsagesManager.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        Task.Backgroundable task2 = new Task.Backgroundable(handler2.getProject(), "Finding Usages"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                UsageSearcher usageSearcher = (UsageSearcher)ReadAction.compute(() -> {
                    if (primaryElements == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (secondaryElements == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (handler2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (findUsagesOptions == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    PsiElement2UsageTargetAdapter[] primaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
                    PsiElement2UsageTargetAdapter[] secondaryTargets = PsiElement2UsageTargetAdapter.convert(secondaryElements);
                    return FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, null);
                });
                usageSearcher.generate(processor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "primaryElements";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "secondaryElements";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "findUsagesOptions";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task2, indicator, onComplete);
        ProgressIndicatorBase progressIndicatorBase = indicator;
        if (progressIndicatorBase == null) {
            FindUsagesManager.$$$reportNull$$$0(27);
        }
        return progressIndicatorBase;
    }

    @NotNull
    public UsageViewPresentation createPresentation(@NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(28);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(29);
        }
        PsiElement element = handler2.getPsiElement();
        LOG.assertTrue(element.isValid());
        UsageViewPresentation usageViewPresentation = FindUsagesManager.createPresentation(element, findUsagesOptions, FindSettings.getInstance().isShowResultsInSeparateView());
        if (usageViewPresentation == null) {
            FindUsagesManager.$$$reportNull$$$0(30);
        }
        return usageViewPresentation;
    }

    private void setOpenInNewTab(boolean toOpenInNewTab) {
        if (!this.mustOpenInNewTab()) {
            FindSettings.getInstance().setShowResultsInSeparateView(toOpenInNewTab);
        }
    }

    private boolean shouldOpenInNewTab() {
        return this.mustOpenInNewTab() || FindSettings.getInstance().isShowResultsInSeparateView();
    }

    private boolean mustOpenInNewTab() {
        Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
        return selectedContent != null && selectedContent.isPinned();
    }

    @NotNull
    private static UsageSearcher createUsageSearcher(@NotNull PsiElement2UsageTargetAdapter[] primaryTargets, @NotNull PsiElement2UsageTargetAdapter[] secondaryTargets, @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions options, PsiFile scopeFile) throws PsiInvalidElementAccessException {
        if (primaryTargets == null) {
            FindUsagesManager.$$$reportNull$$$0(31);
        }
        if (secondaryTargets == null) {
            FindUsagesManager.$$$reportNull$$$0(32);
        }
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(33);
        }
        if (options == null) {
            FindUsagesManager.$$$reportNull$$$0(34);
        }
        ReadAction.run(() -> {
            if (primaryTargets == null) {
                FindUsagesManager.$$$reportNull$$$0(91);
            }
            if (secondaryTargets == null) {
                FindUsagesManager.$$$reportNull$$$0(92);
            }
            PsiElement[] primaryElements = PsiElement2UsageTargetAdapter.convertToPsiElements(primaryTargets);
            PsiElement[] secondaryElements = PsiElement2UsageTargetAdapter.convertToPsiElements(secondaryTargets);
            ContainerUtil.concat((Object[][])new PsiElement[][]{primaryElements, secondaryElements}).forEach(psi -> {
                if (psi == null || !psi.isValid()) {
                    throw new PsiInvalidElementAccessException(psi);
                }
            });
        });
        FindUsagesOptions optionsClone = options.clone();
        UsageSearcher usageSearcher = processor2 -> {
            if (primaryTargets == null) {
                FindUsagesManager.$$$reportNull$$$0(86);
            }
            if (secondaryTargets == null) {
                FindUsagesManager.$$$reportNull$$$0(87);
            }
            if (handler2 == null) {
                FindUsagesManager.$$$reportNull$$$0(88);
            }
            PsiElement[] primaryElements = (PsiElement[])ReadAction.compute(() -> {
                if (primaryTargets == null) {
                    FindUsagesManager.$$$reportNull$$$0(90);
                }
                return PsiElement2UsageTargetAdapter.convertToPsiElements(primaryTargets);
            });
            PsiElement[] secondaryElements = (PsiElement[])ReadAction.compute(() -> {
                if (secondaryTargets == null) {
                    FindUsagesManager.$$$reportNull$$$0(89);
                }
                return PsiElement2UsageTargetAdapter.convertToPsiElements(secondaryTargets);
            });
            Project project = (Project)ReadAction.compute(() -> scopeFile != null ? scopeFile.getProject() : primaryElements[0].getProject());
            FindUsagesManager.dropResolveCacheRegularly(ProgressManager.getInstance().getProgressIndicator(), project);
            if (scopeFile != null) {
                optionsClone.searchScope = new LocalSearchScope((PsiElement)scopeFile);
            }
            CommonProcessors.UniqueProcessor usageInfoProcessor = new CommonProcessors.UniqueProcessor(usageInfo -> {
                Usage usage = (Usage)ReadAction.compute(() -> UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo)usageInfo));
                return processor2.process((Object)usage);
            });
            Iterable elements = ContainerUtil.concat((Object[][])new PsiElement[][]{primaryElements, secondaryElements});
            optionsClone.fastTrack = new SearchRequestCollector(new SearchSession());
            if (optionsClone.searchScope instanceof GlobalSearchScope) {
                optionsClone.searchScope = optionsClone.searchScope.union((SearchScope)GlobalSearchScope.projectScope((Project)project));
            }
            try {
                for (PsiElement element : elements) {
                    handler2.processElementUsages(element, (Processor<UsageInfo>)usageInfoProcessor, optionsClone);
                    for (CustomUsageSearcher searcher : (CustomUsageSearcher[])Extensions.getExtensions(CustomUsageSearcher.EP_NAME)) {
                        try {
                            searcher.processElementUsages(element, (Processor<Usage>)processor2, optionsClone);
                        }
                        catch (IndexNotReadyException e) {
                            DumbService.getInstance((Project)element.getProject()).showDumbModeNotification("Find usages is not available during indexing");
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                PsiSearchHelper.getInstance((Project)project).processRequests(optionsClone.fastTrack, arg_0 -> FindUsagesManager.lambda$null$8((Processor)usageInfoProcessor, arg_0));
            }
            finally {
                optionsClone.fastTrack = null;
            }
        };
        if (usageSearcher == null) {
            FindUsagesManager.$$$reportNull$$$0(35);
        }
        return usageSearcher;
    }

    @NotNull
    private static PsiElement2UsageTargetAdapter[] convertToUsageTargets(@NotNull Iterable<PsiElement> elementsToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        if (elementsToSearch == null) {
            FindUsagesManager.$$$reportNull$$$0(36);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(37);
        }
        List targets = ContainerUtil.map(elementsToSearch, element -> {
            if (findUsagesOptions == null) {
                FindUsagesManager.$$$reportNull$$$0(85);
            }
            return FindUsagesManager.convertToUsageTarget(element, findUsagesOptions);
        });
        PsiElement2UsageTargetAdapter[] psiElement2UsageTargetAdapterArray = targets.toArray(new PsiElement2UsageTargetAdapter[0]);
        if (psiElement2UsageTargetAdapterArray == null) {
            FindUsagesManager.$$$reportNull$$$0(38);
        }
        return psiElement2UsageTargetAdapterArray;
    }

    public void findUsages(@NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements, @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(39);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(40);
        }
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(41);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(42);
        }
        this.doFindUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, toSkipUsagePanelWhenOneUsage);
    }

    public UsageView doFindUsages(@NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements, @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(43);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(44);
        }
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(45);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(46);
        }
        if (primaryElements.length == 0) {
            throw new AssertionError((Object)(handler2 + " " + findUsagesOptions));
        }
        Object[] primaryTargets = FindUsagesManager.convertToUsageTargets(Arrays.asList(primaryElements), findUsagesOptions);
        Object[] secondaryTargets = FindUsagesManager.convertToUsageTargets(Arrays.asList(secondaryElements), findUsagesOptions);
        PsiElement2UsageTargetAdapter[] targets = (PsiElement2UsageTargetAdapter[])ArrayUtil.mergeArrays((Object[])primaryTargets, (Object[])secondaryTargets);
        Factory factory = () -> FindUsagesManager.lambda$doFindUsages$11((PsiElement2UsageTargetAdapter[])primaryTargets, (PsiElement2UsageTargetAdapter[])secondaryTargets, handler2, findUsagesOptions);
        UsageView usageView = this.myAnotherManager.searchAndShowUsages((UsageTarget[])targets, factory, !toSkipUsagePanelWhenOneUsage, true, FindUsagesManager.createPresentation(primaryElements[0], findUsagesOptions, this.shouldOpenInNewTab()), null);
        this.myHistory.add(targets[0]);
        return usageView;
    }

    private static void dropResolveCacheRegularly(ProgressIndicator indicator, final @NotNull Project project) {
        if (project == null) {
            FindUsagesManager.$$$reportNull$$$0(47);
        }
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate(new ProgressIndicatorBase(){
                volatile long lastCleared = System.currentTimeMillis();

                @Override
                public void setFraction(double fraction) {
                    super.setFraction(fraction);
                    long current = System.currentTimeMillis();
                    if (current - this.lastCleared >= 500L) {
                        this.lastCleared = current;
                        PsiManager.getInstance((Project)project).dropResolveCaches();
                    }
                }
            });
        }
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions options, boolean toOpenInNewTab) {
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(48);
        }
        if (options == null) {
            FindUsagesManager.$$$reportNull$$$0(49);
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        String scopeString = options.searchScope.getDisplayName();
        presentation.setScopeText(scopeString);
        String usagesString = FindUsagesManager.generateUsagesString(options);
        presentation.setUsagesString(usagesString);
        String title = FindBundle.message("find.usages.of.element.in.scope.panel.title", usagesString, UsageViewUtil.getLongName(psiElement), scopeString);
        presentation.setTabText(title);
        presentation.setTabName(FindBundle.message("find.usages.of.element.tab.name", usagesString, UsageViewUtil.getShortName(psiElement)));
        presentation.setTargetsNodeText(StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)));
        presentation.setOpenInNewTab(toOpenInNewTab);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            FindUsagesManager.$$$reportNull$$$0(50);
        }
        return usageViewPresentation;
    }

    private void findUsagesInEditor(@NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements, @NotNull FindUsagesHandler handler2, @NotNull PsiFile scopeFile, @NotNull FileSearchScope direction, @NotNull FindUsagesOptions findUsagesOptions, @NotNull FileEditor fileEditor) {
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(51);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(52);
        }
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(53);
        }
        if (scopeFile == null) {
            FindUsagesManager.$$$reportNull$$$0(54);
        }
        if (direction == null) {
            FindUsagesManager.$$$reportNull$$$0(55);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(56);
        }
        if (fileEditor == null) {
            FindUsagesManager.$$$reportNull$$$0(57);
        }
        this.initLastSearchElement(findUsagesOptions, primaryElements, secondaryElements);
        this.clearStatusBar();
        FileEditorLocation currentLocation = fileEditor.getCurrentLocation();
        PsiElement2UsageTargetAdapter[] primaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
        PsiElement2UsageTargetAdapter[] secondaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
        UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, scopeFile);
        AtomicBoolean usagesWereFound = new AtomicBoolean();
        Usage fUsage = FindUsagesManager.findSiblingUsage(usageSearcher, direction, currentLocation, usagesWereFound, fileEditor);
        if (fUsage != null) {
            fUsage.navigate(true);
            fUsage.selectInEditor();
        } else if (!usagesWereFound.get()) {
            String message = FindUsagesManager.getNoUsagesFoundMessage(primaryElements[0]) + " in " + scopeFile.getName();
            this.showHintOrStatusBarMessage(message, fileEditor);
        } else {
            fileEditor.putUserData(KEY_START_USAGE_AGAIN, (Object)VALUE_START_USAGE_AGAIN);
            this.showHintOrStatusBarMessage(FindUsagesManager.getSearchAgainMessage(primaryElements[0], direction), fileEditor);
        }
    }

    @NotNull
    private static String getNoUsagesFoundMessage(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(58);
        }
        String elementType = UsageViewUtil.getType(psiElement);
        String elementName = UsageViewUtil.getShortName(psiElement);
        String string = FindBundle.message("find.usages.of.element_type.element_name.not.found.message", elementType, elementName);
        if (string == null) {
            FindUsagesManager.$$$reportNull$$$0(59);
        }
        return string;
    }

    private void clearStatusBar() {
        StatusBar.Info.set((String)"", (Project)this.myProject);
    }

    @NotNull
    private static String getSearchAgainMessage(@NotNull PsiElement element, @NotNull FileSearchScope direction) {
        String shortcutsText;
        AnAction action;
        String shortcutsText2;
        if (element == null) {
            FindUsagesManager.$$$reportNull$$$0(60);
        }
        if (direction == null) {
            FindUsagesManager.$$$reportNull$$$0(61);
        }
        String message = FindUsagesManager.getNoUsagesFoundMessage(element);
        message = direction == FileSearchScope.AFTER_CARET ? ((shortcutsText2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action = ActionManager.getInstance().getAction("FindNext")))).isEmpty() ? FindBundle.message("find.search.again.from.top.action.message", message) : FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText2)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FindPrevious"))).isEmpty() ? FindBundle.message("find.search.again.from.bottom.action.message", message) : FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText));
        String string = message;
        if (string == null) {
            FindUsagesManager.$$$reportNull$$$0(62);
        }
        return string;
    }

    private void showHintOrStatusBarMessage(@NotNull String message, FileEditor fileEditor) {
        if (message == null) {
            FindUsagesManager.$$$reportNull$$$0(63);
        }
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            FindUsagesManager.showEditorHint(message, textEditor.getEditor());
        } else {
            StatusBar.Info.set((String)message, (Project)this.myProject);
        }
    }

    private static Usage findSiblingUsage(@NotNull UsageSearcher usageSearcher, @NotNull FileSearchScope dir, FileEditorLocation currentLocation, @NotNull AtomicBoolean usagesWereFound, @NotNull FileEditor fileEditor) {
        if (usageSearcher == null) {
            FindUsagesManager.$$$reportNull$$$0(64);
        }
        if (dir == null) {
            FindUsagesManager.$$$reportNull$$$0(65);
        }
        if (usagesWereFound == null) {
            FindUsagesManager.$$$reportNull$$$0(66);
        }
        if (fileEditor == null) {
            FindUsagesManager.$$$reportNull$$$0(67);
        }
        if (fileEditor.getUserData(KEY_START_USAGE_AGAIN) != null) {
            dir = dir == FileSearchScope.AFTER_CARET ? FileSearchScope.FROM_START : FileSearchScope.FROM_END;
        }
        FileSearchScope direction = dir;
        AtomicReference foundUsage = new AtomicReference();
        usageSearcher.generate(usage -> {
            block6: {
                Usage found;
                block7: {
                    block5: {
                        if (usagesWereFound == null) {
                            FindUsagesManager.$$$reportNull$$$0(82);
                        }
                        usagesWereFound.set(true);
                        if (direction == FileSearchScope.FROM_START) {
                            foundUsage.compareAndSet(null, usage);
                            return false;
                        }
                        if (direction != FileSearchScope.FROM_END) break block5;
                        foundUsage.set(usage);
                        break block6;
                    }
                    if (direction != FileSearchScope.AFTER_CARET) break block7;
                    if (Comparing.compare((Comparable)usage.getLocation(), (Comparable)currentLocation) > 0) {
                        foundUsage.set(usage);
                        return false;
                    }
                    break block6;
                }
                if (direction != FileSearchScope.BEFORE_CARET) break block6;
                if (Comparing.compare((Comparable)usage.getLocation(), (Comparable)currentLocation) >= 0) {
                    return false;
                }
                while (!((found = (Usage)foundUsage.get()) == null ? foundUsage.compareAndSet(null, usage) : Comparing.compare((Comparable)found.getLocation(), (Comparable)usage.getLocation()) < 0 && foundUsage.compareAndSet(found, usage))) {
                }
            }
            return true;
        });
        fileEditor.putUserData(KEY_START_USAGE_AGAIN, null);
        return (Usage)foundUsage.get();
    }

    @NotNull
    private static PsiElement2UsageTargetAdapter convertToUsageTarget(@NotNull PsiElement elementToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        if (elementToSearch == null) {
            FindUsagesManager.$$$reportNull$$$0(68);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(69);
        }
        if (elementToSearch instanceof NavigationItem) {
            PsiElement2UsageTargetAdapter psiElement2UsageTargetAdapter = new PsiElement2UsageTargetAdapter(elementToSearch, findUsagesOptions);
            if (psiElement2UsageTargetAdapter == null) {
                FindUsagesManager.$$$reportNull$$$0(70);
            }
            return psiElement2UsageTargetAdapter;
        }
        throw new IllegalArgumentException("Wrong usage target:" + elementToSearch + "; " + elementToSearch.getClass());
    }

    @NotNull
    private static String generateUsagesString(@NotNull FindUsagesOptions selectedOptions) {
        if (selectedOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(71);
        }
        String string = selectedOptions.generateUsagesString();
        if (string == null) {
            FindUsagesManager.$$$reportNull$$$0(72);
        }
        return string;
    }

    private static void showEditorHint(@NotNull String message, @NotNull Editor editor) {
        if (message == null) {
            FindUsagesManager.$$$reportNull$$$0(73);
        }
        if (editor == null) {
            FindUsagesManager.$$$reportNull$$$0(74);
        }
        JComponent component = HintUtil.createInformationLabel(message);
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }

    public static String getHelpID(@NotNull PsiElement element) {
        if (element == null) {
            FindUsagesManager.$$$reportNull$$$0(75);
        }
        return ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(element.getLanguage())).getHelpId(element);
    }

    public void rerunAndRecallFromHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        if (usageTarget == null) {
            FindUsagesManager.$$$reportNull$$$0(76);
        }
        usageTarget.findUsages();
        this.addToHistory(usageTarget);
    }

    public void addToHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        if (usageTarget == null) {
            FindUsagesManager.$$$reportNull$$$0(77);
        }
        this.myHistory.add(usageTarget);
    }

    @NotNull
    public UsageHistory getHistory() {
        UsageHistory usageHistory = this.myHistory;
        if (usageHistory == null) {
            FindUsagesManager.$$$reportNull$$$0(78);
        }
        return usageHistory;
    }

    @NotNull
    public static GlobalSearchScope getMaximalScope(@NotNull FindUsagesHandler handler2) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(79);
        }
        PsiElement element = handler2.getPsiElement();
        Project project = element.getProject();
        PsiFile file2 = element.getContainingFile();
        if (file2 != null && ProjectFileIndex.SERVICE.getInstance((Project)project).isInContent(file2.getViewProvider().getVirtualFile())) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            if (globalSearchScope == null) {
                FindUsagesManager.$$$reportNull$$$0(80);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        if (globalSearchScope == null) {
            FindUsagesManager.$$$reportNull$$$0(81);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ UsageSearcher lambda$doFindUsages$11(PsiElement2UsageTargetAdapter[] primaryTargets, PsiElement2UsageTargetAdapter[] secondaryTargets, @NotNull FindUsagesHandler handler2, @NotNull FindUsagesOptions findUsagesOptions) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(83);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(84);
        }
        return FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, null);
    }

    private static /* synthetic */ boolean lambda$null$8(Processor usageInfoProcessor, PsiReference ref) {
        UsageInfo info = (UsageInfo)ReadAction.compute(() -> {
            if (!ref.getElement().isValid()) {
                return null;
            }
            return new UsageInfo(ref);
        });
        return info == null || usageInfoProcessor.process((Object)info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 50: 
            case 59: 
            case 62: 
            case 70: 
            case 72: 
            case 78: 
            case 80: 
            case 81: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 50: 
            case 59: 
            case 62: 
            case 70: 
            case 72: 
            case 78: 
            case 80: 
            case 81: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherManager";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 60: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 55: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 25: 
            case 29: 
            case 37: 
            case 42: 
            case 46: 
            case 56: 
            case 69: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findUsagesOptions";
                break;
            }
            case 8: 
            case 22: 
            case 39: 
            case 43: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryElements";
                break;
            }
            case 9: 
            case 23: 
            case 40: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryElements";
                break;
            }
            case 12: 
            case 13: 
            case 48: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 33: 
            case 41: 
            case 45: 
            case 53: 
            case 79: 
            case 83: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onComplete";
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 50: 
            case 59: 
            case 62: 
            case 70: 
            case 72: 
            case 78: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/FindUsagesManager";
                break;
            }
            case 31: 
            case 86: 
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryTargets";
                break;
            }
            case 32: 
            case 87: 
            case 89: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryTargets";
                break;
            }
            case 34: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToSearch";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeFile";
                break;
            }
            case 57: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 63: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageSearcher";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 66: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesWereFound";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedOptions";
                break;
            }
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesManager";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessUsages";
                break;
            }
            case 30: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageSearcher";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToUsageTargets";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoUsagesFoundMessage";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchAgainMessage";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToUsageTarget";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUsagesString";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaximalScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findNextUsageInFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findPreviousUsageInFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUsageInFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initLastSearchElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNewFindUsagesHandler";
                break;
            }
            case 12: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsAndFindUsages";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNull";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "startProcessUsages";
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 50: 
            case 59: 
            case 62: 
            case 70: 
            case 72: 
            case 78: 
            case 80: 
            case 81: {
                break;
            }
            case 28: 
            case 29: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createUsageSearcher";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "convertToUsageTargets";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doFindUsages";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "dropResolveCacheRegularly";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInEditor";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getNoUsagesFoundMessage";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getSearchAgainMessage";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "showHintOrStatusBarMessage";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingUsage";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "convertToUsageTarget";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "generateUsagesString";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "showEditorHint";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getHelpID";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "rerunAndRecallFromHistory";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getMaximalScope";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSiblingUsage$12";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doFindUsages$11";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "lambda$convertToUsageTargets$10";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createUsageSearcher$9";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createUsageSearcher$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 50: 
            case 59: 
            case 62: 
            case 70: 
            case 72: 
            case 78: 
            case 80: 
            case 81: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum FileSearchScope {
        FROM_START,
        FROM_END,
        AFTER_CARET,
        BEFORE_CARET;

    }
}

