/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FindInProjectTask {
    private static final Comparator<VirtualFile> SEARCH_RESULT_FILE_COMPARATOR = Comparator.comparing(f -> f instanceof VirtualFileWithId ? ((VirtualFileWithId)f).getId() : 0).thenComparing(VirtualFile::getName).thenComparing(VirtualFile::getPath);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindInProjectTask");
    private static final int FILES_SIZE_LIMIT = 0x4600000;
    private final FindModel myFindModel;
    private final Project myProject;
    private final PsiManager myPsiManager;
    @Nullable
    private final VirtualFile myDirectory;
    private final ProjectFileIndex myProjectFileIndex;
    private final FileIndex myFileIndex;
    private final Condition<VirtualFile> myFileMask;
    private final ProgressIndicator myProgress;
    @Nullable
    private final Module myModule;
    private final Set<VirtualFile> myLargeFiles;
    private final Set<VirtualFile> myFilesToScanInitially;
    private final AtomicLong myTotalFilesSize;
    private final String myStringToFindInIndices;

    FindInProjectTask(@NotNull FindModel findModel, @NotNull Project project, @NotNull Set<VirtualFile> filesToScanInitially) {
        if (findModel == null) {
            FindInProjectTask.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FindInProjectTask.$$$reportNull$$$0(1);
        }
        if (filesToScanInitially == null) {
            FindInProjectTask.$$$reportNull$$$0(2);
        }
        this.myLargeFiles = Collections.synchronizedSet(ContainerUtil.newTroveSet());
        this.myTotalFilesSize = new AtomicLong();
        this.myFindModel = findModel;
        this.myProject = project;
        this.myFilesToScanInitially = filesToScanInitially;
        this.myDirectory = FindInProjectUtil.getDirectory(findModel);
        this.myPsiManager = PsiManager.getInstance((Project)project);
        String moduleName = findModel.getModuleName();
        this.myModule = moduleName == null ? null : (Module)ReadAction.compute(() -> {
            if (project == null) {
                FindInProjectTask.$$$reportNull$$$0(25);
            }
            return ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        });
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myFileIndex = this.myModule == null ? this.myProjectFileIndex : ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
        Condition<CharSequence> patternCondition = FindInProjectUtil.createFileMaskCondition(findModel.getFileFilter());
        this.myFileMask = file2 -> file2 != null && patternCondition.value((Object)file2.getNameSequence());
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        this.myProgress = progress != null ? progress : new EmptyProgressIndicator();
        String stringToFind = this.myFindModel.getStringToFind();
        if (this.myFindModel.isRegularExpressions()) {
            stringToFind = FindInProjectUtil.buildStringToFindForIndicesFromRegExp(stringToFind, this.myProject);
        }
        this.myStringToFindInIndices = stringToFind;
        TooManyUsagesStatus.createFor(this.myProgress);
    }

    public void findUsages(@NotNull FindUsagesProcessPresentation processPresentation, @NotNull Processor<UsageInfo> consumer) {
        block9: {
            if (processPresentation == null) {
                FindInProjectTask.$$$reportNull$$$0(3);
            }
            if (consumer == null) {
                FindInProjectTask.$$$reportNull$$$0(4);
            }
            try {
                this.myProgress.setIndeterminate(true);
                this.myProgress.setText("Scanning indexed files...");
                Set filesForFastWordSearch = (Set)ReadAction.compute(this::getFilesForFastWordSearch);
                this.myProgress.setIndeterminate(false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for " + this.myFindModel.getStringToFind() + " in " + filesForFastWordSearch.size() + " indexed files");
                }
                this.searchInFiles(filesForFastWordSearch, processPresentation, consumer);
                this.myProgress.setIndeterminate(true);
                this.myProgress.setText("Scanning non-indexed files...");
                boolean canRelyOnIndices = this.canRelyOnIndices();
                Collection<VirtualFile> otherFiles = this.collectFilesInScope(filesForFastWordSearch, canRelyOnIndices);
                this.myProgress.setIndeterminate(false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for " + this.myFindModel.getStringToFind() + " in " + otherFiles.size() + " non-indexed files");
                }
                this.myProgress.checkCanceled();
                long start = System.currentTimeMillis();
                this.searchInFiles(otherFiles, processPresentation, consumer);
                if (canRelyOnIndices && otherFiles.size() > 1000) {
                    long time = System.currentTimeMillis() - start;
                    FindInProjectTask.logStats(otherFiles, time);
                }
            }
            catch (ProcessCanceledException e) {
                processPresentation.setCanceled(true);
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug("Usage search canceled", (Throwable)e);
            }
        }
        if (!this.myLargeFiles.isEmpty()) {
            processPresentation.setLargeFilesWereNotScanned(this.myLargeFiles);
        }
        if (!this.myProgress.isCanceled()) {
            this.myProgress.setText(FindBundle.message("find.progress.search.completed", new Object[0]));
        }
    }

    private static void logStats(@NotNull Collection<VirtualFile> otherFiles, long time) {
        if (otherFiles == null) {
            FindInProjectTask.$$$reportNull$$$0(5);
        }
        Map<String, Long> extensionToCount = otherFiles.stream().collect(Collectors.groupingBy(file2 -> StringUtil.notNullize((String)file2.getExtension()).toLowerCase(Locale.ENGLISH), Collectors.counting()));
        String topExtensions = extensionToCount.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(entry -> (String)entry.getKey() + "(" + entry.getValue() + ")").limit(10L).collect(Collectors.joining(", "));
        LOG.info("Search in " + otherFiles.size() + " files with unknown types took " + time + "ms.\nMapping their extensions to an existing file type (e.g. Plain Text) might speed up the search.\nMost frequent non-indexed file extensions: " + topExtensions);
    }

    private void searchInFiles(@NotNull Collection<VirtualFile> virtualFiles, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull Processor<UsageInfo> consumer) {
        if (virtualFiles == null) {
            FindInProjectTask.$$$reportNull$$$0(6);
        }
        if (processPresentation == null) {
            FindInProjectTask.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            FindInProjectTask.$$$reportNull$$$0(8);
        }
        AtomicInteger occurrenceCount = new AtomicInteger();
        AtomicInteger processedFileCount = new AtomicInteger();
        Processor processor2 = virtualFile -> {
            long totalSize;
            boolean skipProjectFile;
            if (virtualFiles == null) {
                FindInProjectTask.$$$reportNull$$$0(20);
            }
            if (consumer == null) {
                FindInProjectTask.$$$reportNull$$$0(21);
            }
            if (processPresentation == null) {
                FindInProjectTask.$$$reportNull$$$0(22);
            }
            if (!virtualFile.isValid()) {
                return true;
            }
            long fileLength = UsageViewManagerImpl.getFileLength((VirtualFile)virtualFile);
            if (fileLength == -1L) {
                return true;
            }
            boolean bl = skipProjectFile = ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) && !this.myFindModel.isSearchInProjectFiles();
            if (skipProjectFile && !Registry.is((String)"find.search.in.project.files")) {
                return true;
            }
            if (fileLength > (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                this.myLargeFiles.add((VirtualFile)virtualFile);
                return true;
            }
            this.myProgress.checkCanceled();
            if (this.myProgress.isRunning()) {
                double fraction = (double)processedFileCount.incrementAndGet() / (double)virtualFiles.size();
                this.myProgress.setFraction(fraction);
            }
            String text2 = FindBundle.message("find.searching.for.string.in.file.progress", this.myFindModel.getStringToFind(), virtualFile.getPresentableUrl());
            this.myProgress.setText(text2);
            this.myProgress.setText2(FindBundle.message("find.searching.for.string.in.file.occurrences.progress", occurrenceCount));
            Pair.NonNull pair = (Pair.NonNull)ReadAction.compute(() -> this.findFile((VirtualFile)virtualFile));
            if (pair == null) {
                return true;
            }
            PsiFile psiFile = (PsiFile)pair.first;
            VirtualFile sourceVirtualFile = (VirtualFile)pair.second;
            int countInFile = FindInProjectUtil.processUsagesInFile(psiFile, sourceVirtualFile, this.myFindModel, (Processor<UsageInfo>)((Processor)info -> {
                if (consumer == null) {
                    FindInProjectTask.$$$reportNull$$$0(24);
                }
                return skipProjectFile || consumer.process(info);
            }));
            if (countInFile > 0 && skipProjectFile) {
                processPresentation.projectFileUsagesFound(() -> {
                    FindModel model = this.myFindModel.clone();
                    model.setSearchInProjectFiles(true);
                    FindInProjectManager.getInstance(this.myProject).startFindInProject(model);
                });
                return true;
            }
            if (countInFile > 0) {
                occurrenceCount.addAndGet(countInFile);
                totalSize = this.myTotalFilesSize.addAndGet(fileLength);
            } else {
                totalSize = this.myTotalFilesSize.get();
            }
            if (totalSize > 0x4600000L) {
                TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom(this.myProgress);
                if (tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        String message;
                        UsageLimitUtil.Result ret;
                        if (processPresentation == null) {
                            FindInProjectTask.$$$reportNull$$$0(23);
                        }
                        if ((ret = UsageLimitUtil.showTooManyUsagesWarning((Project)this.myProject, (String)(message = FindBundle.message("find.excessive.total.size.prompt", UsageViewManagerImpl.presentableSize((long)this.myTotalFilesSize.longValue()), ApplicationNamesInfo.getInstance().getProductName())), (UsageViewPresentation)processPresentation.getUsageViewPresentation())) == UsageLimitUtil.Result.ABORT) {
                            this.myProgress.cancel();
                        }
                        tooManyUsagesStatus.userResponded();
                    });
                }
                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                this.myProgress.checkCanceled();
            }
            return true;
        };
        List sorted = ContainerUtil.sorted(virtualFiles, SEARCH_RESULT_FILE_COMPARATOR);
        PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myProject, sorted, this.myProgress, new AtomicBoolean(), (Processor<VirtualFile>)processor2);
    }

    @NotNull
    private Collection<VirtualFile> collectFilesInScope(final @NotNull Set<VirtualFile> alreadySearched, final boolean skipIndexed) {
        if (alreadySearched == null) {
            FindInProjectTask.$$$reportNull$$$0(9);
        }
        SearchScope customScope = this.myFindModel.isCustomScope() ? this.myFindModel.getCustomScope() : null;
        final GlobalSearchScope globalCustomScope = customScope == null ? null : GlobalSearchScopeUtil.toGlobalSearchScope(customScope, this.myProject);
        final ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        final boolean hasTrigrams = FindInProjectTask.hasTrigrams(this.myStringToFindInIndices);
        class EnumContentIterator
        implements ContentIterator {
            private final Set<VirtualFile> myFiles = new LinkedHashSet<VirtualFile>();

            EnumContentIterator() {
            }

            public boolean processFile(final @NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    EnumContentIterator.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){
                    private final FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();

                    @Override
                    public void run() {
                        ProgressManager.checkCanceled();
                        if (virtualFile.isDirectory() || !virtualFile.isValid() || !FindInProjectTask.this.myFileMask.value((Object)virtualFile) || globalCustomScope != null && !globalCustomScope.contains(virtualFile)) {
                            return;
                        }
                        if (skipIndexed && this.isCoveredByIndex(virtualFile) && (fileIndex.isInContent(virtualFile) || fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInLibrarySource(virtualFile))) {
                            return;
                        }
                        Pair.NonNull pair = FindInProjectTask.this.findFile(virtualFile);
                        if (pair == null) {
                            return;
                        }
                        VirtualFile sourceVirtualFile = (VirtualFile)pair.second;
                        if (sourceVirtualFile != null && !alreadySearched.contains(sourceVirtualFile)) {
                            myFiles.add(sourceVirtualFile);
                        }
                    }

                    private boolean isCoveredByIndex(VirtualFile file2) {
                        FileType fileType = file2.getFileType();
                        if (hasTrigrams) {
                            return TrigramIndex.isIndexable(fileType) && this.fileBasedIndex.isIndexingCandidate(file2, TrigramIndex.INDEX_ID);
                        }
                        return IdIndex.isIndexable(fileType) && this.fileBasedIndex.isIndexingCandidate(file2, IdIndex.NAME);
                    }
                });
                return true;
            }

            @NotNull
            private Collection<VirtualFile> getFiles() {
                Set<VirtualFile> set2 = this.myFiles;
                if (set2 == null) {
                    EnumContentIterator.$$$reportNull$$$0(1);
                }
                return set2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "virtualFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/impl/FindInProjectTask$1EnumContentIterator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/impl/FindInProjectTask$1EnumContentIterator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFiles";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processFile";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        final EnumContentIterator iterator = new EnumContentIterator();
        if (customScope instanceof LocalSearchScope) {
            for (VirtualFile file2 : GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)customScope)) {
                iterator.processFile(file2);
            }
        } else if (customScope instanceof Iterable) {
            for (VirtualFile file3 : (Iterable)customScope) {
                iterator.processFile(file3);
            }
        } else if (this.myDirectory != null) {
            final boolean checkExcluded = !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isExcluded(this.myDirectory) && !Registry.is((String)"find.search.in.excluded.dirs");
            VirtualFileVisitor.Option limit = VirtualFileVisitor.limit((int)(this.myFindModel.isWithSubdirectories() ? -1 : 1));
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myDirectory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{limit}){
                {
                    super(arg0);
                }

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (checkExcluded && FindInProjectTask.this.myProjectFileIndex.isExcluded(file2)) {
                        return false;
                    }
                    iterator.processFile(file2);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindInProjectTask$1", "visitFile"));
                }
            });
        } else {
            boolean success2 = this.myFileIndex.iterateContent((ContentIterator)iterator);
            if (success2 && globalCustomScope != null && globalCustomScope.isSearchInLibraries()) {
                VirtualFile[] librarySources = (VirtualFile[])ReadAction.compute(() -> {
                    OrderEnumerator enumerator = this.myModule == null ? OrderEnumerator.orderEntries((Project)this.myProject) : OrderEnumerator.orderEntries((Module)this.myModule);
                    return enumerator.withoutModuleSourceEntries().withoutDepModules().getSourceRoots();
                });
                FindInProjectTask.iterateAll(librarySources, globalCustomScope, iterator);
            }
        }
        Collection collection = iterator.getFiles();
        if (collection == null) {
            FindInProjectTask.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private static void iterateAll(@NotNull VirtualFile[] files2, @NotNull GlobalSearchScope searchScope, @NotNull ContentIterator iterator) {
        if (files2 == null) {
            FindInProjectTask.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            FindInProjectTask.$$$reportNull$$$0(12);
        }
        if (iterator == null) {
            FindInProjectTask.$$$reportNull$$$0(13);
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VirtualFileFilter contentFilter = file2 -> {
            if (searchScope == null) {
                FindInProjectTask.$$$reportNull$$$0(19);
            }
            return file2.isDirectory() || !fileTypeManager.isFileIgnored(file2) && !file2.getFileType().isBinary() && searchScope.contains(file2);
        };
        for (VirtualFile file3 : files2) {
            if (!VfsUtilCore.iterateChildrenRecursively((VirtualFile)file3, (VirtualFileFilter)contentFilter, (ContentIterator)iterator)) break;
        }
    }

    private boolean canRelyOnIndices() {
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        if (this.myFindModel.getCustomScope() instanceof LocalSearchScope) {
            return false;
        }
        String text2 = this.myStringToFindInIndices;
        if (StringUtil.isEmptyOrSpaces((String)text2)) {
            return false;
        }
        if (FindInProjectTask.hasTrigrams(text2)) {
            return true;
        }
        return this.myFindModel.isWholeWordsOnly() && text2.indexOf(36) < 0 && !StringUtil.getWordsInStringLongestFirst((String)text2).isEmpty();
    }

    private static boolean hasTrigrams(@NotNull String text2) {
        if (text2 == null) {
            FindInProjectTask.$$$reportNull$$$0(14);
        }
        return TrigramIndex.ENABLED && !TrigramBuilder.processTrigrams((CharSequence)text2, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor(){

            public boolean execute(int value) {
                return false;
            }
        });
    }

    @NotNull
    private Set<VirtualFile> getFilesForFastWordSearch() {
        VirtualFile[] filesWithWord;
        String stringToFind = this.myStringToFindInIndices;
        if (stringToFind.isEmpty() || DumbService.getInstance((Project)this.myProject).isDumb()) {
            Set<VirtualFile> set2 = Collections.emptySet();
            if (set2 == null) {
                FindInProjectTask.$$$reportNull$$$0(15);
            }
            return set2;
        }
        LinkedHashSet<VirtualFile> resultFiles = new LinkedHashSet<VirtualFile>();
        for (VirtualFile file3 : this.myFilesToScanInitially) {
            if (!this.myFileMask.value((Object)file3)) continue;
            resultFiles.add(file3);
        }
        GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope(FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel), this.myProject);
        if (TrigramIndex.ENABLED) {
            THashSet keys = ContainerUtil.newTroveSet();
            TrigramBuilder.processTrigrams((CharSequence)stringToFind, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor((Set)keys){
                final /* synthetic */ Set val$keys;
                {
                    this.val$keys = set2;
                }

                public boolean execute(int value) {
                    this.val$keys.add(value);
                    return true;
                }
            });
            if (!keys.isEmpty()) {
                ArrayList hits = new ArrayList();
                ApplicationManager.getApplication().runReadAction(() -> FindInProjectTask.lambda$getFilesForFastWordSearch$12((Set)keys, hits, scope));
                for (VirtualFile hit : hits) {
                    if (!this.myFileMask.value((Object)hit)) continue;
                    resultFiles.add(hit);
                }
                LinkedHashSet<VirtualFile> linkedHashSet = resultFiles;
                if (linkedHashSet == null) {
                    FindInProjectTask.$$$reportNull$$$0(16);
                }
                return linkedHashSet;
            }
        }
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.getInstance((Project)this.myProject);
        helper.processFilesWithText(scope, (short)255, this.myFindModel.isCaseSensitive(), stringToFind, (Processor<VirtualFile>)((Processor)file2 -> {
            if (this.myFileMask.value(file2)) {
                ContainerUtil.addIfNotNull((Collection)resultFiles, (Object)file2);
            }
            return true;
        }));
        CacheManager cacheManager = CacheManager.SERVICE.getInstance(this.myProject);
        for (VirtualFile file4 : filesWithWord = cacheManager.getVirtualFilesWithWord(stringToFind, (short)255, scope, this.myFindModel.isCaseSensitive())) {
            if (!this.myFileMask.value((Object)file4)) continue;
            resultFiles.add(file4);
        }
        LinkedHashSet<VirtualFile> linkedHashSet = resultFiles;
        if (linkedHashSet == null) {
            FindInProjectTask.$$$reportNull$$$0(17);
        }
        return linkedHashSet;
    }

    private Pair.NonNull<PsiFile, VirtualFile> findFile(@NotNull VirtualFile virtualFile) {
        PsiFile psiFile;
        if (virtualFile == null) {
            FindInProjectTask.$$$reportNull$$$0(18);
        }
        if ((psiFile = this.myPsiManager.findFile(virtualFile)) != null) {
            PsiFile sourceFile = (PsiFile)psiFile.getNavigationElement();
            if (sourceFile != null) {
                psiFile = sourceFile;
            }
            if (psiFile.getFileType().isBinary()) {
                psiFile = null;
            }
        }
        VirtualFile sourceVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        if (psiFile == null || psiFile.getFileType().isBinary() || sourceVirtualFile == null) {
            return null;
        }
        return Pair.createNonNull((Object)psiFile, (Object)sourceVirtualFile);
    }

    private static /* synthetic */ void lambda$getFilesForFastWordSearch$12(Set keys, List hits, GlobalSearchScope scope) {
        FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, keys, Processors.cancelableCollectProcessor((Collection)hits), scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToScanInitially";
                break;
            }
            case 3: 
            case 7: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 4: 
            case 8: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherFiles";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadySearched";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindInProjectTask";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindInProjectTask";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesInScope";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesForFastWordSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logStats";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "searchInFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesInScope";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "iterateAll";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasTrigrams";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateAll$11";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchInFiles$9";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$8";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

