/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.SwitcherToolWindowsListRenderer;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Switcher
extends AnAction
implements DumbAware {
    private static volatile SwitcherPanel SWITCHER;
    private static final Color BORDER_COLOR;
    private static final Color SEPARATOR_COLOR;
    @NonNls
    private static final String SWITCHER_FEATURE_ID = "switcher";
    private static final Color ON_MOUSE_OVER_BG_COLOR;
    private static int CTRL_KEY;
    @Nullable
    public static final Runnable CHECKER;
    @NotNull
    private static final CustomShortcutSet TW_SHORTCUT;
    @NonNls
    private static final String SWITCHER_TITLE = "Switcher";
    @NonNls
    private static InputEvent INIT_EVENT;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            Switcher.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            Switcher.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        boolean isNewSwitcher = false;
        Class<Switcher> clazz = Switcher.class;
        synchronized (Switcher.class) {
            INIT_EVENT = e.getInputEvent();
            if (SWITCHER != null && SWITCHER.isPinnedMode()) {
                Switcher.SWITCHER.cancel();
                SWITCHER = null;
            }
            if (SWITCHER == null) {
                isNewSwitcher = true;
                SWITCHER = Switcher.createAndShowSwitcher(e, SWITCHER_TITLE, false, null);
                FeatureUsageTracker.getInstance().triggerFeatureUsed(SWITCHER_FEATURE_ID);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            assert (SWITCHER != null);
            if (!SWITCHER.isPinnedMode()) {
                if (e.getInputEvent() != null && e.getInputEvent().isShiftDown()) {
                    SWITCHER.goBack();
                } else if (isNewSwitcher && !FileEditorManagerEx.getInstanceEx(project).hasOpenedFile()) {
                    Switcher.SWITCHER.files.setSelectedIndex(0);
                } else {
                    SWITCHER.goForward();
                }
            }
            return;
        }
    }

    @Nullable
    public static SwitcherPanel createAndShowSwitcher(@NotNull AnActionEvent e, @NotNull String title, boolean pinned, @Nullable VirtualFile[] vFiles) {
        if (e == null) {
            Switcher.$$$reportNull$$$0(2);
        }
        if (title == null) {
            Switcher.$$$reportNull$$$0(3);
        }
        Project project = Switcher.getEventProject((AnActionEvent)e);
        if (SWITCHER != null && Comparing.equal((String)Switcher.SWITCHER.myTitle, (String)title)) {
            SWITCHER.goForward();
            return null;
        }
        return project == null ? null : Switcher.createAndShowSwitcher(project, title, pinned, vFiles == null ? null : Arrays.asList(vFiles));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static SwitcherPanel createAndShowSwitcher(@NotNull Project project, @NotNull String title, boolean pinned, final @Nullable List<VirtualFile> vFiles) {
        if (project == null) {
            Switcher.$$$reportNull$$$0(4);
        }
        if (title == null) {
            Switcher.$$$reportNull$$$0(5);
        }
        Class<Switcher> clazz = Switcher.class;
        synchronized (Switcher.class) {
            if (SWITCHER != null) {
                Switcher.SWITCHER.cancel();
            }
            SWITCHER = new SwitcherPanel(project, title, pinned){

                @Override
                @NotNull
                protected List<VirtualFile> getFiles(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    List<VirtualFile> list2 = vFiles != null ? vFiles : super.getFiles(project);
                    if (list2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return list2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/Switcher$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/Switcher$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFiles";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getFiles";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return SWITCHER;
        }
    }

    static {
        char ch;
        SWITCHER = null;
        BORDER_COLOR = Gray._135;
        SEPARATOR_COLOR = new JBColor(BORDER_COLOR.brighter(), (Color)Gray._75);
        ON_MOUSE_OVER_BG_COLOR = new JBColor(new Color(231, 242, 249), new Color(77, 80, 84));
        CHECKER = () -> {
            Class<Switcher> clazz = Switcher.class;
            synchronized (Switcher.class) {
                if (SWITCHER != null) {
                    SWITCHER.navigate(null);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        };
        Shortcut recentFiles = (Shortcut)ArrayUtil.getFirstElement((Object[])KeymapUtil.getActiveKeymapShortcuts((String)"RecentFiles").getShortcuts());
        ArrayList shortcuts = ContainerUtil.newArrayList();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            shortcuts.add(CustomShortcutSet.fromString((String[])new String[]{"control " + ch}).getShortcuts()[0]);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            Shortcut shortcut = CustomShortcutSet.fromString((String[])new String[]{"control " + ch}).getShortcuts()[0];
            if (shortcut.equals(recentFiles)) continue;
            shortcuts.add(shortcut);
        }
        TW_SHORTCUT = new CustomShortcutSet(shortcuts.toArray(Shortcut.EMPTY_ARRAY));
        IdeEventQueue.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(@NotNull AWTEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (SWITCHER != null && event instanceof KeyEvent && !SWITCHER.isPinnedMode()) {
                    ToolWindow tw;
                    KeyEvent keyEvent = (KeyEvent)event;
                    if (event.getID() == 402 && keyEvent.getKeyCode() == CTRL_KEY) {
                        ApplicationManager.getApplication().invokeLater(CHECKER, ModalityState.current());
                    } else if (event.getID() == 401 && event != INIT_EVENT && (tw = SWITCHER.twShortcuts.get(String.valueOf((char)keyEvent.getKeyCode()))) != null) {
                        SWITCHER.myPopup.closeOk(null);
                        tw.activate(null, true, true);
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/Switcher$1", "dispatch"));
            }
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/Switcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createAndShowSwitcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FileInfo
    extends Pair<VirtualFile, EditorWindow> {
        private final Project myProject;
        private String myNameForRendering;

        public FileInfo(VirtualFile first, EditorWindow second, Project project) {
            super((Object)first, (Object)second);
            this.myProject = project;
        }

        String getNameForRendering() {
            if (this.myNameForRendering == null) {
                this.myNameForRendering = EditorTabPresentationUtil.getUniqueEditorTabTitle(this.myProject, (VirtualFile)this.first, (EditorWindow)this.second);
            }
            return this.myNameForRendering;
        }
    }

    private static class VirtualFilesRenderer
    extends ColoredListCellRenderer {
        private final SwitcherPanel mySwitcherPanel;
        boolean open;

        public VirtualFilesRenderer(@NotNull SwitcherPanel switcherPanel) {
            if (switcherPanel == null) {
                VirtualFilesRenderer.$$$reportNull$$$0(0);
            }
            this.mySwitcherPanel = switcherPanel;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                VirtualFilesRenderer.$$$reportNull$$$0(1);
            }
            if (value instanceof FileInfo) {
                Project project = this.mySwitcherPanel.project;
                VirtualFile virtualFile = (VirtualFile)((FileInfo)((Object)value)).getFirst();
                String renderedName = ((FileInfo)((Object)value)).getNameForRendering();
                this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)project));
                FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
                this.open = FileEditorManager.getInstance((Project)project).isFileOpen(virtualFile);
                boolean hasProblem = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(virtualFile);
                TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, (Color)(hasProblem ? JBColor.red : null), EffectType.WAVE_UNDERSCORE, 0);
                this.append(renderedName, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                Color color = EditorTabPresentationUtil.getFileBackgroundColor(project, virtualFile);
                if (!selected && color != null) {
                    this.setBackground(color);
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)this.mySwitcherPanel, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switcherPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/Switcher$VirtualFilesRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SwitcherPanel
    extends JPanel
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    DataProvider {
        final JBPopup myPopup;
        final JBList toolWindows;
        final JBList files;
        final JPanel separator;
        final ToolWindowManager twManager;
        final JLabel pathLabel;
        final JPanel descriptions;
        final Project project;
        private final boolean myPinned;
        final Map<String, ToolWindow> twShortcuts;
        final Alarm myAlarm;
        final SwitcherSpeedSearch mySpeedSearch;
        final String myTitle;
        final ClickListener myClickListener;
        KeyEvent lastEvent;
        private boolean mouseMovedFirstTime;
        private JList mouseMoveSrc;
        private int mouseMoveListIndex;

        @Nullable
        public Object getData(@NonNls String dataId) {
            List list2;
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId) && !(list2 = this.getSelectedList().getSelectedValuesList()).isEmpty()) {
                ArrayList<Object> vFiles = new ArrayList<Object>();
                for (Object o : list2) {
                    if (!(o instanceof FileInfo)) continue;
                    vFiles.add(((FileInfo)((Object)o)).first);
                }
                return vFiles.isEmpty() ? null : vFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            return null;
        }

        private static void exchangeSelectionState(JBList toClear, JBList toSelect2) {
            if (toSelect2.getModel().getSize() > 0) {
                int index = Math.min(toClear.getSelectedIndex(), toSelect2.getModel().getSize() - 1);
                toSelect2.setSelectedIndex(index);
                toSelect2.ensureIndexIsVisible(index);
                toClear.clearSelection();
            }
        }

        SwitcherPanel(@NotNull Project project, @NotNull String title, boolean pinned) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SwitcherPanel.$$$reportNull$$$0(1);
            }
            this.pathLabel = new JLabel(" ");
            this.myClickListener = new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myPinned && (e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
                        return false;
                    }
                    Object source = e.getSource();
                    if (source instanceof JList) {
                        JList jList = (JList)source;
                        if (jList.getSelectedIndex() == -1 && jList.getAnchorSelectionIndex() != -1) {
                            jList.setSelectedIndex(jList.getAnchorSelectionIndex());
                        }
                        if (jList.getSelectedIndex() != -1) {
                            this.navigate(e);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$1", "onClick"));
                }
            };
            this.mouseMovedFirstTime = true;
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.setLayout(new SwitcherLayouter());
            this.project = project;
            this.myTitle = title;
            this.myPinned = pinned;
            this.mySpeedSearch = pinned ? new SwitcherSpeedSearch() : null;
            this.setBorder((Border)JBUI.Borders.empty());
            this.setBackground(JBColor.background());
            this.pathLabel.setHorizontalAlignment(2);
            Font font = this.pathLabel.getFont();
            this.pathLabel.setFont(font.deriveFont(Math.max(10.0f, (float)font.getSize() - 4.0f)));
            this.descriptions = new JPanel(new BorderLayout()){

                @Override
                protected void paintComponent(@NotNull Graphics g) {
                    if (g == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.paintComponent(g);
                    g.setColor(UIUtil.isUnderDarcula() ? SEPARATOR_COLOR : BORDER_COLOR);
                    UIUtil.drawLine((Graphics)g, (int)0, (int)0, (int)this.getWidth(), (int)0);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/actions/Switcher$SwitcherPanel$2", "paintComponent"));
                }
            };
            this.descriptions.setBorder((Border)JBUI.Borders.empty((int)1, (int)4));
            this.descriptions.add((Component)this.pathLabel, "Center");
            this.twManager = ToolWindowManager.getInstance((Project)project);
            DefaultListModel<ToolWindow> twModel = new DefaultListModel<ToolWindow>();
            List<ActivateToolWindowAction> actions = ToolWindowsGroup.getToolWindowActions(project, true);
            ArrayList windows = ContainerUtil.newArrayList();
            for (Object action : actions) {
                ToolWindow tw = this.twManager.getToolWindow(action.getToolWindowId());
                if (!tw.isAvailable()) continue;
                windows.add(tw);
            }
            this.twShortcuts = SwitcherPanel.createShortcuts(windows);
            Map map2 = ContainerUtil.reverseMap(this.twShortcuts);
            Collections.sort(windows, (o1, o2) -> StringUtil.compare((String)((String)map2.get(o1)), (String)((String)map2.get(o2)), (boolean)false));
            for (ToolWindow window2 : windows) {
                twModel.addElement(window2);
            }
            this.toolWindows = new JBList(twModel);
            this.toolWindows.addFocusListener((FocusListener)new MyToolWindowsListFocusListener());
            if (pinned) {
                new NameFilteringListModel((JList)this.toolWindows, window -> window.getStripeTitle(), s -> !this.mySpeedSearch.isPopupActive() || StringUtil.isEmpty((String)this.mySpeedSearch.getEnteredPrefix()) || this.mySpeedSearch.getComparator().matchingFragments(this.mySpeedSearch.getEnteredPrefix(), (String)s) != null, (SpeedSearchSupply)this.mySpeedSearch);
            }
            this.toolWindows.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)5, (int)20));
            this.toolWindows.setSelectionMode(pinned ? 2 : 0);
            this.toolWindows.setCellRenderer((ListCellRenderer)((Object)new SwitcherToolWindowsListRenderer(this.mySpeedSearch, map2, this.myPinned){

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                    if (list2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    JComponent renderer = (JComponent)super.getListCellRendererComponent(list2, value, index, selected, selected);
                    if (selected) {
                        JComponent jComponent = renderer;
                        if (jComponent == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        return jComponent;
                    }
                    Color bgColor = list2 == mouseMoveSrc && index == mouseMoveListIndex ? ON_MOUSE_OVER_BG_COLOR : list2.getBackground();
                    UIUtil.changeBackGround((Component)renderer, (Color)bgColor);
                    JComponent jComponent = renderer;
                    if (jComponent == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return jComponent;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$3";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }));
            this.toolWindows.addKeyListener((KeyListener)this);
            ScrollingUtil.installActions((JList)this.toolWindows);
            this.toolWindows.addMouseListener((MouseListener)this);
            this.toolWindows.addMouseMotionListener((MouseMotionListener)this);
            ScrollingUtil.ensureSelectionExists((JList)this.toolWindows);
            this.myClickListener.installOn((Component)this.toolWindows);
            this.toolWindows.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (!toolWindows.isSelectionEmpty() && !files.isSelectionEmpty()) {
                        files.clearSelection();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$4", "valueChanged"));
                }
            });
            this.separator = new JPanel(){

                @Override
                protected void paintComponent(@NotNull Graphics g) {
                    if (g == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    super.paintComponent(g);
                    g.setColor(SEPARATOR_COLOR);
                    UIUtil.drawLine((Graphics)g, (int)0, (int)0, (int)0, (int)this.getHeight());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/actions/Switcher$SwitcherPanel$5", "paintComponent"));
                }
            };
            this.separator.setBackground(this.toolWindows.getBackground());
            int selectionIndex = -1;
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project);
            ArrayList filesData = new ArrayList();
            ArrayList<FileInfo> editors = new ArrayList<FileInfo>();
            if (!pinned && UISettings.getInstance().getEditorTabPlacement() != 0) {
                for (Pair<VirtualFile, EditorWindow> pair : editorManager.getSelectionHistory()) {
                    editors.add(new FileInfo((VirtualFile)pair.first, (EditorWindow)pair.second, project));
                }
            }
            if (editors.size() < 2 || this.isPinnedMode()) {
                if (this.isPinnedMode() && editors.size() > 1) {
                    filesData.addAll(editors);
                }
                List<VirtualFile> recentFiles = this.getFiles(project);
                int maxFiles = Math.max(editors.size(), recentFiles.size());
                int minIndex = this.isPinnedMode() ? 0 : recentFiles.size() - Math.min(this.toolWindows.getModel().getSize(), maxFiles);
                boolean firstRecentMarked = false;
                List<VirtualFile> selectedFiles = Arrays.asList(editorManager.getSelectedFiles());
                for (int i = recentFiles.size() - 1; i >= minIndex; --i) {
                    if (this.isPinnedMode() && selectedFiles.contains(recentFiles.get(i)) && UISettings.getInstance().getEditorTabPlacement() != 0) continue;
                    FileInfo info2 = new FileInfo(recentFiles.get(i), null, project);
                    boolean add = true;
                    if (this.isPinnedMode()) {
                        for (FileInfo fileInfo : filesData) {
                            if (!((VirtualFile)fileInfo.first).equals(info2.first)) continue;
                            add = false;
                            break;
                        }
                    }
                    if (!add) continue;
                    filesData.add(info2);
                    if (firstRecentMarked || (selectionIndex = filesData.size() - 1) == 0 && UISettings.getInstance().getEditorTabPlacement() == 0 && this.isPinnedMode()) continue;
                    firstRecentMarked = true;
                }
                if (editors.size() == 1 && (filesData.isEmpty() || !((VirtualFile)((FileInfo)((Object)editors.get(0))).getFirst()).equals(((FileInfo)((Object)filesData.get(0))).getFirst()))) {
                    filesData.add(0, editors.get(0));
                }
            } else {
                for (int i = 0; i < Math.min(30, editors.size()); ++i) {
                    filesData.add(editors.get(i));
                }
            }
            DefaultListModel<FileInfo> filesModel = new DefaultListModel<FileInfo>();
            for (FileInfo editor : filesData) {
                filesModel.addElement(editor);
            }
            VirtualFilesRenderer filesRenderer = new VirtualFilesRenderer(this){
                JPanel myPanel;
                JLabel myLabel;
                {
                    super(switcherPanel);
                    this.myPanel = new JPanel(new BorderLayout());
                    this.myLabel = new JLabel(){

                        @Override
                        protected void paintComponent(@NotNull Graphics g) {
                            if (g == null) {
                                SwitcherPanel.1.$$$reportNull$$$0(0);
                            }
                            GraphicsConfig config = new GraphicsConfig(g);
                            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.3f));
                            super.paintComponent(g);
                            config.restore();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/actions/Switcher$SwitcherPanel$6$1", "paintComponent"));
                        }
                    };
                    this.myPanel.setOpaque(false);
                    this.myPanel.setBackground(UIUtil.getListBackground());
                    this.myLabel.setText("* ");
                }

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                    if (list2 == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    assert (value instanceof FileInfo);
                    Component c = super.getListCellRendererComponent(list2, value, index, selected, selected);
                    Color bg = UIUtil.getListBackground();
                    Color fg = UIUtil.getListForeground();
                    this.myLabel.setFont(list2.getFont());
                    this.myLabel.setForeground(this.open ? fg : bg);
                    this.myPanel.removeAll();
                    this.myPanel.add((Component)this.myLabel, "West");
                    this.myPanel.add(c, "Center");
                    this.myPanel.getAccessibleContext().setAccessibleName(c.getAccessibleContext().getAccessibleName());
                    VirtualFile file2 = (VirtualFile)((FileInfo)((Object)value)).first;
                    String presentableUrl = ((VirtualFile)ObjectUtils.notNull((Object)file2.getParent(), (Object)file2)).getPresentableUrl();
                    String location = FileUtil.getLocationRelativeToUserHome((String)presentableUrl);
                    this.myPanel.getAccessibleContext().setAccessibleDescription(location);
                    if (!selected && list2 == mouseMoveSrc && index == mouseMoveListIndex) {
                        this.setBackground(ON_MOUSE_OVER_BG_COLOR);
                    }
                    JPanel jPanel = this.myPanel;
                    if (jPanel == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    return jPanel;
                }

                @Override
                protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                    if (list2 == null) {
                        6.$$$reportNull$$$0(2);
                    }
                    this.setPaintFocusBorder(false);
                    super.customizeCellRenderer(list2, value, index, selected, hasFocus);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$6";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$6";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "customizeCellRenderer";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            ListSelectionListener filesSelectionListener = new ListSelectionListener(){

                @Nullable
                private String getTitle2Text(@Nullable String fullText) {
                    int labelWidth = pathLabel.getWidth();
                    if (fullText == null || fullText.length() == 0) {
                        return " ";
                    }
                    while (pathLabel.getFontMetrics(pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                        int sep = fullText.indexOf(File.separatorChar, 4);
                        if (sep < 0) {
                            return fullText;
                        }
                        fullText = "..." + fullText.substring(sep);
                    }
                    return fullText;
                }

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> this.updatePathLabel());
                }

                private void updatePathLabel() {
                    Object[] values = files.getSelectedValues();
                    if (values != null && values.length == 1) {
                        VirtualFile file2 = (VirtualFile)((FileInfo)((Object)values[0])).first;
                        String presentableUrl = ((VirtualFile)ObjectUtils.notNull((Object)file2.getParent(), (Object)file2)).getPresentableUrl();
                        pathLabel.setText(this.getTitle2Text(FileUtil.getLocationRelativeToUserHome((String)presentableUrl)));
                    } else {
                        pathLabel.setText(" ");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$7", "valueChanged"));
                }
            };
            this.files = new JBList(filesModel);
            if (pinned) {
                new NameFilteringListModel((JList)this.files, info -> info.getNameForRendering(), s -> !this.mySpeedSearch.isPopupActive() || StringUtil.isEmpty((String)this.mySpeedSearch.getEnteredPrefix()) || this.mySpeedSearch.getComparator().matchingFragments(this.mySpeedSearch.getEnteredPrefix(), (String)s) != null, (SpeedSearchSupply)this.mySpeedSearch);
            }
            this.files.setSelectionMode(pinned ? 2 : 0);
            this.files.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if (!files.isSelectionEmpty() && !toolWindows.isSelectionEmpty()) {
                        toolWindows.getSelectionModel().clearSelection();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$8", "valueChanged"));
                }
            });
            this.files.getSelectionModel().addListSelectionListener(filesSelectionListener);
            this.files.setCellRenderer((ListCellRenderer)((Object)filesRenderer));
            this.files.setBorder(JBUI.Borders.empty((int)5));
            this.files.addKeyListener((KeyListener)this);
            ScrollingUtil.installActions((JList)this.files);
            this.files.addMouseListener((MouseListener)this);
            this.files.addMouseMotionListener((MouseMotionListener)this);
            this.files.addFocusListener((FocusListener)new MyFilesListFocusListener());
            this.myClickListener.installOn((Component)this.files);
            ScrollingUtil.ensureSelectionExists((JList)this.files);
            this.add((Component)this.toolWindows, "West");
            if (filesModel.size() > 0) {
                this.files.setAlignmentY(1.0f);
                JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.files, (boolean)true);
                pane.setPreferredSize(new Dimension(this.files.getPreferredSize().width, 400));
                this.add((Component)pane, "East");
                if (selectionIndex > -1) {
                    this.files.setSelectedIndex(selectionIndex);
                }
                this.add((Component)this.separator, "Center");
            }
            this.add((Component)this.descriptions, "South");
            ShortcutSet shortcutSet = ActionManager.getInstance().getAction(Switcher.SWITCHER_TITLE).getShortcutSet();
            int modifiers = SwitcherPanel.getModifiers(shortcutSet);
            boolean isAlt = (modifiers & 8) != 0;
            CTRL_KEY = isAlt ? 18 : 17;
            this.files.addKeyListener((KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners()));
            this.toolWindows.addKeyListener((KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners()));
            KeymapUtil.reassignAction((JComponent)this.toolWindows, (KeyStroke)KeyStroke.getKeyStroke(38, 0), (KeyStroke)KeyStroke.getKeyStroke(38, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction((JComponent)this.toolWindows, (KeyStroke)KeyStroke.getKeyStroke(40, 0), (KeyStroke)KeyStroke.getKeyStroke(40, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction((JComponent)this.files, (KeyStroke)KeyStroke.getKeyStroke(38, 0), (KeyStroke)KeyStroke.getKeyStroke(38, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction((JComponent)this.files, (KeyStroke)KeyStroke.getKeyStroke(40, 0), (KeyStroke)KeyStroke.getKeyStroke(40, 128), (int)0, (boolean)false);
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)(filesModel.getSize() > 0 ? this.files : this.toolWindows)).setResizable(pinned).setModalContext(false).setFocusable(true).setRequestFocus(true).setTitle(title).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(pinned).setCancelKeyEnabled(false).setCancelCallback(() -> {
                Container popupFocusAncestor = this.getPopupFocusAncestor();
                if (popupFocusAncestor != null) {
                    popupFocusAncestor.setFocusTraversalPolicy(null);
                }
                SWITCHER = null;
                return true;
            }).createPopup();
            if (this.isPinnedMode()) {
                new DumbAwareAction(null, null, null){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        if (mySpeedSearch != null && mySpeedSearch.isPopupActive()) {
                            mySpeedSearch.hidePopup();
                            Object[] elements = mySpeedSearch.getAllElements();
                            if (elements != null && elements.length > 0) {
                                mySpeedSearch.selectElement(elements[0], "");
                            }
                        } else {
                            myPopup.cancel();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$9", "actionPerformed"));
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)this, (Disposable)this.myPopup);
            }
            new DumbAwareAction(null, null, null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        10.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$10", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)TW_SHORTCUT, (JComponent)this, (Disposable)this.myPopup);
            Window window3 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window3 == null) {
                window3 = WindowManager.getInstance().getFrame(project);
            }
            this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            this.myPopup.showInCenterOf((Component)window3);
            Container popupFocusAncestor = this.getPopupFocusAncestor();
            popupFocusAncestor.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 0, "RIGHT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 1, "LEFT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 0, "control RIGHT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 1, "control LEFT");
        }

        private Container getPopupFocusAncestor() {
            JComponent content = this.myPopup.getContent();
            return content == null ? null : content.getFocusCycleRootAncestor();
        }

        private static void addFocusTraversalKeys(Container focusCycleRoot, int focusTraversalType, String keyStroke) {
            Set<AWTKeyStroke> focusTraversalKeySet = focusCycleRoot.getFocusTraversalKeys(focusTraversalType);
            HashSet<AWTKeyStroke> set2 = new HashSet<AWTKeyStroke>(focusTraversalKeySet);
            set2.add(KeyStroke.getKeyStroke(keyStroke));
            focusCycleRoot.setFocusTraversalKeys(focusTraversalType, set2);
        }

        @NotNull
        protected List<VirtualFile> getFiles(@NotNull Project project) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(2);
            }
            List<VirtualFile> list2 = EditorHistoryManager.getInstance(project).getFileList();
            if (list2 == null) {
                SwitcherPanel.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        private static Map<String, ToolWindow> createShortcuts(@NotNull List<ToolWindow> windows) {
            if (windows == null) {
                SwitcherPanel.$$$reportNull$$$0(4);
            }
            HashMap<String, ToolWindow> keymap = new HashMap<String, ToolWindow>(windows.size());
            ArrayList<ToolWindow> otherTW = new ArrayList<ToolWindow>();
            for (ToolWindow window : windows) {
                int index = ActivateToolWindowAction.getMnemonicForToolWindow(((ToolWindowImpl)window).getId());
                if (index >= 48 && index <= 57) {
                    keymap.put(SwitcherPanel.getIndexShortcut(index - 48), window);
                    continue;
                }
                otherTW.add(window);
            }
            int i = 0;
            for (ToolWindow window : otherTW) {
                String bestShortcut = SwitcherPanel.getSmartShortcut(window, keymap);
                if (bestShortcut != null) {
                    keymap.put(bestShortcut, window);
                    continue;
                }
                while (keymap.get(SwitcherPanel.getIndexShortcut(i)) != null) {
                    ++i;
                }
                keymap.put(SwitcherPanel.getIndexShortcut(i), window);
                ++i;
            }
            HashMap<String, ToolWindow> hashMap = keymap;
            if (hashMap == null) {
                SwitcherPanel.$$$reportNull$$$0(5);
            }
            return hashMap;
        }

        @Nullable
        private static String getSmartShortcut(ToolWindow window, Map<String, ToolWindow> keymap) {
            String title = window.getStripeTitle();
            if (StringUtil.isEmpty((String)title)) {
                return null;
            }
            for (int i = 0; i < title.length(); ++i) {
                String shortcut;
                char c = title.charAt(i);
                if (!Character.isUpperCase(c) || keymap.get(shortcut = String.valueOf(c)) != null) continue;
                return shortcut;
            }
            return null;
        }

        private static String getIndexShortcut(int index) {
            return StringUtil.toUpperCase((String)Integer.toString(index, index + 1));
        }

        private static int getModifiers(@Nullable ShortcutSet shortcutSet) {
            if (shortcutSet == null || shortcutSet.getShortcuts().length == 0 || !(shortcutSet.getShortcuts()[0] instanceof KeyboardShortcut)) {
                return 2;
            }
            return ((KeyboardShortcut)shortcutSet.getShortcuts()[0]).getFirstKeyStroke().getModifiers();
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(6);
            }
            if (e.getKeyCode() == 10) {
                this.navigate(e);
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            boolean ctrl;
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(7);
            }
            boolean bl = ctrl = e.getKeyCode() == CTRL_KEY;
            if (ctrl && this.isAutoHide()) {
                this.navigate(e);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(8);
            }
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive() || this.lastEvent == e) {
                return;
            }
            this.lastEvent = e;
            switch (e.getKeyCode()) {
                case 8: 
                case 81: 
                case 127: {
                    this.closeTabOrToolWindow();
                    break;
                }
                case 27: {
                    this.cancel();
                }
            }
        }

        private void closeTabOrToolWindow() {
            JBList selectedList = this.getSelectedList();
            int[] selected = selectedList.getSelectedIndices();
            Arrays.sort(selected);
            int selectedIndex = 0;
            for (int i = selected.length - 1; i >= 0; --i) {
                selectedIndex = selected[i];
                Object value = selectedList.getModel().getElementAt(selectedIndex);
                if (value instanceof FileInfo) {
                    FileInfo info = (FileInfo)((Object)value);
                    VirtualFile virtualFile = (VirtualFile)info.first;
                    FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    JBList jList = this.getSelectedList();
                    EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                    if (wnd == null) {
                        editorManager.closeFile(virtualFile, false, false);
                    } else {
                        editorManager.closeFile(virtualFile, wnd, false);
                    }
                    IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.project);
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(() -> {
                        JBList focusTarget = selectedList;
                        if (selectedList.getModel().getSize() == 0) {
                            focusTarget = selectedList == this.files ? this.toolWindows : this.files;
                        }
                        focusManager.requestFocus((Component)focusTarget, true);
                    }, 300);
                    if (jList.getModel().getSize() == 1) {
                        SwitcherPanel.removeElementAt((JList)jList, selectedIndex);
                        this.remove((Component)jList);
                        this.remove(this.separator);
                        Dimension size = this.toolWindows.getSize();
                        this.myPopup.setSize(new Dimension(size.width, this.myPopup.getSize().height));
                    } else {
                        SwitcherPanel.removeElementAt((JList)jList, selectedIndex);
                        jList.setSize(jList.getPreferredSize());
                    }
                    if (!this.isPinnedMode()) continue;
                    EditorHistoryManager.getInstance(this.project).removeFile(virtualFile);
                    continue;
                }
                if (!(value instanceof ToolWindow)) continue;
                ToolWindow toolWindow = (ToolWindow)value;
                if (this.twManager instanceof ToolWindowManagerImpl) {
                    ToolWindowManagerImpl manager = (ToolWindowManagerImpl)this.twManager;
                    manager.hideToolWindow(((ToolWindowImpl)toolWindow).getId(), false, false);
                    continue;
                }
                toolWindow.hide(null);
            }
            this.pack();
            this.myPopup.getContent().revalidate();
            this.myPopup.getContent().repaint();
            if (this.getSelectedList().getModel().getSize() > selectedIndex) {
                this.getSelectedList().setSelectedIndex(selectedIndex);
                this.getSelectedList().ensureIndexIsVisible(selectedIndex);
            }
        }

        private static void removeElementAt(@NotNull JList jList, int index) {
            ListModel model;
            if (jList == null) {
                SwitcherPanel.$$$reportNull$$$0(9);
            }
            if ((model = jList.getModel()) instanceof DefaultListModel) {
                ((DefaultListModel)model).removeElementAt(index);
            } else if (model instanceof NameFilteringListModel) {
                ((NameFilteringListModel)model).remove(index);
            } else {
                throw new IllegalArgumentException("Wrong list model " + model.getClass());
            }
        }

        private void pack() {
            this.setSize(this.getPreferredSize());
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            Container container = this;
            do {
                container = container.getParent();
                container.setSize(container.getPreferredSize());
            } while (container != rootPane);
            container.getParent().setSize(container.getPreferredSize());
        }

        private boolean isFilesSelected() {
            return this.getSelectedList() == this.files;
        }

        private boolean isFilesVisible() {
            return this.files.getModel().getSize() > 0;
        }

        private boolean isToolWindowsSelected() {
            return this.getSelectedList() == this.toolWindows;
        }

        private void cancel() {
            this.myPopup.cancel();
        }

        public void go(boolean forward) {
            JBList selected;
            JBList list2 = selected = this.getSelectedList();
            int index = list2.getSelectedIndex();
            index = forward ? ++index : --index;
            if (forward && index >= list2.getModel().getSize() || !forward && index < 0) {
                if (this.isFilesVisible()) {
                    list2 = this.isFilesSelected() ? this.toolWindows : this.files;
                }
                index = forward ? 0 : list2.getModel().getSize() - 1;
            }
            list2.setSelectedIndex(index);
            list2.ensureIndexIsVisible(index);
            if (selected != list2) {
                IdeFocusManager.findInstanceByComponent((Component)list2).requestFocus((Component)list2, true);
            }
        }

        public void goForward() {
            this.go(true);
        }

        public void goBack() {
            this.go(false);
        }

        public JBList getSelectedList() {
            return this.getSelectedList(this.files);
        }

        @Nullable
        JBList getSelectedList(@Nullable JBList preferable) {
            return this.files.hasFocus() ? this.files : (this.toolWindows.hasFocus() ? this.toolWindows : preferable);
        }

        void navigate(InputEvent e) {
            boolean openInNewWindow = e != null && e.isShiftDown() && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 10;
            Object[] values = this.getSelectedList().getSelectedValues();
            String searchQuery = this.mySpeedSearch != null ? this.mySpeedSearch.getEnteredPrefix() : null;
            this.myPopup.cancel(null);
            if (values.length == 0) {
                this.tryToOpenFileSearch(e, searchQuery);
            } else if (values[0] instanceof ToolWindow) {
                ToolWindow toolWindow = (ToolWindow)values[0];
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(() -> toolWindow.activate(null, true, true), ModalityState.current());
            } else {
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(() -> {
                    FileEditorManagerImpl manager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    for (Object value : values) {
                        if (!(value instanceof FileInfo)) continue;
                        FileInfo info = (FileInfo)((Object)((Object)value));
                        VirtualFile file2 = (VirtualFile)info.first;
                        if (openInNewWindow) {
                            manager.openFileInNewWindow(file2);
                            continue;
                        }
                        if (info.second != null) {
                            EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                            if (wnd == null) continue;
                            manager.openFileImpl2(wnd, file2, true);
                            manager.addSelectionRecord(file2, wnd);
                            continue;
                        }
                        boolean oldValue = UISettings.getInstance().getReuseNotModifiedTabs();
                        UISettings.getInstance().setReuseNotModifiedTabs(false);
                        manager.openFile(file2, true, true);
                        if (!oldValue) continue;
                        CommandProcessor.getInstance().executeCommand(this.project, () -> UISettings.getInstance().setReuseNotModifiedTabs(true), "", null);
                    }
                }, ModalityState.current());
            }
        }

        private void tryToOpenFileSearch(InputEvent e, final String fileName) {
            AnAction gotoFile = ActionManager.getInstance().getAction("GotoFile");
            if (gotoFile != null && !StringUtil.isEmpty((String)fileName)) {
                this.myPopup.cancel();
                AnAction action = gotoFile;
                ApplicationManager.getApplication().invokeLater(() -> DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> {
                    DataContext dataContext = new DataContext((DataContext)context){
                        final /* synthetic */ DataContext val$context;
                        {
                            this.val$context = dataContext;
                        }

                        @Nullable
                        public Object getData(@NonNls String dataId) {
                            if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                                return fileName;
                            }
                            return this.val$context.getData(dataId);
                        }
                    };
                    AnActionEvent event = new AnActionEvent(e, dataContext, "EditorPopup", new PresentationFactory().getPresentation(action), ActionManager.getInstance(), 0);
                    action.actionPerformed(event);
                }), ModalityState.current());
            }
        }

        @Nullable
        private static EditorWindow findAppropriateWindow(@NotNull FileInfo info) {
            if (info == null) {
                SwitcherPanel.$$$reportNull$$$0(10);
            }
            if (info.second == null) {
                return null;
            }
            Object[] windows = ((EditorWindow)info.second).getOwner().getWindows();
            return ArrayUtil.contains((Object)info.second, (Object[])windows) ? (EditorWindow)info.second : (windows.length > 0 ? windows[0] : null);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(11);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            JList list2;
            int index;
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(12);
            }
            if (this.mouseMovedFirstTime) {
                this.mouseMovedFirstTime = false;
                return;
            }
            Object source = e.getSource();
            boolean changed = false;
            if (source instanceof JList && 0 <= (index = (list2 = (JList)source).locationToIndex(e.getPoint())) && index < list2.getModel().getSize()) {
                this.mouseMoveSrc = list2;
                this.mouseMoveListIndex = index;
                changed = true;
            }
            if (!changed) {
                this.mouseMoveSrc = null;
                this.mouseMoveListIndex = -1;
            }
            this.repaintLists();
        }

        private void repaintLists() {
            this.toolWindows.repaint();
            this.files.repaint();
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(13);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(14);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(15);
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(16);
            }
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.repaintLists();
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(17);
            }
        }

        public boolean isAutoHide() {
            return !this.myPinned;
        }

        public boolean isPinnedMode() {
            return this.myPinned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windows";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jList";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createShortcuts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createShortcuts";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "keyTyped";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "keyReleased";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "keyPressed";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElementAt";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findAppropriateWindow";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseClicked";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseMoved";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "mousePressed";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseReleased";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseEntered";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseExited";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseDragged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class SwitcherLayouter
        extends BorderLayout {
            private Rectangle sBounds;
            private Rectangle tBounds;
            private Rectangle fBounds;
            private Rectangle dBounds;

            private SwitcherLayouter() {
            }

            @Override
            public void layoutContainer(@NotNull Container target2) {
                JScrollPane scrollPane;
                JScrollPane filesPane;
                if (target2 == null) {
                    SwitcherLayouter.$$$reportNull$$$0(0);
                }
                JScrollPane jScrollPane = filesPane = (scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)SwitcherPanel.this.files)) != null ? scrollPane : SwitcherPanel.this.files;
                if (this.sBounds == null || !target2.isShowing()) {
                    super.layoutContainer(target2);
                    this.sBounds = SwitcherPanel.this.separator.getBounds();
                    this.tBounds = SwitcherPanel.this.toolWindows.getBounds();
                    this.fBounds = filesPane.getBounds();
                    this.dBounds = SwitcherPanel.this.descriptions.getBounds();
                } else {
                    int h = target2.getHeight();
                    int w = target2.getWidth();
                    this.sBounds.height = h - this.dBounds.height;
                    this.tBounds.height = h - this.dBounds.height;
                    this.fBounds.height = h - this.dBounds.height;
                    this.fBounds.width = w - this.sBounds.width - this.tBounds.width;
                    this.dBounds.width = w;
                    this.dBounds.y = h - this.dBounds.height;
                    SwitcherPanel.this.separator.setBounds(this.sBounds);
                    SwitcherPanel.this.toolWindows.setBounds(this.tBounds);
                    filesPane.setBounds(this.fBounds);
                    SwitcherPanel.this.descriptions.setBounds(this.dBounds);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherLayouter", "layoutContainer"));
            }
        }

        private class SwitcherSpeedSearch
        extends SpeedSearchBase<SwitcherPanel>
        implements PropertyChangeListener {
            private Object[] myElements;

            public SwitcherSpeedSearch() {
                super(SwitcherPanel.this);
                this.addChangeListener(this);
                this.setComparator(new SpeedSearchComparator(false, true));
            }

            @Override
            protected void processKeyEvent(@NotNull KeyEvent e) {
                int keyCode;
                if (e == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(0);
                }
                if ((keyCode = e.getKeyCode()) == 10) {
                    SWITCHER.navigate(e);
                    e.consume();
                    return;
                }
                if (keyCode == 37 || keyCode == 39) {
                    return;
                }
                super.processKeyEvent(e);
            }

            @Override
            protected int getSelectedIndex() {
                return SwitcherPanel.this.isFilesSelected() ? SwitcherPanel.this.files.getSelectedIndex() : SwitcherPanel.this.files.getModel().getSize() + SwitcherPanel.this.toolWindows.getSelectedIndex();
            }

            @Override
            @NotNull
            protected Object[] getAllElements() {
                SwitcherPanel switcher = SwitcherPanel.this;
                ListModel filesModel = switcher.files.getModel();
                Object[] files2 = new Object[filesModel.getSize()];
                for (int i = 0; i < files2.length; ++i) {
                    files2[i] = filesModel.getElementAt(i);
                }
                ListModel twModel = switcher.toolWindows.getModel();
                Object[] toolWindows = new Object[twModel.getSize()];
                for (int i = 0; i < toolWindows.length; ++i) {
                    toolWindows[i] = twModel.getElementAt(i);
                }
                this.myElements = new Object[files2.length + toolWindows.length];
                System.arraycopy(files2, 0, this.myElements, 0, files2.length);
                System.arraycopy(toolWindows, 0, this.myElements, files2.length, toolWindows.length);
                if (this.myElements == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(1);
                }
                return this.myElements;
            }

            @Override
            protected String getElementText(Object element) {
                if (element instanceof ToolWindow) {
                    return ((ToolWindow)element).getStripeTitle();
                }
                if (element instanceof FileInfo) {
                    return ((FileInfo)((Object)element)).getNameForRendering();
                }
                return "";
            }

            @Override
            protected void selectElement(Object element, String selectedText) {
                if (element instanceof FileInfo) {
                    if (!SwitcherPanel.this.toolWindows.isSelectionEmpty()) {
                        SwitcherPanel.this.toolWindows.clearSelection();
                    }
                    SwitcherPanel.this.files.clearSelection();
                    SwitcherPanel.this.files.setSelectedValue(element, true);
                    SwitcherPanel.this.files.requestFocusInWindow();
                } else {
                    if (!SwitcherPanel.this.files.isSelectionEmpty()) {
                        SwitcherPanel.this.files.clearSelection();
                    }
                    SwitcherPanel.this.toolWindows.clearSelection();
                    SwitcherPanel.this.toolWindows.setSelectedValue(element, true);
                    SwitcherPanel.this.toolWindows.requestFocusInWindow();
                }
            }

            @Override
            @Nullable
            protected Object findElement(String s) {
                List<SpeedSearchObjectWithWeight> elements = SpeedSearchObjectWithWeight.findElement(s, this);
                return elements.isEmpty() ? null : elements.get((int)0).node;
            }

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(2);
                }
                if (SwitcherPanel.this.project.isDisposed()) {
                    SwitcherPanel.this.myPopup.cancel();
                    return;
                }
                ((NameFilteringListModel)SwitcherPanel.this.files.getModel()).refilter();
                ((NameFilteringListModel)SwitcherPanel.this.toolWindows.getModel()).refilter();
                if (SwitcherPanel.this.files.getModel().getSize() + SwitcherPanel.this.toolWindows.getModel().getSize() == 0) {
                    SwitcherPanel.this.toolWindows.getEmptyText().setText("");
                    SwitcherPanel.this.files.getEmptyText().setText("Press 'Enter' to search in Project");
                } else {
                    SwitcherPanel.this.files.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                    SwitcherPanel.this.toolWindows.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                }
                this.refreshSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherSpeedSearch";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "evt";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherSpeedSearch";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processKeyEvent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "propertyChange";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyFilesListFocusListener
        extends FocusAdapter {
            private MyFilesListFocusListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                SwitcherPanel.exchangeSelectionState(SwitcherPanel.this.toolWindows, SwitcherPanel.this.files);
            }
        }

        private class MyToolWindowsListFocusListener
        extends FocusAdapter {
            private MyToolWindowsListFocusListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                SwitcherPanel.exchangeSelectionState(SwitcherPanel.this.files, SwitcherPanel.this.toolWindows);
            }
        }

        private class MyFocusTraversalPolicy
        extends FocusTraversalPolicy {
            private MyFocusTraversalPolicy() {
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                return aComponent == SwitcherPanel.this.toolWindows ? SwitcherPanel.this.files : SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return aComponent == SwitcherPanel.this.toolWindows ? SwitcherPanel.this.files : SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return SwitcherPanel.this.files;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return SwitcherPanel.this.files;
            }
        }
    }
}

