/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PersistentSearchEverywhereContributorFilter<T>
implements SearchEverywhereContributorFilter<T> {
    private final ChooseByNameFilterConfiguration<T> myPersistentConfiguration;
    private final List<T> myElements;
    private final Function<? super T, String> myTextExtractor;
    private final Function<? super T, ? extends Icon> myIconExtractor;

    public PersistentSearchEverywhereContributorFilter(@NotNull List<T> elements, @NotNull ChooseByNameFilterConfiguration<T> configuration, Function<? super T, String> textExtractor, Function<? super T, ? extends Icon> iconExtractor) {
        if (elements == null) {
            PersistentSearchEverywhereContributorFilter.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            PersistentSearchEverywhereContributorFilter.$$$reportNull$$$0(1);
        }
        this.myElements = elements;
        this.myPersistentConfiguration = configuration;
        this.myTextExtractor = textExtractor;
        this.myIconExtractor = iconExtractor;
    }

    public List<T> getAllElements() {
        return this.myElements;
    }

    public List<T> getSelectedElements() {
        return this.myElements.stream().filter(this.myPersistentConfiguration::isFileTypeVisible).collect(Collectors.toList());
    }

    public boolean isSelected(T element) {
        return this.myPersistentConfiguration.isFileTypeVisible(element);
    }

    public void setSelected(T element, boolean selected) {
        this.myPersistentConfiguration.setVisible(element, selected);
    }

    public String getElementText(T element) {
        return this.myTextExtractor.apply(element);
    }

    public Icon getElementIcon(T element) {
        return this.myIconExtractor.apply(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/searcheverywhere/PersistentSearchEverywhereContributorFilter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

