/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.ide.actions.searcheverywhere.ContributorSearchResult;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class RecentFilesSEContributor
extends FileSearchEverywhereContributor {
    public RecentFilesSEContributor(Project project) {
        super(project);
    }

    @Override
    @NotNull
    public String getSearchProviderId() {
        String string = RecentFilesSEContributor.class.getSimpleName();
        if (string == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupName() {
        if ("Recent Files" == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(1);
        }
        return "Recent Files";
    }

    @Override
    public String includeNonProjectItemsText() {
        return null;
    }

    @Override
    public int getSortWeight() {
        return 70;
    }

    @Override
    public ContributorSearchResult<Object> search(String pattern, boolean everywhere, SearchEverywhereContributorFilter<FileType> filter, ProgressIndicator progressIndicator, int elementsLimit) {
        String searchString = this.filterControlSymbols(pattern);
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + searchString)).build();
        List<VirtualFile> opened = Arrays.asList(FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles());
        List history = Lists.reverse(EditorHistoryManager.getInstance(this.myProject).getFileList());
        ArrayList res = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            Stream<Object> stream = history.stream();
            if (!StringUtil.isEmptyOrSpaces((String)searchString)) {
                stream = stream.filter(file2 -> matcher.matches(file2.getName()));
            }
            res.addAll(stream.filter(vf -> !opened.contains(vf) && vf.isValid()).distinct().map(vf -> psiManager.findFile(vf)).collect(Collectors.toList()));
        });
        return elementsLimit > 0 && res.size() > elementsLimit ? new ContributorSearchResult(res.subList(0, elementsLimit), true) : new ContributorSearchResult(res);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/actions/searcheverywhere/RecentFilesSEContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

