/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.SmartElementDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyNodeDescriptor
extends SmartElementDescriptor {
    protected CompositeAppearance myHighlightedText;
    private Object[] myCachedChildren;
    protected final boolean myIsBase;

    protected HierarchyNodeDescriptor(@NotNull Project project, @Nullable NodeDescriptor parentDescriptor, @NotNull PsiElement element, boolean isBase) {
        if (project == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        super(project, parentDescriptor, element);
        this.myCachedChildren = null;
        this.myHighlightedText = new CompositeAppearance();
        this.myName = "";
        this.myIsBase = isBase;
    }

    @Override
    public final Object getElement() {
        return this;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiElement element = this.getPsiElement();
        return element != null ? element.getContainingFile() : null;
    }

    public boolean isValid() {
        return this.getPsiElement() != null;
    }

    public final Object[] getCachedChildren() {
        return this.myCachedChildren;
    }

    public final void setCachedChildren(Object[] cachedChildren) {
        this.myCachedChildren = cachedChildren;
    }

    @Override
    protected final boolean isMarkReadOnly() {
        return true;
    }

    @Override
    protected final boolean isMarkModified() {
        return true;
    }

    public final CompositeAppearance getHighlightedText() {
        return this.myHighlightedText;
    }

    protected static TextAttributes getInvalidPrefixAttributes() {
        return UsageTreeColorsScheme.getInstance().getScheme().getAttributes(UsageTreeColors.INVALID_PREFIX);
    }

    protected static TextAttributes getUsageCountPrefixAttributes() {
        return UsageTreeColorsScheme.getInstance().getScheme().getAttributes(UsageTreeColors.NUMBER_OF_USAGES);
    }

    protected static TextAttributes getPackageNameAttributes() {
        return HierarchyNodeDescriptor.getUsageCountPrefixAttributes();
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    protected final boolean invalidElement() {
        String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
        if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
            this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
        }
        return true;
    }

    protected final void installIcon(@Nullable Icon elementIcon, boolean changes) {
        if (changes && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(elementIcon, 0);
            icon.setIcon(AllIcons.Actions.Forward, 1, -AllIcons.Actions.Forward.getIconWidth() / 2, 0);
            this.setIcon((Icon)icon);
        } else {
            this.setIcon(elementIcon);
        }
    }

    protected final void installIcon(@NotNull PsiElement element, boolean changes) {
        if (element == null) {
            HierarchyNodeDescriptor.$$$reportNull$$$0(2);
        }
        Icon icon = this.getIcon(element);
        this.installIcon(icon, changes);
    }

    protected final void installIcon(boolean changes) {
        this.installIcon(this.getIcon(), changes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyNodeDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

