/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.SourceRootIconProvider;
import com.intellij.ui.HighlightedRegion;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class TodoDirNode
extends PsiDirectoryNode
implements HighlightedRegionProvider {
    private final ArrayList<HighlightedRegion> myHighlightedRegions;
    private final TodoTreeBuilder myBuilder;

    public TodoDirNode(Project project, PsiDirectory directory2, TodoTreeBuilder builder2) {
        super(project, directory2, ViewSettings.DEFAULT);
        this.myBuilder = builder2;
        this.myHighlightedRegions = new ArrayList(2);
    }

    public ArrayList<HighlightedRegion> getHighlightedRegions() {
        return this.myHighlightedRegions;
    }

    @Override
    protected void updateImpl(PresentationData data) {
        super.updateImpl(data);
        int fileCount = this.getFileCount((PsiDirectory)this.getValue());
        if (this.getValue() == null || !((PsiDirectory)this.getValue()).isValid() || fileCount == 0) {
            this.setValue(null);
            return;
        }
        VirtualFile directory2 = ((PsiDirectory)this.getValue()).getVirtualFile();
        boolean isProjectRoot = !ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(directory2);
        String newName = isProjectRoot || this.getStructure().getIsFlattenPackages() ? ((PsiDirectory)this.getValue()).getVirtualFile().getPresentableUrl() : ((PsiDirectory)this.getValue()).getName();
        int nameEndOffset = newName.length();
        int todoItemCount = this.getTodoItemCount((PsiDirectory)this.getValue());
        newName = IdeBundle.message((String)"node.todo.group", (Object[])new Object[]{newName, todoItemCount, fileCount});
        this.myHighlightedRegions.clear();
        TextAttributes textAttributes = new TextAttributes();
        Color newColor = FileStatusManager.getInstance((Project)this.getProject()).getStatus(((PsiDirectory)this.getValue()).getVirtualFile()).getColor();
        if (CopyPasteManager.getInstance().isCutElement(this.getValue())) {
            newColor = CopyPasteManager.CUT_COLOR;
        }
        textAttributes.setForegroundColor(newColor);
        this.myHighlightedRegions.add(new HighlightedRegion(0, nameEndOffset, textAttributes));
        EditorColorsScheme colorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
        this.myHighlightedRegions.add(new HighlightedRegion(nameEndOffset, newName.length(), colorsScheme.getAttributes(UsageTreeColors.NUMBER_OF_USAGES)));
        data.setPresentableText(newName);
    }

    @Override
    protected void setupIcon(PresentationData data, PsiDirectory psiDirectory) {
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        if (ProjectRootsUtil.isModuleContentRoot(virtualFile, psiDirectory.getProject())) {
            data.setIcon(new SourceRootIconProvider.DirectoryProvider().getIcon((PsiElement)psiDirectory, 0));
        } else {
            super.setupIcon(data, psiDirectory);
        }
    }

    private TodoTreeStructure getStructure() {
        return this.myBuilder.getTodoTreeStructure();
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        return TodoTreeHelper.getInstance(this.getProject()).getDirectoryChildren((PsiDirectory)this.getValue(), this.myBuilder, this.getSettings().isFlattenPackages());
    }

    public int getFileCount(PsiDirectory directory2) {
        Iterator<PsiFile> iterator = this.myBuilder.getFiles(directory2);
        int count = 0;
        try {
            while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                if (!this.getStructure().accept(psiFile)) continue;
                ++count;
            }
        }
        catch (IndexNotReadyException e) {
            return count;
        }
        return count;
    }

    public int getTodoItemCount(PsiDirectory directory2) {
        if (TodoTreeHelper.getInstance(this.getProject()).skipDirectory(directory2)) {
            return 0;
        }
        int count = 0;
        Iterator<PsiFile> iterator = this.myBuilder.getFiles(directory2);
        while (iterator.hasNext()) {
            PsiFile psiFile = iterator.next();
            count += this.getStructure().getTodoItemCount(psiFile);
        }
        return count;
    }

    @Override
    public int getWeight() {
        return 2;
    }
}

