/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.util.TipPanel;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.service.fus.collectors.FUSApplicationUsageTrigger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipDialog
extends DialogWrapper {
    private TipPanel myTipPanel;

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public TipDialog() {
        super((Component)WindowManagerEx.getInstanceEx().findVisibleFrame(), true);
        this.initialize();
    }

    public TipDialog(@NotNull Window parent) {
        if (parent == null) {
            TipDialog.$$$reportNull$$$0(0);
        }
        super((Component)parent, true);
        this.initialize();
    }

    private void initialize() {
        this.setModal(false);
        this.setTitle(IdeBundle.message((String)"title.tip.of.the.day", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myTipPanel = new TipPanel();
        this.myTipPanel.nextTip();
        this.setDoNotAskOption(this.myTipPanel);
        this.setHorizontalStretch(1.33f);
        this.setVerticalStretch(1.25f);
        this.init();
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            TipDialog.$$$reportNull$$$0(1);
        }
        return dialogStyle;
    }

    protected JComponent createSouthPanel() {
        JComponent component = super.createSouthPanel();
        component.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        return component;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new PreviousTipAction(), new NextTipAction(), this.getCancelAction()};
        if (actionArray == null) {
            TipDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myTipPanel;
    }

    public void dispose() {
        super.dispose();
    }

    public static TipDialog createForProject(Project project) {
        Window w = WindowManagerEx.getInstanceEx().suggestParentWindow(project);
        return w == null ? new TipDialog() : new TipDialog(w);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NextTipAction
    extends AbstractAction {
        public NextTipAction() {
            super(IdeBundle.message((String)"action.next.tip", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
            this.putValue("FocusedAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FUSApplicationUsageTrigger.getInstance().trigger(TipsOfTheDayUsagesCollector.class, "next.tip");
            TipDialog.this.myTipPanel.nextTip();
            UsageTrigger.trigger("tips.of.the.day.next");
        }
    }

    private class PreviousTipAction
    extends AbstractAction {
        public PreviousTipAction() {
            super(IdeBundle.message((String)"action.previous.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FUSApplicationUsageTrigger.getInstance().trigger(TipsOfTheDayUsagesCollector.class, "previous.tip");
            TipDialog.this.myTipPanel.prevTip();
            UsageTrigger.trigger("tips.of.the.day.prev");
        }
    }
}

