/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.TimeoutUtil;
import org.jetbrains.annotations.NotNull;

public class ToggleDumbModeAction
extends DumbAwareAction {
    private static final Key<Boolean> DUMB = Key.create((String)"ToggleDumbModeAction");

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        if (ToggleDumbModeAction.isToggledDumb(project)) {
            ToggleDumbModeAction.setToggledDumb(project, false);
        } else {
            ToggleDumbModeAction.setToggledDumb(project, true);
            DumbServiceImpl.getInstance(project).queueTask(new DumbModeTask(){

                public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    while (ToggleDumbModeAction.isToggledDumb(project)) {
                        indicator.checkCanceled();
                        TimeoutUtil.sleep((long)100L);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/ToggleDumbModeAction$1", "performInDumbMode"));
                }
            });
        }
    }

    private static void setToggledDumb(Project project, boolean value) {
        project.putUserData(DUMB, (Object)value);
    }

    private static boolean isToggledDumb(Project project) {
        return project.getUserData(DUMB) == Boolean.TRUE;
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean dumb = DumbServiceImpl.getInstance(project).isDumb();
        if (!dumb && ToggleDumbModeAction.isToggledDumb(project)) {
            ToggleDumbModeAction.setToggledDumb(project, false);
        }
        e.getPresentation().setEnabled(!dumb || ToggleDumbModeAction.isToggledDumb(project));
        e.getPresentation().setText(dumb ? "Exit Dumb Mode" : "Enter Dumb Mode");
    }
}

