/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence;
import com.intellij.internal.statistic.updater.StatisticsNotificationManager;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class StatisticsJobsScheduler
implements ApplicationComponent {
    private static final int SEND_STATISTICS_INITIAL_DELAY_IN_MILLIS = 600000;
    private static final int SEND_STATISTICS_DELAY_IN_MIN = 10;
    public static final int PERSIST_SESSIONS_INITIAL_DELAY_IN_MIN = 30;
    public static final int PERSIST_SESSIONS_DELAY_IN_MIN = 720;
    private final FrameStateManager myFrameStateManager;
    private static final Map<Project, Future> myPersistStatisticsSessionsMap = Collections.synchronizedMap(new HashMap());

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.runStatisticsService();
        StatisticsJobsScheduler.runStatisticsSessionsPersistence();
    }

    public StatisticsJobsScheduler(@NotNull FrameStateManager frameStateManager) {
        if (frameStateManager == null) {
            StatisticsJobsScheduler.$$$reportNull$$$0(0);
        }
        NotificationsConfigurationImpl.remove("SendUsagesStatistics");
        this.myFrameStateManager = frameStateManager;
    }

    private static boolean isEmpty(Window window) {
        BalloonLayout layout;
        if (window instanceof IdeFrameImpl && (layout = ((IdeFrameImpl)window).getBalloonLayout()) instanceof BalloonLayoutImpl) {
            return ((BalloonLayoutImpl)layout).isEmpty();
        }
        return false;
    }

    private void runStatisticsService() {
        if (StatisticsUploadAssistant.isShouldShowNotification()) {
            this.myFrameStateManager.addListener(new FrameStateListener(){

                public void onFrameActivated() {
                    if (StatisticsJobsScheduler.isEmpty(((WindowManagerEx)WindowManager.getInstance()).getMostRecentFocusedWindow())) {
                        StatisticsService statisticsService = StatisticsUploadAssistant.getApprovedGroupsStatisticsService();
                        ApplicationManager.getApplication().invokeLater(() -> StatisticsNotificationManager.showNotification(statisticsService));
                        StatisticsJobsScheduler.this.myFrameStateManager.removeListener((FrameStateListener)this);
                    }
                }
            });
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            StatisticsService statisticsService = StatisticsUploadAssistant.getApprovedGroupsStatisticsService();
            if (StatisticsUploadAssistant.isSendAllowed() && StatisticsUploadAssistant.isTimeToSend()) {
                StatisticsJobsScheduler.runStatisticsServiceWithDelay(statisticsService, 10);
                StatisticsJobsScheduler.runStatisticsServiceWithDelay(StatisticsUploadAssistant.getOldStatisticsService(), 20);
            }
            if (FeatureUsageLogger.INSTANCE.isEnabled() && StatisticsUploadAssistant.isTimeToSendEventLog()) {
                StatisticsJobsScheduler.runStatisticsServiceWithDelay(StatisticsUploadAssistant.getEventLogStatisticsService(), 30);
            }
        }, 600000L, StatisticsUploadAssistant.getSendPeriodInMillis(), TimeUnit.MILLISECONDS);
    }

    private static void runStatisticsServiceWithDelay(@NotNull StatisticsService statisticsService, int delayInMin) {
        if (statisticsService == null) {
            StatisticsJobsScheduler.$$$reportNull$$$0(1);
        }
        JobScheduler.getScheduler().schedule(statisticsService::send, (long)delayInMin, TimeUnit.MINUTES);
    }

    private static void runStatisticsSessionsPersistence() {
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project) {
                ScheduledFuture<?> future2 = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStatisticsPersistence.persistProjectUsages(project), 30L, 720L, TimeUnit.MINUTES);
                myPersistStatisticsSessionsMap.put(project, future2);
            }

            public void projectClosed(Project project) {
                Future future2 = (Future)myPersistStatisticsSessionsMap.remove(project);
                if (future2 != null) {
                    future2.cancel(true);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameStateManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statisticsService";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/updater/StatisticsJobsScheduler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runStatisticsServiceWithDelay";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

