/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.parser;

import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LimitedPool;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedParserUtilBase {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.grammar.parser.GeneratedParserUtilBase");
    private static final int MAX_RECURSION_LEVEL = StringUtil.parseInt((String)System.getProperty("grammar.kit.gpub.max.level"), (int)1000);
    private static final int MAX_VARIANTS_SIZE = 10000;
    private static final int MAX_VARIANTS_TO_DISPLAY = 50;
    private static final int MAX_ERROR_TOKEN_TEXT = 20;
    private static final int INITIAL_VARIANTS_SIZE = 1000;
    private static final int VARIANTS_POOL_SIZE = 10000;
    private static final int FRAMES_POOL_SIZE = 500;
    public static final IElementType DUMMY_BLOCK = new DummyBlockElementType();
    public static final Parser TOKEN_ADVANCER = (builder2, level) -> {
        if (builder2.eof()) {
            return false;
        }
        builder2.advanceLexer();
        return true;
    };
    public static final Parser TRUE_CONDITION = (builder2, level) -> true;
    public static final Hook<WhitespacesAndCommentsBinder> LEFT_BINDER = (builder2, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders(param, null);
        }
        return marker;
    };
    public static final Hook<WhitespacesAndCommentsBinder> RIGHT_BINDER = (builder2, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders(null, param);
        }
        return marker;
    };
    public static final Hook<WhitespacesAndCommentsBinder[]> WS_BINDERS = (builder2, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders(param[0], param[1]);
        }
        return marker;
    };
    public static final Hook<String> LOG_HOOK = (builder2, marker, param) -> {
        PsiBuilderImpl.ProductionMarker m = (PsiBuilderImpl.ProductionMarker)marker;
        int start = m == null ? builder2.getCurrentOffset() : m.getStartOffset();
        int end = m == null ? start : m.getEndOffset();
        String prefix = "[" + start + ", " + end + "]" + (m == null ? "" : " " + m.getTokenType());
        builder2.mark().error(prefix + ": " + param);
        return marker;
    };
    public static final int _NONE_ = 0;
    public static final int _COLLAPSE_ = 1;
    public static final int _LEFT_ = 2;
    public static final int _LEFT_INNER_ = 4;
    public static final int _AND_ = 8;
    public static final int _NOT_ = 16;
    public static final int _UPPER_ = 32;
    public static final Key<CompletionState> COMPLETION_STATE_KEY = Key.create((String)"COMPLETION_STATE_KEY");
    private static final int MAX_CHILDREN_IN_TREE = 10;

    public static boolean eof(PsiBuilder builder2, int level) {
        return builder2.eof();
    }

    public static int current_position_(PsiBuilder builder2) {
        return builder2.rawTokenIndex();
    }

    public static boolean recursion_guard_(PsiBuilder builder2, int level, String funcName) {
        if (level > MAX_RECURSION_LEVEL) {
            builder2.mark().error("Maximum recursion level (" + MAX_RECURSION_LEVEL + ") reached in '" + funcName + "'");
            return false;
        }
        return true;
    }

    public static boolean empty_element_parsed_guard_(PsiBuilder builder2, String funcName, int pos) {
        if (pos == GeneratedParserUtilBase.current_position_(builder2)) {
            builder2.error("Empty element parsed in '" + funcName + "' at offset " + builder2.getCurrentOffset());
            return false;
        }
        return true;
    }

    public static boolean invalid_left_marker_guard_(PsiBuilder builder2, PsiBuilder.Marker marker, String funcName) {
        boolean goodMarker;
        boolean bl = goodMarker = marker != null;
        if (!goodMarker) {
            return false;
        }
        ErrorState state2 = ErrorState.get(builder2);
        return state2.currentFrame != null;
    }

    public static TokenSet create_token_set_(IElementType ... tokenTypes) {
        return TokenSet.create((IElementType[])tokenTypes);
    }

    public static boolean leftMarkerIs(PsiBuilder builder2, IElementType type) {
        LighterASTNode marker = builder2.getLatestDoneMarker();
        return marker != null && marker.getTokenType() == type;
    }

    private static boolean consumeTokens(PsiBuilder builder2, boolean smart, int pin, IElementType ... tokens) {
        ErrorState state2 = ErrorState.get(builder2);
        if (state2.completionState != null && state2.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder2, state2.completionState, tokens);
        }
        CompletionState completionState = state2.completionState;
        state2.completionState = null;
        boolean result2 = true;
        boolean pinned = false;
        int tokensLength = tokens.length;
        for (int i = 0; i < tokensLength; ++i) {
            boolean fast;
            if (pin > 0 && i == pin) {
                pinned = result2;
            }
            if (!result2 && !pinned) continue;
            boolean bl = fast = smart && i == 0;
            if (!fast ? GeneratedParserUtilBase.consumeToken(builder2, tokens[i]) : GeneratedParserUtilBase.consumeTokenFast(builder2, tokens[i])) continue;
            result2 = false;
            if (pin >= 0 && !pinned) continue;
            GeneratedParserUtilBase.report_error_(builder2, state2, false);
        }
        state2.completionState = completionState;
        return pinned || result2;
    }

    public static boolean consumeTokens(PsiBuilder builder2, int pin, IElementType ... token) {
        return GeneratedParserUtilBase.consumeTokens(builder2, false, pin, token);
    }

    public static boolean consumeTokensSmart(PsiBuilder builder2, int pin, IElementType ... token) {
        return GeneratedParserUtilBase.consumeTokens(builder2, true, pin, token);
    }

    public static boolean parseTokens(PsiBuilder builder2, int pin, IElementType ... tokens) {
        return GeneratedParserUtilBase.parseTokens(builder2, false, pin, tokens);
    }

    public static boolean parseTokensSmart(PsiBuilder builder2, int pin, IElementType ... tokens) {
        return GeneratedParserUtilBase.parseTokens(builder2, true, pin, tokens);
    }

    public static boolean parseTokens(PsiBuilder builder2, boolean smart, int pin, IElementType ... tokens) {
        PsiBuilder.Marker marker = builder2.mark();
        boolean result2 = GeneratedParserUtilBase.consumeTokens(builder2, smart, pin, tokens);
        if (!result2) {
            marker.rollbackTo();
        } else {
            marker.drop();
        }
        return result2;
    }

    public static boolean consumeTokenSmart(PsiBuilder builder2, IElementType token) {
        GeneratedParserUtilBase.addCompletionVariantSmart(builder2, token);
        return GeneratedParserUtilBase.consumeTokenFast(builder2, token);
    }

    public static boolean consumeTokenSmart(PsiBuilder builder2, String token) {
        GeneratedParserUtilBase.addCompletionVariantSmart(builder2, token);
        return GeneratedParserUtilBase.consumeTokenFast(builder2, token);
    }

    public static boolean consumeToken(PsiBuilder builder2, IElementType token) {
        GeneratedParserUtilBase.addVariantSmart(builder2, token, true);
        if (GeneratedParserUtilBase.nextTokenIsFast(builder2, token)) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeTokenFast(PsiBuilder builder2, IElementType token) {
        if (GeneratedParserUtilBase.nextTokenIsFast(builder2, token)) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeToken(PsiBuilder builder2, String text2) {
        return GeneratedParserUtilBase.consumeToken(builder2, text2, ErrorState.get(builder2).caseSensitive);
    }

    public static boolean consumeToken(PsiBuilder builder2, String text2, boolean caseSensitive) {
        GeneratedParserUtilBase.addVariantSmart(builder2, text2, true);
        int count = GeneratedParserUtilBase.nextTokenIsFast(builder2, text2, caseSensitive);
        if (count > 0) {
            while (count-- > 0) {
                builder2.advanceLexer();
            }
            return true;
        }
        return false;
    }

    public static boolean consumeTokenFast(PsiBuilder builder2, String text2) {
        int count = GeneratedParserUtilBase.nextTokenIsFast(builder2, text2, ErrorState.get(builder2).caseSensitive);
        if (count > 0) {
            while (count-- > 0) {
                builder2.advanceLexer();
            }
            return true;
        }
        return false;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder2, IElementType token) {
        return builder2.getTokenType() == token;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder2, IElementType ... tokens) {
        IElementType tokenType = builder2.getTokenType();
        for (IElementType token : tokens) {
            if (token != tokenType) continue;
            return true;
        }
        return false;
    }

    public static boolean nextTokenIsSmart(PsiBuilder builder2, IElementType token) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, token) || ErrorState.get((PsiBuilder)builder2).completionState != null;
    }

    public static boolean nextTokenIsSmart(PsiBuilder builder2, IElementType ... tokens) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, tokens) || ErrorState.get((PsiBuilder)builder2).completionState != null;
    }

    public static boolean nextTokenIs(PsiBuilder builder2, String frameName, IElementType ... tokens) {
        ErrorState state2 = ErrorState.get(builder2);
        if (state2.completionState != null) {
            return true;
        }
        boolean track = !state2.suppressErrors && state2.predicateCount < 2 && state2.predicateSign;
        return !track ? GeneratedParserUtilBase.nextTokenIsFast(builder2, tokens) : GeneratedParserUtilBase.nextTokenIsSlow(builder2, frameName, tokens);
    }

    public static boolean nextTokenIsSlow(PsiBuilder builder2, String frameName, IElementType ... tokens) {
        ErrorState state2 = ErrorState.get(builder2);
        IElementType tokenType = builder2.getTokenType();
        if (StringUtil.isNotEmpty((String)frameName)) {
            GeneratedParserUtilBase.addVariantInner(state2, state2.currentFrame, builder2.rawTokenIndex(), frameName);
        } else {
            for (IElementType token : tokens) {
                GeneratedParserUtilBase.addVariant(builder2, state2, token);
            }
        }
        if (tokenType == null) {
            return false;
        }
        for (IElementType token : tokens) {
            if (tokenType != token) continue;
            return true;
        }
        return false;
    }

    public static boolean nextTokenIs(PsiBuilder builder2, IElementType token) {
        if (!GeneratedParserUtilBase.addVariantSmart(builder2, token, false)) {
            return true;
        }
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, token);
    }

    public static boolean nextTokenIs(PsiBuilder builder2, String tokenText) {
        if (!GeneratedParserUtilBase.addVariantSmart(builder2, tokenText, false)) {
            return true;
        }
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, tokenText, ErrorState.get(builder2).caseSensitive) > 0;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder2, String tokenText) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder2, tokenText, ErrorState.get(builder2).caseSensitive) > 0;
    }

    public static int nextTokenIsFast(PsiBuilder builder2, String tokenText, boolean caseSensitive) {
        int nextOffset;
        int endOffset;
        int offset;
        CharSequence sequence = builder2.getOriginalText();
        CharSequence subSequence = sequence.subSequence(offset = builder2.getCurrentOffset(), Math.min(endOffset = offset + tokenText.length(), sequence.length()));
        if (!Comparing.equal((CharSequence)subSequence, (CharSequence)tokenText, (boolean)caseSensitive)) {
            return 0;
        }
        int count = 0;
        do {
            if ((nextOffset = builder2.rawTokenTypeStart(++count)) <= endOffset) continue;
            return -count;
        } while (nextOffset != endOffset);
        return count;
    }

    private static void addCompletionVariantSmart(PsiBuilder builder2, Object token) {
        ErrorState state2 = ErrorState.get(builder2);
        CompletionState completionState = state2.completionState;
        if (completionState != null && state2.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder2, completionState, token);
        }
    }

    private static boolean addVariantSmart(PsiBuilder builder2, Object token, boolean force) {
        ErrorState state2 = ErrorState.get(builder2);
        if (state2.completionState != null && !force) {
            return false;
        }
        builder2.eof();
        if (!state2.suppressErrors && state2.predicateCount < 2) {
            GeneratedParserUtilBase.addVariant(builder2, state2, token);
        }
        return true;
    }

    public static void addVariant(PsiBuilder builder2, String text2) {
        GeneratedParserUtilBase.addVariant(builder2, ErrorState.get(builder2), text2);
    }

    private static void addVariant(PsiBuilder builder2, ErrorState state2, Object o) {
        builder2.eof();
        GeneratedParserUtilBase.addVariantInner(state2, state2.currentFrame, builder2.rawTokenIndex(), o);
        CompletionState completionState = state2.completionState;
        if (completionState != null && state2.predicateSign) {
            GeneratedParserUtilBase.addCompletionVariant(builder2, completionState, o);
        }
    }

    private static void addVariantInner(ErrorState state2, Frame frame, int pos, Object o) {
        Variant variant = ((Variant)state2.VARIANTS.alloc()).init(pos, o);
        if (state2.predicateSign) {
            state2.variants.add(variant);
            if (frame.lastVariantAt < pos) {
                frame.lastVariantAt = pos;
            }
        } else {
            state2.unexpected.add(variant);
        }
    }

    private static void addCompletionVariant(@NotNull PsiBuilder builder2, @NotNull CompletionState completionState, Object o) {
        if (builder2 == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(0);
        }
        if (completionState == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(1);
        }
        int offset = builder2.getCurrentOffset();
        if (!builder2.eof() && offset == builder2.rawTokenTypeStart(1)) {
            return;
        }
        String text2 = completionState.convertItem(o);
        int length = text2 == null ? 0 : text2.length();
        boolean add = length != 0 && completionState.prefixMatches(builder2, text2);
        boolean bl = add = !(!add || length <= 1 || text2.charAt(0) == '<' && text2.charAt(length - 1) == '>' || text2.charAt(0) == '\'' && text2.charAt(length - 1) == '\'' && length < 5);
        if (add) {
            completionState.addItem(builder2, text2);
        }
    }

    public static boolean isWhitespaceOrComment(@NotNull PsiBuilder builder2, @Nullable IElementType type) {
        if (builder2 == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(2);
        }
        return ((PsiBuilderImpl)((Builder)builder2).getDelegate()).whitespaceOrComment(type);
    }

    private static boolean wasAutoSkipped(@NotNull PsiBuilder builder2, int steps) {
        if (builder2 == null) {
            GeneratedParserUtilBase.$$$reportNull$$$0(3);
        }
        for (int i = -1; i >= -steps; --i) {
            if (GeneratedParserUtilBase.isWhitespaceOrComment(builder2, builder2.rawLookup(i))) continue;
            return false;
        }
        return true;
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder2) {
        ErrorState state2 = ErrorState.get(builder2);
        GeneratedParserUtilBase.reportFrameError(builder2, state2);
        ++state2.level;
        return builder2.mark();
    }

    public static void exit_section_(PsiBuilder builder2, PsiBuilder.Marker marker, @Nullable IElementType elementType, boolean result2) {
        ErrorState state2 = ErrorState.get(builder2);
        GeneratedParserUtilBase.close_marker_impl_(state2.currentFrame, marker, elementType, result2);
        GeneratedParserUtilBase.run_hooks_impl_(builder2, state2, (IElementType)(result2 ? elementType : null));
        --state2.level;
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder2, int level, int modifiers, String frameName) {
        return GeneratedParserUtilBase.enter_section_(builder2, level, modifiers, null, frameName);
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder2, int level, int modifiers) {
        return GeneratedParserUtilBase.enter_section_(builder2, level, modifiers, null, null);
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder2, int level, int modifiers, IElementType elementType, String frameName) {
        GeneratedParserUtilBase.reportFrameError(builder2, ErrorState.get(builder2));
        PsiBuilder.Marker marker = builder2.mark();
        GeneratedParserUtilBase.enter_section_impl_(builder2, level, modifiers, elementType, frameName);
        return marker;
    }

    private static void enter_section_impl_(PsiBuilder builder2, int level, int modifiers, IElementType elementType, String frameName) {
        PsiBuilder.Marker left;
        ErrorState state2 = ErrorState.get(builder2);
        ++state2.level;
        Frame frame = ((Frame)state2.FRAMES.alloc()).init(builder2, state2, level, modifiers, elementType, frameName);
        if ((frame.modifiers & 2 | frame.modifiers & 4) != 0 && GeneratedParserUtilBase.invalid_left_marker_guard_(builder2, left = (PsiBuilder.Marker)builder2.getLatestDoneMarker(), frameName)) {
            frame.leftMarker = left;
        }
        state2.currentFrame = frame;
        if ((modifiers & 8) != 0) {
            if (state2.predicateCount == 0 && !state2.predicateSign) {
                throw new AssertionError((Object)"Incorrect false predicate sign");
            }
            ++state2.predicateCount;
        } else if ((modifiers & 0x10) != 0) {
            state2.predicateSign = state2.predicateCount != 0 && !state2.predicateSign;
            ++state2.predicateCount;
        }
    }

    public static void exit_section_(PsiBuilder builder2, int level, PsiBuilder.Marker marker, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        GeneratedParserUtilBase.exit_section_(builder2, level, marker, null, result2, pinned, eatMore);
    }

    public static void exit_section_(PsiBuilder builder2, int level, PsiBuilder.Marker marker, @Nullable IElementType elementType, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        ErrorState state2 = ErrorState.get(builder2);
        Frame frame = state2.currentFrame;
        Frame frame2 = state2.currentFrame = frame == null ? null : frame.parentFrame;
        if (frame != null && frame.elementType != null) {
            elementType = frame.elementType;
        }
        if (frame == null || level != frame.level) {
            LOG.error("Unbalanced error section: got " + frame + ", expected level " + level);
            if (frame != null) {
                state2.FRAMES.recycle((Object)frame);
            }
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, elementType, result2);
            return;
        }
        GeneratedParserUtilBase.close_frame_impl_(state2, frame, builder2, marker, elementType, result2, pinned);
        GeneratedParserUtilBase.exit_section_impl_(state2, frame, builder2, elementType, result2, pinned, eatMore);
        GeneratedParserUtilBase.run_hooks_impl_(builder2, state2, (IElementType)(pinned || result2 ? elementType : null));
        state2.FRAMES.recycle((Object)frame);
        --state2.level;
    }

    public static <T> void register_hook_(PsiBuilder builder2, Hook<T> hook, T param) {
        ErrorState state2 = ErrorState.get(builder2);
        state2.hooks = Hooks.concat(hook, param, state2.level, state2.hooks);
    }

    @SafeVarargs
    public static <T> void register_hook_(PsiBuilder builder2, Hook<T[]> hook, T ... param) {
        ErrorState state2 = ErrorState.get(builder2);
        state2.hooks = Hooks.concat(hook, param, state2.level, state2.hooks);
    }

    private static void run_hooks_impl_(PsiBuilder builder2, ErrorState state2, @Nullable IElementType elementType) {
        PsiBuilder.Marker marker;
        if (state2.hooks == null) {
            return;
        }
        PsiBuilder.Marker marker2 = marker = elementType == null ? null : (PsiBuilder.Marker)builder2.getLatestDoneMarker();
        if (elementType != null && marker == null) {
            builder2.mark().error("No expected done marker at offset " + builder2.getCurrentOffset());
        }
        while (state2.hooks != null && state2.hooks.level >= state2.level) {
            if (state2.hooks.level == state2.level) {
                marker = state2.hooks.hook.run(builder2, marker, state2.hooks.param);
            }
            state2.hooks = state2.hooks.next;
        }
    }

    private static void exit_section_impl_(ErrorState state2, Frame frame, PsiBuilder builder2, @Nullable IElementType elementType, boolean result2, boolean pinned, @Nullable Parser eatMore) {
        int lastErrorPos;
        int initialPos = builder2.rawTokenIndex();
        GeneratedParserUtilBase.replace_variants_with_name_(state2, frame, builder2, elementType, result2, pinned);
        int n = lastErrorPos = frame.lastVariantAt < 0 ? initialPos : frame.lastVariantAt;
        if (!state2.suppressErrors && eatMore != null) {
            boolean errorReported;
            state2.suppressErrors = true;
            boolean eatMoreFlagOnce = !builder2.eof() && eatMore.parse(builder2, frame.level + 1);
            boolean eatMoreFlag = eatMoreFlagOnce || !result2 && frame.position == initialPos && lastErrorPos > frame.position;
            PsiBuilderImpl.ProductionMarker latestDoneMarker = !(!pinned && !result2 || !state2.altMode && elementType == null || !eatMoreFlagOnce) ? (PsiBuilderImpl.ProductionMarker)builder2.getLatestDoneMarker() : null;
            PsiBuilder.Marker extensionMarker = null;
            IElementType extensionTokenType = null;
            if (latestDoneMarker != null && frame.position >= latestDoneMarker.getStartIndex() && frame.position <= latestDoneMarker.getEndIndex()) {
                extensionMarker = ((PsiBuilder.Marker)latestDoneMarker).precede();
                extensionTokenType = latestDoneMarker.getTokenType();
                ((PsiBuilder.Marker)latestDoneMarker).drop();
            }
            int parenCount = 0;
            while ((eatMoreFlag || parenCount > 0) && builder2.rawTokenIndex() < lastErrorPos) {
                IElementType tokenType = builder2.getTokenType();
                if (state2.braces != null) {
                    if (tokenType == state2.braces[0].getLeftBraceType()) {
                        ++parenCount;
                    } else if (tokenType == state2.braces[0].getRightBraceType()) {
                        --parenCount;
                    }
                }
                if (builder2.rawTokenIndex() >= lastErrorPos) break;
                state2.tokenAdvancer.parse(builder2, frame.level + 1);
                eatMoreFlag = eatMore.parse(builder2, frame.level + 1);
            }
            boolean bl = errorReported = frame.errorReportedAt == initialPos || !result2 && frame.errorReportedAt >= frame.position;
            if (errorReported || eatMoreFlag) {
                if (!errorReported) {
                    errorReported = GeneratedParserUtilBase.reportError(builder2, state2, frame, false, true, true);
                } else if (eatMoreFlag) {
                    state2.tokenAdvancer.parse(builder2, frame.level + 1);
                }
                if (eatMore.parse(builder2, frame.level + 1)) {
                    GeneratedParserUtilBase.parseAsTree(state2, builder2, frame.level + 1, DUMMY_BLOCK, true, state2.tokenAdvancer, eatMore);
                }
            } else if (eatMoreFlagOnce || !result2 && frame.position != builder2.rawTokenIndex() || frame.errorReportedAt > initialPos) {
                errorReported = GeneratedParserUtilBase.reportError(builder2, state2, frame, false, true, false);
            } else if (!result2 && pinned && frame.errorReportedAt < 0) {
                errorReported = GeneratedParserUtilBase.reportError(builder2, state2, frame, elementType != null, false, false);
            }
            if (extensionMarker != null) {
                extensionMarker.done(extensionTokenType);
            }
            state2.suppressErrors = false;
            if (errorReported || result2) {
                state2.clearVariants(true, 0);
                state2.clearVariants(false, 0);
                frame.lastVariantAt = -1;
                Frame f = frame;
                while (f != null && f.variantCount > 0) {
                    f.variantCount = 0;
                    f = f.parentFrame;
                }
            }
        } else if (!result2 && pinned && frame.errorReportedAt < 0) {
            if (lastErrorPos == initialPos) {
                GeneratedParserUtilBase.reportError(builder2, state2, frame, elementType != null, false, false);
            } else if (lastErrorPos > initialPos) {
                frame.errorReportedAt = lastErrorPos;
            }
        }
        if (state2.currentFrame != null) {
            if (state2.currentFrame.errorReportedAt < frame.errorReportedAt) {
                state2.currentFrame.errorReportedAt = frame.errorReportedAt;
            }
            if (state2.currentFrame.lastVariantAt < frame.lastVariantAt) {
                state2.currentFrame.lastVariantAt = frame.lastVariantAt;
            }
        }
    }

    private static void close_frame_impl_(ErrorState state2, Frame frame, PsiBuilder builder2, PsiBuilder.Marker marker, IElementType elementType, boolean result2, boolean pinned) {
        if ((frame.modifiers & 8 | frame.modifiers & 0x10) != 0) {
            boolean resetLastPos = !state2.suppressErrors && frame.lastVariantAt < 0 && frame.position < builder2.rawTokenIndex();
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
            --state2.predicateCount;
            if ((frame.modifiers & 0x10) != 0) {
                state2.predicateSign = !state2.predicateSign;
            }
            PsiBuilder.Marker marker2 = marker = elementType != null && marker != null && (result2 || pinned) ? builder2.mark() : null;
            if (resetLastPos) {
                frame.lastVariantAt = builder2.rawTokenIndex();
            }
        }
        if (elementType != null && marker != null) {
            if (result2 || pinned) {
                PsiBuilderImpl.ProductionMarker last;
                if ((frame.modifiers & 1) != 0 && (last = (PsiBuilderImpl.ProductionMarker)builder2.getLatestDoneMarker()) != null && last.getStartIndex() == frame.position && state2.typeExtends(last.getTokenType(), elementType) && GeneratedParserUtilBase.wasAutoSkipped(builder2, builder2.rawTokenIndex() - last.getEndIndex())) {
                    elementType = last.getTokenType();
                    ((PsiBuilder.Marker)last).drop();
                }
                if ((frame.modifiers & 0x20) != 0) {
                    marker.drop();
                    Frame f = frame.parentFrame;
                    while (f != null) {
                        if (f.elementType != null) {
                            f.elementType = elementType;
                            break;
                        }
                        f = f.parentFrame;
                    }
                } else if ((frame.modifiers & 4) != 0 && frame.leftMarker != null) {
                    marker.done(elementType);
                    frame.leftMarker.precede().done(((LighterASTNode)frame.leftMarker).getTokenType());
                    frame.leftMarker.drop();
                } else if ((frame.modifiers & 2) != 0 && frame.leftMarker != null) {
                    marker.drop();
                    frame.leftMarker.precede().done(elementType);
                } else {
                    if (frame.level == 0) {
                        builder2.eof();
                    }
                    marker.done(elementType);
                }
            } else {
                GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
            }
        } else if (result2 || pinned) {
            if (marker != null) {
                marker.drop();
            }
            if ((frame.modifiers & 4) != 0 && frame.leftMarker != null) {
                frame.leftMarker.precede().done(((LighterASTNode)frame.leftMarker).getTokenType());
                frame.leftMarker.drop();
            }
        } else {
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
        }
    }

    private static void close_marker_impl_(Frame frame, PsiBuilder.Marker marker, IElementType elementType, boolean result2) {
        if (marker == null) {
            return;
        }
        if (result2) {
            if (elementType != null) {
                marker.done(elementType);
            } else {
                marker.drop();
            }
        } else {
            int position;
            if (frame != null && frame.errorReportedAt > (position = ((PsiBuilderImpl.ProductionMarker)marker).getStartIndex())) {
                frame.errorReportedAt = frame.parentFrame == null ? -1 : frame.parentFrame.errorReportedAt;
            }
            marker.rollbackTo();
        }
    }

    private static void replace_variants_with_name_(ErrorState state2, Frame frame, PsiBuilder builder2, IElementType elementType, boolean result2, boolean pinned) {
        boolean willFail;
        int initialPos = builder2.rawTokenIndex();
        boolean bl = willFail = !result2 && !pinned;
        if (willFail && initialPos == frame.position && frame.lastVariantAt == frame.position && frame.name != null && state2.variants.size() >= frame.variantCount + (elementType == null ? 0 : 2)) {
            state2.clearVariants(true, frame.variantCount);
            GeneratedParserUtilBase.addVariantInner(state2, frame, initialPos, frame.name);
        }
    }

    public static boolean report_error_(PsiBuilder builder2, boolean result2) {
        if (!result2) {
            GeneratedParserUtilBase.report_error_(builder2, ErrorState.get(builder2), false);
        }
        return result2;
    }

    public static void report_error_(PsiBuilder builder2, ErrorState state2, boolean advance) {
        Frame frame = state2.currentFrame;
        if (frame == null) {
            LOG.error("unbalanced enter/exit section call: got null");
            return;
        }
        int position = builder2.rawTokenIndex();
        if (frame.errorReportedAt < position && frame.lastVariantAt > -1 && frame.lastVariantAt <= position) {
            GeneratedParserUtilBase.reportError(builder2, state2, frame, false, true, advance);
        }
    }

    private static boolean reportError(PsiBuilder builder2, ErrorState state2, Frame frame, boolean inner, boolean force, boolean advance) {
        boolean empty;
        int position = builder2.rawTokenIndex();
        StringBuilder sb = new StringBuilder();
        state2.appendExpected(sb, position, true);
        boolean bl = empty = sb.length() == 0;
        if (!force && empty && !advance) {
            return false;
        }
        String actual = StringUtil.trim((String)builder2.getTokenText());
        if (StringUtil.isEmpty((String)actual)) {
            sb.append(empty ? "unmatched input" : " expected");
        } else {
            if (!empty) {
                sb.append(" expected, got ");
            }
            sb.append("'").append(StringUtil.first((String)actual, (int)20, (boolean)true)).append("'");
            if (empty) {
                sb.append(" unexpected");
            }
        }
        String message = sb.toString();
        if (advance) {
            PsiBuilder.Marker mark = builder2.mark();
            state2.tokenAdvancer.parse(builder2, frame.level + 1);
            mark.error(message);
        } else if (inner) {
            PsiBuilder.Marker extensionMarker = null;
            IElementType extensionTokenType = null;
            PsiBuilderImpl.ProductionMarker latestDoneMarker = (PsiBuilderImpl.ProductionMarker)builder2.getLatestDoneMarker();
            if (latestDoneMarker != null && frame.position >= latestDoneMarker.getStartIndex() && frame.position <= latestDoneMarker.getEndIndex()) {
                extensionMarker = ((PsiBuilder.Marker)latestDoneMarker).precede();
                extensionTokenType = latestDoneMarker.getTokenType();
                ((PsiBuilder.Marker)latestDoneMarker).drop();
            }
            builder2.error(message);
            if (extensionMarker != null) {
                extensionMarker.done(extensionTokenType);
            }
        } else {
            builder2.error(message);
        }
        builder2.eof();
        frame.errorReportedAt = builder2.rawTokenIndex();
        return true;
    }

    private static void reportFrameError(PsiBuilder builder2, ErrorState state2) {
        if (state2.currentFrame == null || state2.suppressErrors) {
            return;
        }
        Frame frame = state2.currentFrame;
        int pos = builder2.rawTokenIndex();
        if (frame.errorReportedAt > pos) {
            int endOffset;
            LighterASTNode marker = builder2.getLatestDoneMarker();
            int n = endOffset = marker != null ? ((PsiBuilderImpl.ProductionMarker)marker).getEndIndex() : pos + 1;
            while (endOffset <= pos && GeneratedParserUtilBase.isWhitespaceOrComment(builder2, builder2.rawLookup(endOffset - pos))) {
                ++endOffset;
            }
            boolean inner = endOffset == pos;
            builder2.eof();
            GeneratedParserUtilBase.reportError(builder2, state2, frame, inner, true, false);
        }
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder2, PsiParser parser) {
        return GeneratedParserUtilBase.adapt_builder_(root, builder2, parser, null);
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder2, PsiParser parser, TokenSet[] extendsSets) {
        ErrorState state2 = new ErrorState();
        ErrorState.initState(state2, builder2, root, extendsSets);
        return new Builder(builder2, state2, parser);
    }

    private static void checkSiblings(IElementType chunkType, ArrayDeque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>> parens, ArrayDeque<Pair<PsiBuilder.Marker, Integer>> siblings) {
        block0: while (!siblings.isEmpty()) {
            Pair<PsiBuilder.Marker, PsiBuilder.Marker> parenPair = parens.peek();
            int rating = (Integer)siblings.getFirst().second;
            int count = 0;
            for (Pair<PsiBuilder.Marker, Integer> pair : siblings) {
                if ((Integer)pair.second != rating || parenPair != null && pair.first == parenPair.second) break block0;
                if (++count < 10) continue;
                PsiBuilder.Marker parentMarker = ((PsiBuilder.Marker)pair.first).precede();
                parentMarker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                while (count-- > 0) {
                    siblings.removeFirst();
                }
                parentMarker.done(chunkType);
                siblings.addFirst((Pair<PsiBuilder.Marker, Integer>)Pair.create((Object)parentMarker, (Object)(rating + 1)));
                continue block0;
            }
        }
    }

    public static boolean parseAsTree(ErrorState state2, PsiBuilder builder2, int level, IElementType chunkType, boolean checkBraces, Parser parser, Parser eatMoreCondition) {
        ArrayDeque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>> parens = new ArrayDeque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>>(4);
        ArrayDeque<Pair<PsiBuilder.Marker, Integer>> siblings = new ArrayDeque<Pair<PsiBuilder.Marker, Integer>>();
        PsiBuilder.Marker marker = null;
        IElementType lBrace = checkBraces && state2.braces != null && state2.braces.length > 0 ? state2.braces[0].getLeftBraceType() : null;
        IElementType rBrace = lBrace != null ? state2.braces[0].getRightBraceType() : null;
        int totalCount = 0;
        int tokenCount = 0;
        if (lBrace != null) {
            LighterASTNode doneMarker;
            int tokenIdx = -1;
            while (builder2.rawLookup(tokenIdx) == TokenType.WHITE_SPACE) {
                --tokenIdx;
            }
            LighterASTNode lighterASTNode = doneMarker = builder2.rawLookup(tokenIdx) == lBrace ? builder2.getLatestDoneMarker() : null;
            if (doneMarker != null && doneMarker.getStartOffset() == builder2.rawTokenTypeStart(tokenIdx) && doneMarker.getTokenType() == TokenType.ERROR_ELEMENT) {
                parens.add((Pair<PsiBuilder.Marker, PsiBuilder.Marker>)Pair.create((Object)((PsiBuilder.Marker)doneMarker).precede(), null));
            }
        }
        int c = GeneratedParserUtilBase.current_position_(builder2);
        while (true) {
            IElementType tokenType = builder2.getTokenType();
            if (lBrace != null && (tokenType == lBrace || tokenType == rBrace && !parens.isEmpty())) {
                if (marker != null) {
                    marker.done(chunkType);
                    siblings.addFirst((Pair<PsiBuilder.Marker, Integer>)Pair.create((Object)marker, (Object)1));
                    marker = null;
                    tokenCount = 0;
                }
                if (tokenType == lBrace) {
                    Pair prev2 = (Pair)siblings.peek();
                    parens.addFirst((Pair<PsiBuilder.Marker, PsiBuilder.Marker>)Pair.create((Object)builder2.mark(), prev2 == null ? null : (PsiBuilder.Marker)prev2.first));
                }
                GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings);
                state2.tokenAdvancer.parse(builder2, level);
                if (tokenType == rBrace) {
                    Pair<PsiBuilder.Marker, PsiBuilder.Marker> pair = parens.removeFirst();
                    ((PsiBuilder.Marker)pair.first).done(chunkType);
                    while (!siblings.isEmpty() && siblings.getFirst().first != pair.second) {
                        siblings.removeFirst();
                    }
                    siblings.addFirst((Pair<PsiBuilder.Marker, Integer>)Pair.create((Object)pair.first, (Object)1));
                    GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings);
                }
            } else {
                boolean result2;
                if (marker == null) {
                    marker = builder2.mark();
                    marker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                }
                boolean bl = result2 = (!parens.isEmpty() || eatMoreCondition.parse(builder2, level + 1)) && parser.parse(builder2, level + 1);
                if (!result2) break;
                ++tokenCount;
                ++totalCount;
            }
            if (tokenCount >= 10) {
                marker.done(chunkType);
                siblings.addFirst((Pair<PsiBuilder.Marker, Integer>)Pair.create((Object)marker, (Object)1));
                GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings);
                marker = null;
                tokenCount = 0;
            }
            if (!GeneratedParserUtilBase.empty_element_parsed_guard_(builder2, "parseAsTree", c)) break;
            c = GeneratedParserUtilBase.current_position_(builder2);
        }
        if (marker != null) {
            marker.drop();
        }
        for (Pair<PsiBuilder.Marker, PsiBuilder.Marker> pair : parens) {
            ((PsiBuilder.Marker)pair.first).drop();
        }
        return totalCount != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/parser/GeneratedParserUtilBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionVariant";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitespaceOrComment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "wasAutoSkipped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyList<E>
    extends ArrayList<E> {
        MyList(int initialCapacity) {
            super(initialCapacity);
        }

        protected void setSize(int fromIndex) {
            this.removeRange(fromIndex, this.size());
        }

        @Override
        public boolean add(E e) {
            int size = this.size();
            if (size >= 10000) {
                this.removeRange(2500, size - 2500);
            }
            return super.add(e);
        }
    }

    public static class DummyBlock
    extends CompositePsiElement {
        DummyBlock() {
            super(DUMMY_BLOCK);
        }

        @Override
        @NotNull
        public PsiReference[] getReferences() {
            if (PsiReference.EMPTY_ARRAY == null) {
                DummyBlock.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            Language language = this.getParent().getLanguage();
            if (language == null) {
                DummyBlock.$$$reportNull$$$0(1);
            }
            return language;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/parser/GeneratedParserUtilBase$DummyBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class DummyBlockElementType
    extends IElementType
    implements ICompositeElementType {
        DummyBlockElementType() {
            super("DUMMY_BLOCK", Language.ANY);
        }

        @NotNull
        public ASTNode createCompositeNode() {
            DummyBlock dummyBlock = new DummyBlock();
            if (dummyBlock == null) {
                DummyBlockElementType.$$$reportNull$$$0(0);
            }
            return dummyBlock;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/parser/GeneratedParserUtilBase$DummyBlockElementType", "createCompositeNode"));
        }
    }

    private static class Hooks<T> {
        final Hook<T> hook;
        final T param;
        final int level;
        final Hooks<?> next;

        Hooks(Hook<T> hook, T param, int level, Hooks next) {
            this.hook = hook;
            this.param = param;
            this.level = level;
            this.next = next;
        }

        static <E> Hooks<E> concat(Hook<E> hook, E param, int level, Hooks<?> hooks) {
            return new Hooks<E>(hook, param, level, hooks);
        }
    }

    private static class Variant {
        int position;
        Object object;

        private Variant() {
        }

        public Variant init(int pos, Object o) {
            this.position = pos;
            this.object = o;
            return this;
        }

        public String toString() {
            return "<" + this.position + ", " + this.object + ">";
        }
    }

    public static class Frame {
        public Frame parentFrame;
        public IElementType elementType;
        public int offset;
        public int position;
        public int level;
        public int modifiers;
        public String name;
        public int variantCount;
        public int errorReportedAt;
        public int lastVariantAt;
        public PsiBuilder.Marker leftMarker;

        public Frame init(PsiBuilder builder2, ErrorState state2, int level_, int modifiers_, IElementType elementType_, String name_) {
            this.parentFrame = state2.currentFrame;
            this.elementType = elementType_;
            this.offset = builder2.getCurrentOffset();
            this.position = builder2.rawTokenIndex();
            this.level = level_;
            this.modifiers = modifiers_;
            this.name = name_;
            this.variantCount = state2.variants.size();
            this.errorReportedAt = -1;
            this.lastVariantAt = -1;
            this.leftMarker = null;
            return this;
        }

        public String toString() {
            String mod = this.modifiers == 0 ? "_NONE_, " : ((this.modifiers & 1) != 0 ? "_CAN_COLLAPSE_, " : "") + ((this.modifiers & 2) != 0 ? "_LEFT_, " : "") + ((this.modifiers & 4) != 0 ? "_LEFT_INNER_, " : "") + ((this.modifiers & 8) != 0 ? "_AND_, " : "") + ((this.modifiers & 0x10) != 0 ? "_NOT_, " : "") + ((this.modifiers & 0x20) != 0 ? "_UPPER_, " : "");
            return String.format("{%s:%s:%d, %d, %s%s, %s}", this.offset, this.position, this.level, this.errorReportedAt, mod, this.elementType, this.name);
        }
    }

    public static class ErrorState {
        public Frame currentFrame;
        public CompletionState completionState;
        MyList<Variant> variants = new MyList(1000);
        MyList<Variant> unexpected = new MyList(100);
        int predicateCount;
        int level;
        boolean predicateSign = true;
        boolean suppressErrors;
        Hooks<?> hooks;
        TokenSet[] extendsSets;
        public PairProcessor<IElementType, IElementType> altExtendsChecker;
        private boolean caseSensitive;
        public BracePair[] braces;
        public Parser tokenAdvancer = TOKEN_ADVANCER;
        public boolean altMode;
        final LimitedPool<Variant> VARIANTS = new LimitedPool(10000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<Variant>(){

            @NotNull
            public Variant create() {
                Variant variant = new Variant();
                if (variant == null) {
                    1.$$$reportNull$$$0(0);
                }
                return variant;
            }

            public void cleanup(@NotNull Variant o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "cleanup";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        final LimitedPool<Frame> FRAMES = new LimitedPool(500, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<Frame>(){

            @NotNull
            public Frame create() {
                Frame frame = new Frame();
                if (frame == null) {
                    2.$$$reportNull$$$0(0);
                }
                return frame;
            }

            public void cleanup(@NotNull Frame o) {
                if (o == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "cleanup";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });

        public static ErrorState get(PsiBuilder builder2) {
            return ((Builder)builder2).state;
        }

        public static void initState(ErrorState state2, PsiBuilder builder2, IElementType root, TokenSet[] extendsSets) {
            state2.extendsSets = extendsSets;
            PsiFile file2 = (PsiFile)builder2.getUserData(FileContextUtil.CONTAINING_FILE_KEY);
            state2.completionState = file2 == null ? null : (CompletionState)file2.getUserData(COMPLETION_STATE_KEY);
            Language language = file2 == null ? root.getLanguage() : file2.getLanguage();
            state2.caseSensitive = language.isCaseSensitive();
            PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(language);
            BracePair[] bracePairArray = state2.braces = matcher == null ? null : matcher.getPairs();
            if (state2.braces != null && state2.braces.length == 0) {
                state2.braces = null;
            }
        }

        public void appendExpected(@NotNull StringBuilder sb, int position, boolean expected) {
            if (sb == null) {
                ErrorState.$$$reportNull$$$0(0);
            }
            MyList<Variant> list2 = expected ? this.variants : this.unexpected;
            Object[] strings = new String[list2.size()];
            long[] hashes = new long[strings.length];
            Arrays.fill(strings, "");
            int count = 0;
            block0: for (Variant variant : list2) {
                if (position != variant.position) continue;
                String text2 = String.valueOf(variant.object);
                long hash = StringHash.calc((String)text2);
                for (int i = 0; i < count; ++i) {
                    if (hashes[i] == hash) continue block0;
                }
                hashes[count] = hash;
                strings[count] = text2;
                ++count;
            }
            Arrays.sort(strings);
            count = 0;
            for (Object s : strings) {
                char c;
                if (((String)s).length() == 0) continue;
                if (count++ > 0) {
                    if (count > 50) {
                        sb.append(" and ...");
                        break;
                    }
                    sb.append(", ");
                }
                Object displayText = (c = ((String)s).charAt(0)) == '<' || StringUtil.isJavaIdentifierStart((char)c) ? s : '\'' + (String)s + '\'';
                sb.append((String)displayText);
            }
            if (count > 1 && count < 50) {
                int idx = sb.lastIndexOf(", ");
                sb.replace(idx, idx + 1, " or");
            }
        }

        public void clearVariants(Frame frame) {
            this.clearVariants(true, frame == null ? 0 : frame.variantCount);
            if (frame != null) {
                frame.lastVariantAt = -1;
            }
        }

        void clearVariants(boolean expected, int start) {
            MyList<Variant> list2;
            MyList<Variant> myList = list2 = expected ? this.variants : this.unexpected;
            if (start < 0 || start >= list2.size()) {
                return;
            }
            int len = list2.size();
            for (int i = start; i < len; ++i) {
                this.VARIANTS.recycle(list2.get(i));
            }
            list2.setSize(start);
        }

        public boolean typeExtends(IElementType child, IElementType parent) {
            if (child == parent) {
                return true;
            }
            if (this.extendsSets != null) {
                for (TokenSet set2 : this.extendsSets) {
                    if (!set2.contains(child) || !set2.contains(parent)) continue;
                    return true;
                }
            }
            return this.altExtendsChecker != null && this.altExtendsChecker.process((Object)child, (Object)parent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/lang/parser/GeneratedParserUtilBase$ErrorState", "appendExpected"));
        }
    }

    public static class Builder
    extends PsiBuilderAdapter {
        public final ErrorState state;
        public final PsiParser parser;

        public Builder(PsiBuilder builder2, ErrorState state_, PsiParser parser_) {
            super(builder2);
            this.state = state_;
            this.parser = parser_;
        }

        public Lexer getLexer() {
            return ((PsiBuilderImpl)this.myDelegate).getLexer();
        }
    }

    public static class CompletionState
    implements Function<Object, String> {
        public final int offset;
        public final Collection<String> items = ContainerUtil.newTroveSet();

        public CompletionState(int offset_) {
            this.offset = offset_;
        }

        @Nullable
        public String convertItem(Object o) {
            return o instanceof Object[] ? StringUtil.join((Object[])((Object[])o), (Function)this, (String)" ") : o.toString();
        }

        public String fun(Object o) {
            return this.convertItem(o);
        }

        public void addItem(@NotNull PsiBuilder builder2, @NotNull String text2) {
            if (builder2 == null) {
                CompletionState.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                CompletionState.$$$reportNull$$$0(1);
            }
            this.items.add(text2);
        }

        public boolean prefixMatches(@NotNull PsiBuilder builder2, @NotNull String text2) {
            if (builder2 == null) {
                CompletionState.$$$reportNull$$$0(2);
            }
            if (text2 == null) {
                CompletionState.$$$reportNull$$$0(3);
            }
            int builderOffset = builder2.getCurrentOffset();
            int diff = this.offset - builderOffset;
            int length = text2.length();
            if (diff == 0) {
                return true;
            }
            if (diff > 0 && diff <= length) {
                CharSequence fragment = builder2.getOriginalText().subSequence(builderOffset, this.offset);
                return this.prefixMatches(fragment.toString(), text2);
            }
            if (diff < 0) {
                int i = -1;
                while (true) {
                    IElementType type = builder2.rawLookup(i);
                    int tokenStart = builder2.rawTokenTypeStart(i);
                    if (!GeneratedParserUtilBase.isWhitespaceOrComment(builder2, type)) {
                        CharSequence fragment;
                        if (type == null || tokenStart >= this.offset || !this.prefixMatches((fragment = builder2.getOriginalText().subSequence(tokenStart, this.offset)).toString(), text2)) break;
                        diff = this.offset - tokenStart;
                        break;
                    }
                    diff = this.offset - tokenStart;
                    --i;
                }
                return diff >= 0 && diff < length;
            }
            return false;
        }

        public boolean prefixMatches(@NotNull String prefix, @NotNull String variant) {
            boolean matches;
            if (prefix == null) {
                CompletionState.$$$reportNull$$$0(4);
            }
            if (variant == null) {
                CompletionState.$$$reportNull$$$0(5);
            }
            if ((matches = new CamelHumpMatcher(prefix, false).prefixMatches(variant.replace(' ', '_'))) && StringUtil.isWhiteSpace((char)prefix.charAt(prefix.length() - 1))) {
                return StringUtil.startsWithIgnoreCase((String)variant, (String)prefix);
            }
            return matches;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/parser/GeneratedParserUtilBase$CompletionState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItem";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixMatches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Hook<T> {
        @Contract(value="_,null,_->null")
        public PsiBuilder.Marker run(PsiBuilder var1, PsiBuilder.Marker var2, T var3);
    }

    public static interface Parser {
        public boolean parse(PsiBuilder var1, int var2);
    }
}

