/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;

class AppUIExecutorImpl
implements AppUIExecutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.AppUIExecutorImpl");
    private final ModalityState myModality;
    private final Set<Disposable> myDisposables;
    private final ConstrainedExecutor[] myConstraints;

    AppUIExecutorImpl(final ModalityState modality) {
        this(modality, Collections.emptySet(), new ConstrainedExecutor[]{new ConstrainedExecutor(){

            @Override
            public boolean isCorrectContext() {
                return ApplicationManager.getApplication().isDispatchThread() && !ModalityState.current().dominates(modality);
            }

            @Override
            public void doReschedule(@NotNull Runnable runnable2) {
                if (runnable2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(runnable2, modality);
            }

            @Override
            public String toString() {
                return "onUiThread(" + modality + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/AppUIExecutorImpl$1", "doReschedule"));
            }
        }});
    }

    private AppUIExecutorImpl(ModalityState modality, Set<Disposable> disposables, ConstrainedExecutor[] constraints) {
        this.myModality = modality;
        this.myConstraints = constraints;
        this.myDisposables = disposables;
    }

    @NotNull
    private AppUIExecutor withConstraint(ConstrainedExecutor element) {
        AppUIExecutorImpl appUIExecutorImpl = new AppUIExecutorImpl(this.myModality, this.myDisposables, (ConstrainedExecutor[])ArrayUtil.append((Object[])this.myConstraints, (Object)element));
        if (appUIExecutorImpl == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(0);
        }
        return appUIExecutorImpl;
    }

    @NotNull
    public AppUIExecutor later() {
        final Integer edtEventCount = ApplicationManager.getApplication().isDispatchThread() ? Integer.valueOf(IdeEventQueue.getInstance().getEventCount()) : null;
        AppUIExecutor appUIExecutor = this.withConstraint(new ConstrainedExecutor(){
            volatile boolean usedOnce;

            @Override
            public boolean isCorrectContext() {
                return edtEventCount == null ? ApplicationManager.getApplication().isDispatchThread() : edtEventCount.intValue() != IdeEventQueue.getInstance().getEventCount() || this.usedOnce;
            }

            @Override
            public void doReschedule(@NotNull Runnable runnable2) {
                if (runnable2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (runnable2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    this.usedOnce = true;
                    runnable2.run();
                }, AppUIExecutorImpl.this.myModality);
            }

            @Override
            public String toString() {
                return "later";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "runnable";
                objectArray2[1] = "com/intellij/openapi/application/impl/AppUIExecutorImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doReschedule";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$doReschedule$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (appUIExecutor == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(1);
        }
        return appUIExecutor;
    }

    @NotNull
    public AppUIExecutor withDocumentsCommitted(final @NotNull Project project) {
        if (project == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(2);
        }
        AppUIExecutor appUIExecutor = this.withConstraint(new ConstrainedExecutor(){

            @Override
            public boolean isCorrectContext() {
                return !PsiDocumentManager.getInstance((Project)project).hasUncommitedDocuments();
            }

            @Override
            public void doReschedule(@NotNull Runnable runnable2) {
                if (runnable2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(runnable2, AppUIExecutorImpl.this.myModality);
            }

            @Override
            public String toString() {
                return "withDocumentsCommitted";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/AppUIExecutorImpl$3", "doReschedule"));
            }
        }).expireWith((Disposable)project);
        if (appUIExecutor == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(3);
        }
        return appUIExecutor;
    }

    @NotNull
    public AppUIExecutor inSmartMode(final @NotNull Project project) {
        if (project == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(4);
        }
        AppUIExecutor appUIExecutor = this.withConstraint(new ConstrainedExecutor(){

            @Override
            public boolean isCorrectContext() {
                return !DumbService.getInstance((Project)project).isDumb();
            }

            @Override
            public void doReschedule(@NotNull Runnable runnable2) {
                if (runnable2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                DumbService.getInstance((Project)project).smartInvokeLater(runnable2, AppUIExecutorImpl.this.myModality);
            }

            @Override
            public String toString() {
                return "inSmartMode";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/AppUIExecutorImpl$4", "doReschedule"));
            }
        }).expireWith((Disposable)project);
        if (appUIExecutor == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(5);
        }
        return appUIExecutor;
    }

    @NotNull
    public AppUIExecutor inTransaction(final @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(6);
        }
        final TransactionId id = TransactionGuard.getInstance().getContextTransaction();
        AppUIExecutor appUIExecutor = this.withConstraint(new ConstrainedExecutor(){

            @Override
            public boolean isCorrectContext() {
                return TransactionGuard.getInstance().getContextTransaction() != null;
            }

            @Override
            public void doReschedule(@NotNull Runnable runnable2) {
                if (runnable2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                TransactionGuard.getInstance().submitTransaction(parentDisposable, id, runnable2);
            }

            @Override
            public String toString() {
                return "inTransaction";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/AppUIExecutorImpl$5", "doReschedule"));
            }
        }).expireWith(parentDisposable);
        if (appUIExecutor == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(7);
        }
        return appUIExecutor;
    }

    @NotNull
    public AppUIExecutor expireWith(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(8);
        }
        if (this.myDisposables.contains(parentDisposable)) {
            AppUIExecutorImpl appUIExecutorImpl = this;
            if (appUIExecutorImpl == null) {
                AppUIExecutorImpl.$$$reportNull$$$0(9);
            }
            return appUIExecutorImpl;
        }
        HashSet disposables = ContainerUtil.newHashSet(this.myDisposables);
        disposables.add(parentDisposable);
        AppUIExecutorImpl appUIExecutorImpl = new AppUIExecutorImpl(this.myModality, disposables, this.myConstraints);
        if (appUIExecutorImpl == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(10);
        }
        return appUIExecutorImpl;
    }

    public CancellablePromise<?> submit(Runnable task2) {
        return this.submit(() -> {
            task2.run();
            return null;
        });
    }

    public void execute(@NotNull Runnable command) {
        if (command == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(11);
        }
        this.submit(command);
    }

    public <T> CancellablePromise<T> submit(Callable<T> task2) {
        AsyncPromise promise2 = new AsyncPromise();
        if (!this.myDisposables.isEmpty()) {
            ArrayList<Disposable> children2 = new ArrayList<Disposable>();
            for (Disposable parent : this.myDisposables) {
                Disposable child = () -> ((AsyncPromise)promise2).cancel();
                children2.add(child);
                Disposer.register((Disposable)parent, (Disposable)child);
            }
            promise2.onProcessed(__ -> children2.forEach(Disposer::dispose));
        }
        this.checkConstraints(task2, promise2, new ArrayList<ConstrainedExecutor>());
        return promise2;
    }

    private <T> void checkConstraints(@NotNull Callable<T> task2, AsyncPromise<T> future2, List<ConstrainedExecutor> log2) {
        Application app;
        if (task2 == null) {
            AppUIExecutorImpl.$$$reportNull$$$0(12);
        }
        if (!(app = ApplicationManager.getApplication()).isDispatchThread()) {
            app.invokeLater(() -> {
                if (task2 == null) {
                    AppUIExecutorImpl.$$$reportNull$$$0(14);
                }
                this.checkConstraints(task2, future2, log2);
            }, this.myModality);
            return;
        }
        if (future2.isCancelled()) {
            return;
        }
        for (ConstrainedExecutor constraint : this.myConstraints) {
            if (constraint.isCorrectContext()) continue;
            log2.add(constraint);
            if (log2.size() > 3000) {
                LOG.error("Too many reschedule requests, probably constraints can't be satisfied all together: " + log2.subList(log2.size() - 30, log2.size()));
            } else {
                constraint.rescheduleInCorrectContext(() -> {
                    if (task2 == null) {
                        AppUIExecutorImpl.$$$reportNull$$$0(13);
                    }
                    this.checkConstraints(task2, future2, log2);
                });
            }
            return;
        }
        try {
            T result2 = task2.call();
            future2.setResult(result2);
        }
        catch (Throwable e) {
            future2.setError(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/AppUIExecutorImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withConstraint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "later";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/AppUIExecutorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withDocumentsCommitted";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "inSmartMode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "inTransaction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "expireWith";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withDocumentsCommitted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inSmartMode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inTransaction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expireWith";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkConstraints";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkConstraints$3";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkConstraints$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class ConstrainedExecutor {
        private ConstrainedExecutor() {
        }

        public abstract boolean isCorrectContext();

        public abstract void doReschedule(Runnable var1);

        public abstract String toString();

        void rescheduleInCorrectContext(Runnable r) {
            this.doReschedule(() -> {
                LOG.assertTrue(this.isCorrectContext(), (Object)this);
                r.run();
            });
        }
    }
}

