/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.util.DocumentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Change {
    private static final Logger LOG = Logger.getInstance(Change.class);

    public abstract ChangeSide getChangeSide(FragmentSide var1);

    public abstract ChangeType getType();

    public abstract ChangeList getChangeList();

    protected abstract void removeFromList();

    public abstract void onApplied();

    public abstract void onRemovedFromList();

    public abstract boolean isValid();

    private void apply(@NotNull FragmentSide original) {
        if (original == null) {
            Change.$$$reportNull$$$0(0);
        }
        FragmentSide targetSide = original.otherSide();
        RangeMarker originalRangeMarker = this.getRangeMarker(original);
        RangeMarker rangeMarker = this.getRangeMarker(targetSide);
        TextRange textRange = Change.modifyDocument(this.getProject(), originalRangeMarker, rangeMarker);
        if (textRange != null && this.isValid()) {
            this.updateTargetRangeMarker(targetSide, textRange);
        }
        this.onApplied();
    }

    protected final void updateTargetRangeMarker(@NotNull FragmentSide targetFragmentSide, @NotNull TextRange updatedTextRange) {
        if (targetFragmentSide == null) {
            Change.$$$reportNull$$$0(1);
        }
        if (updatedTextRange == null) {
            Change.$$$reportNull$$$0(2);
        }
        ChangeSide targetSide = this.getChangeSide(targetFragmentSide);
        DiffRangeMarker originalRange = targetSide.getRange();
        DiffRangeMarker updatedRange = new DiffRangeMarker(originalRange.getDocument(), updatedTextRange, null);
        this.changeSide(targetSide, updatedRange);
    }

    protected abstract void changeSide(ChangeSide var1, DiffRangeMarker var2);

    @Nullable
    private static TextRange modifyDocument(@Nullable Project project, @NotNull RangeMarker original, @NotNull RangeMarker target2) {
        if (original == null) {
            Change.$$$reportNull$$$0(3);
        }
        if (target2 == null) {
            Change.$$$reportNull$$$0(4);
        }
        Document document = target2.getDocument();
        if (project != null && !ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)document)) {
            return null;
        }
        if (DocumentUtil.isEmpty(original)) {
            int offset = target2.getStartOffset();
            document.deleteString(offset, target2.getEndOffset());
        }
        CharSequence text2 = original.getDocument().getImmutableCharSequence().subSequence(original.getStartOffset(), original.getEndOffset());
        int startOffset = target2.getStartOffset();
        if (DocumentUtil.isEmpty(target2)) {
            document.insertString(startOffset, text2);
        } else {
            document.replaceString(startOffset, target2.getEndOffset(), text2);
        }
        return new TextRange(startOffset, startOffset + text2.length());
    }

    public void addMarkup(Editor[] editors) {
        LOG.assertTrue(editors.length == 2);
        this.highlight(editors, FragmentSide.SIDE1);
        this.highlight(editors, FragmentSide.SIDE2);
    }

    private void highlight(Editor[] editors, FragmentSide side) {
        this.getHighlighterHolder(side).highlight(this.getChangeSide(side), editors[side.getIndex()], this.getType());
    }

    private void updateHighlighter(FragmentSide side) {
        this.getHighlighterHolder(side).updateHighlighter(this.getChangeSide(side), this.getType());
    }

    @Nullable
    private Project getProject() {
        return this.getChangeList().getProject();
    }

    @NotNull
    private ChangeHighlighterHolder getHighlighterHolder(FragmentSide side) {
        ChangeHighlighterHolder changeHighlighterHolder = this.getChangeSide(side).getHighlighterHolder();
        if (changeHighlighterHolder == null) {
            Change.$$$reportNull$$$0(5);
        }
        return changeHighlighterHolder;
    }

    @NotNull
    private RangeMarker getRangeMarker(FragmentSide side) {
        ChangeSide changeSide = this.getChangeSide(side);
        LOG.assertTrue(changeSide != null);
        DiffRangeMarker diffRangeMarker = changeSide.getRange();
        if (diffRangeMarker == null) {
            Change.$$$reportNull$$$0(6);
        }
        return diffRangeMarker;
    }

    public static void apply(Change change, FragmentSide fromSide) {
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(change.getProject(), () -> Change.doApply(change, fromSide), null, (Object)DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0])));
    }

    public static void doApply(Change change, FragmentSide fromSide) {
        change.apply(fromSide);
    }

    public void updateMarkup() {
        this.updateHighlighter(FragmentSide.SIDE1);
        this.updateHighlighter(FragmentSide.SIDE2);
    }

    public boolean canHasActions(FragmentSide fromSide) {
        FragmentSide targetSide = fromSide.otherSide();
        Document targetDocument = this.getChangeList().getDocument(targetSide);
        if (!targetDocument.isWritable()) {
            return false;
        }
        Editor targetEditor = this.getHighlighterHolder(targetSide).getEditor();
        return !targetEditor.isViewer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFragmentSide";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedTextRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/Change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/Change";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighterHolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateTargetRangeMarker";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modifyDocument";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class SimpleChangeSide
    extends ChangeSide {
        private final FragmentSide mySide;
        private final DiffRangeMarker myRange;
        private final ChangeHighlighterHolder myHighlighterHolder;

        public SimpleChangeSide(FragmentSide side, DiffRangeMarker rangeMarker) {
            this.mySide = side;
            this.myRange = rangeMarker;
            this.myHighlighterHolder = new ChangeHighlighterHolder();
        }

        public SimpleChangeSide(@NotNull ChangeSide originalSide, @NotNull DiffRangeMarker newRange) {
            if (originalSide == null) {
                SimpleChangeSide.$$$reportNull$$$0(0);
            }
            if (newRange == null) {
                SimpleChangeSide.$$$reportNull$$$0(1);
            }
            this.mySide = ((SimpleChangeSide)originalSide).getFragmentSide();
            this.myRange = newRange;
            this.myHighlighterHolder = originalSide.getHighlighterHolder();
        }

        @NotNull
        public FragmentSide getFragmentSide() {
            FragmentSide fragmentSide = this.mySide;
            if (fragmentSide == null) {
                SimpleChangeSide.$$$reportNull$$$0(2);
            }
            return fragmentSide;
        }

        @Override
        @NotNull
        public DiffRangeMarker getRange() {
            DiffRangeMarker diffRangeMarker = this.myRange;
            if (diffRangeMarker == null) {
                SimpleChangeSide.$$$reportNull$$$0(3);
            }
            return diffRangeMarker;
        }

        @Override
        @NotNull
        public ChangeHighlighterHolder getHighlighterHolder() {
            ChangeHighlighterHolder changeHighlighterHolder = this.myHighlighterHolder;
            if (changeHighlighterHolder == null) {
                SimpleChangeSide.$$$reportNull$$$0(4);
            }
            return changeHighlighterHolder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRange";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/Change$SimpleChangeSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/Change$SimpleChangeSide";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragmentSide";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlighterHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ChangeOrder
    implements Comparator<Change> {
        private final FragmentSide myMainSide;

        public ChangeOrder(FragmentSide mainSide) {
            this.myMainSide = mainSide;
        }

        @Override
        public int compare(@NotNull Change change, @NotNull Change change1) {
            int result1;
            if (change == null) {
                ChangeOrder.$$$reportNull$$$0(0);
            }
            if (change1 == null) {
                ChangeOrder.$$$reportNull$$$0(1);
            }
            if ((result1 = ChangeOrder.compareSide(change, change1, this.myMainSide)) != 0) {
                return result1;
            }
            return ChangeOrder.compareSide(change, change1, this.myMainSide.otherSide());
        }

        private static int compareSide(Change change, Change change1, FragmentSide side) {
            return RangeMarker.BY_START_OFFSET.compare(change.getRangeMarker(side), change1.getRangeMarker(side));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "change";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "change1";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/diff/impl/incrementalMerge/Change$ChangeOrder";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

