/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameLibraryHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.actions.RenameModuleHandler");

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Library library;
        if (dataContext == null) {
            RenameLibraryHandler.$$$reportNull$$$0(0);
        }
        return (library = (Library)LangDataKeys.LIBRARY.getData(dataContext)) != null;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameLibraryHandler.$$$reportNull$$$0(1);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            RenameLibraryHandler.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(false);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        Library library;
        if (project == null) {
            RenameLibraryHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            RenameLibraryHandler.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            RenameLibraryHandler.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((library = (Library)LangDataKeys.LIBRARY.getData(dataContext)) != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.library.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.library", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)library.getName(), (InputValidator)new MyInputValidator(project, library));
    }

    public String getActionTitle() {
        return IdeBundle.message((String)"title.rename.library", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/RenameLibraryHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final Library myLibrary;

        public MyInputValidator(Project project, Library library) {
            this.myProject = project;
            this.myLibrary = library;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && !inputString.isEmpty() && this.myLibrary.getTable().getLibraryByName(inputString) == null;
        }

        public boolean canClose(final String inputString) {
            final String oldName = this.myLibrary.getName();
            Library.ModifiableModel modifiableModel = this.renameLibrary(inputString);
            if (modifiableModel == null) {
                return false;
            }
            Ref success2 = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                BasicUndoableAction action = new BasicUndoableAction(){

                    public void undo() throws UnexpectedUndoException {
                        Library.ModifiableModel modifiableModel1 = this.renameLibrary(oldName);
                        if (modifiableModel1 != null) {
                            modifiableModel1.commit();
                        }
                    }

                    public void redo() throws UnexpectedUndoException {
                        Library.ModifiableModel modifiableModel1 = this.renameLibrary(inputString);
                        if (modifiableModel1 != null) {
                            modifiableModel1.commit();
                        }
                    }
                };
                UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action);
                ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
            }, IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{oldName}), null);
            return (Boolean)success2.get();
        }

        @Nullable
        private Library.ModifiableModel renameLibrary(String inputString) {
            Library.ModifiableModel modifiableModel = this.myLibrary.getModifiableModel();
            modifiableModel.setName(inputString);
            return modifiableModel;
        }
    }
}

