/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.actions.AnnotateCurrentRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotatePreviousRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.AnnotationGutterLineConvertorProxy;
import com.intellij.openapi.vcs.actions.AnnotationPresentation;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.actions.AspectAnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.CopyRevisionNumberFromAnnotateAction;
import com.intellij.openapi.vcs.actions.CurrentRevisionAnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ExtraFieldGutter;
import com.intellij.openapi.vcs.actions.HighlightedAdditionalColumn;
import com.intellij.openapi.vcs.actions.HistoryIdColumn;
import com.intellij.openapi.vcs.actions.MergeSourceAvailableMarkerGutter;
import com.intellij.openapi.vcs.actions.ShowDiffFromAnnotation;
import com.intellij.openapi.vcs.actions.SwitchAnnotationSourceAction;
import com.intellij.openapi.vcs.annotate.AnnotationGutterActionProvider;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateToggleAction
extends ToggleAction
implements DumbAware {
    public static final ExtensionPointName<Provider> EP_NAME = ExtensionPointName.create((String)"com.intellij.openapi.vcs.actions.AnnotateToggleAction.Provider");

    public AnnotateToggleAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateToggleAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Provider provider = AnnotateToggleAction.getProvider(e);
        e.getPresentation().setEnabled(provider != null && !provider.isSuspended(e));
    }

    public boolean isSelected(AnActionEvent e) {
        Provider provider = AnnotateToggleAction.getProvider(e);
        return provider != null && provider.isAnnotated(e);
    }

    public void setSelected(AnActionEvent e, boolean selected) {
        MyEditorNotificationPanel notificationPanel;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null && (notificationPanel = (MyEditorNotificationPanel)((Object)ObjectUtils.tryCast((Object)editor.getHeaderComponent(), MyEditorNotificationPanel.class))) != null) {
            notificationPanel.showAnnotations();
            return;
        }
        Provider provider = AnnotateToggleAction.getProvider(e);
        if (provider != null) {
            provider.perform(e, selected);
        }
    }

    public static void doAnnotate(@NotNull Editor editor, @NotNull Project project, @Nullable VirtualFile currentFile, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AnnotateToggleAction.$$$reportNull$$$0(2);
        }
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            AnnotateToggleAction.$$$reportNull$$$0(4);
        }
        UpToDateLineNumberProviderImpl upToDateLineNumberProvider = new UpToDateLineNumberProviderImpl(editor.getDocument(), project);
        AnnotateToggleAction.doAnnotate(editor, project, currentFile, fileAnnotation, vcs, upToDateLineNumberProvider);
    }

    public static void doAnnotate(@NotNull Editor editor, @NotNull Project project, @Nullable VirtualFile currentFile, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, @NotNull UpToDateLineNumberProvider upToDateLineNumbers) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            AnnotateToggleAction.$$$reportNull$$$0(6);
        }
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(7);
        }
        if (vcs == null) {
            AnnotateToggleAction.$$$reportNull$$$0(8);
        }
        if (upToDateLineNumbers == null) {
            AnnotateToggleAction.$$$reportNull$$$0(9);
        }
        AnnotateToggleAction.doAnnotate(editor, project, currentFile, fileAnnotation, vcs, upToDateLineNumbers, true);
    }

    private static void doAnnotate(@NotNull Editor editor, @NotNull Project project, @Nullable VirtualFile currentFile, final @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, @NotNull UpToDateLineNumberProvider upToDateLineNumbers, boolean warnAboutSuspiciousAnnotations) {
        int actualLines;
        int expectedLines;
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(10);
        }
        if (project == null) {
            AnnotateToggleAction.$$$reportNull$$$0(11);
        }
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(12);
        }
        if (vcs == null) {
            AnnotateToggleAction.$$$reportNull$$$0(13);
        }
        if (upToDateLineNumbers == null) {
            AnnotateToggleAction.$$$reportNull$$$0(14);
        }
        if (project.isDisposed() || editor.isDisposed()) {
            return;
        }
        if (warnAboutSuspiciousAnnotations && Math.abs((expectedLines = Math.max(upToDateLineNumbers.getLineCount(), 1)) - (actualLines = Math.max(fileAnnotation.getLineCount(), 1))) > 1) {
            editor.setHeaderComponent((JComponent)((Object)new MyEditorNotificationPanel(editor, vcs, () -> {
                if (editor == null) {
                    AnnotateToggleAction.$$$reportNull$$$0(29);
                }
                if (project == null) {
                    AnnotateToggleAction.$$$reportNull$$$0(30);
                }
                if (fileAnnotation == null) {
                    AnnotateToggleAction.$$$reportNull$$$0(31);
                }
                if (vcs == null) {
                    AnnotateToggleAction.$$$reportNull$$$0(32);
                }
                if (upToDateLineNumbers == null) {
                    AnnotateToggleAction.$$$reportNull$$$0(33);
                }
                AnnotateToggleAction.doAnnotate(editor, project, currentFile, fileAnnotation, vcs, upToDateLineNumbers, false);
            })));
            return;
        }
        fileAnnotation.setCloser(() -> {
            if (project == null) {
                AnnotateToggleAction.$$$reportNull$$$0(25);
            }
            if (editor == null) {
                AnnotateToggleAction.$$$reportNull$$$0(26);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (project == null) {
                    AnnotateToggleAction.$$$reportNull$$$0(27);
                }
                if (editor == null) {
                    AnnotateToggleAction.$$$reportNull$$$0(28);
                }
                if (project.isDisposed()) {
                    return;
                }
                editor.getGutter().closeAllAnnotations();
            });
        });
        fileAnnotation.setReloader(newFileAnnotation -> {
            if (editor == null) {
                AnnotateToggleAction.$$$reportNull$$$0(20);
            }
            if (fileAnnotation == null) {
                AnnotateToggleAction.$$$reportNull$$$0(21);
            }
            if (project == null) {
                AnnotateToggleAction.$$$reportNull$$$0(22);
            }
            if (vcs == null) {
                AnnotateToggleAction.$$$reportNull$$$0(23);
            }
            if (upToDateLineNumbers == null) {
                AnnotateToggleAction.$$$reportNull$$$0(24);
            }
            if (editor.getGutter().isAnnotationsShown()) {
                assert (Comparing.equal((Object)fileAnnotation.getFile(), (Object)newFileAnnotation.getFile()));
                AnnotateToggleAction.doAnnotate(editor, project, currentFile, newFileAnnotation, vcs, upToDateLineNumbers, false);
            }
        });
        if (fileAnnotation.isClosed()) {
            return;
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                fileAnnotation.dispose();
            }
        };
        if (fileAnnotation.getFile() != null && fileAnnotation.getFile().isInLocalFileSystem()) {
            final VcsAnnotationLocalChangesListener changesListener = ProjectLevelVcsManager.getInstance((Project)project).getAnnotationLocalChangesListener();
            changesListener.registerAnnotation(fileAnnotation.getFile(), fileAnnotation);
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    changesListener.unregisterAnnotation(fileAnnotation.getFile(), fileAnnotation);
                }
            });
        }
        editor.getGutter().closeAllAnnotations();
        ArrayList<AnnotationFieldGutter> gutters = new ArrayList<AnnotationFieldGutter>();
        AnnotationSourceSwitcher switcher = fileAnnotation.getAnnotationSourceSwitcher();
        AnnotationPresentation presentation = new AnnotationPresentation(fileAnnotation, upToDateLineNumbers, switcher, disposable);
        if (currentFile != null && vcs.getCommittedChangesProvider() != null) {
            presentation.addAction((AnAction)new ShowDiffFromAnnotation(fileAnnotation, vcs, currentFile));
        }
        presentation.addAction((AnAction)new CopyRevisionNumberFromAnnotateAction(fileAnnotation));
        presentation.addAction((AnAction)Separator.getInstance());
        Couple<Map<VcsRevisionNumber, Color>> bgColorMap = AnnotateToggleAction.computeBgColors(fileAnnotation, editor);
        Map<VcsRevisionNumber, Integer> historyIds = AnnotateToggleAction.computeLineNumbers(fileAnnotation);
        if (switcher != null) {
            switcher.switchTo(switcher.getDefaultSource());
            LineAnnotationAspect revisionAspect = switcher.getRevisionAspect();
            CurrentRevisionAnnotationFieldGutter currentRevisionGutter = new CurrentRevisionAnnotationFieldGutter(fileAnnotation, revisionAspect, presentation, bgColorMap);
            MergeSourceAvailableMarkerGutter mergeSourceGutter = new MergeSourceAvailableMarkerGutter(fileAnnotation, presentation, bgColorMap);
            SwitchAnnotationSourceAction switchAction = new SwitchAnnotationSourceAction(switcher);
            presentation.addAction(switchAction);
            switchAction.addSourceSwitchListener(currentRevisionGutter);
            switchAction.addSourceSwitchListener(mergeSourceGutter);
            currentRevisionGutter.consume(switcher.getDefaultSource());
            mergeSourceGutter.consume(switcher.getDefaultSource());
            gutters.add(currentRevisionGutter);
            gutters.add(mergeSourceGutter);
        }
        LineAnnotationAspect[] aspects = fileAnnotation.getAspects();
        for (LineAnnotationAspect aspect : aspects) {
            gutters.add(new AspectAnnotationFieldGutter(fileAnnotation, aspect, presentation, bgColorMap));
        }
        if (historyIds != null) {
            gutters.add(new HistoryIdColumn(fileAnnotation, presentation, bgColorMap, historyIds));
        }
        gutters.add(new HighlightedAdditionalColumn(fileAnnotation, presentation, bgColorMap));
        AnnotateActionGroup actionGroup = new AnnotateActionGroup(gutters, bgColorMap);
        presentation.addAction((AnAction)actionGroup, 1);
        gutters.add(new ExtraFieldGutter(fileAnnotation, presentation, bgColorMap, actionGroup));
        presentation.addAction((AnAction)new AnnotateCurrentRevisionAction(fileAnnotation, vcs));
        presentation.addAction((AnAction)new AnnotatePreviousRevisionAction(fileAnnotation, vcs));
        AnnotateToggleAction.addActionsFromExtensions(presentation, fileAnnotation);
        for (AnnotationFieldGutter gutter : gutters) {
            AnnotationGutterLineConvertorProxy proxy = new AnnotationGutterLineConvertorProxy(upToDateLineNumbers, gutter);
            if (gutter.isGutterAction()) {
                editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy, (EditorGutterAction)proxy);
                continue;
            }
            editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy);
        }
    }

    private static void addActionsFromExtensions(@NotNull AnnotationPresentation presentation, @NotNull FileAnnotation fileAnnotation) {
        AnnotationGutterActionProvider[] extensions;
        if (presentation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(15);
        }
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(16);
        }
        if ((extensions = (AnnotationGutterActionProvider[])AnnotationGutterActionProvider.EP_NAME.getExtensions()).length > 0) {
            presentation.addAction((AnAction)new Separator());
        }
        for (AnnotationGutterActionProvider provider : extensions) {
            presentation.addAction(provider.createAction(fileAnnotation));
        }
    }

    @Nullable
    private static Map<VcsRevisionNumber, Integer> computeLineNumbers(@NotNull FileAnnotation fileAnnotation) {
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(17);
        }
        HashMap<VcsRevisionNumber, Integer> numbers = new HashMap<VcsRevisionNumber, Integer>();
        List fileRevisionList = fileAnnotation.getRevisions();
        if (fileRevisionList != null) {
            int size = fileRevisionList.size();
            for (int i = 0; i < size; ++i) {
                VcsFileRevision revision = (VcsFileRevision)fileRevisionList.get(i);
                VcsRevisionNumber number = revision.getRevisionNumber();
                numbers.put(number, size - i);
            }
        }
        return numbers.size() < 2 ? null : numbers;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Couple<Map<VcsRevisionNumber, Color>> computeBgColors(@NotNull FileAnnotation fileAnnotation, @NotNull Editor editor) {
        FileAnnotation.RevisionsOrderProvider revisionsOrderProvider;
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(19);
        }
        HashMap<VcsRevisionNumber, Color> commitOrderColors = new HashMap<VcsRevisionNumber, Color>();
        HashMap<VcsRevisionNumber, Color> commitAuthorColors = new HashMap<VcsRevisionNumber, Color>();
        EditorColorsScheme colorScheme = editor.getColorsScheme();
        AnnotationsSettings settings = AnnotationsSettings.getInstance();
        List<Color> authorsColorPalette = settings.getAuthorsColors(colorScheme);
        List<Color> orderedColorPalette = settings.getOrderedColors(colorScheme);
        FileAnnotation.AuthorsMappingProvider authorsMappingProvider = fileAnnotation.getAuthorsMappingProvider();
        if (authorsMappingProvider != null) {
            Map authorsMap = authorsMappingProvider.getAuthors();
            HashMap<String, Color> authorColors = new HashMap<String, Color>();
            for (String string : ContainerUtil.sorted(authorsMap.values(), Comparing::compare)) {
                int index = authorColors.size();
                Color color = authorsColorPalette.get(index % authorsColorPalette.size());
                authorColors.put(string, color);
            }
            for (Map.Entry entry : authorsMap.entrySet()) {
                VcsRevisionNumber revision = (VcsRevisionNumber)entry.getKey();
                String author = (String)entry.getValue();
                Color color = (Color)authorColors.get(author);
                commitAuthorColors.put(revision, color);
            }
        }
        if ((revisionsOrderProvider = fileAnnotation.getRevisionsOrderProvider()) != null) {
            void var12_17;
            List orderedRevisions = revisionsOrderProvider.getOrderedRevisions();
            int revisionsCount = orderedRevisions.size();
            boolean bl = false;
            while (var12_17 < revisionsCount) {
                Color color = orderedColorPalette.get(orderedColorPalette.size() * var12_17 / revisionsCount);
                for (VcsRevisionNumber number : (List)orderedRevisions.get((int)var12_17)) {
                    commitOrderColors.put(number, color);
                }
                ++var12_17;
            }
        }
        return Couple.of(commitOrderColors.size() > 1 ? commitOrderColors : null, commitAuthorColors.size() > 1 ? commitAuthorColors : null);
    }

    @Nullable
    private static Provider getProvider(AnActionEvent e) {
        for (Provider provider : (Provider[])EP_NAME.getExtensions()) {
            if (!provider.isEnabled(e)) continue;
            return provider;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 19: 
            case 20: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 22: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 9: 
            case 14: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upToDateLineNumbers";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateToggleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "doAnnotate";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addActionsFromExtensions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "computeLineNumbers";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "computeBgColors";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doAnnotate$3";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doAnnotate$2";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doAnnotate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        private final Editor myEditor;
        private final Runnable myShowAnnotations;

        public MyEditorNotificationPanel(@NotNull Editor editor, @NotNull AbstractVcs vcs, @NotNull Runnable doShowAnnotations) {
            if (editor == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(0);
            }
            if (vcs == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(1);
            }
            if (doShowAnnotations == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(2);
            }
            super(LightColors.RED);
            this.myEditor = editor;
            this.myShowAnnotations = doShowAnnotations;
            this.setText(VcsBundle.message((String)"annotation.wrong.line.number.notification.text", (Object[])new Object[]{vcs.getDisplayName()}));
            this.createActionLabel("Display anyway", () -> this.showAnnotations());
            this.createActionLabel("Hide", () -> this.hideNotification()).setToolTipText("Hide this notification");
        }

        public void showAnnotations() {
            this.hideNotification();
            this.myShowAnnotations.run();
        }

        private void hideNotification() {
            this.setVisible(false);
            if (this.myEditor.getHeaderComponent() == this) {
                this.myEditor.setHeaderComponent(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "doShowAnnotations";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotateToggleAction$MyEditorNotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Provider {
        public boolean isEnabled(AnActionEvent var1);

        public boolean isSuspended(AnActionEvent var1);

        public boolean isAnnotated(AnActionEvent var1);

        public void perform(AnActionEvent var1, boolean var2);
    }
}

